/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.jcraft.jsch.JSchException;
import com.mapr.ycsb.App;
import com.mapr.ycsb.db.DBSummary;
import com.mapr.ycsb.ssh.Cluster;
import com.mapr.ycsb.ssh.CopyFromRemote;
import com.mapr.ycsb.ssh.CopyToRemote;
import com.mapr.ycsb.ssh.RunCommand;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.exec.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
extends App {
    private static final Logger _logger = LoggerFactory.getLogger(Driver.class);
    private Cluster cluster;
    private String sessionFolder;
    private String sessionLogFolder;

    @Override
    public int run0() throws Exception {
        Config driverConfig = this.config.getDriverConfig();
        if (driverConfig.isCreatetable() && !this.config.getTableInfo().createTable(this.config)) {
            _logger.error("Unable to create table '{}'.", (Object)this.config.getTableInfo().getTable());
            return 1;
        }
        String hosts = driverConfig.getHosts();
        this.cluster = new Cluster(hosts);
        String java_bin = this.config.getJavaInfo().getBin();
        if (!this.exec("which " + java_bin + " >/dev/null")) {
            _logger.error("The path specified by setting 'ycsb.java' does not exist on at least one node. See log for details.");
            return 1;
        }
        this.sessionFolder = "/var/ycsb/" + this.getSessionName() + "_${node_id}_dir";
        this.sessionLogFolder = this.sessionFolder + "/logs";
        _logger.info("Creating session folder '{}' on each node.", (Object)this.sessionFolder);
        this.createSessionFolder(this.sessionLogFolder);
        _logger.info("Generating ID file on each node.");
        for (Future<RunCommand> result : this.cluster.copyId(this.sessionFolder)) {
            RunCommand cmd = result.get();
            if (cmd.getExitCode() == 0) continue;
            _logger.error("Unable to create id file on " + cmd.getHost());
            return 1;
        }
        String remoteConfPath = this.sessionFolder + "/" + this.getConfigFile().getName();
        _logger.info("Copying configuration file '{}' to remote nodes.", (Object)this.getConfigFile().getAbsolutePath());
        this.copyToRemote(this.getConfigFile().getAbsolutePath(), remoteConfPath);
        String remoteJarPath = this.sessionFolder + "/" + this.config.getJarFile().getName();
        _logger.info("Copying the jar file '{}' to remote nodes.", (Object)this.config.getJarFile().getAbsolutePath());
        this.copyToRemote(this.config.getJarFile().getAbsolutePath(), remoteJarPath);
        StringBuilder launcher = new StringBuilder().append("cd ").append(this.sessionFolder).append(" && ").append("LOG_DIR=" + this.sessionLogFolder + " ").append(java_bin).append(" -cp ").append(remoteJarPath).append(" com.mapr.ycsb.Launcher ").append(remoteConfPath);
        _logger.info("Starting YCSB benchmark on all nodes.");
        _logger.info("Total record count: {}, avg record size: {}", (Object)this.config.getBenchmark().getDocumentCount(), (Object)this.config.getBenchmark().getRowSize());
        this.exec(launcher.toString());
        _logger.info("YCSB benchmark execution completed.");
        String[] filesToCollect = driverConfig.getFilesToCollect();
        if (filesToCollect != null && filesToCollect.length > 0) {
            launcher = new StringBuilder().append("cd ").append(this.sessionLogFolder).append(" && ").append("cp ").append(StringUtils.toString((String[])filesToCollect, (String)" ")).append(" .");
            _logger.info("Collecting requested files.");
            this.exec(launcher.toString());
        }
        String tarballName = "ycsb_" + this.getSessionName() + "_${node_host}.tar.bz2";
        String sessionLogTarball = this.sessionFolder + "/" + tarballName;
        launcher = new StringBuilder().append("cd ").append(this.sessionFolder).append(" && ").append("touch ").append(this.sessionLogFolder).append("/`hostname -f` && ").append("tar -cjf ").append(sessionLogTarball).append(" logs ").append(this.getConfigFile().getName());
        _logger.info("Archiving execution logs on all nodes.");
        this.exec(launcher.toString());
        File localLogDir = new File(this.config.getWorkingDir(), "logs");
        localLogDir.mkdirs();
        _logger.info("Collecting execution logs from all nodes.");
        File localTarFile = new File(localLogDir, tarballName);
        this.copyFromRemote(sessionLogTarball, localTarFile.getAbsolutePath());
        _logger.info("Execution logs is copied to {}.", (Object)localLogDir);
        _logger.info("Shutting down the cluster connections.");
        this.cluster.shoutdown();
        _logger.info("Cluster connections are shutdown.");
        this.printSummary();
        return 0;
    }

    private void printSummary() throws Exception {
        String client = this.config.getLauncherConfig().getClient();
        String type = this.config.getTableInfo().getType();
        if ("com.mapr.ycsb.db.MapRDBClient".equals(client) || "json".equalsIgnoreCase(type) || "com.mapr.ycsb.db.MapRDBJavaClient".equals(client) || "json-java".equalsIgnoreCase(type)) {
            DBSummary.printSummary(this.config);
        }
    }

    public boolean exec(String cmd) throws JSchException, InterruptedException, ExecutionException {
        List<Future<RunCommand>> results = this.cluster.runCommand(cmd);
        boolean success = true;
        for (Future<RunCommand> result : results) {
            RunCommand run_cmd = result.get();
            if (run_cmd.getExitCode() == 0) continue;
            _logger.error("Command execution failed on " + run_cmd.getHost());
            success = false;
        }
        return success;
    }

    public void copyToRemote(String localFilePath, String remoteFilePath) throws InterruptedException, ExecutionException, JSchException {
        List<Future<CopyToRemote>> results = this.cluster.copyToRemote(localFilePath, remoteFilePath);
        for (Future<CopyToRemote> result : results) {
            result.get();
        }
    }

    public void copyFromRemote(String remoteFilePath, String localFilePath) throws InterruptedException, ExecutionException, JSchException {
        new File(localFilePath).getParentFile().mkdirs();
        List<Future<CopyFromRemote>> results = this.cluster.copyFromRemote(remoteFilePath, localFilePath);
        for (Future<CopyFromRemote> result : results) {
            result.get();
        }
    }

    public void createSessionFolder(String folder) throws JSchException, InterruptedException, ExecutionException {
        List<Future<RunCommand>> results = this.cluster.runCommand("mkdir -p " + folder);
        for (Future<RunCommand> cmd : results) {
            cmd.get();
        }
    }

    @Override
    protected Logger getLogger() {
        return _logger;
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, Exception {
        _logger.info("Starting YCSB Driver");
        int ret = ToolRunner.run((Tool)new Driver(), (String[])args);
        System.exit(ret);
    }

    public static class Config {
        private String hosts;
        private boolean createtable;
        @JsonProperty(value="files_to_collect")
        private String[] files_to_collect;

        public String getHosts() {
            return this.hosts;
        }

        public boolean isCreatetable() {
            return this.createtable;
        }

        public String[] getFilesToCollect() {
            return this.files_to_collect;
        }
    }
}

