/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb;

import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mapr.ycsb.App;
import com.mapr.ycsb.Command;
import com.mapr.ycsb.WorkloadRunner;
import com.mapr.ycsb.workload.Benchmark;
import com.mapr.ycsb.workload.Workload;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher
extends App {
    private static final Logger _logger = LoggerFactory.getLogger(Launcher.class);
    private int node_id;
    private int node_count;

    @Override
    public int run0() throws Exception {
        File idFile = new File("id");
        if (!idFile.exists()) {
            _logger.error("Unable to find 'id' file in the current directory, terminating.");
            return 1;
        }
        String java_bin = this.config.getJavaInfo().getBin();
        if (!new File(java_bin).exists()) {
            _logger.error("The specified java binary '{}' does not exist.", (Object)java_bin);
            return 1;
        }
        _logger.info("Found java binary at {}", (Object)java_bin);
        try (BufferedReader reader = new BufferedReader(new FileReader(idFile));){
            String[] parts = reader.readLine().split(":");
            this.node_id = Integer.parseInt(parts[0]);
            this.node_count = Integer.parseInt(parts[1]);
            _logger.info("Node id: {}.", (Object)this.node_id);
        }
        catch (Exception e) {
            _logger.error("Unable to get id from the file. " + e.getMessage(), (Throwable)e);
            return 1;
        }
        HashMap props = Maps.newHashMap();
        props.put("table", this.config.getTableInfo().getTable());
        props.put("columnfamily", this.config.getTableInfo().getFamily());
        Benchmark benchmark = this.config.getBenchmark();
        long rowPerNode = benchmark.getDocumentCount() / (long)this.node_count;
        long startRow = rowPerNode * (long)this.node_id;
        props.put("insertstart", String.valueOf(startRow));
        props.put("insertcount", String.valueOf(rowPerNode));
        Config launcherConfig = this.config.getLauncherConfig();
        LinkedList cmdDescList = Lists.newLinkedList();
        if (launcherConfig.runBefore != null) {
            for (Command cmd : launcherConfig.runBefore) {
                cmdDescList.add(cmd.run(this.config));
            }
        }
        for (Workload workload : benchmark.getWorkloads()) {
            if (workload.isEnabled()) {
                _logger.info("Starting workload {}.", (Object)workload.getId());
                workload.override(props);
                int err = new WorkloadRunner(this.config).run(workload);
                if (err != 0) {
                    _logger.error("Error {} encountered during workload execution.", (Object)err);
                    return err;
                }
                _logger.info("Workload {} completed.", (Object)workload.getId());
                continue;
            }
            _logger.info("Workload {} is disabled.", (Object)workload.getId());
        }
        ScheduledExecutorService shutDownScheduler = Executors.newScheduledThreadPool(1);
        if (!cmdDescList.isEmpty()) {
            _logger.info("Shutting down previously launched processes.");
            for (final Command.Desc desc : cmdDescList) {
                if (desc.watchDog == null) continue;
                shutDownScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        _logger.debug("Terminating {}.", (Object)desc.command());
                        try {
                            desc.watchDog.destroyProcess();
                            if (desc.out != null) {
                                desc.out.flush();
                                desc.out.close();
                            }
                        }
                        catch (IOException e) {
                            _logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }, (long)desc.command().getLingerFor(), TimeUnit.SECONDS);
            }
        }
        if (launcherConfig.runAfter != null) {
            for (Command cmd : launcherConfig.runAfter) {
                Command.Desc desc = cmd.run(this.config);
                if (desc.resultHandler != null) {
                    desc.resultHandler.waitFor();
                }
                if (desc.out == null) continue;
                desc.out.flush();
                desc.out.close();
            }
        }
        shutDownScheduler.shutdown();
        shutDownScheduler.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return _logger;
    }

    public int getId() {
        return this.node_id;
    }

    public static void main(String[] args) throws Exception {
        LoggerContext logCtx = (LoggerContext)LoggerFactory.getILoggerFactory();
        logCtx.getLogger("ROOT").detachAppender("STDOUT");
        logCtx.getLogger("com.mapr.ycsb").detachAppender("STDOUT");
        String ip = InetAddress.getLocalHost().getHostAddress();
        _logger.info("Starting Launcher on {}.", (Object)ip);
        int ret = ToolRunner.run((Tool)new Launcher(), (String[])args);
        System.exit(ret);
    }

    public static class Config {
        private String client;
        private Map<String, String> env;
        private Command[] runBefore;
        private Command[] runAfter;

        @JsonProperty(value="db")
        public String getClient() {
            return this.client;
        }

        @JsonProperty(value="env")
        public Map<String, String> getEnv() {
            return this.env;
        }

        @JsonProperty(value="run_before")
        public Command[] getRunBefore() {
            return this.runBefore;
        }

        @JsonProperty(value="run_after")
        public Command[] getRunAfter() {
            return this.runAfter;
        }
    }
}

