/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mapr.ycsb.Driver;
import com.mapr.ycsb.Launcher;
import com.mapr.ycsb.config.JavaInfo;
import com.mapr.ycsb.config.TableInfo;
import com.mapr.ycsb.workload.Benchmark;
import com.mapr.ycsb.workload.Workload;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger _logger = LoggerFactory.getLogger(Config.class);
    private static final File CURRENT_DIR = new File(System.getProperty("user.dir"));
    private File jarFile;
    private static ObjectMapper mapper = new ObjectMapper();
    private JavaInfo javaInfo;
    private Driver.Config driverConfig;
    private Launcher.Config launcherConfig;
    private Benchmark benchmark;
    private String javaCmdLine = null;
    private File configFile;
    private TableInfo tableInfo;

    @JsonProperty(value="java")
    public JavaInfo getJavaInfo() {
        return this.javaInfo;
    }

    @JsonProperty(value="tableinfo")
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    @JsonProperty(value="driver")
    public Driver.Config getDriverConfig() {
        return this.driverConfig;
    }

    @JsonProperty(value="launcher")
    public Launcher.Config getLauncherConfig() {
        return this.launcherConfig;
    }

    @JsonProperty(value="benchmark")
    public Benchmark getBenchmark() {
        return this.benchmark.setConfig(this);
    }

    @JsonIgnore
    public File getJarFile() {
        return this.jarFile;
    }

    @JsonIgnore
    public File getWorkingDir() {
        return CURRENT_DIR;
    }

    @JsonIgnore
    public synchronized CommandLine getJavaCmdLine() {
        if (this.javaCmdLine == null) {
            String hadoopClasspath = "";
            if (this.javaInfo.includeHadoopClasspath()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                CommandLine cmdLine = CommandLine.parse((String)"hadoop classpath");
                DefaultExecutor executor = new DefaultExecutor();
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)baos, (OutputStream)System.err));
                try {
                    _logger.info("Calculating Hadoop classpath.");
                    _logger.debug("Executing {}.", (Object)cmdLine);
                    executor.execute(cmdLine);
                    hadoopClasspath = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    _logger.debug(e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("Unable to launch 'hadoop classpath'. See logfile for more detail.");
                }
            }
            this.javaCmdLine = this.javaInfo.getBin() + " " + " -cp " + this.javaInfo.getClasspath() + File.pathSeparatorChar + this.getJarFile().getAbsolutePath() + File.pathSeparatorChar + hadoopClasspath;
        }
        CommandLine cmdLine = CommandLine.parse((String)this.javaCmdLine);
        cmdLine.addArguments(this.javaInfo.getArgs(), false);
        return cmdLine;
    }

    @JsonIgnore
    public File getConfigFile() {
        return this.configFile;
    }

    private Config init(File configFile) throws IOException {
        this.configFile = configFile;
        String jarPath = Config.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        this.jarFile = !jarPath.endsWith(".jar") ? new File(System.getProperty("user.dir"), "target/ycsb-driver-7.1.0.7-mapr.jar") : new File(jarPath);
        if (!this.jarFile.exists()) {
            throw new IllegalStateException("This command must be run from its JAR file. Unable to find " + this.jarFile);
        }
        return this;
    }

    public static Config load(File configFile) throws JsonParseException, JsonMappingException, IOException {
        return ((Config)mapper.readValue(configFile, Config.class)).init(configFile);
    }

    static {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.registerSubtypes((Class[])Workload.getSubTypes());
    }
}

