/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.db;

import com.google.common.collect.Lists;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DBException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.ojai.Document;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentBuilder {
    private static final Logger _logger = LoggerFactory.getLogger(DocumentBuilder.class);
    protected Config config;
    private static volatile List<Document> recordList;
    private static volatile int maxDocuments;
    private static volatile int numDocuments;
    Random rand = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DocumentBuilder(Config config) throws DBException {
        this.config = config;
        if (!config.fixedset) return;
        Class<DocumentBuilder> clazz = DocumentBuilder.class;
        synchronized (DocumentBuilder.class) {
            if (maxDocuments != 0) return;
            maxDocuments = config.fixedset_count;
            recordList = Lists.newArrayListWithCapacity((int)maxDocuments);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document newDocument(HashMap<String, ByteIterator> values) {
        Document record = null;
        if (this.config.fixedset) {
            if (numDocuments < maxDocuments) {
                List<Document> list = recordList;
                synchronized (list) {
                    if (numDocuments < maxDocuments) {
                        record = this.newDocument0(values);
                        recordList.add(record);
                        ++numDocuments;
                    }
                }
                if (numDocuments == maxDocuments) {
                    _logger.info("Finished generating {} records.", (Object)numDocuments);
                }
            }
            return record == null ? recordList.get(this.rand.nextInt(numDocuments)) : record;
        }
        return this.newDocument0(values);
    }

    public abstract Document newDocument0(HashMap<String, ByteIterator> var1);

    public abstract DocumentMutation newMutation(HashMap<String, ByteIterator> var1);

    public abstract HashMap<String, ByteIterator> buildRowResult(Document var1);

    public abstract HashMap<String, ByteIterator> buildRowResult(Document var1, HashMap<String, ByteIterator> var2);

    static {
        maxDocuments = 0;
        numDocuments = 0;
    }

    public static class Config {
        public String type = "default";
        public boolean fixedset = false;
        public int fixedset_count = 10000;
        private Map<String, ?> schema = null;

        public Map<String, ?> getSchema() {
            return this.schema;
        }
    }
}

