/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.ssh;

import com.jcraft.jsch.ChannelExec;
import com.mapr.ycsb.ssh.Cluster;
import com.mapr.ycsb.ssh.NodeTask;
import com.mapr.ycsb.ssh.SSHSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyToRemote
extends NodeTask<CopyToRemote> {
    private static final Logger _logger = LoggerFactory.getLogger(CopyToRemote.class);
    private final File localFile;
    private String remoteFilePath;

    public CopyToRemote(Cluster cluster, String host, String localFile, String remoteFile) {
        super(cluster, host);
        this.localFile = new File(localFile);
        this.remoteFilePath = remoteFile;
    }

    @Override
    public CopyToRemote run(SSHSession session) throws Exception {
        int len;
        this.remoteFilePath = session.substituteId(this.remoteFilePath);
        _logger.debug("Copying {} to {}", (Object)this.localFile, (Object)this.remoteFilePath);
        StringBuilder command = new StringBuilder("scp -p -t ").append(this.remoteFilePath);
        ChannelExec channel = session.openChannelExec("exec");
        channel.setCommand(command.toString());
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();
        channel.connect();
        this.checkAck(in);
        command.setLength(0);
        Path localFileDir = Paths.get(this.localFile.getParent(), new String[0]);
        Path localFilePath = localFileDir.resolve(this.localFile.getName());
        BasicFileAttributes attrs = Files.readAttributes(localFilePath, BasicFileAttributes.class, new LinkOption[0]);
        command.append("T").append(attrs.lastModifiedTime().toMillis() / 1000L).append(" 0");
        command.append(" ").append(attrs.lastAccessTime().toMillis() / 1000L).append(" 0\n");
        _logger.debug("Transmiting last modified and access time");
        out.write(command.toString().getBytes(StandardCharsets.UTF_8));
        out.flush();
        this.checkAck(in);
        command.setLength(0);
        long filesize = this.localFile.length();
        command.append("C0644 ").append(filesize).append(" ").append(this.localFile.getName()).append('\n');
        _logger.debug("Transmiting file size and name");
        out.write(command.toString().getBytes(StandardCharsets.UTF_8));
        out.flush();
        this.checkAck(in);
        FileInputStream fis = new FileInputStream(this.localFile);
        _logger.debug("Transmiting file content");
        byte[] buf = new byte[1024];
        long transmitted = 0L;
        long lastPercentTransmitted = 0L;
        while ((len = fis.read(buf, 0, buf.length)) > 0) {
            out.write(buf, 0, len);
            long percentTransmitted = (transmitted += (long)len) * 100L / filesize;
            if (percentTransmitted <= lastPercentTransmitted || percentTransmitted % 10L != 0L) continue;
            lastPercentTransmitted = percentTransmitted;
            _logger.debug("{}% complete", (Object)percentTransmitted);
        }
        fis.close();
        buf[0] = 0;
        out.write(buf, 0, 1);
        out.flush();
        this.checkAck(in);
        out.close();
        channel.disconnect();
        _logger.debug("Transmission complete.");
        return this;
    }
}

