/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.db;

import com.google.common.io.ByteStreams;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.ycsb.App;
import com.mapr.ycsb.config.Config;
import com.mapr.ycsb.db.SchemaDocumentBuilder;
import com.yahoo.ycsb.DBException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSizeCalculator
extends App {
    private static final Logger _logger = LoggerFactory.getLogger(DocumentSizeCalculator.class);

    @Override
    protected int run0() throws Exception {
        System.out.println(this.getDocumentSize(this.config));
        return 0;
    }

    private long getDocumentSize(Config config) throws DBException {
        Document r = new SchemaDocumentBuilder(config.getBenchmark().getDocumentBuilderConfig()).newDocument(null);
        ByteBuffer buff = RowcolCodec.encode((Document)r);
        return buff.remaining();
    }

    @Override
    protected Logger getLogger() {
        return _logger;
    }

    public static long calculate(Config config) {
        try {
            return new DocumentSizeCalculator().getDocumentSize(config);
        }
        catch (Throwable t) {
            _logger.debug("Unable to calculate in-process, will launch externally");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                CommandLine cmdLine = config.getJavaCmdLine().addArgument("-Xloggc:/dev/null").addArgument(" com.mapr.ycsb.db.DocumentSizeCalculator ").addArgument(config.getConfigFile().getAbsolutePath());
                DefaultExecutor executor = new DefaultExecutor();
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)baos, ByteStreams.nullOutputStream()));
                executor.execute(cmdLine);
                String sizeStr = new String(baos.toByteArray(), StandardCharsets.UTF_8).trim();
                _logger.debug("Calculated record size = '{}'", (Object)sizeStr);
                return Long.parseLong(sizeStr);
            }
            catch (Exception e) {
                _logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, Exception {
        int ret = ToolRunner.run((Tool)new DocumentSizeCalculator(), (String[])args);
        System.exit(ret);
    }
}

