/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb;

import com.mapr.ycsb.config.Config;
import com.mapr.ycsb.workload.Workload;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadRunner {
    private static final Logger _logger = LoggerFactory.getLogger(WorkloadRunner.class);
    private Config config;

    public WorkloadRunner(Config config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(Workload workload) {
        File logFile = new File(this.config.getWorkingDir(), "./logs/" + workload.getId() + "_out.log");
        try (FileOutputStream logStream = new FileOutputStream(logFile);){
            String client = this.config.getLauncherConfig().getClient();
            if (client == null) {
                String dbType = this.config.getTableInfo().getType();
                if (dbType == null) {
                    _logger.error("Either 'tableinfo.type' or 'launcher.db' must be specified.");
                    int n = 1;
                    return n;
                }
                client = dbType.equalsIgnoreCase("json") ? "com.mapr.ycsb.db.MapRDBClient" : (dbType.equalsIgnoreCase("json-java") ? "com.mapr.ycsb.db.MapRDBJavaClient" : "com.yahoo.ycsb.db.HBaseClient");
            }
            CommandLine cmdLine = this.config.getJavaCmdLine().addArgument("-Xloggc:./logs/" + workload.getId() + "_gc.log").addArgument("com.yahoo.ycsb.Client").addArgument("-s").addArgument("-db").addArgument(client).addArgument("-p").addArgument("workload=com.yahoo.ycsb.workloads.CoreWorkload").addArgument("-p").addArgument("dbconfigfile=" + this.config.getConfigFile().getAbsolutePath()).addArgument("-p").addArgument("exportfile=./logs/" + workload.getId() + "_status.log").addArgument("-p").addArgument("multicf=" + this.config.getTableInfo().getMulticf()).addArguments(CommandLine.parse((String)workload.getParams().toString()).toStrings());
            _logger.info("Launching {}.", (Object)cmdLine.toString());
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.config.getWorkingDir());
            _logger.info("Logging output to '{}'", (Object)logFile);
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)logStream));
            if (workload.getWaitBefore() > 0) {
                _logger.info("Sleeping for {} seconds", (Object)workload.getWaitBefore());
                Thread.sleep(workload.getWaitBefore() * 1000);
            }
            int code = executor.execute(cmdLine, this.config.getLauncherConfig().getEnv());
            if (workload.getWaitAfter() > 0) {
                _logger.info("Sleeping for {} seconds", (Object)workload.getWaitAfter());
                Thread.sleep(workload.getWaitAfter() * 1000);
            }
            int n = code;
            return n;
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return 1;
        }
    }
}

