/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.ssh;

import com.google.common.collect.Maps;
import com.jcraft.jsch.JSchException;
import com.mapr.ycsb.ssh.SSHSession;
import java.util.Map;

public class SessionManager {
    final Map<String, SSHSession> sessionMap = Maps.newHashMap();
    private final String user;

    public SessionManager(String user) {
        this.user = user;
    }

    public synchronized SSHSession getSession(String host) throws JSchException {
        String hostString = this.user + "@" + host;
        SSHSession session = this.sessionMap.get(hostString);
        if (session == null || !session.isConnected()) {
            session = new SSHSession(this.user, host);
            this.sessionMap.put(hostString, session);
        }
        return session;
    }

    public void shoutdown() {
        for (SSHSession session : this.sessionMap.values()) {
            if (!session.isConnected()) continue;
            session.disconnect();
        }
    }
}

