/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAdminClient
extends Configured
implements Tool {
    private static final Logger _logger = LoggerFactory.getLogger(HBaseAdminClient.class);
    private static final String PARAM_NAME_NUM_REGIONS = "num_regions";
    private static final String PARAM_NAME_FAMILY = "family";
    private static final String PARAM_NAME_COMPRESSION = "compression";
    private static final String PARAM_NAME_TYPE = "type";
    private static final String PARAM_NAME_KEY_PREFIX = "key_prefix";
    private static final int PARAM_NAME_NUM_REGIONS_DEFAULT = 100;
    private static final String PARAM_NAME_FAMILY_DEFAULT = "family";
    private static final String PARAM_NAME_COMPRESSION_DEFAULT = "NONE";
    private static final String PARAM_NAME_TYPE_DEFAULT = "hbase";
    private static final String PARAM_NAME_KEY_PREFIX_DEFAULT = "user";
    HBaseAdmin admin_;
    String compression_;
    protected int num_splits_;
    protected TableName tablename_;
    protected String family_;
    protected String type_;
    protected String key_prefix_;
    protected Operation operation_;

    public HBaseAdminClient() {
        super(HBaseConfiguration.create());
    }

    public int run(String[] args) throws Exception {
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs == null || otherArgs.length != 2) {
            this.usage();
            return 1;
        }
        this.tablename_ = TableName.valueOf((String)otherArgs[1]);
        this.operation_ = Operation.valueOf(otherArgs[0].toUpperCase());
        this.family_ = this.getConf().get("family", "family");
        this.type_ = this.getConf().get(PARAM_NAME_TYPE, PARAM_NAME_TYPE_DEFAULT).toUpperCase();
        this.key_prefix_ = this.getConf().get(PARAM_NAME_KEY_PREFIX, PARAM_NAME_KEY_PREFIX_DEFAULT);
        this.compression_ = this.getConf().get(PARAM_NAME_COMPRESSION, PARAM_NAME_COMPRESSION_DEFAULT).toUpperCase();
        this.num_splits_ = this.getConf().getInt(PARAM_NAME_NUM_REGIONS, 100) - 1;
        return this.run0();
    }

    protected int run0() throws IOException {
        try (HBaseAdmin admin = new HBaseAdmin(this.getConf());){
            this.admin_ = admin;
            switch (this.operation_) {
                case CREATE: {
                    int n = this.createTable();
                    return n;
                }
                case DROP: {
                    int n = this.dropTable();
                    return n;
                }
                case ENABLE: {
                    int n = this.enableTable();
                    return n;
                }
                case DISABLE: {
                    int n = this.disableTable();
                    return n;
                }
            }
            int n = 1;
            return n;
        }
    }

    protected int disableTable() throws IOException {
        if (this.admin_.isTableEnabled(this.tablename_)) {
            _logger.info("Disabling table: {}", (Object)this.tablename_);
            try {
                this.admin_.disableTable(this.tablename_);
                _logger.info("Table: {} disabled", (Object)this.tablename_);
            }
            catch (IOException e) {
                _logger.error("Error disabling table: " + this.tablename_ + ".\n", (Throwable)e);
            }
        } else {
            _logger.info("Table: {} is already disabled.", (Object)this.tablename_);
        }
        return 0;
    }

    protected int enableTable() throws IOException {
        if (this.admin_.isTableDisabled(this.tablename_)) {
            _logger.info("Enabling table: " + this.tablename_);
            try {
                this.admin_.enableTable(this.tablename_);
                _logger.info("Table: {} enabled.", (Object)this.tablename_);
            }
            catch (IOException e) {
                _logger.error("Error enabling table: " + this.tablename_ + ".", (Throwable)e);
                throw e;
            }
        } else {
            _logger.info("Table: {} is already enabled.", (Object)this.tablename_);
        }
        return 0;
    }

    protected int dropTable() throws IOException {
        this.disableTable();
        _logger.info("Deleting table: " + this.tablename_);
        try {
            this.admin_.deleteTable(this.tablename_);
            _logger.info("Table: {} deleted.", (Object)this.tablename_);
        }
        catch (IOException e) {
            _logger.error("Error deleting table: " + this.tablename_ + ".", (Throwable)e);
            throw e;
        }
        return 0;
    }

    protected int createTable() throws IOException {
        if (this.admin_.tableExists(this.tablename_)) {
            _logger.error("Table: {} already exists.", (Object)this.tablename_);
            return 1;
        }
        _logger.info("Creating table: {} with column family: {} and total {} regions.", new Object[]{this.tablename_, this.family_, this.num_splits_ + 1});
        HTableDescriptor descriptor = new HTableDescriptor(this.tablename_);
        HColumnDescriptor family = new HColumnDescriptor(this.family_);
        family.setCompressionType(Compression.Algorithm.valueOf((String)this.compression_));
        descriptor.addFamily(family);
        descriptor.setValue("TABLETYPE", this.type_);
        try {
            this.admin_.createTable(descriptor, this.getSplits());
            _logger.info("Table: {} created.", (Object)this.tablename_);
        }
        catch (IOException e) {
            _logger.error("Error creating table: " + this.tablename_ + ".\n" + e.getMessage());
            throw e;
        }
        return 0;
    }

    protected void usage() {
        System.out.println("HBaseAdminClient 1.0\nUsage:\n");
        System.out.println(((Object)((Object)this)).getClass().getName() + " [-Doption=value]... <operation> <table_path>");
    }

    protected byte[][] getSplits() {
        long start = 1000000L;
        long end = 9999999L;
        long delta = (end - start) / (long)this.num_splits_;
        ArrayList<String> splitKeys = new ArrayList<String>();
        long split = start;
        for (int i = 0; i < this.num_splits_; ++i) {
            splitKeys.add(this.key_prefix_ + (split += delta));
        }
        Collections.sort(splitKeys);
        _logger.info("Split keys: {}", splitKeys);
        byte[][] splits = new byte[this.num_splits_][];
        int i = 0;
        for (String key : splitKeys) {
            splits[i++] = key.getBytes();
        }
        return splits;
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, Exception {
        _logger.info("Starting HBaseAdminClient");
        int ret = ToolRunner.run((Tool)new HBaseAdminClient(), (String[])args);
        System.exit(ret);
    }

    public static enum Operation {
        CREATE,
        DROP,
        ENABLE,
        DISABLE;

    }
}

