/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.ssh;

import com.google.common.collect.Lists;
import com.jcraft.jsch.JSchException;
import com.mapr.ycsb.ssh.CopyFromRemote;
import com.mapr.ycsb.ssh.CopyToRemote;
import com.mapr.ycsb.ssh.RunCommand;
import com.mapr.ycsb.ssh.SessionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster {
    private static final Logger _logger = LoggerFactory.getLogger(Cluster.class);
    public static final String ID_FILE = "id";
    private final SessionManager manager;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final List<String> clusterNodes = Lists.newLinkedList();

    public Cluster(String hosts) {
        this("root", hosts);
    }

    public Cluster(String user, String hosts) {
        try {
            this.manager = new SessionManager(user);
            this.buildNodeList(hosts);
            _logger.info("Cluster initialized with {} nodes.", this.clusterNodes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse host/IP string: " + hosts, e);
        }
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    public List<Future<CopyToRemote>> copyToRemote(String localFile, String remoteFile) throws JSchException {
        ArrayList copyFuture = Lists.newArrayList();
        for (String node : this.clusterNodes) {
            CopyToRemote cmd = new CopyToRemote(this, node, localFile, remoteFile);
            copyFuture.add(this.executor.submit(cmd));
        }
        return copyFuture;
    }

    public List<Future<CopyFromRemote>> copyFromRemote(String remoteFile, String localFile) throws JSchException {
        ArrayList copyFuture = Lists.newArrayList();
        for (String node : this.clusterNodes) {
            CopyFromRemote cmd = new CopyFromRemote(this, node, remoteFile, localFile);
            copyFuture.add(this.executor.submit(cmd));
        }
        return copyFuture;
    }

    public List<Future<RunCommand>> copyId(String remoteDir) throws JSchException {
        ArrayList cmdsFuture = Lists.newArrayList();
        int id = 0;
        for (String node : this.clusterNodes) {
            StringBuilder idcmd = new StringBuilder().append("echo ").append(id++).append(':').append(this.clusterNodes.size()).append(" > ").append(remoteDir).append('/').append(ID_FILE);
            RunCommand cmd = new RunCommand(this, node, idcmd.toString());
            cmdsFuture.add(this.executor.submit(cmd));
        }
        return cmdsFuture;
    }

    public List<Future<RunCommand>> runCommand(String command) throws JSchException {
        ArrayList cmdsFuture = Lists.newArrayList();
        for (String node : this.clusterNodes) {
            RunCommand cmd = new RunCommand(this, node, command);
            cmdsFuture.add(this.executor.submit(cmd));
        }
        return cmdsFuture;
    }

    public void shoutdown() {
        this.manager.shoutdown();
        this.executor.shutdown();
    }

    private void buildNodeList(String hosts) {
        String prefix = hosts;
        String[] nodes = null;
        if (hosts.matches("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\..*")) {
            String[] parts = hosts.split("\\.");
            String range = parts[3];
            if (range.charAt(0) == '[' && range.charAt(range.length() - 1) == ']') {
                prefix = parts[0] + "." + parts[1] + "." + parts[2] + ".";
                nodes = range.substring(1, range.length() - 1).split(",");
            }
        } else {
            int begin = hosts.lastIndexOf(91);
            int end = hosts.lastIndexOf(93);
            if (begin != -1 && end != -1 && begin < end) {
                prefix = hosts.substring(0, begin);
                nodes = hosts.substring(begin + 1, end).split(",");
            }
        }
        if (nodes == null || nodes.length == 0) {
            this.clusterNodes.add(prefix);
        } else {
            for (void var7_10 : nodes) {
                if (var7_10.contains("-")) {
                    String[] rangeLimit = var7_10.split("-");
                    int startIP = Integer.parseInt(rangeLimit[0].trim());
                    int stopIP = Integer.parseInt(rangeLimit[1].trim());
                    for (int i = startIP; i <= stopIP; ++i) {
                        this.clusterNodes.add(prefix + i);
                    }
                    continue;
                }
                this.clusterNodes.add(prefix + var7_10.trim());
            }
        }
    }
}

