/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;

@Category(value={ClusterTest.class})
public class TestMCFOrder
extends BaseTest {
    private static MapRDBTableImpl srcTable = null;
    private static MapRDBTableImpl dstTable = null;

    @Test
    public void testMCFEncodingWithDifferentFamilyOrder() throws IOException {
        String SRC_PATH = "/testtable-TestMCFEncodingWithDifferentFamilyOrderSrc";
        String DST_PATH = "/testtable-TestMCFEncodingWithDifferentFamilyOrderDst";
        LinkedHashMap<String, String> cfPath = new LinkedHashMap<String, String>();
        cfPath.put("CF1", "a.b");
        cfPath.put("CF2", "c.d");
        MapRDBTableImpl srcTab = (MapRDBTableImpl)DBTests.createOrReplaceTable(SRC_PATH, cfPath);
        srcTab.setPrivateOption(BaseJsonTable.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        Document d = MapRDBImpl.newDocument().set("x", 123).set("a.b.p", "xyz").set("c.d", false);
        srcTab.insertOrReplace("k1", d);
        srcTab.flush();
        LinkedHashMap<String, String> cfPath2 = new LinkedHashMap<String, String>();
        cfPath2.put("CF1", "c.d");
        cfPath2.put("CF2", "a.b");
        MapRDBTableImpl destTab = (MapRDBTableImpl)DBTests.createOrReplaceTable(DST_PATH, cfPath2);
        destTab.setPrivateOption(BaseJsonTable.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        Document srcDoc = (Document)srcTab.find().iterator().next();
        destTab.insertOrReplace("k1", srcDoc);
        destTab.flush();
        Document destDoc = (Document)destTab.find().iterator().next();
        Assert.assertEquals((long)123L, (long)destDoc.getInt("x"));
        Assert.assertEquals((Object)"xyz", (Object)destDoc.getString("a.b.p"));
        Assert.assertEquals((Object)false, (Object)destDoc.getBoolean("c.d"));
    }

    @Test
    public void testMCFEncodingOneToManyFamily() throws IOException {
        String SRC_PATH = "/Testtable-testMCFEncodingOneToManyFamilySrc";
        String DST_PATH = "/Testtable-testMCFEncodingOneToManyFamilyDst";
        MapRDBTableImpl srcTab = (MapRDBTableImpl)DBTests.createOrReplaceTable(SRC_PATH);
        srcTab.setPrivateOption(BaseJsonTable.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        Document d = MapRDBImpl.newDocument().set("x", 456).set("a.b.p", "abc").set("c.d", true);
        srcTab.insertOrReplace("k1", d);
        srcTab.flush();
        LinkedHashMap<String, String> cfPath2 = new LinkedHashMap<String, String>();
        cfPath2.put("CF1", "c.d");
        cfPath2.put("CF2", "a.b");
        MapRDBTableImpl destTab = (MapRDBTableImpl)DBTests.createOrReplaceTable(DST_PATH, cfPath2);
        destTab.setPrivateOption(BaseJsonTable.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        Document srcDoc = (Document)srcTab.find().iterator().next();
        destTab.insertOrReplace("k1", srcDoc);
        destTab.flush();
        Document destDoc = (Document)destTab.find().iterator().next();
        Assert.assertEquals((long)456L, (long)destDoc.getInt("x"));
        Assert.assertEquals((Object)"abc", (Object)destDoc.getString("a.b.p"));
        Assert.assertEquals((Object)true, (Object)destDoc.getBoolean("c.d"));
    }

    @Test
    public void testMCFEncodingSrcHasMoreFamily() throws IOException {
        String SRC_PATH = "/Testtable-TestMCFEncodingSrcHasMoreFamilySrc";
        String DST_PATH = "/Testtable-TestMCFEncodingSrcHasMoreFamilyDst";
        LinkedHashMap<String, String> cfPath = new LinkedHashMap<String, String>();
        cfPath.put("CFA", "used");
        cfPath.put("CF1", "a.b");
        cfPath.put("CF2", "c.d");
        cfPath.put("CFB", "not.used");
        MapRDBTableImpl srcTab = (MapRDBTableImpl)DBTests.createOrReplaceTable(SRC_PATH, cfPath);
        srcTab.setPrivateOption(BaseJsonTable.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        Document d = MapRDBImpl.newDocument().set("x", 111).set("used", "dsthasthisfamilyid").set("a.b.p", "aaa");
        srcTab.insertOrReplace("k1", d);
        srcTab.flush();
        LinkedHashMap<String, String> cfPath2 = new LinkedHashMap<String, String>();
        cfPath2.put("CF1", "c.d");
        cfPath2.put("CF2", "a.b");
        MapRDBTableImpl destTab = (MapRDBTableImpl)DBTests.createOrReplaceTable(DST_PATH, cfPath2);
        destTab.setPrivateOption(BaseJsonTable.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        Document srcDoc = srcTab.findById("k1");
        destTab.insertOrReplace("k1", srcDoc);
        destTab.flush();
        Document destDoc = destTab.findById("k1");
        Assert.assertEquals((long)111L, (long)destDoc.getInt("x"));
        Assert.assertEquals((Object)"aaa", (Object)destDoc.getString("a.b.p"));
        Assert.assertEquals((Object)"dsthasthisfamilyid", (Object)destDoc.getString("used"));
        d = MapRDBImpl.newDocument().set("x", 222).set("a.b.p", "bbb").set("not.used", "dstdosNOThasthisfamilyid");
        srcTab.insertOrReplace("k2", d);
        srcTab.flush();
        srcDoc = srcTab.findById("k2");
        destTab.insertOrReplace("k2", srcDoc);
        destTab.flush();
        destDoc = destTab.findById("k2");
        Assert.assertEquals((long)222L, (long)destDoc.getInt("x"));
        Assert.assertEquals((Object)"bbb", (Object)destDoc.getString("a.b.p"));
        Assert.assertEquals((Object)"dstdosNOThasthisfamilyid", (Object)destDoc.getString("not.used"));
    }
}

