/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.util.DocumentReaderStack;
import com.mapr.db.util.JdkDocumentReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ojai.DocumentReader;

public class ListDocumentReader
extends JdkDocumentReader {
    private final List<Object> theList;
    private final Iterator<Object> iter;
    private Object object;
    private int arrayIndex = -1;

    public ListDocumentReader(List<Object> theList, DocumentReaderStack docReaderStack) {
        super(docReaderStack);
        this.theList = Collections.unmodifiableList(new ArrayList<Object>(theList));
        this.iter = this.theList.iterator();
    }

    public DocumentReader.EventType next() {
        if (!this.iter.hasNext()) {
            this.docReaderStack.pop();
            return this.docReaderStack.enqueue(DocumentReader.EventType.END_ARRAY);
        }
        this.object = this.iter.next();
        ++this.arrayIndex;
        return this.docReaderStack.enqueue(this.object);
    }

    @Override
    public int getArrayIndex() {
        return this.arrayIndex;
    }

    @Override
    protected Object getObject() {
        return this.object;
    }
}

