/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.beans;

import com.google.common.primitives.Ints;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.beans.model.BeanWithAllTypes;
import com.mapr.db.tests.beans.model.User;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.Value;

@Category(value={SimpleTest.class})
public class TestJavaBeans
extends BaseTest {
    @Test
    public void testJavaBeansWithAllTypes() {
        BeanWithAllTypes bean = new BeanWithAllTypes().init();
        Document doc = MapRDBImpl.newDocument((Object)bean);
        BeanWithAllTypes newBean = (BeanWithAllTypes)doc.toJavaBean(BeanWithAllTypes.class);
        Assert.assertEquals((Object)Value.Type.NULL, (Object)doc.getValue("nullT").getType());
        Assert.assertEquals((Object)bean.getNullT(), (Object)newBean.getNullT());
        Assert.assertEquals((Object)bean.isBooleanT(), (Object)doc.getBoolean("booleanT"));
        Assert.assertEquals((Object)bean.isBooleanT(), (Object)newBean.isBooleanT());
        Assert.assertEquals((Object)bean.getStringT(), (Object)doc.getString("stringT"));
        Assert.assertEquals((Object)bean.getStringT(), (Object)newBean.getStringT());
        Assert.assertEquals((long)bean.getByteT(), (long)doc.getByte("byteT"));
        Assert.assertEquals((long)bean.getByteT(), (long)newBean.getByteT());
        Assert.assertEquals((long)bean.getShortT(), (long)doc.getShort("shortT"));
        Assert.assertEquals((long)bean.getShortT(), (long)newBean.getShortT());
        Assert.assertEquals((long)bean.getIntT(), (long)doc.getInt("intT"));
        Assert.assertEquals((long)bean.getIntT(), (long)newBean.getIntT());
        Assert.assertEquals((long)bean.getLongT(), (long)doc.getLong("longT"));
        Assert.assertEquals((long)bean.getLongT(), (long)newBean.getLongT());
        Assert.assertEquals((float)bean.getFloatT(), (float)doc.getFloat("floatT"), (float)0.0f);
        Assert.assertEquals((float)bean.getFloatT(), (float)newBean.getFloatT(), (float)0.0f);
        Assert.assertEquals((double)bean.getDoubleT(), (double)doc.getDouble("doubleT"), (double)0.0);
        Assert.assertEquals((double)bean.getDoubleT(), (double)newBean.getDoubleT(), (double)0.0);
        Assert.assertEquals((Object)bean.getBigDecimalT(), (Object)doc.getDecimal("bigDecimalT"));
        Assert.assertEquals((Object)bean.getBigDecimalT(), (Object)newBean.getBigDecimalT());
        Assert.assertEquals((Object)bean.getTimeT().toString(), (Object)doc.getTime("timeT").toString());
        Assert.assertEquals((Object)bean.getTimeT().toString(), (Object)newBean.getTimeT().toString());
        Assert.assertEquals((Object)bean.getTimestampT(), (Object)doc.getTimestamp("timestampT"));
        Assert.assertEquals((Object)bean.getTimestampT(), (Object)newBean.getTimestampT());
        Assert.assertEquals((Object)bean.getByteBufferT(), (Object)doc.getBinary("byteBufferT"));
        Assert.assertEquals((Object)bean.getByteBufferT(), (Object)newBean.getByteBufferT());
        Assert.assertEquals((Object)Ints.asList((int[])bean.getIntArrayT()), (Object)doc.getList("intArrayT"));
        Assert.assertArrayEquals((int[])bean.getIntArrayT(), (int[])newBean.getIntArrayT());
        Assert.assertEquals((Object)bean.getChildObjectT(), (Object)newBean.getChildObjectT());
        Assert.assertEquals((Object)bean.getBigDecimalT(), (Object)doc.getDecimal("bigDecimalT"));
        Assert.assertEquals((Object)bean.getBigDecimalT(), (Object)newBean.getBigDecimalT());
    }

    @Test
    public void testMultiLevelJavaBeans() {
        String jsonString = "{ \"_id\" : \"1001\", \"first_name\" : \"John\", \"last_name\" : \"Doe\", \"active\" : false, \"age\" : 35, \"interests\" : [\"sports\",\"computers\"], \"account\" : 1234.4321, \"address\" : {     \"street\" : \"1015 15th av\",     \"city\" : \"SFO\",     \"zip\" : 94065    }}";
        Document doc = MapRDBImpl.newDocument((String)jsonString);
        User user = (User)doc.toJavaBean(User.class);
        Document userDoc = MapRDBImpl.newDocument((Object)user);
        Assert.assertNotEquals((Object)doc, (Object)userDoc);
        Assert.assertEquals((Object)doc.getString("first_name"), (Object)userDoc.getString("first_name"));
        Assert.assertEquals((Object)user.getFirstName(), (Object)userDoc.getString("first_name"));
        Assert.assertEquals((Object)doc.getString("last_name"), (Object)userDoc.getString("last_name"));
        Assert.assertEquals((Object)user.getLastName(), (Object)userDoc.getString("last_name"));
        Assert.assertEquals((double)doc.getDouble("age"), (double)userDoc.getInt("age"), (double)0.0);
        Assert.assertEquals((double)user.getAge(), (double)userDoc.getInt("age"), (double)0.0);
        Assert.assertEquals((Object)doc.getString("address.city"), (Object)userDoc.getString("address.city"));
        Assert.assertEquals((Object)user.getAddress().getTown(), (Object)userDoc.getString("address.city"));
        Document addressDoc = MapRDBImpl.newDocument((Object)user.getAddress());
        Assert.assertEquals((Object)addressDoc, (Object)userDoc.getMap("address"));
    }
}

