/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.ArrayComponent;
import com.mapr.db.indexrowkeyfmt.BooleanComponent;
import com.mapr.db.indexrowkeyfmt.ByteArrayComponent;
import com.mapr.db.indexrowkeyfmt.DateComponent;
import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.ErrorComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.MapComponent;
import com.mapr.db.indexrowkeyfmt.MissingComponent;
import com.mapr.db.indexrowkeyfmt.Null;
import com.mapr.db.indexrowkeyfmt.NullComponent;
import com.mapr.db.indexrowkeyfmt.NumericComponent;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.db.indexrowkeyfmt.OMap;
import com.mapr.db.indexrowkeyfmt.StringComponent;
import com.mapr.db.indexrowkeyfmt.TimeComponent;
import com.mapr.db.indexrowkeyfmt.TimestampComponent;
import java.util.ArrayList;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class IndexRowKeyComponentArray {
    private boolean missingAndNullFirst_;
    private int numComponents_;
    private ArrayList<IndexRowKeyComponent> components_;

    public IndexRowKeyComponentArray() {
        this.init(0);
    }

    public IndexRowKeyComponentArray(int numComponents, boolean missingAndNullFirst) {
        this.missingAndNullFirst_ = missingAndNullFirst;
        this.init(numComponents);
    }

    public void init(int numComponents) {
        this.numComponents_ = numComponents;
        this.components_ = new ArrayList(this.numComponents_);
        this.reset();
    }

    public void init(int numComponents, boolean missingAndNullFirst) {
        this.init(numComponents);
        this.missingAndNullFirst_ = missingAndNullFirst;
    }

    public void reset() {
        for (int i = 0; i < this.numComponents_; ++i) {
            this.components_.add(null);
        }
    }

    public void set(int idx, Error componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new ErrorComponent(componentValue));
    }

    public void emplace_back(Error componentValue, boolean descendingOrder) {
        this.components_.add(new ErrorComponent(componentValue));
        ++this.numComponents_;
    }

    public void set(int idx, Null componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new NullComponent(this.missingAndNullFirst_, descendingOrder));
    }

    public void emplace_back(Null componentValue, boolean descendingOrder) {
        this.components_.add(new NullComponent(this.missingAndNullFirst_, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, boolean componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new BooleanComponent(componentValue, descendingOrder));
    }

    public void emplace_back(boolean componentValue, boolean descendingOrder) {
        this.components_.add(new BooleanComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, byte[] componentValue, int componentSize, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new ByteArrayComponent(componentValue, componentSize, descendingOrder));
    }

    public void emplace_back(byte[] componentValue, int componentSize, boolean descendingOrder) {
        this.components_.add(new ByteArrayComponent(componentValue, componentSize, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new MissingComponent(this.missingAndNullFirst_, descendingOrder));
    }

    public void emplace_back(boolean descendingOrder) {
        this.components_.add(new MissingComponent(this.missingAndNullFirst_, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, byte componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new NumericComponent(componentValue, descendingOrder));
    }

    public void emplace_back(byte componentValue, boolean descendingOrder) {
        this.components_.add(new NumericComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, short componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new NumericComponent(componentValue, descendingOrder));
    }

    public void emplace_back(short componentValue, boolean descendingOrder) {
        this.components_.add(new NumericComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, int componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new NumericComponent(componentValue, descendingOrder));
    }

    public void emplace_back(int componentValue, boolean descendingOrder) {
        this.components_.add(new NumericComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, long componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new NumericComponent(componentValue, descendingOrder));
    }

    public void emplace_back(long componentValue, boolean descendingOrder) {
        this.components_.add(new NumericComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, float componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new NumericComponent(componentValue, descendingOrder));
    }

    public void emplace_back(float componentValue, boolean descendingOrder) {
        this.components_.add(new NumericComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, double componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new NumericComponent(componentValue, descendingOrder));
    }

    public void emplace_back(double componentValue, boolean descendingOrder) {
        this.components_.add(new NumericComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, byte[] componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new StringComponent(componentValue, descendingOrder));
    }

    public void emplace_back(byte[] componentValue, boolean descendingOrder) {
        this.components_.add(new StringComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, OTime componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new TimeComponent(componentValue, descendingOrder));
    }

    public void emplace_back(OTime componentValue, boolean descendingOrder) {
        this.components_.add(new TimeComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, OTimestamp componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new TimestampComponent(componentValue, descendingOrder));
    }

    public void emplace_back(OTimestamp componentValue, boolean descendingOrder) {
        this.components_.add(new TimestampComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, ODate componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new DateComponent(componentValue, descendingOrder));
    }

    public void emplace_back(ODate componentValue, boolean descendingOrder) {
        this.components_.add(new DateComponent(componentValue, descendingOrder));
        ++this.numComponents_;
    }

    public void set(int idx, OArray componentValue, boolean descendingOrder) {
        this.set(idx, componentValue, descendingOrder, false);
    }

    public void set(int idx, OArray componentValue, boolean descendingOrder, boolean root) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new ArrayComponent(componentValue, this.missingAndNullFirst_, descendingOrder, root));
    }

    public void emplace_back(OArray componentValue, boolean descendingOrder) {
        this.emplace_back(componentValue, descendingOrder, false);
    }

    public void emplace_back(OArray componentValue, boolean descendingOrder, boolean root) {
        this.components_.add(new ArrayComponent(componentValue, this.missingAndNullFirst_, descendingOrder, root));
        ++this.numComponents_;
    }

    public void set(int idx, OMap componentValue, boolean descendingOrder) {
        this.set(idx, componentValue, descendingOrder, false);
    }

    public void set(int idx, OMap componentValue, boolean descendingOrder, boolean root) {
        assert (idx < this.numComponents_);
        this.components_.set(idx, new MapComponent(componentValue, this.missingAndNullFirst_, descendingOrder, root));
    }

    public void emplace_back(OMap componentValue, boolean descendingOrder) {
        this.emplace_back(componentValue, descendingOrder, false);
    }

    public void emplace_back(OMap componentValue, boolean descendingOrder, boolean root) {
        this.components_.add(new MapComponent(componentValue, this.missingAndNullFirst_, descendingOrder, root));
        ++this.numComponents_;
    }

    public IndexRowKeyComponent get(int idx) {
        return this.components_.get(idx);
    }

    public IndexRowKeyComponent back() {
        return this.components_.get(this.components_.size() - 1);
    }

    public int getEncodingSizeEstimate() {
        int exncodingSizeEstimate = 0;
        for (int i = 0; i < this.numComponents_; ++i) {
            IndexRowKeyComponent irkc = this.components_.get(i);
            exncodingSizeEstimate += irkc.getEncodingSizeEstimate();
        }
        return exncodingSizeEstimate;
    }

    public int getNumComponents() {
        return this.numComponents_;
    }
}

