/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.KeyValueSizeDescriptor;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SimpleTest.class})
public class KeyValueSizeDescriptorTest
extends BaseTest {
    @Test
    public void testSizeDescriptor() {
        ByteWriter w = new ByteWriter();
        int keySize = 7;
        int valueSize = 8;
        int numBitsForValue = 4;
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize((int)numBitsForValue, (int)keySize);
        int valueSizeOfSize = KeyValueSizeDescriptor.getValueSizeOfSize((int)numBitsForValue, (int)valueSize);
        KeyValueSizeDescriptor.encodeKeyValueSize((int)4, (int)keySizeOfSize, (int)valueSizeOfSize, (int)keySize, (int)valueSize, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        Assert.assertEquals((long)1L, (long)bbuf.limit());
        int[] output = KeyValueSizeDescriptor.decodeKeyValueSize((int)4, (ByteBuffer)bbuf);
        Assert.assertEquals((long)1L, (long)bbuf.position());
        Assert.assertEquals((long)keySize, (long)output[0]);
        Assert.assertEquals((long)valueSize, (long)output[1]);
    }

    @Test
    public void testNonDefaultValueBits() {
        ByteWriter w = new ByteWriter();
        int keySize = 27;
        int valueSize = 2;
        int numBitsForValue = 3;
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize((int)numBitsForValue, (int)keySize);
        int valueSizeOfSize = KeyValueSizeDescriptor.getValueSizeOfSize((int)numBitsForValue, (int)valueSize);
        Assert.assertEquals((long)0L, (long)keySizeOfSize);
        Assert.assertEquals((long)0L, (long)valueSizeOfSize);
        KeyValueSizeDescriptor.encodeKeyValueSize((int)numBitsForValue, (int)keySizeOfSize, (int)valueSizeOfSize, (int)keySize, (int)valueSize, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.limit());
        int[] output = KeyValueSizeDescriptor.decodeKeyValueSize((int)numBitsForValue, (ByteBuffer)bbuf);
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.position());
        Assert.assertEquals((long)keySize, (long)output[0]);
        Assert.assertEquals((long)valueSize, (long)output[1]);
    }

    @Test
    public void testZeroKeyValueSize() {
        ByteWriter w = new ByteWriter();
        int keySize = 0;
        int valueSize = 0;
        int numBitsForValue = 3;
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize((int)numBitsForValue, (int)keySize);
        int valueSizeOfSize = KeyValueSizeDescriptor.getValueSizeOfSize((int)numBitsForValue, (int)valueSize);
        Assert.assertEquals((long)0L, (long)keySizeOfSize);
        Assert.assertEquals((long)0L, (long)valueSizeOfSize);
        KeyValueSizeDescriptor.encodeKeyValueSize((int)numBitsForValue, (int)keySizeOfSize, (int)valueSizeOfSize, (int)keySize, (int)valueSize, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.limit());
        bbuf.rewind();
        int[] output = KeyValueSizeDescriptor.decodeKeyValueSize((int)numBitsForValue, (ByteBuffer)bbuf);
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.position());
        Assert.assertEquals((long)keySize, (long)output[0]);
        Assert.assertEquals((long)valueSize, (long)output[1]);
    }

    @Test
    public void testZeroValueSizeOfSize() {
        ByteWriter w = new ByteWriter();
        int keySize = 220;
        int valueSize = 0;
        int numBitsForValue = 0;
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize((int)numBitsForValue, (int)keySize);
        int valueSizeOfSize = 0;
        Assert.assertEquals((long)0L, (long)keySizeOfSize);
        Assert.assertEquals((long)0L, (long)valueSizeOfSize);
        KeyValueSizeDescriptor.encodeKeyValueSize((int)numBitsForValue, (int)keySizeOfSize, (int)valueSizeOfSize, (int)keySize, (int)valueSize, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.limit());
        int[] output = KeyValueSizeDescriptor.decodeKeyValueSize((int)numBitsForValue, (ByteBuffer)bbuf);
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.position());
        Assert.assertEquals((long)keySize, (long)output[0]);
    }

    @Test
    public void testSizeDescriptorWithLargeKeySize() {
        ByteWriter w = new ByteWriter();
        int keySize = 12;
        int valueSize = 8;
        int numBitsForValue = 4;
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize((int)numBitsForValue, (int)keySize);
        int valueSizeOfSize = KeyValueSizeDescriptor.getValueSizeOfSize((int)numBitsForValue, (int)valueSize);
        Assert.assertEquals((long)1L, (long)keySizeOfSize);
        Assert.assertEquals((long)0L, (long)valueSizeOfSize);
        KeyValueSizeDescriptor.encodeKeyValueSize((int)numBitsForValue, (int)keySizeOfSize, (int)valueSizeOfSize, (int)keySize, (int)valueSize, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.limit());
        int[] output = KeyValueSizeDescriptor.decodeKeyValueSize((int)numBitsForValue, (ByteBuffer)bbuf);
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.position());
        Assert.assertEquals((long)keySize, (long)output[0]);
        Assert.assertEquals((long)valueSize, (long)output[1]);
    }

    @Test
    public void testSizeDescriptorWithLargeKeyValueSize() {
        ByteWriter w = new ByteWriter();
        int keySize = 22;
        int valueSize = 25;
        int numBitsForValue = 4;
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize((int)numBitsForValue, (int)keySize);
        int valueSizeOfSize = KeyValueSizeDescriptor.getValueSizeOfSize((int)numBitsForValue, (int)valueSize);
        Assert.assertEquals((long)1L, (long)keySizeOfSize);
        Assert.assertEquals((long)1L, (long)valueSizeOfSize);
        KeyValueSizeDescriptor.encodeKeyValueSize((int)numBitsForValue, (int)keySizeOfSize, (int)valueSizeOfSize, (int)keySize, (int)valueSize, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.limit());
        bbuf.rewind();
        int[] output = KeyValueSizeDescriptor.decodeKeyValueSize((int)numBitsForValue, (ByteBuffer)bbuf);
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.position());
        Assert.assertEquals((long)keySize, (long)output[0]);
        Assert.assertEquals((long)valueSize, (long)output[1]);
    }

    @Test
    public void testSizeDescriptorWithVeryLargeKeyValueSize() {
        ByteWriter w = new ByteWriter();
        int keySize = 256;
        int valueSize = 1000000;
        int numBitsForValue = 4;
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize((int)numBitsForValue, (int)keySize);
        int valueSizeOfSize = KeyValueSizeDescriptor.getValueSizeOfSize((int)numBitsForValue, (int)valueSize);
        Assert.assertEquals((long)2L, (long)keySizeOfSize);
        Assert.assertEquals((long)4L, (long)valueSizeOfSize);
        KeyValueSizeDescriptor.encodeKeyValueSize((int)numBitsForValue, (int)keySizeOfSize, (int)valueSizeOfSize, (int)keySize, (int)valueSize, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.limit());
        bbuf.rewind();
        int[] output = KeyValueSizeDescriptor.decodeKeyValueSize((int)numBitsForValue, (ByteBuffer)bbuf);
        Assert.assertEquals((long)(1 + keySizeOfSize + valueSizeOfSize), (long)bbuf.position());
        Assert.assertEquals((long)keySize, (long)output[0]);
        Assert.assertEquals((long)valueSize, (long)output[1]);
    }
}

