/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.DBValueBuilder;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.exceptions.TypeException;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Fields;

public abstract class DBValueBuilderBase
implements DBValueBuilder {
    @Override
    public KeyValue initFromArray(Object value) {
        Class<?> c = value.getClass().getComponentType();
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                byte[] v = (byte[])value;
                return this.initFromArray(v);
            }
            if (c == Short.TYPE) {
                short[] v = (short[])value;
                return this.initFromArray(v);
            }
            if (c == Integer.TYPE) {
                int[] v = (int[])value;
                return this.initFromArray(v);
            }
            if (c == Long.TYPE) {
                long[] v = (long[])value;
                return this.initFromArray(v);
            }
            if (c == Float.TYPE) {
                float[] v = (float[])value;
                return this.initFromArray(v);
            }
            if (c == Double.TYPE) {
                double[] v = (double[])value;
                return this.initFromArray(v);
            }
            if (c == Boolean.TYPE) {
                boolean[] v = (boolean[])value;
                return this.initFromArray(v);
            }
            if (c == Character.TYPE) {
                char[] v = (char[])value;
                return this.initFromArray(v);
            }
        } else {
            return this.initFromArray((Object[])value);
        }
        return null;
    }

    protected KeyValue initFromObjectType(Object value) {
        if (value instanceof Byte) {
            return this.initFrom((Byte)value);
        }
        if (value instanceof Boolean) {
            return this.initFrom((Boolean)value);
        }
        if (value instanceof String) {
            return this.initFrom((String)value);
        }
        if (value instanceof Short) {
            return this.initFrom((Short)value);
        }
        if (value instanceof Integer) {
            return this.initFrom((Integer)value);
        }
        if (value instanceof Long) {
            return this.initFrom((Long)value);
        }
        if (value instanceof Float) {
            return this.initFrom(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.initFrom((Double)value);
        }
        if (value instanceof OTime) {
            return this.initFrom((OTime)value);
        }
        if (value instanceof ODate) {
            return this.initFrom((ODate)value);
        }
        if (value instanceof OTimestamp) {
            return this.initFrom((OTimestamp)value);
        }
        if (value instanceof BigDecimal) {
            return this.initFrom((BigDecimal)value);
        }
        if (value instanceof ByteBuffer) {
            return this.initFrom((ByteBuffer)value);
        }
        if (value instanceof OInterval) {
            return this.initFrom((OInterval)value);
        }
        if (value instanceof Document) {
            return this.initFrom((Document)value);
        }
        if (value instanceof Map) {
            return this.initFrom((Map)value);
        }
        if (value instanceof List) {
            return this.initFrom((List)value);
        }
        if (value instanceof Value) {
            return this.initFrom((Value)value);
        }
        if (value.getClass().isArray()) {
            return this.initFromArray(value);
        }
        throw new TypeException("Unsupported object type of class: " + value.getClass());
    }

    @Override
    public KeyValue initFrom(Map<String, ? extends Object> map) {
        if (map instanceof DBDocumentImpl) {
            return ((DBDocumentImpl)map).shallowCopy();
        }
        DBDocumentImpl doc = new DBDocumentImpl();
        for (String k : map.keySet()) {
            KeyValue child = this.initFromObject(map.get(k));
            child.setOpTypeAndFlags(null, false);
            doc.set(k, (Value)child);
        }
        return doc;
    }

    @Override
    public KeyValue initFrom(Document value) {
        if (value instanceof DBDocumentImpl) {
            return ((DBDocumentImpl)value).shallowCopy();
        }
        DBDocumentImpl r = new DBDocumentImpl();
        for (Map.Entry e : value) {
            KeyValue child = this.initFromObject(e.getValue());
            child.setOpTypeAndFlags(null, false);
            r.set(Fields.quoteFieldName((String)((String)e.getKey())), (Value)child);
        }
        return r;
    }

    @Override
    public KeyValue initFromArray(Object[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFromObject(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    @Override
    public KeyValue initFromArray(byte[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    @Override
    public KeyValue initFromArray(short[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    @Override
    public KeyValue initFromArray(int[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    @Override
    public KeyValue initFromArray(long[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    @Override
    public KeyValue initFromArray(float[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    @Override
    public KeyValue initFromArray(double[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    @Override
    public KeyValue initFromArray(boolean[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }

    @Override
    public KeyValue initFromArray(char[] values) {
        DBList list = new DBList(InsertContext.OpType.NONE);
        for (int i = 0; i < values.length; ++i) {
            KeyValue child = this.initFrom(values[i]);
            child.setOpTypeAndFlags(null, false);
            list.addToDBList(child);
        }
        return list;
    }
}

