/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;

@Category(value={SimpleTest.class})
public class MultiColumnFamilyEncodeDecodeTest
extends BaseTest {
    @Test
    public void encodeMultiColumnFamily() throws IOException {
        Document r = MapRDBImpl.newDocument();
        r.set("defaultchild1", 10).set("defaultchild2", true).set("defaultchild3", "Value").set("defaultchild4.child1", "child1").set("defaultchild4.child2", "child2").set("defaultchild4.family1", "family1").set("defaultchild4.family2.child1", false).set("defaultchild4.family2.child2", 50000).set("Family1.child1", 10).set("Family1.child2", true).set("Family1.child3", "Value").set("Family1.child4.child1", "child1").set("Family1.child4.child2", "child2").set("Family1.child4.family1", "family1").set("Family1.child4.family2.child1", false).set("Family1.child4.family2.child2", 50000).set("Family2", "NewFamily");
        LinkedHashMap<FieldPath, Integer> familyMap = new LinkedHashMap<FieldPath, Integer>();
        familyMap.put(FieldPath.EMPTY, 1);
        familyMap.put(FieldPath.parseFrom((String)"defaultchild4.family1"), 3);
        familyMap.put(FieldPath.parseFrom((String)"defaultchild4.family2"), 4);
        familyMap.put(FieldPath.parseFrom((String)"Family1"), 6);
        familyMap.put(FieldPath.parseFrom((String)"Family1.child4.family1"), 7);
        familyMap.put(FieldPath.parseFrom((String)"Family1.child4.family2"), 8);
        familyMap.put(FieldPath.parseFrom((String)"Family2"), 9);
        familyMap.put(FieldPath.parseFrom((String)"NonExistingFamily"), 10);
        familyMap.put(FieldPath.parseFrom((String)"NonExistingFamily2"), 11);
        SerializedFamilyInfo[] serializedBuffers = RowcolCodec.encode((Document)r, familyMap);
        Assert.assertEquals((long)serializedBuffers.length, (long)familyMap.size());
        Assert.assertEquals((long)1L, (long)serializedBuffers[0].getFamilyId());
        DBDocumentImpl defaultRec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[0].getByteBuffer());
        Assert.assertEquals((long)10L, (long)defaultRec.getInt("defaultchild1"));
        Assert.assertEquals((Object)true, (Object)defaultRec.getBoolean("defaultchild2"));
        Assert.assertEquals((Object)"Value", (Object)defaultRec.getString("defaultchild3"));
        Assert.assertEquals((Object)"child1", (Object)defaultRec.getString("defaultchild4.child1"));
        Assert.assertEquals((Object)"child2", (Object)defaultRec.getString("defaultchild4.child2"));
        Assert.assertNull((Object)defaultRec.getKeyValue("defaultchild4.family1"));
        Assert.assertNull((Object)defaultRec.getKeyValue("defaultchild4.family2"));
        Assert.assertNull((Object)defaultRec.getKeyValue("Family2"));
        Assert.assertEquals((long)3L, (long)serializedBuffers[1].getFamilyId());
        DBDocumentImpl defFamily1Rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[1].getByteBuffer());
        Assert.assertEquals((Object)"family1", (Object)defFamily1Rec.getString("v"));
        Assert.assertEquals((long)4L, (long)serializedBuffers[2].getFamilyId());
        DBDocumentImpl defFamily2Rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[2].getByteBuffer());
        Assert.assertEquals((Object)false, (Object)defFamily2Rec.getBoolean("v.child1"));
        Assert.assertEquals((long)50000L, (long)defFamily2Rec.getInt("v.child2"));
        Assert.assertEquals((long)6L, (long)serializedBuffers[3].getFamilyId());
        DBDocumentImpl family1Rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[3].getByteBuffer());
        Assert.assertEquals((long)10L, (long)family1Rec.getInt("v.child1"));
        Assert.assertEquals((Object)true, (Object)family1Rec.getBoolean("v.child2"));
        Assert.assertEquals((Object)"Value", (Object)family1Rec.getString("v.child3"));
        Assert.assertEquals((Object)"child1", (Object)family1Rec.getString("v.child4.child1"));
        Assert.assertEquals((Object)"child2", (Object)family1Rec.getString("v.child4.child2"));
        Assert.assertNull((Object)family1Rec.getKeyValue("v.child4.family1"));
        Assert.assertNull((Object)family1Rec.getKeyValue("v.child4.family2"));
        Assert.assertEquals((long)7L, (long)serializedBuffers[4].getFamilyId());
        DBDocumentImpl family1Child4Family1Rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[4].getByteBuffer());
        Assert.assertEquals((Object)"family1", (Object)family1Child4Family1Rec.getString("v"));
        Assert.assertEquals((long)8L, (long)serializedBuffers[5].getFamilyId());
        DBDocumentImpl family1Child4Family2Rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[5].getByteBuffer());
        Assert.assertEquals((Object)false, (Object)family1Child4Family2Rec.getBoolean("v.child1"));
        Assert.assertEquals((long)50000L, (long)family1Child4Family2Rec.getInt("v.child2"));
        Assert.assertEquals((long)9L, (long)serializedBuffers[6].getFamilyId());
        DBDocumentImpl family2Rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[6].getByteBuffer());
        Assert.assertEquals((Object)"NewFamily", (Object)family2Rec.getString("v"));
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[0].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[1].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[2].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[3].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[4].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[5].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[6].getAction());
        Assert.assertEquals((long)10L, (long)serializedBuffers[7].getFamilyId());
        Assert.assertEquals((Object)SerializationAction.DELETE_FAMILY, (Object)serializedBuffers[7].getAction());
        Assert.assertEquals((long)11L, (long)serializedBuffers[8].getFamilyId());
        Assert.assertEquals((Object)SerializationAction.DELETE_FAMILY, (Object)serializedBuffers[8].getAction());
        LinkedHashMap<Integer, ByteBuffer> bufferMap = new LinkedHashMap<Integer, ByteBuffer>();
        for (int i = 0; i < serializedBuffers.length; ++i) {
            if (serializedBuffers[i].getByteBuffer() == null) continue;
            bufferMap.put(serializedBuffers[i].getFamilyId(), serializedBuffers[i].getByteBuffer());
        }
        DBDocumentImpl dRec = RowcolCodec.decode(bufferMap, familyMap, null);
        Assert.assertEquals((long)10L, (long)dRec.getInt("defaultchild1"));
        Assert.assertEquals((Object)true, (Object)dRec.getBoolean("defaultchild2"));
        Assert.assertEquals((Object)"Value", (Object)dRec.getString("defaultchild3"));
        Assert.assertEquals((Object)"child1", (Object)dRec.getString("defaultchild4.child1"));
        Assert.assertEquals((Object)"child2", (Object)dRec.getString("defaultchild4.child2"));
        Assert.assertEquals((Object)"family1", (Object)dRec.getString("defaultchild4.family1"));
        Assert.assertEquals((Object)false, (Object)dRec.getBoolean("defaultchild4.family2.child1"));
        Assert.assertEquals((long)50000L, (long)dRec.getInt("defaultchild4.family2.child2"));
        Assert.assertEquals((long)10L, (long)dRec.getInt("Family1.child1"));
        Assert.assertEquals((Object)true, (Object)dRec.getBoolean("Family1.child2"));
        Assert.assertEquals((Object)"Value", (Object)dRec.getString("Family1.child3"));
        Assert.assertEquals((Object)"child1", (Object)dRec.getString("Family1.child4.child1"));
        Assert.assertEquals((Object)"child2", (Object)dRec.getString("Family1.child4.child2"));
        Assert.assertEquals((Object)"family1", (Object)dRec.getString("Family1.child4.family1"));
        Assert.assertEquals((Object)false, (Object)dRec.getBoolean("Family1.child4.family2.child1"));
        Assert.assertEquals((long)50000L, (long)dRec.getInt("Family1.child4.family2.child2"));
        Assert.assertEquals((Object)"NewFamily", (Object)dRec.getString("Family2"));
    }

    @Test
    public void mutateMultiColumnFamily() {
        MutationImpl m = (MutationImpl)MapRDBImpl.newMutation();
        m.increment("a.b.c.d", 10);
        Assert.assertEquals((Object)m.needsReadOnServer(), (Object)true);
        LinkedHashMap<FieldPath, Integer> familyMap = new LinkedHashMap<FieldPath, Integer>();
        familyMap.put(FieldPath.EMPTY, 1);
        familyMap.put(FieldPath.parseFrom((String)"a.b"), 3);
        SerializedFamilyInfo[] serializedBuffers = m.rowcolSerialize(familyMap);
        Assert.assertEquals((long)serializedBuffers.length, (long)familyMap.size());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[0].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[1].getAction());
        Assert.assertEquals((long)3L, (long)serializedBuffers[1].getFamilyId());
        DBDocumentImpl rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[1].getByteBuffer());
        KeyValue kv = rec.getKeyValue("v.c.d");
        Assert.assertEquals((long)10L, (long)kv.getInt());
        Assert.assertEquals((Object)InsertContext.OpType.INCREMENT, (Object)kv.getOpType());
        familyMap = new LinkedHashMap();
        familyMap.put(FieldPath.EMPTY, 1);
        familyMap.put(FieldPath.parseFrom((String)"a.b.c.d"), 3);
        serializedBuffers = m.rowcolSerialize(familyMap);
        Assert.assertEquals((long)serializedBuffers.length, (long)familyMap.size());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[0].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[1].getAction());
        Assert.assertEquals((long)3L, (long)serializedBuffers[1].getFamilyId());
        rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[1].getByteBuffer());
        kv = rec.getKeyValue("v");
        Assert.assertEquals((long)10L, (long)kv.getInt());
        Assert.assertEquals((Object)InsertContext.OpType.INCREMENT, (Object)kv.getOpType());
    }

    @Test
    public void unaffectedColumnFamilyNoAction() {
        MutationImpl m = (MutationImpl)MapRDBImpl.newMutation();
        m.increment("a.b.c.d", 10);
        Assert.assertEquals((Object)m.needsReadOnServer(), (Object)true);
        LinkedHashMap<FieldPath, Integer> familyMap = new LinkedHashMap<FieldPath, Integer>();
        familyMap.put(FieldPath.EMPTY, 1);
        familyMap.put(FieldPath.parseFrom((String)"a.b"), 3);
        familyMap.put(FieldPath.parseFrom((String)"a.x"), 5);
        SerializedFamilyInfo[] serializedBuffers = m.rowcolSerialize(familyMap);
        Assert.assertEquals((long)serializedBuffers.length, (long)familyMap.size());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[0].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[1].getAction());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[2].getAction());
    }

    @Test
    public void parentColumnFamilyWithNoMutationNoAction() {
        MutationImpl m = (MutationImpl)MapRDBImpl.newMutation();
        m.increment("a.b.c.d.e.f", 10);
        Assert.assertEquals((Object)m.needsReadOnServer(), (Object)true);
        LinkedHashMap<FieldPath, Integer> familyMap = new LinkedHashMap<FieldPath, Integer>();
        familyMap.put(FieldPath.EMPTY, 1);
        familyMap.put(FieldPath.parseFrom((String)"a.b"), 3);
        familyMap.put(FieldPath.parseFrom((String)"a.b.c.d"), 5);
        SerializedFamilyInfo[] serializedBuffers = m.rowcolSerialize(familyMap);
        Assert.assertEquals((long)serializedBuffers.length, (long)familyMap.size());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[0].getAction());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[1].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[2].getAction());
    }

    @Test
    public void parentColumnWithOneMutation() {
        MutationImpl m = (MutationImpl)MapRDBImpl.newMutation();
        m.increment("a.b.c.d.e.f", 10);
        m.append("a.b.e", "hello");
        Assert.assertEquals((Object)m.needsReadOnServer(), (Object)true);
        LinkedHashMap<FieldPath, Integer> familyMap = new LinkedHashMap<FieldPath, Integer>();
        familyMap.put(FieldPath.EMPTY, 1);
        familyMap.put(FieldPath.parseFrom((String)"a.b"), 3);
        familyMap.put(FieldPath.parseFrom((String)"a.b.c.d"), 5);
        SerializedFamilyInfo[] serializedBuffers = m.rowcolSerialize(familyMap);
        Assert.assertEquals((long)serializedBuffers.length, (long)familyMap.size());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[0].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[1].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[2].getAction());
        Assert.assertEquals((long)3L, (long)serializedBuffers[1].getFamilyId());
        DBDocumentImpl rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[1].getByteBuffer());
        KeyValue kv = rec.getKeyValue("v.e");
        Assert.assertEquals((Object)"hello", (Object)kv.getString());
        Assert.assertEquals((Object)InsertContext.OpType.APPEND, (Object)kv.getOpType());
        kv = rec.getKeyValue("v.c");
        Assert.assertEquals((Object)Value.Type.MAP, (Object)kv.getType());
        Assert.assertEquals((Object)InsertContext.OpType.NONE, (Object)kv.getOpType());
        Assert.assertEquals((long)5L, (long)serializedBuffers[2].getFamilyId());
        rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[2].getByteBuffer());
        kv = rec.getKeyValue("v.e.f");
        Assert.assertEquals((long)10L, (long)kv.getInt());
        Assert.assertEquals((Object)InsertContext.OpType.INCREMENT, (Object)kv.getOpType());
    }

    @Test
    public void childCFOfMutationCFShouldDelete() {
        MutationImpl m = (MutationImpl)MapRDBImpl.newMutation();
        m.increment("a.b.c", 1000);
        Assert.assertEquals((Object)m.needsReadOnServer(), (Object)true);
        LinkedHashMap<FieldPath, Integer> familyMap = new LinkedHashMap<FieldPath, Integer>();
        familyMap.put(FieldPath.EMPTY, 1);
        familyMap.put(FieldPath.parseFrom((String)"a.b.c.d.e"), 3);
        familyMap.put(FieldPath.parseFrom((String)"a.b.c.d.e.f"), 5);
        familyMap.put(FieldPath.parseFrom((String)"a.x"), 100);
        SerializedFamilyInfo[] serializedBuffers = m.rowcolSerialize(familyMap);
        Assert.assertEquals((long)serializedBuffers.length, (long)familyMap.size());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[0].getAction());
        Assert.assertEquals((Object)SerializationAction.DELETE_FAMILY, (Object)serializedBuffers[1].getAction());
        Assert.assertEquals((Object)SerializationAction.DELETE_FAMILY, (Object)serializedBuffers[2].getAction());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[3].getAction());
        Assert.assertEquals((long)1L, (long)serializedBuffers[0].getFamilyId());
        DBDocumentImpl rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[0].getByteBuffer());
        KeyValue kv = rec.getKeyValue("a.b.c");
        Assert.assertEquals((long)1000L, (long)kv.getInt());
        Assert.assertEquals((Object)InsertContext.OpType.INCREMENT, (Object)kv.getOpType());
    }

    @Test
    public void unaffectedChildCFWithParentMergeOp() {
        MutationImpl m = (MutationImpl)MapRDBImpl.newMutation();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "valueA");
        map.put("B", "valueB");
        m.merge("a.b.c", map);
        Assert.assertEquals((Object)m.needsReadOnServer(), (Object)true);
        LinkedHashMap<FieldPath, Integer> familyMap = new LinkedHashMap<FieldPath, Integer>();
        familyMap.put(FieldPath.EMPTY, 1);
        familyMap.put(FieldPath.parseFrom((String)"a.b"), 3);
        familyMap.put(FieldPath.parseFrom((String)"a.b.c.d.e.f"), 5);
        familyMap.put(FieldPath.parseFrom((String)"a.x"), 100);
        SerializedFamilyInfo[] serializedBuffers = m.rowcolSerialize(familyMap);
        Assert.assertEquals((long)serializedBuffers.length, (long)familyMap.size());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[0].getAction());
        Assert.assertEquals((Object)SerializationAction.SET, (Object)serializedBuffers[1].getAction());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[2].getAction());
        Assert.assertEquals((Object)SerializationAction.NO_ACTION, (Object)serializedBuffers[3].getAction());
        Assert.assertEquals((long)3L, (long)serializedBuffers[1].getFamilyId());
        DBDocumentImpl rec = (DBDocumentImpl)RowcolCodec.decode((ByteBuffer)serializedBuffers[1].getByteBuffer());
        KeyValue kv = rec.getKeyValue("v.c");
        Assert.assertEquals((Object)InsertContext.OpType.MERGE, (Object)kv.getOpType());
        Assert.assertEquals((Object)"valueA", (Object)rec.getString("v.c.A"));
        Assert.assertEquals((Object)"valueB", (Object)rec.getString("v.c.B"));
    }
}

