/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.exceptions;

import com.google.common.util.concurrent.ExecutionError;
import com.mapr.db.exceptions.AccessDeniedException;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.DBRetryException;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.ReadOnlyException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.fs.ErrnoException;
import com.mapr.fs.PathNotFoundException;
import com.mapr.fs.RetryException;
import com.mapr.fs.StaleFileException;
import com.mapr.fs.jni.IOExceptionWithErrorCode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.security.AccessControlException;

public class ExceptionHandler {
    public static DBException handle(IOException e, String op) {
        DBException dbx;
        if (e instanceof ErrnoException) {
            ErrnoException ex = (ErrnoException)e;
            switch (ex.getErrno()) {
                case 13: {
                    dbx = new AccessDeniedException(op, e);
                    break;
                }
                case 1: {
                    dbx = new OpNotPermittedException(op, e);
                    break;
                }
                case 30: {
                    dbx = new ReadOnlyException(op, e);
                    break;
                }
                case 11: {
                    dbx = new DBRetryException(op, (Throwable)e);
                    break;
                }
                case 2: 
                case 116: {
                    dbx = new TableNotFoundException(String.format("(unknown table, error code = %d)", ex.getErrno()), (Throwable)e);
                    break;
                }
                default: {
                    dbx = new DBException(String.format("%s failed with err code = %d,", op, ex.getErrno()), e);
                    break;
                }
            }
        } else {
            dbx = e instanceof StaleFileException ? new TableNotFoundException(((StaleFileException)e).getFilePath(), (Throwable)e) : (e instanceof RetryException ? new DBRetryException(((RetryException)e).getFilePath(), (Throwable)e) : (e instanceof PathNotFoundException ? new TableNotFoundException(((PathNotFoundException)e).getFilePath(), (Throwable)e) : (e instanceof FileNotFoundException ? new TableNotFoundException(e.getMessage(), (Throwable)e) : (e instanceof AccessControlException ? new AccessDeniedException(e.getMessage(), e) : (e instanceof IOExceptionWithErrorCode ? new DBException(e.getMessage(), e) : new DBException(String.format("%s failed.,", op), e))))));
        }
        return dbx;
    }

    public static DBException handle(Throwable t, String op) {
        DBException dbx;
        Throwable cause = t;
        if (t instanceof IOException) {
            dbx = ExceptionHandler.handle((IOException)t, op);
        } else {
            if (t instanceof ExecutionException || t instanceof ExecutionError) {
                cause = t.getCause();
            }
            dbx = new DBException(String.format("%s failed.,", op), cause);
        }
        return dbx;
    }
}

