/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.utils.IndentingStringBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ojai.FieldPath;

public class FieldPathHelper {
    private static final Pattern fieldQuotes = Pattern.compile("((\\A)|([^\\\\]))\"");

    public static void emitQuotedFieldPath(StringBuilder sb, String tableAlias, FieldPath fieldPath) {
        FieldPathHelper.emitQuotedFieldPath(sb, tableAlias, fieldPath.asPathString());
    }

    public static void emitQuotedFieldPath(StringBuilder sb, String tableAlias, String fieldPathStr) {
        if (tableAlias != null) {
            sb.append(tableAlias);
            sb.append('.');
        }
        sb.append('`').append(fieldPathStr).append('`');
    }

    public static void emitFieldPath(StringBuilder sb, String tableAlias, FieldPath fieldPath) {
        if (tableAlias != null) {
            sb.append(tableAlias);
            sb.append('.');
        }
        Matcher matcher = fieldQuotes.matcher(fieldPath.asPathString(true));
        String tickedPath = matcher.replaceAll("$3`");
        sb.append(tickedPath);
    }

    public static void emitQuotedFieldPath(IndentingStringBuilder sb, String tableAlias, FieldPath fieldPath) {
        FieldPathHelper.emitQuotedFieldPath(sb, tableAlias, fieldPath.asPathString());
    }

    public static void emitQuotedFieldPath(IndentingStringBuilder sb, String tableAlias, String fieldPathStr) {
        if (tableAlias != null) {
            sb.append(tableAlias);
            sb.append('.');
        }
        sb.append('`').append(fieldPathStr).append('`');
    }

    public static void emitFieldPath(IndentingStringBuilder sb, String tableAlias, FieldPath fieldPath) {
        if (tableAlias != null) {
            sb.append(tableAlias);
            sb.append('.');
        }
        Matcher matcher = fieldQuotes.matcher(fieldPath.asPathString(true));
        String tickedPath = matcher.replaceAll("$3`");
        sb.append(tickedPath);
    }
}

