/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.google.common.base.Preconditions;
import com.mapr.db.util.DocumentReaderStack;
import com.mapr.db.util.JdkDocumentReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ojai.DocumentReader;

public class MapDocumentReader
extends JdkDocumentReader {
    private final Map<String, Object> theMap;
    private final Iterator<Map.Entry<String, Object>> entryIter;
    private Map.Entry<String, Object> mapEntry;

    public MapDocumentReader(Map<String, Object> theMap, DocumentReaderStack docReaderStack) {
        super(docReaderStack);
        this.theMap = Collections.unmodifiableMap(new HashMap<String, Object>(theMap));
        this.entryIter = this.theMap.entrySet().iterator();
    }

    @Override
    public boolean inMap() {
        return true;
    }

    public DocumentReader.EventType next() {
        if (!this.entryIter.hasNext()) {
            this.docReaderStack.pop();
            return this.docReaderStack.enqueue(DocumentReader.EventType.END_MAP);
        }
        this.mapEntry = this.entryIter.next();
        return this.docReaderStack.enqueue(this.mapEntry.getKey(), this.mapEntry.getValue());
    }

    @Override
    protected Object getObject() {
        Preconditions.checkNotNull(this.mapEntry);
        Object object = this.mapEntry.getValue();
        return this.mapEntry.getValue();
    }
}

