/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db;

import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.ojai.store.QueryCondition;

public class TableSplitInternal {
    private String tableName;
    private ConditionImpl cond;
    private String[] locations = null;
    private long length;

    public TableSplitInternal() {
    }

    public TableSplitInternal(TableSplitInternal splitInt) {
        this.tableName = splitInt.getTableName();
        this.cond = splitInt.getCondition();
        this.locations = splitInt.getLocations();
        this.length = splitInt.getLength();
    }

    public TableSplitInternal(String tabName, QueryCondition c, String[] locs, long len) {
        this.tableName = tabName;
        this.cond = (ConditionImpl)c;
        this.locations = locs;
        this.length = len;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locs) {
        this.locations = locs;
    }

    public ConditionImpl getCondition() {
        return this.cond;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] readField(DataInput in) throws IOException {
        int len = in.readInt();
        byte[] buff = new byte[len];
        in.readFully(buff);
        return buff;
    }

    public void readFields(DataInput in) throws IOException {
        this.tableName = new String(this.readField(in), "UTF-8");
        this.cond = (ConditionImpl)ConditionImpl.parseFrom(ByteBufs.wrap(this.readField(in)));
        this.locations = new String[]{new String(this.readField(in), "UTF-8")};
        this.length = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        byte[] tabName = this.tableName.getBytes(Charset.forName("UTF-8"));
        out.writeInt(tabName.length);
        out.write(tabName);
        ByteBuffer buff = this.cond.getDescriptor().getSerialized();
        int condBuffLength = buff.remaining();
        byte[] condBytes = new byte[condBuffLength];
        buff.get(condBytes);
        out.writeInt(condBuffLength);
        out.write(condBytes);
        byte[] locationsInBytes = this.concatLocationString().getBytes(Charset.forName("UTF-8"));
        out.writeInt(locationsInBytes.length);
        out.write(locationsInBytes);
        out.writeLong(this.length);
    }

    private String concatLocationString() {
        return Arrays.toString(this.locations);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("data-size : " + this.length + "\n");
        buf.append("startRow : " + Bytes.toStringBinary((byte[])this.getStartRow()) + "\n");
        buf.append("stopRow : " + Bytes.toStringBinary((byte[])this.getStopRow()) + "\n");
        buf.append("condition : " + this.cond + "\n");
        buf.append("locations : \n");
        for (String loc : this.locations) {
            buf.append("  " + loc + "\n");
        }
        return buf.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public byte[] getStartRow() {
        return this.cond.getRowkeyRanges().get(0).getStartRow();
    }

    public byte[] getStopRow() {
        return this.cond.getRowkeyRanges().get(0).getStopRow();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TableSplitInternal)) {
            return false;
        }
        return this.tableName.equals(((TableSplitInternal)o).tableName) && this.cond.equals(((TableSplitInternal)o).getCondition()) && this.locations.equals(((TableSplitInternal)o).locations);
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.cond != null ? this.cond.hashCode() : 0);
        result = 31 * result + (this.locations != null ? Arrays.hashCode(this.locations) : 0);
        return result;
    }
}

