/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.util.SubDocumentParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.Json;
import org.ojai.store.DocumentMutation;

public class MutationParser {
    private DocumentMutation mutation = MapRDBImpl.newMutation();
    private DocumentReader reader = null;
    private DocumentReader.EventType et = null;
    private String key = null;
    private SubDocumentParser cUtils = null;

    private Document parseSubDoc() {
        if (this.cUtils == null) {
            this.cUtils = new SubDocumentParser();
        }
        return this.cUtils.parseSubDocument(this.reader);
    }

    private KeyValue getValue() {
        switch (this.et) {
            case NULL: {
                return DBValueBuilderImpl.KeyValueBuilder.initFromNull();
            }
            case BOOLEAN: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getBoolean());
            }
            case STRING: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getString());
            }
            case BYTE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getByte());
            }
            case SHORT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getShort());
            }
            case INT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getInt());
            }
            case LONG: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getLong());
            }
            case DOUBLE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getDouble());
            }
            case FLOAT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getFloat());
            }
            case DECIMAL: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getDecimal());
            }
            case DATE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getDate());
            }
            case TIME: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getTime());
            }
            case TIMESTAMP: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getTimestamp());
            }
            case BINARY: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getBinary());
            }
            case INTERVAL: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.reader.getInterval());
            }
            case START_MAP: {
                return (KeyValue)this.parseSubDoc();
            }
            case START_ARRAY: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.parseArray());
            }
        }
        throw new DecodingException("Invalid type encountered while parsing array.");
    }

    private List<Object> parseArray() {
        ArrayList<Object> l = new ArrayList<Object>();
        while ((this.et = this.reader.next()) != null && this.et != DocumentReader.EventType.END_ARRAY) {
            KeyValue val = this.getValue();
            if (val.getType() == Value.Type.MAP && val.getMap().isEmpty()) continue;
            l.add(val);
        }
        return l;
    }

    private void parseDeleteList() {
        while ((this.et = this.reader.next()) != null && this.et != DocumentReader.EventType.END_ARRAY) {
            if (this.et != DocumentReader.EventType.STRING) {
                throw new DecodingException("Delete mutation only takes fieldNames in string format");
            }
            this.mutation.delete(this.reader.getString());
        }
    }

    private void buildMerge() {
        while (this.et != null) {
            switch (this.et) {
                case NULL: {
                    this.mutation.setOrReplaceNull(this.key);
                    break;
                }
                case BOOLEAN: {
                    this.mutation.setOrReplace(this.key, this.reader.getBoolean());
                    break;
                }
                case STRING: {
                    this.mutation.setOrReplace(this.key, this.reader.getString());
                    break;
                }
                case BYTE: {
                    this.mutation.setOrReplace(this.key, this.reader.getByte());
                    break;
                }
                case SHORT: {
                    this.mutation.setOrReplace(this.key, this.reader.getShort());
                    break;
                }
                case INT: {
                    this.mutation.setOrReplace(this.key, this.reader.getInt());
                    break;
                }
                case LONG: {
                    this.mutation.setOrReplace(this.key, this.reader.getLong());
                    break;
                }
                case FLOAT: {
                    this.mutation.setOrReplace(this.key, this.reader.getFloat());
                    break;
                }
                case DOUBLE: {
                    this.mutation.setOrReplace(this.key, this.reader.getDouble());
                    break;
                }
                case DECIMAL: {
                    this.mutation.setOrReplace(this.key, this.reader.getDecimal());
                    break;
                }
                case DATE: {
                    this.mutation.setOrReplace(this.key, this.reader.getDate());
                    break;
                }
                case TIME: {
                    this.mutation.setOrReplace(this.key, this.reader.getTime());
                    break;
                }
                case TIMESTAMP: {
                    this.mutation.setOrReplace(this.key, this.reader.getTimestamp());
                    break;
                }
                case INTERVAL: {
                    this.mutation.setOrReplace(this.key, this.reader.getInterval());
                    break;
                }
                case BINARY: {
                    this.mutation.setOrReplace(this.key, this.reader.getBinary());
                    break;
                }
                case START_ARRAY: {
                    List<Object> valList = this.parseArray();
                    this.mutation.setOrReplace(this.key, valList);
                    break;
                }
                case START_MAP: {
                    this.mutation.merge(this.key, this.parseSubDoc());
                    break;
                }
            }
            this.et = this.reader.next();
            this.key = this.reader.getFieldName();
        }
    }

    private void applyPut() {
        switch (this.et) {
            case NULL: {
                this.mutation.setOrReplaceNull(this.key);
                break;
            }
            case BOOLEAN: {
                this.mutation.setOrReplace(this.key, this.reader.getBoolean());
                break;
            }
            case STRING: {
                this.mutation.setOrReplace(this.key, this.reader.getString());
                break;
            }
            case BINARY: {
                this.mutation.setOrReplace(this.key, this.reader.getBinary());
                break;
            }
            case BYTE: {
                this.mutation.setOrReplace(this.key, this.reader.getByte());
                break;
            }
            case SHORT: {
                this.mutation.setOrReplace(this.key, this.reader.getShort());
                break;
            }
            case INT: {
                this.mutation.setOrReplace(this.key, this.reader.getInt());
                break;
            }
            case LONG: {
                this.mutation.setOrReplace(this.key, this.reader.getLong());
                break;
            }
            case FLOAT: {
                this.mutation.setOrReplace(this.key, this.reader.getFloat());
                break;
            }
            case DOUBLE: {
                this.mutation.setOrReplace(this.key, this.reader.getDouble());
                break;
            }
            case DECIMAL: {
                this.mutation.setOrReplace(this.key, this.reader.getDecimal());
                break;
            }
            case DATE: {
                this.mutation.setOrReplace(this.key, this.reader.getDate());
                break;
            }
            case TIME: {
                this.mutation.setOrReplace(this.key, this.reader.getTime());
                break;
            }
            case TIMESTAMP: {
                this.mutation.setOrReplace(this.key, this.reader.getTimestamp());
                break;
            }
            case INTERVAL: {
                this.mutation.setOrReplace(this.key, this.reader.getInterval());
                break;
            }
            case START_MAP: {
                this.mutation.setOrReplace(this.key, this.parseSubDoc());
                break;
            }
            case START_ARRAY: {
                List<Object> valList = this.parseArray();
                this.mutation.setOrReplace(this.key, valList);
            }
        }
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private void applySet() {
        switch (this.et) {
            case NULL: {
                this.mutation.setNull(this.key);
                break;
            }
            case BOOLEAN: {
                this.mutation.set(this.key, this.reader.getBoolean());
                break;
            }
            case STRING: {
                this.mutation.set(this.key, this.reader.getString());
                break;
            }
            case BINARY: {
                this.mutation.set(this.key, this.reader.getBinary());
                break;
            }
            case BYTE: {
                this.mutation.set(this.key, this.reader.getByte());
                break;
            }
            case SHORT: {
                this.mutation.set(this.key, this.reader.getShort());
                break;
            }
            case INT: {
                this.mutation.set(this.key, this.reader.getInt());
                break;
            }
            case LONG: {
                this.mutation.set(this.key, this.reader.getLong());
                break;
            }
            case FLOAT: {
                this.mutation.set(this.key, this.reader.getFloat());
                break;
            }
            case DOUBLE: {
                this.mutation.set(this.key, this.reader.getDouble());
                break;
            }
            case DECIMAL: {
                this.mutation.set(this.key, this.reader.getDecimal());
                break;
            }
            case DATE: {
                this.mutation.set(this.key, this.reader.getDate());
                break;
            }
            case TIME: {
                this.mutation.set(this.key, this.reader.getTime());
                break;
            }
            case TIMESTAMP: {
                this.mutation.set(this.key, this.reader.getTimestamp());
                break;
            }
            case INTERVAL: {
                this.mutation.set(this.key, this.reader.getInterval());
                break;
            }
            case START_MAP: {
                this.mutation.set(this.key, this.parseSubDoc());
                break;
            }
            case START_ARRAY: {
                List<Object> valList = this.parseArray();
                this.mutation.set(this.key, valList);
            }
        }
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private void applySetOrPutByOp(String mutationOp) {
        if (mutationOp.equals("$set")) {
            this.applySet();
        } else {
            this.applyPut();
        }
    }

    private void addSetMutations() {
        String setOp = this.key;
        if (this.et == DocumentReader.EventType.START_MAP) {
            this.et = this.reader.next();
            this.key = this.reader.getFieldName();
            this.applySetOrPutByOp(setOp);
        } else if (this.et == DocumentReader.EventType.START_ARRAY) {
            this.et = this.reader.next();
            while (this.et != DocumentReader.EventType.END_ARRAY) {
                this.checkContext(DocumentReader.EventType.START_MAP);
                this.et = this.reader.next();
                if (this.et != DocumentReader.EventType.END_MAP) {
                    this.key = this.reader.getFieldName();
                    this.applySetOrPutByOp(setOp);
                }
                this.et = this.reader.next();
            }
        } else {
            throw new DecodingException("Invalid syntax for operation " + setOp);
        }
    }

    private void parseAndApplyDeleteMutation() {
        if (this.et == DocumentReader.EventType.START_ARRAY) {
            this.parseDeleteList();
        } else {
            String fpath = this.reader.getString();
            this.mutation.delete(fpath);
        }
    }

    private void addMergeMutation() {
        this.et = this.reader.next();
        if (this.et != DocumentReader.EventType.START_MAP) {
            throw new DecodingException("$merge cannot take scalar value");
        }
        String mergePath = this.reader.getFieldName();
        Document d = this.parseSubDoc();
        this.mutation.merge(mergePath, d);
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.END_MAP);
    }

    private void setIncrement() {
        switch (this.et) {
            case BYTE: {
                this.mutation.increment(this.reader.getFieldName(), this.reader.getByte());
                break;
            }
            case SHORT: {
                this.mutation.increment(this.reader.getFieldName(), this.reader.getShort());
                break;
            }
            case INT: {
                this.mutation.increment(this.reader.getFieldName(), this.reader.getInt());
                break;
            }
            case LONG: {
                this.mutation.increment(this.reader.getFieldName(), this.reader.getLong());
                break;
            }
            case FLOAT: {
                this.mutation.increment(this.reader.getFieldName(), this.reader.getFloat());
                break;
            }
            case DOUBLE: {
                this.mutation.increment(this.reader.getFieldName(), this.reader.getDouble());
                break;
            }
            case DECIMAL: {
                this.mutation.increment(this.reader.getFieldName(), this.reader.getDecimal());
                break;
            }
            default: {
                throw new DecodingException("Illegal data type for increment : " + this.et);
            }
        }
    }

    private void setDecrement() {
        switch (this.et) {
            case BYTE: {
                this.mutation.decrement(this.reader.getFieldName(), this.reader.getByte());
                break;
            }
            case SHORT: {
                this.mutation.decrement(this.reader.getFieldName(), this.reader.getShort());
                break;
            }
            case INT: {
                this.mutation.decrement(this.reader.getFieldName(), this.reader.getInt());
                break;
            }
            case LONG: {
                this.mutation.decrement(this.reader.getFieldName(), this.reader.getLong());
                break;
            }
            case FLOAT: {
                this.mutation.decrement(this.reader.getFieldName(), this.reader.getFloat());
                break;
            }
            case DOUBLE: {
                this.mutation.decrement(this.reader.getFieldName(), this.reader.getDouble());
                break;
            }
            case DECIMAL: {
                this.mutation.decrement(this.reader.getFieldName(), this.reader.getDecimal());
                break;
            }
            default: {
                throw new DecodingException("Illegal data type for increment : " + this.et);
            }
        }
    }

    private void setIncrementFromValue(String fkey, KeyValue val) {
        switch (val.getType()) {
            case BYTE: {
                this.mutation.increment(fkey, val.getByte());
                break;
            }
            case SHORT: {
                this.mutation.increment(fkey, val.getShort());
                break;
            }
            case INT: {
                this.mutation.increment(fkey, val.getInt());
                break;
            }
            case LONG: {
                this.mutation.increment(fkey, val.getLong());
                break;
            }
            case FLOAT: {
                this.mutation.increment(fkey, val.getFloat());
                break;
            }
            case DOUBLE: {
                this.mutation.increment(fkey, val.getDouble());
                break;
            }
            case DECIMAL: {
                this.mutation.increment(fkey, val.getDecimal());
                break;
            }
            default: {
                throw new DecodingException("Illegal data type for increment : " + this.et);
            }
        }
    }

    private void setDecrementFromValue(String fkey, KeyValue val) {
        switch (val.getType()) {
            case BYTE: {
                this.mutation.decrement(fkey, val.getByte());
                break;
            }
            case SHORT: {
                this.mutation.decrement(fkey, val.getShort());
                break;
            }
            case INT: {
                this.mutation.decrement(fkey, val.getInt());
                break;
            }
            case LONG: {
                this.mutation.decrement(fkey, val.getLong());
                break;
            }
            case FLOAT: {
                this.mutation.decrement(fkey, val.getFloat());
                break;
            }
            case DOUBLE: {
                this.mutation.decrement(fkey, val.getDouble());
                break;
            }
            case DECIMAL: {
                this.mutation.decrement(fkey, val.getDecimal());
                break;
            }
            default: {
                throw new DecodingException("Illegal data type for increment : " + this.et);
            }
        }
    }

    private void parseAndApplyIncrementMutation() {
        if (this.et == DocumentReader.EventType.START_ARRAY) {
            List<Object> valueList = this.parseArray();
            for (Object e : valueList) {
                KeyValue v = DBValueBuilderImpl.KeyValueBuilder.initFromObject(e);
                if (v.getType() == Value.Type.STRING) {
                    this.mutation.increment(v.getString(), 1);
                    continue;
                }
                if (v.getType() != Value.Type.MAP) continue;
                Map m = ((Value)e).getMap();
                Map.Entry mEntry = m.entrySet().iterator().next();
                KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFromObject(mEntry.getValue());
                this.setIncrementFromValue((String)mEntry.getKey(), kv);
            }
        } else if (this.et == DocumentReader.EventType.START_MAP) {
            this.et = this.reader.next();
            if (this.et != DocumentReader.EventType.END_MAP) {
                this.setIncrement();
            }
            this.et = this.reader.next();
            this.checkContext(DocumentReader.EventType.END_MAP);
        } else {
            this.mutation.increment(this.reader.getString(), 1);
        }
    }

    private void parseAndApplyDecrementMutation() {
        if (this.et == DocumentReader.EventType.START_ARRAY) {
            List<Object> valueList = this.parseArray();
            for (Object e : valueList) {
                KeyValue v = DBValueBuilderImpl.KeyValueBuilder.initFromObject(e);
                if (v.getType() == Value.Type.STRING) {
                    this.mutation.decrement(v.getString(), 1);
                    continue;
                }
                if (v.getType() != Value.Type.MAP) continue;
                Map m = ((Value)e).getMap();
                Map.Entry mEntry = m.entrySet().iterator().next();
                KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFromObject(mEntry.getValue());
                this.setDecrementFromValue((String)mEntry.getKey(), kv);
            }
        } else if (this.et == DocumentReader.EventType.START_MAP) {
            this.et = this.reader.next();
            if (this.et != DocumentReader.EventType.END_MAP) {
                this.setDecrement();
            }
            this.et = this.reader.next();
            this.checkContext(DocumentReader.EventType.END_MAP);
        } else {
            this.mutation.decrement(this.reader.getString(), 1);
        }
    }

    private void processAppendFromList(List<Object> valueList) {
        for (Object e : valueList) {
            Map m = ((Value)e).getMap();
            if (m.size() != 1) {
                throw new DecodingException("Invalid map for append");
            }
            Map.Entry entry = m.entrySet().iterator().next();
            String mapKey = (String)entry.getKey();
            Object objValue = entry.getValue();
            KeyValue kv = DBValueBuilderImpl.KeyValueBuilder.initFromObject(objValue);
            if (kv.getType() == Value.Type.MAP) {
                ArrayList<KeyValue> l = new ArrayList<KeyValue>();
                l.add(kv);
                this.mutation.append(mapKey, l);
                continue;
            }
            if (kv.getType() == Value.Type.ARRAY) {
                this.mutation.append(mapKey, kv.getList());
                continue;
            }
            if (kv.getType() == Value.Type.STRING) {
                this.mutation.append(mapKey, kv.getString());
                continue;
            }
            this.mutation.append(mapKey, kv.getBinary());
        }
    }

    private void checkContext(DocumentReader.EventType t) {
        if (this.et != t) {
            throw new DecodingException("Error in context, expected " + t + " , actual " + this.et);
        }
    }

    private void parseAndApplyAppendMutation() {
        if (this.et == DocumentReader.EventType.START_MAP) {
            this.et = this.reader.next();
            if (this.et == DocumentReader.EventType.START_ARRAY) {
                List<Object> appendList = this.parseArray();
                String akey = this.reader.getFieldName();
                this.mutation.append(akey, appendList);
            } else if (this.et == DocumentReader.EventType.STRING) {
                this.mutation.append(this.reader.getFieldName(), this.reader.getString());
            } else if (this.et == DocumentReader.EventType.BINARY) {
                this.mutation.append(this.reader.getFieldName(), this.reader.getBinary());
            } else {
                if (this.et == DocumentReader.EventType.END_MAP) {
                    return;
                }
                throw new DecodingException("Invalid value type " + this.et.toString() + " given for $append");
            }
            this.et = this.reader.next();
            this.checkContext(DocumentReader.EventType.END_MAP);
        } else if (this.et == DocumentReader.EventType.START_ARRAY) {
            List<Object> valueList = this.parseArray();
            this.processAppendFromList(valueList);
        } else {
            throw new DecodingException("Invalid format for mutation operation " + this.key);
        }
    }

    private void buildMutationWithSubcommands() {
        while (this.et != null) {
            switch (this.key) {
                case "$set": {
                    this.addSetMutations();
                    break;
                }
                case "$put": {
                    this.addSetMutations();
                    break;
                }
                case "$delete": {
                    this.parseAndApplyDeleteMutation();
                    break;
                }
                case "$merge": {
                    this.addMergeMutation();
                    break;
                }
                case "$increment": {
                    this.parseAndApplyIncrementMutation();
                    break;
                }
                case "$decrement": {
                    this.parseAndApplyDecrementMutation();
                    break;
                }
                case "$append": {
                    this.parseAndApplyAppendMutation();
                    break;
                }
                default: {
                    throw new DecodingException("Unknown mutation subcommand : " + this.key);
                }
            }
            this.et = this.reader.next();
            if (this.reader.inMap()) {
                this.key = this.reader.getFieldName();
            }
            if (this.et != DocumentReader.EventType.END_MAP || this.key != null) continue;
            break;
        }
    }

    public DocumentMutation parseMutation(String jsonMutation) {
        this.reader = Json.newDocumentReader((String)jsonMutation);
        this.et = this.reader.next();
        this.checkContext(DocumentReader.EventType.START_MAP);
        this.et = this.reader.next();
        this.key = this.reader.getFieldName();
        if (this.key != null) {
            if (!this.key.startsWith("$")) {
                this.buildMerge();
            } else {
                this.buildMutationWithSubcommands();
            }
        }
        return this.mutation;
    }
}

