/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.util.DocumentReaderStack;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.ojai.DocumentReader;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public abstract class JdkDocumentReader
implements DocumentReader {
    protected final DocumentReaderStack docReaderStack;

    protected JdkDocumentReader(DocumentReaderStack docReaderStack) {
        this.docReaderStack = docReaderStack;
    }

    public DocumentReader.EventType getCurrentEvent() {
        return this.docReaderStack.getCurrentEvent();
    }

    public String getFieldName() {
        return this.docReaderStack.getFieldName();
    }

    public boolean inMap() {
        return false;
    }

    public int getArrayIndex() {
        throw new UnsupportedOperationException("not in an array");
    }

    public DocumentReader skipChildren() {
        throw new UnsupportedOperationException("unimplemented");
    }

    protected abstract Object getObject();

    private <T> T getObject(Class<T> clazz) {
        Object object = this.getObject();
        if (object == null) {
            return null;
        }
        return clazz.cast(object);
    }

    public ByteBuffer getBinary() {
        return this.getObject(ByteBuffer.class);
    }

    public boolean getBoolean() {
        return this.getObject(Boolean.class);
    }

    public byte getByte() {
        return this.getObject(Byte.class);
    }

    public ODate getDate() {
        return this.getObject(ODate.class);
    }

    public int getDateInt() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public BigDecimal getDecimal() {
        return this.getObject(BigDecimal.class);
    }

    public int getDecimalPrecision() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public int getDecimalScale() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ByteBuffer getDecimalValueAsBytes() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public int getDecimalValueAsInt() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public long getDecimalValueAsLong() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public double getDouble() {
        return this.getObject(Double.class);
    }

    public float getFloat() {
        return this.getObject(Float.class).floatValue();
    }

    public int getInt() {
        return this.getObject(Integer.class);
    }

    public OInterval getInterval() {
        return this.getObject(OInterval.class);
    }

    public int getIntervalDays() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public long getIntervalMillis() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public long getLong() {
        return this.getObject(Long.class);
    }

    public short getShort() {
        return this.getObject(Short.class);
    }

    public String getString() {
        return this.getObject(String.class);
    }

    public OTime getTime() {
        return this.getObject(OTime.class);
    }

    public int getTimeInt() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public OTimestamp getTimestamp() {
        return this.getObject(OTimestamp.class);
    }

    public long getTimestampLong() {
        throw new UnsupportedOperationException("unimplemented");
    }
}

