/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.securitypolicy;

import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.exceptions.AccessDeniedException;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.util.MutationParser;
import com.mapr.fs.utils.ssh.RunCommand;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentMutation;
import org.ojai.store.exceptions.DocumentExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestJSONSecurityPolicyEnforcement
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestJSONSecurityPolicyEnforcement.class);
    private static String VOLUME_TAGGED_OK;
    private static String VOLUME_TAGGED_NOACCESS;
    private static String VOLUME_UNTAGGED;
    private static String VOLUME_UNTAGGED_POLICYACEONLY;
    private static String VOLUME_TAGGED_OK_PATH;
    private static String VOLUME_TAGGED_NOACCESS_PATH;
    private static String VOLUME_UNTAGGED_PATH;
    private static String VOLUME_UNTAGGED_POLICYACEONLY_PATH;
    private static String VOLUME_NOWIREENCRYPTION;
    private static String VOLUME_NOWIREENCRYPTION_PATH;
    private static String VOLUME_TAGGED_OK_POLICYACEONLY;
    private static String VOLUME_TAGGED_OK_POLICYACEONLY_PATH;
    private static String SECURITY_POLICY_ENFORCE_OK;
    private static String SECURITY_POLICY_ENFORCE_NOTALLOWED;
    private static String SECURITY_POLICY_ENFORCE_PUBLIC;
    private static String defaultCFName;
    private static String REGEX_AUDIT_MATCH;
    private static boolean DEBUG_AUDIT_TIME;

    @BeforeClass
    public static void prep() throws Exception {
        int exitCode = 0;
        SECURITY_POLICY_ENFORCE_OK = "spenforceok";
        SECURITY_POLICY_ENFORCE_NOTALLOWED = "spenforcenotallowed";
        SECURITY_POLICY_ENFORCE_PUBLIC = "spenforcepublic";
        VOLUME_TAGGED_OK = "voltaggedok";
        VOLUME_TAGGED_OK_POLICYACEONLY = "voltaggedokpolaceonly";
        VOLUME_UNTAGGED = "voluntagged";
        VOLUME_UNTAGGED_POLICYACEONLY = "voluntaggedpolicyaceonly";
        VOLUME_TAGGED_NOACCESS = "voltaggednoaccess";
        VOLUME_NOWIREENCRYPTION = "volnowire";
        REGEX_AUDIT_MATCH = "(.|\\n)*\\{.+\"AccessDeniedPolicyId\":\\d.+\"AccessDeniedPolicyName\":" + SECURITY_POLICY_ENFORCE_NOTALLOWED + ".+\"PolicyPmStatus\":13.+\"status\":0.*\\}(.|\\n)*";
        VOLUME_TAGGED_OK_PATH = DBTests.getTestRoot() + "/" + VOLUME_TAGGED_OK;
        VOLUME_TAGGED_OK_POLICYACEONLY_PATH = DBTests.getTestRoot() + "/" + VOLUME_TAGGED_OK_POLICYACEONLY;
        VOLUME_UNTAGGED_PATH = DBTests.getTestRoot() + "/" + VOLUME_UNTAGGED;
        VOLUME_UNTAGGED_POLICYACEONLY_PATH = DBTests.getTestRoot() + "/" + VOLUME_UNTAGGED_POLICYACEONLY;
        VOLUME_TAGGED_NOACCESS_PATH = DBTests.getTestRoot() + "/" + VOLUME_TAGGED_NOACCESS;
        VOLUME_NOWIREENCRYPTION_PATH = DBTests.getTestRoot() + "/" + VOLUME_NOWIREENCRYPTION;
        defaultCFName = "default";
        _logger.info("Setting CLDB to global PBS master");
        DBTests.updatePolicyServiceMasterStatus();
        TestCluster.runCommand((String)"maprcli audit cluster -enabled true; maprcli audit data -enabled true");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"0\"}");
        TestCluster.runCommand((String)("/opt/mapr/server/mrconfig -h " + TestJSONSecurityPolicyEnforcement.getHostName() + " audit setaudittestparams 2"));
        _logger.info("Checking if security policy " + SECURITY_POLICY_ENFORCE_OK + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli security policy info -columns policyname -name " + SECURITY_POLICY_ENFORCE_OK)).getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_OK + " does not exist, creating");
            TestCluster.runCommand((String)("maprcli security policy create -name " + SECURITY_POLICY_ENFORCE_OK + " -allowtagging true -accesscontrol Armed -readaces 'u:root' -writeaces 'u:root' -auditenabled true"));
        } else {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_OK + " exists, setting allowtagging=true, accesscontrol=Armed, readaces|writeaces=u:root, auditenabled true");
            TestCluster.runCommand((String)("maprcli security policy modify -name " + SECURITY_POLICY_ENFORCE_OK + " -wiresecurityenabled true -allowtagging true -accesscontrol Armed  -readaces 'u:root' -writeaces 'u:root' -auditenabled true"));
        }
        _logger.info("Checking if security policy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli security policy info -columns policyname -name " + SECURITY_POLICY_ENFORCE_NOTALLOWED)).getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " does not exist, creating");
            TestCluster.runCommand((String)("maprcli security policy create -name " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -allowtagging true -accesscontrol Armed -readaces '!u:root' -writeaces '!u:root' -auditenabled true"));
        } else {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " already exists, setting allowtagging=true, accesscontrol=Armed, readaces|writeaces=!u=root, auditenabled true");
            TestCluster.runCommand((String)("maprcli security policy modify -name " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -allowtagging true -accesscontrol Armed -readaces '!u:root'  -writeaces '!u:root' -auditenabled true"));
        }
        _logger.info("Checking if security policy " + SECURITY_POLICY_ENFORCE_PUBLIC + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli security policy info -columns policyname -name " + SECURITY_POLICY_ENFORCE_PUBLIC)).getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_PUBLIC + " does not exist, creating");
            TestCluster.runCommand((String)("maprcli security policy create -name " + SECURITY_POLICY_ENFORCE_PUBLIC + " -allowtagging true -accesscontrol Armed -readaces p -writeaces p -auditenabled true"));
        } else {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_PUBLIC + " exists, setting allowtagging=true, accesscontrol=Armed, readaces|writeaces=p, auditenabled true");
            TestCluster.runCommand((String)("maprcli security policy modify -name " + SECURITY_POLICY_ENFORCE_PUBLIC + " -allowtagging true -accesscontrol Armed -readaces p -writeaces p -auditenabled true"));
        }
        Thread.sleep(45000L);
        TestJSONSecurityPolicyEnforcement.createUntaggedVolume(VOLUME_UNTAGGED, VOLUME_UNTAGGED_PATH);
        TestJSONSecurityPolicyEnforcement.createUntaggedVolume(VOLUME_UNTAGGED_POLICYACEONLY, VOLUME_UNTAGGED_POLICYACEONLY_PATH);
        TestJSONSecurityPolicyEnforcement.createTaggedVolume(VOLUME_TAGGED_OK, VOLUME_TAGGED_OK_PATH, SECURITY_POLICY_ENFORCE_OK, "PolicyAceAndDataAce");
        TestJSONSecurityPolicyEnforcement.createTaggedVolume(VOLUME_TAGGED_OK_POLICYACEONLY, VOLUME_TAGGED_OK_POLICYACEONLY_PATH, SECURITY_POLICY_ENFORCE_OK, "PolicyAceOnly");
        TestJSONSecurityPolicyEnforcement.createTaggedVolume(VOLUME_TAGGED_NOACCESS, VOLUME_TAGGED_NOACCESS_PATH, SECURITY_POLICY_ENFORCE_NOTALLOWED, "PolicyAceAndDataAce");
        TestJSONSecurityPolicyEnforcement.createUntaggedVolume(VOLUME_NOWIREENCRYPTION, VOLUME_NOWIREENCRYPTION_PATH, "-wiresecurityenabled false");
        Thread.sleep(45000L);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        TestJSONSecurityPolicyEnforcement.removeVolume(VOLUME_UNTAGGED);
        TestJSONSecurityPolicyEnforcement.removeVolume(VOLUME_UNTAGGED_POLICYACEONLY);
        TestJSONSecurityPolicyEnforcement.removeVolume(VOLUME_TAGGED_OK);
        TestJSONSecurityPolicyEnforcement.removeVolume(VOLUME_TAGGED_NOACCESS);
        TestJSONSecurityPolicyEnforcement.removeVolume(VOLUME_NOWIREENCRYPTION);
    }

    public static String getHostName() throws UnknownHostException {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    @Test
    public void testPutTableLevelEnforcementPolicyAceAndDataAce() throws Exception {
        String TABLE_NAME1_IN_VOLTAGGED_OK = "t1-voltaggedok";
        String tablePath1_in_voltaggedok = VOLUME_TAGGED_OK_PATH + "/" + TABLE_NAME1_IN_VOLTAGGED_OK;
        int exitCode = 0;
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceAndDataAce"));
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath1_in_voltaggedok + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.insertDocumentId(tablePath1_in_voltaggedok, "id1", 0, OpType.OP_INSERTORREPLACE);
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath1_in_voltaggedok);
    }

    @Test
    public void testUpdateGetTableLevelEnforcement() throws Exception {
        String TABLE_NAME1A_IN_VOLTAGGED_OK = "t1a-voltaggedok";
        String tablePath1a_in_voltaggedok = VOLUME_TAGGED_OK_PATH + "/" + TABLE_NAME1A_IN_VOLTAGGED_OK;
        int exitCode = 0;
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceAndDataAce"));
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath1a_in_voltaggedok + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.insertDocumentId(tablePath1a_in_voltaggedok, "id1", 0, OpType.OP_INSERT);
        this.insertDocumentId(tablePath1a_in_voltaggedok, "id1", 3, OpType.OP_INSERT);
        String addSecurityPolicyCommand = "maprcli table securitypolicy add -path " + tablePath1a_in_voltaggedok + " -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + addSecurityPolicyCommand);
        exitCode = TestCluster.runCommand((String)addSecurityPolicyCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        this.insertDocumentId(tablePath1a_in_voltaggedok, "id1", 1, OpType.OP_INSERT);
        this.insertDocumentId(tablePath1a_in_voltaggedok, "id2", 1, OpType.OP_INSERT);
        this.insertDocumentId(tablePath1a_in_voltaggedok, "id1", 1, OpType.OP_REPLACE);
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath1a_in_voltaggedok);
    }

    @Test
    public void testPutTableLevelEnforcementAccessDenied() throws Exception {
        int exitCode = 0;
        String TABLE_NAME2_IN_VOLTAGGED_OK = "t2-voltaggedok";
        String tablePath2_in_voltaggedok = VOLUME_TAGGED_OK_PATH + "/" + TABLE_NAME2_IN_VOLTAGGED_OK;
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceAndDataAce"));
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath2_in_voltaggedok + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.insertDocumentId(tablePath2_in_voltaggedok, "id1", 0, OpType.OP_INSERTORREPLACE);
        String addSecurityPolicyCommand = "maprcli table securitypolicy add -path " + tablePath2_in_voltaggedok + " -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + addSecurityPolicyCommand);
        exitCode = TestCluster.runCommand((String)addSecurityPolicyCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Verifying that inserting a row into the table is denied");
        this.insertDocumentId(tablePath2_in_voltaggedok, "id1", 1, OpType.OP_INSERTORREPLACE);
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath2_in_voltaggedok);
    }

    @Test
    public void testPutTableLevelEnforcementPolicyAceOnly() throws Exception {
        int exitCode = 0;
        String TABLE_NAME3_IN_VOLTAGGED_OK = "t3-voltaggedok";
        String tablePath3_in_voltaggedok = VOLUME_TAGGED_OK_PATH + "/" + TABLE_NAME3_IN_VOLTAGGED_OK;
        String volumeModifyCommand = "maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceAndDataAce";
        _logger.info("Running command " + volumeModifyCommand);
        exitCode = TestCluster.runCommand((String)volumeModifyCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath3_in_voltaggedok + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Verifying that inserting to " + tablePath3_in_voltaggedok + " initially succeeds");
        this.insertDocumentId(tablePath3_in_voltaggedok, "id1", 0, OpType.OP_INSERTORREPLACE);
        this.insertDocumentId(tablePath3_in_voltaggedok, "id2", 0, OpType.OP_INSERTORREPLACE);
        this.insertDocumentId(tablePath3_in_voltaggedok, "id3", 0, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that deleting from " + tablePath3_in_voltaggedok + " initially succeeds");
        this.deleteRow(tablePath3_in_voltaggedok, "id3", 0);
        String tableCfEditCommand = "maprcli table cf edit -path " + tablePath3_in_voltaggedok + " -cfname default -readperm '!u:root'  -writeperm '!u:root' -traverseperm '!u:root'";
        _logger.info("Running command " + tableCfEditCommand);
        exitCode = TestCluster.runCommand((String)tableCfEditCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok + " is now denied");
        this.insertDocumentId(tablePath3_in_voltaggedok, "id2", 1, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that deleting from " + tablePath3_in_voltaggedok + " is now denied");
        this.deleteRow(tablePath3_in_voltaggedok, "id2", 1);
        String volumeModifyCommand2 = "maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceOnly";
        _logger.info("Running command " + volumeModifyCommand2);
        exitCode = TestCluster.runCommand((String)volumeModifyCommand2).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok + " is now allowed in PolicyAceOnly mode");
        this.insertDocumentId(tablePath3_in_voltaggedok, "id3", 0, OpType.OP_INSERTORREPLACE);
        String tableAddSecurityPolicyCommand = "maprcli table securitypolicy add -path " + tablePath3_in_voltaggedok + " -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableAddSecurityPolicyCommand);
        exitCode = TestCluster.runCommand((String)tableAddSecurityPolicyCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok + " fails in PolicyAceOnly mode since it is disallowed by policy");
        this.insertDocumentId(tablePath3_in_voltaggedok, "id4a", 1, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that deleting a row from " + tablePath3_in_voltaggedok + " fails in PolicyAceOnly mode since it is disallowed by policy");
        this.deleteRow(tablePath3_in_voltaggedok, "id3", 1);
        String volumeModifyCommand3 = "maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode DataAceOnly";
        _logger.info("Running command " + volumeModifyCommand3);
        exitCode = TestCluster.runCommand((String)volumeModifyCommand3).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok + " initially fails in DataAceOnly mode since it is disallowed by data ACE");
        this.insertDocumentId(tablePath3_in_voltaggedok, "id5", 1, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that deleting a row from " + tablePath3_in_voltaggedok + " fails in DataAceOnly mode since it is disallowed by data ACE");
        this.deleteRow(tablePath3_in_voltaggedok, "id5", 1);
        String tableCfEditCommand2 = "maprcli table cf edit -path " + tablePath3_in_voltaggedok + " -cfname default -readperm 'u:root'  -writeperm 'u:root' -traverseperm 'u:root'";
        _logger.info("Running command " + tableCfEditCommand2);
        exitCode = TestCluster.runCommand((String)tableCfEditCommand2).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok + " now succeeds in DataAceOnly mode since it is allowed by data ACE");
        this.insertDocumentId(tablePath3_in_voltaggedok, "id6", 0, OpType.OP_INSERTORREPLACE);
        String volumeModifyCommand4 = "maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceAndDataAce";
        _logger.info("Running command " + volumeModifyCommand4);
        exitCode = TestCluster.runCommand((String)volumeModifyCommand4).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok + " fails in PolicyAceAndDataAce mode since it is disallowed by policy");
        this.insertDocumentDefaultContents(tablePath3_in_voltaggedok, "id7", 1, OpType.OP_INSERTORREPLACE);
        String tableRemoveSecurityPolicyCommand = "maprcli table securitypolicy remove -path " + tablePath3_in_voltaggedok + " -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableRemoveSecurityPolicyCommand);
        exitCode = TestCluster.runCommand((String)tableRemoveSecurityPolicyCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok + " now succeeds since it is allowed by both data and policy ACE");
        this.insertDocumentId(tablePath3_in_voltaggedok, "id8", 0, OpType.OP_INSERTORREPLACE);
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath3_in_voltaggedok);
    }

    @Test
    public void testPutEnforcementPolicyAceOnly() throws Exception {
        int exitCode = 0;
        String TABLE_NAME3A_IN_VOLTAGGED_OK_POLICYACEONLY = "t3a-voltaggedok";
        String tablePath3_in_voltaggedok_polaceonly = VOLUME_TAGGED_OK_POLICYACEONLY_PATH + "/" + TABLE_NAME3A_IN_VOLTAGGED_OK_POLICYACEONLY;
        String tableCreateCommand = "maprcli table create -path " + tablePath3_in_voltaggedok_polaceonly + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCfEditCommand = "maprcli table cf edit -path " + tablePath3_in_voltaggedok_polaceonly + " -cfname default -writeperm '!u:root'";
        _logger.info("Running command " + tableCfEditCommand);
        exitCode = TestCluster.runCommand((String)tableCfEditCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok_polaceonly + " is allowed");
        this.insertDocumentId(tablePath3_in_voltaggedok_polaceonly, "id2", 0, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that deleting from " + tablePath3_in_voltaggedok_polaceonly + " is allowed");
        this.deleteRow(tablePath3_in_voltaggedok_polaceonly, "id2", 0);
        String tableAddSecurityPolicyCommand = "maprcli table securitypolicy add -path " + tablePath3_in_voltaggedok_polaceonly + " -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableAddSecurityPolicyCommand);
        exitCode = TestCluster.runCommand((String)tableAddSecurityPolicyCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Verifying that inserting a row into " + tablePath3_in_voltaggedok_polaceonly + " fails in PolicyAceOnly mode since it is disallowed by policy");
        this.insertDocumentId(tablePath3_in_voltaggedok_polaceonly, "id4a", 1, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that deleting a row from " + tablePath3_in_voltaggedok_polaceonly + " fails in PolicyAceOnly mode since it is disallowed by policy");
        this.deleteRow(tablePath3_in_voltaggedok_polaceonly, "id3", 1);
    }

    @Test
    public void testScanTableAndCfLevelEnforcement() throws Exception {
        int exitCode = 0;
        String TABLE_NAME4_IN_VOLUNTAGGED = "t4-voluntagged";
        String tablePath4_in_voluntagged = VOLUME_UNTAGGED_PATH + "/" + TABLE_NAME4_IN_VOLUNTAGGED;
        String tableCreateCommand = "maprcli table create -path " + tablePath4_in_voluntagged + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCf1CreateCommand = "maprcli table cf create -path " + tablePath4_in_voluntagged + " -cfname mycf -jsonpath b -force true";
        _logger.info("Running command " + tableCf1CreateCommand);
        exitCode = TestCluster.runCommand((String)tableCf1CreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCf2CreateCommand = "maprcli table cf create -path " + tablePath4_in_voluntagged + " -cfname mycf2 -jsonpath c -force true";
        _logger.info("Running command " + tableCf2CreateCommand);
        exitCode = TestCluster.runCommand((String)tableCf2CreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Inserting row 1  into the table");
        Document d = MapRDBImpl.newDocument();
        d.set("a.x", true);
        d.set("b.y", "hello");
        d.set("c.x1", "aaa");
        JsonTable table4 = MapRDBImpl.getTable((String)tablePath4_in_voluntagged);
        this.insertDocumentContents(tablePath4_in_voluntagged, table4, "id1", d, 0, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that all CF's are returned");
        for (DocumentReader reader : table4.find().documentReaders()) {
            this.validateScanOk((Table)table4, reader);
        }
        table4.close();
        String spCf2Command = "maprcli table cf securitypolicy add -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -path " + tablePath4_in_voluntagged + " -cfname mycf2";
        _logger.info("Running command " + spCf2Command);
        exitCode = TestCluster.runCommand((String)spCf2Command).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        table4 = MapRDBImpl.getTable((String)tablePath4_in_voluntagged);
        _logger.info("Verifying that denied CF is not returned");
        for (DocumentReader reader : table4.find().documentReaders()) {
            this.validateScanCf3Denied((Table)table4, reader);
        }
        table4.close();
        String spTableCommand = "maprcli table securitypolicy add -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -path " + tablePath4_in_voluntagged;
        _logger.info("Running command " + spTableCommand);
        exitCode = TestCluster.runCommand((String)spTableCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that access to table is denied");
        table4 = MapRDBImpl.getTable((String)tablePath4_in_voluntagged);
        exitCode = 0;
        Iterator iterTableDenied = table4.find().documentReaders().iterator();
        try {
            while (iterTableDenied.hasNext()) {
                DocumentReader documentReader = (DocumentReader)iterTableDenied.next();
            }
        }
        catch (AccessDeniedException e) {
            _logger.info("Obtained Access Denied Exception");
            exitCode = 1;
        }
        catch (DBException e) {
            _logger.info("Obtained DB Exception");
            exitCode = 2;
        }
        Assert.assertEquals((long)1L, (long)exitCode);
        table4.close();
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath4_in_voluntagged);
    }

    @Test
    public void testGetTableAndCfLevelEnforcement() throws Exception {
        int exitCode = 0;
        String TABLE_NAME5_IN_VOLUNTAGGED = "t5-voluntagged";
        String tablePath5_in_voluntagged = VOLUME_UNTAGGED_PATH + "/" + TABLE_NAME5_IN_VOLUNTAGGED;
        String tableCreateCommand = "maprcli table create -path " + tablePath5_in_voluntagged + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCf1CreateCommand = "maprcli table cf create -path " + tablePath5_in_voluntagged + " -cfname mycf -jsonpath b -force true";
        _logger.info("Running command " + tableCf1CreateCommand);
        exitCode = TestCluster.runCommand((String)tableCf1CreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCf2CreateCommand = "maprcli table cf create -path " + tablePath5_in_voluntagged + " -cfname mycf2 -jsonpath c -force true";
        _logger.info("Running command " + tableCf2CreateCommand);
        exitCode = TestCluster.runCommand((String)tableCf2CreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Inserting row 1  into the table");
        Document d = MapRDBImpl.newDocument();
        d.set("a.x", true);
        d.set("b.y", "hello");
        d.set("c.x1", "aaa");
        JsonTable table5 = MapRDBImpl.getTable((String)tablePath5_in_voluntagged);
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id1", d, 0, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that all CF's are returned by GET");
        Document reader = table5.findById("id1");
        Assert.assertTrue((boolean)reader.getBoolean("a.x"));
        Assert.assertEquals((Object)"hello", (Object)reader.getString("b.y"));
        Assert.assertEquals((Object)"aaa", (Object)reader.getString("c.x1"));
        table5.close();
        String spCf2Command = "maprcli table cf securitypolicy add -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -path " + tablePath5_in_voluntagged + " -cfname mycf2";
        _logger.info("Running command " + spCf2Command);
        exitCode = TestCluster.runCommand((String)spCf2Command).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        table5 = MapRDBImpl.getTable((String)tablePath5_in_voluntagged);
        _logger.info("Verifying that denied CF is not returned");
        reader = table5.findById("id1");
        Assert.assertTrue((boolean)reader.getBoolean("a.x"));
        Assert.assertEquals((Object)"hello", (Object)reader.getString("b.y"));
        Assert.assertNull((Object)reader.getString("c.x1"));
        table5.close();
        String spTableCommand = "maprcli table securitypolicy add -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -path " + tablePath5_in_voluntagged;
        _logger.info("Running command " + spTableCommand);
        exitCode = TestCluster.runCommand((String)spTableCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that access to table is denied");
        table5 = MapRDBImpl.getTable((String)tablePath5_in_voluntagged);
        exitCode = 0;
        try {
            reader = table5.findById("id1");
        }
        catch (AccessDeniedException e) {
            _logger.info("Obtained Access Denied Exception");
            exitCode = 1;
        }
        catch (DBException e) {
            _logger.info("Obtained DB Exception");
            exitCode = 2;
        }
        Assert.assertEquals((long)1L, (long)exitCode);
        table5.close();
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath5_in_voluntagged);
    }

    @Test
    public void testResourceLevelWireEncryption() throws Exception {
        String TABLE_NAME11 = "t11-ResourceWireEncryption";
        String tablePath11_in_volnowire = VOLUME_NOWIREENCRYPTION_PATH + "/" + TABLE_NAME11;
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath11_in_volnowire + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String setNoWireEncryptCommand = "hadoop mfs -setnetworkencryption off " + tablePath11_in_volnowire;
        _logger.info("Running command " + setNoWireEncryptCommand);
        exitCode = TestCluster.runCommand((String)setNoWireEncryptCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(60000L);
        String tableListCommand = "maprcli table info -path " + tablePath11_in_volnowire + " -json";
        _logger.info("Running command " + tableListCommand);
        String tableListOutput = TestCluster.runCommand((String)tableListCommand).getStdOut();
        String tableListOutputJSONString = tableListOutput.replace("\"", "'");
        JSONObject tableListOutputJSONObject = new JSONObject(tableListOutputJSONString);
        JSONArray tableList = tableListOutputJSONObject.getJSONArray("data");
        for (int i = 0; i < tableList.length(); ++i) {
            JSONObject tableProperty = tableList.getJSONObject(i);
            String policyTag = tableProperty.getString("wireencryptionfrompolicies");
            _logger.info("Comparing expected value of tag wireencryptionfrompolicies (true) with actual");
            Assert.assertEquals((Object)"true", (Object)policyTag);
        }
        this.insertDocumentId(tablePath11_in_volnowire, "id1", 0, OpType.OP_INSERTORREPLACE);
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath11_in_volnowire);
    }

    @Test
    public void testPutColumnLevelEnforcement() throws Exception {
        int exitCode = 0;
        String TABLE_NAME5_IN_VOLUNTAGGED = "t5a-voluntagged";
        String tablePath5_in_voluntagged = VOLUME_UNTAGGED_PATH + "/" + TABLE_NAME5_IN_VOLUNTAGGED;
        String tableCreateCommand = "maprcli table create -path " + tablePath5_in_voluntagged + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Inserting row 1  into the table");
        JsonTable table5 = MapRDBImpl.getTable((String)tablePath5_in_voluntagged);
        Document d = MapRDBImpl.newDocument();
        d.set("a.x", true);
        d.set("b.y", "hello");
        d.set("c.x1", "aaa");
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id1", d, 0, OpType.OP_INSERTORREPLACE);
        table5.close();
        String tableColumnCfCommand = "maprcli table cf column securitypolicy set -path " + tablePath5_in_voluntagged + " -cfname default -name a.x -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableColumnCfCommand);
        exitCode = TestCluster.runCommand((String)tableColumnCfCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        table5 = MapRDBImpl.getTable((String)tablePath5_in_voluntagged);
        Document d2 = MapRDBImpl.newDocument();
        d2.set("a.x", false);
        d2.set("b.y", "hello2");
        d2.set("c.x1", "aaa2");
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id1", d2, 1, OpType.OP_INSERTORREPLACE);
        Document d2a = MapRDBImpl.newDocument();
        d2a.set("a.x", true);
        d2a.set("b.y", "hello3");
        d2a.set("c.x1", "aaa3");
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id1a", d2a, 1, OpType.OP_INSERT);
        Document d2b = MapRDBImpl.newDocument();
        d2b.set("a.x", true);
        d2b.set("b.y", "hello4");
        d2b.set("c.x1", "aaa4");
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id1", d2b, 1, OpType.OP_REPLACE);
        Document d3 = MapRDBImpl.newDocument();
        d3.set("b.y", "hello3");
        d3.set("c.x1", "aaa3");
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id2", d3, 0, OpType.OP_INSERTORREPLACE);
        Document d3a = MapRDBImpl.newDocument();
        d3a.set("b.y", "hello4");
        d3a.set("c.x1", "aaa4");
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id2a", d3a, 0, OpType.OP_INSERT);
        Document d3b = MapRDBImpl.newDocument();
        d3b.set("b.y", "hello5");
        d3b.set("c.x1", "aaa5");
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id2", d3, 0, OpType.OP_REPLACE);
        this.deleteRow(tablePath5_in_voluntagged, table5, "id1", 0);
        this.deleteRow(tablePath5_in_voluntagged, table5, "id2", 0);
        table5.close();
        String tableColumnCfCommand2 = "maprcli table cf column securitypolicy set -path " + tablePath5_in_voluntagged + " -cfname default -name a.x -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableColumnCfCommand2);
        exitCode = TestCluster.runCommand((String)tableColumnCfCommand2).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        table5 = MapRDBImpl.getTable((String)tablePath5_in_voluntagged);
        Document d4 = MapRDBImpl.newDocument();
        d4.set("a.x", false);
        d4.set("b.y", "hello2");
        d4.set("c.x1", "aaa2");
        this.insertDocumentContents(tablePath5_in_voluntagged, table5, "id1", d4, 0, OpType.OP_INSERTORREPLACE);
        table5.close();
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath5_in_voluntagged);
    }

    @Test
    public void testScanNGetColumnLevelEnforcement() throws Exception {
        int exitCode = 0;
        String TABLE_NAME6_IN_VOLUNTAGGED = "t6-voluntagged";
        String tablePath6_in_voluntagged = VOLUME_UNTAGGED_PATH + "/" + TABLE_NAME6_IN_VOLUNTAGGED;
        String tableCreateCommand = "maprcli table create -path " + tablePath6_in_voluntagged + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Inserting row 1  into the table");
        Document d = MapRDBImpl.newDocument();
        d.set("a.x", true);
        d.set("b.y", "hello");
        d.set("c.x1", "aaa");
        JsonTable table6 = MapRDBImpl.getTable((String)tablePath6_in_voluntagged);
        this.insertDocumentContents(tablePath6_in_voluntagged, table6, "id1", d, 0, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that all columns are returned using SCAN");
        Iterator iterOK = table6.find().documentReaders().iterator();
        while (iterOK.hasNext()) {
            DocumentReader r = (DocumentReader)iterOK.next();
            this.validateScanOk((Table)table6, r);
        }
        table6.close();
        table6 = MapRDBImpl.getTable((String)tablePath6_in_voluntagged);
        _logger.info("Verifying that all columns are returned using GET");
        Document reader = table6.findById("id1");
        Assert.assertTrue((boolean)reader.getBoolean("a.x"));
        Assert.assertEquals((Object)"hello", (Object)reader.getString("b.y"));
        Assert.assertEquals((Object)"aaa", (Object)reader.getString("c.x1"));
        String tableColumnCfCommand = "maprcli table cf column securitypolicy set -path " + tablePath6_in_voluntagged + " -cfname default -name c.x1 -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableColumnCfCommand);
        exitCode = TestCluster.runCommand((String)tableColumnCfCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        table6 = MapRDBImpl.getTable((String)tablePath6_in_voluntagged);
        _logger.info("Verifying that denied columns are not returned using GET");
        reader = table6.findById("id1");
        Assert.assertTrue((boolean)reader.getBoolean("a.x"));
        Assert.assertEquals((Object)"hello", (Object)reader.getString("b.y"));
        Assert.assertNull((Object)reader.getString("c.x1"));
        table6.close();
        table6 = MapRDBImpl.getTable((String)tablePath6_in_voluntagged);
        _logger.info("Verifying that denied columns are not returned using SCAN");
        Iterator iterOK2 = table6.find().documentReaders().iterator();
        while (iterOK.hasNext()) {
            DocumentReader r = (DocumentReader)iterOK2.next();
            this.validateScanCf3Denied((Table)table6, r);
        }
        table6.close();
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath6_in_voluntagged);
    }

    @Test
    public void testIndexCFScanEnforcement() throws Exception {
        int exitCode = 0;
        String TABLE_NAME7 = "t7-IndexCFScan";
        String INDEX_NAME7 = "i7-IndexCFScan";
        JsonTable table = this.createTableForIndex(TABLE_NAME7, INDEX_NAME7);
        Collection tableIndexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        String spCfCommand = "maprcli table cf securitypolicy add -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -path " + table.getPath() + " -cfname default";
        _logger.info("Running command " + spCfCommand);
        exitCode = TestCluster.runCommand((String)spCfCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        this.verifyIndexTableReadDenied(tableIndexList);
        Collection tableIndexList2 = DBTests.admin().getTableIndexes(table.getPath(), true);
        assert (tableIndexList2.isEmpty());
        String spCfCommand2 = "maprcli table cf securitypolicy set -securitypolicy " + SECURITY_POLICY_ENFORCE_OK + " -path " + table.getPath() + " -cfname default";
        _logger.info("Running command " + spCfCommand2);
        exitCode = TestCluster.runCommand((String)spCfCommand2).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        this.verifyIndexTableReadOk(table.getPath());
        table.close();
        DBTests.deleteTables(TABLE_NAME7);
    }

    @Test
    public void testIndexTableScanEnforcement() throws Exception {
        int exitCode = 0;
        String TABLE_NAME8 = "t8-IndexTableScan";
        String INDEX_NAME8 = "i8-IndexTableScan";
        JsonTable table = this.createTableForIndex(TABLE_NAME8, INDEX_NAME8);
        Collection tableIndexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        String spTableCommand = "maprcli table securitypolicy set -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -path " + table.getPath();
        _logger.info("Running command " + spTableCommand);
        exitCode = TestCluster.runCommand((String)spTableCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        this.verifyIndexTableReadDenied(tableIndexList);
        int status = 0;
        try {
            Collection tableIndexList2 = DBTests.admin().getTableIndexes(table.getPath(), true);
        }
        catch (DBException e) {
            status = 1;
        }
        Assert.assertEquals((long)status, (long)1L);
        String spTableCommand2 = "maprcli table securitypolicy set -securitypolicy " + SECURITY_POLICY_ENFORCE_OK + " -path " + table.getPath();
        _logger.info("Running command " + spTableCommand2);
        exitCode = TestCluster.runCommand((String)spTableCommand2).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        this.verifyIndexTableReadOk(table.getPath());
        table.close();
        DBTests.deleteTables(TABLE_NAME8);
    }

    @Test
    public void testIndexColumnScanEnforcement() throws Exception {
        int exitCode = 0;
        String TABLE_NAME10 = "t10-IndexColumnScanEnforcement";
        String INDEX_NAME10 = "i10-IndexColumnScanEnforcement";
        JsonTable table = this.createTableForIndex(TABLE_NAME10, INDEX_NAME10);
        Collection tableIndexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        String tableColumnCfCommand = "maprcli table cf column securitypolicy set -path " + table.getPath() + " -cfname default -name name.first -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableColumnCfCommand);
        exitCode = TestCluster.runCommand((String)tableColumnCfCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        this.verifyIndexTableReadDenied(tableIndexList);
        Collection tableIndexList2 = DBTests.admin().getTableIndexes(table.getPath(), true);
        assert (tableIndexList2.isEmpty());
        String tableColumnCfCommand2 = "maprcli table cf column securitypolicy set -path " + table.getPath() + " -cfname default -name name.first -securitypolicy " + SECURITY_POLICY_ENFORCE_OK;
        _logger.info("Running command " + tableColumnCfCommand2);
        exitCode = TestCluster.runCommand((String)tableColumnCfCommand2).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        this.verifyIndexTableReadOk(table.getPath());
        table.close();
        DBTests.deleteTables(TABLE_NAME10);
    }

    @Test
    public void testPutTableLevelPolicyAceOnlyFallback() throws Exception {
        int exitCode = 0;
        String TABLE_NAME12_IN_VOLUNTAGGEDPOLACE = "t12-voluntaggedpolicyace";
        final String tablePath12_in_voluntagged = VOLUME_UNTAGGED_POLICYACEONLY_PATH + "/" + TABLE_NAME12_IN_VOLUNTAGGEDPOLACE;
        String volumeModifyCommand = "maprcli volume modify -name " + VOLUME_UNTAGGED_POLICYACEONLY + " -enforcementmode PolicyAceOnly";
        _logger.info("Running command " + volumeModifyCommand);
        exitCode = TestCluster.runCommand((String)volumeModifyCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath12_in_voluntagged + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Verifying that inserting to " + tablePath12_in_voluntagged + " initially succeeds");
        this.insertDocumentId(tablePath12_in_voluntagged, "id1", 0, OpType.OP_INSERTORREPLACE);
        String volumeModifyCommand2 = "maprcli volume modify -name " + VOLUME_UNTAGGED_POLICYACEONLY + " -writeAce '!u:root'";
        _logger.info("Running command " + volumeModifyCommand2);
        exitCode = TestCluster.runCommand((String)volumeModifyCommand2).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        _logger.info("Verifying that inserting a row into " + tablePath12_in_voluntagged + " is now denied");
        this.insertDocumentId(tablePath12_in_voluntagged, "id2", 1, OpType.OP_INSERTORREPLACE);
        String m7user1 = "m7user1";
        UserGroupInformation ugi = TestJSONSecurityPolicyEnforcement.createUser(m7user1);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                JsonTable table12a = MapRDBImpl.getTable((String)tablePath12_in_voluntagged);
                TestJSONSecurityPolicyEnforcement.this.insertDocumentId(tablePath12_in_voluntagged, "id3", 1, OpType.OP_INSERTORREPLACE);
                table12a.flush();
                table12a.close();
                return null;
            }
        });
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath12_in_voluntagged);
    }

    @Test
    public void testScanGetTableLevelPolicyAceOnlyFallback() throws Exception {
        int exitCode = 0;
        String TABLE_NAME13_IN_VOLUNTAGGEDPOLACE = "t13-voltaggedok";
        String tablePath13_in_voluntagged = VOLUME_UNTAGGED_POLICYACEONLY_PATH + "/" + TABLE_NAME13_IN_VOLUNTAGGEDPOLACE;
        String volumeModifyCommand = "maprcli volume modify -name " + VOLUME_UNTAGGED_POLICYACEONLY + " -readAce p -writeAce p -enforcementmode PolicyAceOnly";
        _logger.info("Running command " + volumeModifyCommand);
        exitCode = TestCluster.runCommand((String)volumeModifyCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath13_in_voluntagged + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCf1CreateCommand = "maprcli table cf create -path " + tablePath13_in_voluntagged + " -cfname mycf -jsonpath b -force true";
        _logger.info("Running command " + tableCf1CreateCommand);
        exitCode = TestCluster.runCommand((String)tableCf1CreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCf2CreateCommand = "maprcli table cf create -path " + tablePath13_in_voluntagged + " -cfname mycf2 -jsonpath c -force true";
        _logger.info("Running command " + tableCf2CreateCommand);
        exitCode = TestCluster.runCommand((String)tableCf2CreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Inserting row 1 into the table");
        JsonTable table13 = MapRDBImpl.getTable((String)tablePath13_in_voluntagged);
        Document d = MapRDBImpl.newDocument();
        d.set("a.x", true);
        d.set("b.y", "hello");
        d.set("c.x1", "aaa");
        this.insertDocumentContents(tablePath13_in_voluntagged, table13, "id1", d, 0, OpType.OP_INSERTORREPLACE);
        _logger.info("Verifying that all CF's are returned");
        for (DocumentReader reader : table13.find().documentReaders()) {
            this.validateScanOk((Table)table13, reader);
        }
        table13.close();
        String tableCfEditCommand = "maprcli table cf edit -path " + tablePath13_in_voluntagged + " -cfname mycf2 -readperm '!u:root'  -writeperm '!u:root' -traverseperm '!u:root'";
        _logger.info("Running command " + tableCfEditCommand);
        exitCode = TestCluster.runCommand((String)tableCfEditCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        table13 = MapRDBImpl.getTable((String)tablePath13_in_voluntagged);
        _logger.info("Verifying that denied CF is not returned");
        for (DocumentReader reader : table13.find().documentReaders()) {
            this.validateScanCf3Denied((Table)table13, reader);
        }
        table13.close();
        String volumeModifyCommand2 = "maprcli volume modify -name " + VOLUME_UNTAGGED_POLICYACEONLY + " -readAce '!u:root'";
        _logger.info("Running command " + volumeModifyCommand2);
        exitCode = TestCluster.runCommand((String)volumeModifyCommand2).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        Thread.sleep(45000L);
        this.validateScanTableDenied(tablePath13_in_voluntagged);
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath13_in_voluntagged);
    }

    @Test
    public void testVolumeLevelAuditGlobal() throws Exception {
        _logger.info("Running command setting Audit Only Policy Check");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"1\"}");
        _logger.info("Running Tests...");
        this.volumeLevelAudit("PolicyAceOnly");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"0\"}");
    }

    @Test
    public void testVolumeLevelAuditEnforcement() throws Exception {
        this.volumeLevelAudit("PolicyAceAuditAndDataAce");
    }

    private void volumeLevelAudit(String enforcementMode) throws Exception {
        String TABLE_NAME14_INVOLTAGGED_NOACCESS = "t14-voltaggednoallowed";
        String tablePath14InVolTaggedNoAccess = VOLUME_TAGGED_NOACCESS_PATH + "/t14-voltaggednoallowed";
        _logger.info("Starting time");
        Instant beginning = Clock.systemUTC().instant();
        int exitCode = 0;
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_NOACCESS + " -enforcementmode " + enforcementMode));
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath14InVolTaggedNoAccess + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_PUBLIC;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.insertDocumentId(tablePath14InVolTaggedNoAccess, "id1", 0, OpType.OP_INSERTORREPLACE);
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        beginning = Clock.systemUTC().instant();
        Thread.sleep(1000L);
        JsonTable table14 = MapRDBImpl.getTable((String)tablePath14InVolTaggedNoAccess);
        Document reader = table14.findById("id1");
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        beginning = Clock.systemUTC().instant().minus(50L, ChronoUnit.MILLIS);
        Thread.sleep(5000L);
        this.deleteRow(tablePath14InVolTaggedNoAccess, table14, "id1", 0);
        table14.close();
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath14InVolTaggedNoAccess);
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_NOACCESS + " -enforcementmode PolicyAceAndDataAce"));
    }

    @Test
    public void testTableLevelAuditGlobal() throws Exception {
        _logger.info("Running command setting Audit Only Policy Check");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"1\"}");
        _logger.info("Running Tests...");
        this.tableLevelAudit("PolicyAceOnly");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"0\"}");
    }

    @Test
    public void testTableLevelAuditEnforcement() throws Exception {
        this.tableLevelAudit("PolicyAceAuditAndDataAce");
    }

    private void tableLevelAudit(String enforcementMode) throws Exception {
        String TABLE_NAME15_INVOLTAGGED_OK = "t15-voltaggedok";
        String tablePath15InVolTaggedOk = VOLUME_TAGGED_OK_PATH + "/t15-voltaggedok";
        Instant beginning = Clock.systemUTC().instant();
        int exitCode = 0;
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode " + enforcementMode));
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath15InVolTaggedOk + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.insertDocumentId(tablePath15InVolTaggedOk, "id1", 0, OpType.OP_INSERTORREPLACE);
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        beginning = Clock.systemUTC().instant();
        Thread.sleep(1000L);
        JsonTable table15 = MapRDBImpl.getTable((String)tablePath15InVolTaggedOk);
        Document reader = table15.findById("id1");
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        beginning = Clock.systemUTC().instant().minus(50L, ChronoUnit.MILLIS);
        Thread.sleep(1000L);
        this.deleteRow(tablePath15InVolTaggedOk, table15, "id1", 0);
        table15.close();
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath15InVolTaggedOk);
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceAndDataAce"));
    }

    @Test
    public void testCFLevelAuditGlobal() throws Exception {
        _logger.info("Running command setting Audit Only Policy Check");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"1\"}");
        _logger.info("Running Tests...");
        this.cFLevelAudit("PolicyAceOnly");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"0\"}");
    }

    @Test
    public void testCFLevelAuditEnforcement() throws Exception {
        this.cFLevelAudit("PolicyAceAuditAndDataAce");
    }

    private void cFLevelAudit(String enforcementMode) throws Exception {
        String TABLE_NAME16_INVOLTAGGED_OK = "t16-voltaggedok";
        String tablePath16InVolTaggedOk = VOLUME_TAGGED_OK_PATH + "/t16-voltaggedok";
        Instant beginning = Clock.systemUTC().instant();
        int exitCode = 0;
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode " + enforcementMode));
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath16InVolTaggedOk + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_PUBLIC;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCf1CreateCommand = "maprcli table cf create -path " + tablePath16InVolTaggedOk + " -cfname mycf -jsonpath b -force true -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableCf1CreateCommand);
        exitCode = TestCluster.runCommand((String)tableCf1CreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.insertDocumentDefaultContents(tablePath16InVolTaggedOk, "id1", 0, OpType.OP_INSERTORREPLACE);
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        beginning = Clock.systemUTC().instant();
        Thread.sleep(1000L);
        JsonTable table16 = MapRDBImpl.getTable((String)tablePath16InVolTaggedOk);
        Document reader = table16.findById("id1");
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        beginning = Clock.systemUTC().instant().minus(50L, ChronoUnit.MILLIS);
        Thread.sleep(1000L);
        this.deleteRow(tablePath16InVolTaggedOk, table16, "id1", 0);
        table16.close();
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath16InVolTaggedOk);
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceAndDataAce"));
    }

    @Test
    public void testColLevelAuditGlobal() throws Exception {
        _logger.info("Running command setting Audit Only Policy Check");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"1\"}");
        _logger.info("Running Tests...");
        this.colLevelAudit("PolicyAceOnly");
        TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.audit.only.policy.check\":\"0\"}");
    }

    @Test
    public void testColLevelAuditEnforcement() throws Exception {
        this.colLevelAudit("PolicyAceAuditAndDataAce");
    }

    private void colLevelAudit(String enforcementMode) throws Exception {
        String TABLE_NAME17_INVOLTAGGED_OK = "t17-voltaggedok";
        String tablePath17InVolTaggedOk = VOLUME_TAGGED_OK_PATH + "/t17-voltaggedok";
        Instant beginning = Clock.systemUTC().instant();
        int exitCode = 0;
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode " + enforcementMode));
        Thread.sleep(45000L);
        String tableCreateCommand = "maprcli table create -path " + tablePath17InVolTaggedOk + " -tabletype json -securitypolicy " + SECURITY_POLICY_ENFORCE_PUBLIC;
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableColCreateCommand = "maprcli table cf column securitypolicy set -path " + tablePath17InVolTaggedOk + " -cfname default -name b -securitypolicy " + SECURITY_POLICY_ENFORCE_NOTALLOWED;
        _logger.info("Running command " + tableColCreateCommand);
        exitCode = TestCluster.runCommand((String)tableColCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.insertDocumentDefaultContents(tablePath17InVolTaggedOk, "id1", 0, OpType.OP_INSERTORREPLACE);
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        beginning = Clock.systemUTC().instant();
        Thread.sleep(1000L);
        JsonTable table17 = MapRDBImpl.getTable((String)tablePath17InVolTaggedOk);
        Document reader = table17.findById("id1");
        Assert.assertTrue((boolean)TestJSONSecurityPolicyEnforcement.checkAuditLogs(beginning));
        TestJSONSecurityPolicyEnforcement.deleteTable(tablePath17InVolTaggedOk);
        TestCluster.runCommand((String)("maprcli volume modify -name " + VOLUME_TAGGED_OK + " -enforcementmode PolicyAceAndDataAce"));
    }

    private static boolean checkAuditLogs(Instant beginning) throws Exception {
        String[] logs;
        Thread.sleep(2000L);
        RunCommand runCommand = TestCluster.runCommand((String)"hadoop fs -cat /var/mapr/local/*/audit/*/DBAudit.log*.json | tail -n 10");
        if (DEBUG_AUDIT_TIME) {
            System.err.println("Beginning: " + beginning);
        }
        Assert.assertEquals((long)0L, (long)runCommand.getExitCode());
        String response = runCommand.getStdOut();
        for (String log : logs = response.split("\n")) {
            if (DEBUG_AUDIT_TIME) {
                System.err.println(log);
            }
            int begin = log.indexOf("\"$date\":\"") + 9;
            int end = log.indexOf(34, begin);
            if (begin < 0 || end < 0) continue;
            String date = log.substring(begin, end);
            Instant inst = Instant.parse(date);
            if (DEBUG_AUDIT_TIME) {
                System.err.println("Log time: " + inst);
            }
            if (!inst.isAfter(beginning) || !log.matches(REGEX_AUDIT_MATCH)) continue;
            return true;
        }
        return false;
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
    }

    private static void deleteTable(String strTablePath) throws Exception {
        int exitCode = 0;
        String tableDeleteCommand = "maprcli table delete -path " + strTablePath;
        _logger.info("Running command " + tableDeleteCommand);
        exitCode = TestCluster.runCommand((String)tableDeleteCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
    }

    private void insertDocumentDefaultContents(String tablePath, String id, int expectedCode, OpType op) {
        boolean exitCode = false;
        JsonTable table = MapRDBImpl.getTable((String)tablePath);
        Document d = MapRDBImpl.newDocument();
        d.set("a.x", true);
        d.set("b.y", "hello");
        d.set("c.x1", "aaa");
        this.insertDocumentContents(tablePath, table, id, d, expectedCode, op);
        table.close();
    }

    private void insertDocumentContents(String tablePath, JsonTable table, String id, Document d, int expectedCode, OpType op) {
        int exitCode = 0;
        try {
            switch (op) {
                case OP_INSERT: {
                    table.insert(id, d);
                    break;
                }
                case OP_REPLACE: {
                    table.replace(id, d);
                    break;
                }
                case OP_INSERTORREPLACE: {
                    table.insertOrReplace(id, d);
                }
            }
            table.flush();
        }
        catch (AccessDeniedException e) {
            _logger.info("Obtained Access Denied Exception when inserting into table " + tablePath);
            exitCode = 1;
        }
        catch (DBException e) {
            _logger.info("Obtained DB Exception when inserting into table " + tablePath);
            exitCode = 2;
        }
        Assert.assertEquals((long)expectedCode, (long)exitCode);
    }

    private void insertDocumentId(String tablePath, String id, int expectedCode, OpType op) {
        int exitCode = 0;
        JsonTable jsonTable = MapRDBImpl.getTable((String)tablePath);
        Document d = MapRDBImpl.newDocument().set("_id", id);
        try {
            switch (op) {
                case OP_INSERT: {
                    jsonTable.insert(d);
                    break;
                }
                case OP_REPLACE: {
                    jsonTable.replace(d);
                    break;
                }
                case OP_INSERTORREPLACE: {
                    jsonTable.insertOrReplace(d);
                }
            }
            jsonTable.flush();
        }
        catch (AccessDeniedException e) {
            _logger.info("Obtained Access Denied Exception when inserting into table " + tablePath);
            exitCode = 1;
        }
        catch (DocumentExistsException e) {
            _logger.info("Obtained DocumentExistsException when inserting into table " + tablePath);
            exitCode = 3;
        }
        catch (DBException e) {
            _logger.info("Obtained DB Exception when inserting into table " + tablePath);
            exitCode = 2;
        }
        jsonTable.close();
        Assert.assertEquals((long)expectedCode, (long)exitCode);
    }

    private void deleteRow(String tablePath, String id, int expectedCode) {
        JsonTable jsonTable = MapRDBImpl.getTable((String)tablePath);
        this.deleteRow(tablePath, jsonTable, id, expectedCode);
    }

    private void deleteRow(String tablePath, JsonTable table, String id, int expectedCode) {
        int exitCode = 0;
        try {
            table.delete(id);
            table.flush();
        }
        catch (AccessDeniedException e) {
            _logger.info("Obtained Access Denied Exception when deleting row with ID " + id + " from table " + tablePath);
            exitCode = 1;
        }
        catch (DBException e) {
            _logger.info("Obtained DB Exception when deleting row with ID " + id + " from table " + tablePath);
            exitCode = 2;
        }
        Assert.assertEquals((long)expectedCode, (long)exitCode);
    }

    private void applyMutation(Table tab, String id, String mutationString) {
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(mutationString);
        tab.update(id, m);
        tab.flush();
    }

    private static void createUntaggedVolume(String volumeName, String volumePath) throws Exception {
        TestJSONSecurityPolicyEnforcement.createUntaggedVolume(volumeName, volumePath, new String());
    }

    private static void createUntaggedVolume(String volumeName, String volumePath, String extraArgs) throws Exception {
        int exitCode = 0;
        _logger.info("Checking if volume " + volumeName + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli volume info -name " + volumeName)).getExitCode();
        if (exitCode == 0) {
            _logger.info("Volume " + volumeName + " exists, deleting first");
            TestCluster.runCommand((String)("maprcli volume remove -name " + volumeName));
        }
        TestCluster.runCommand((String)("maprcli volume create -name " + volumeName + " -path " + volumePath + " " + extraArgs));
    }

    private static void createTaggedVolume(String volumeName, String volumePath, String securityPolicy, String enforcementMode) throws Exception {
        int exitCode = 0;
        _logger.info("Checking if volume " + volumeName + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli volume info -name " + volumeName)).getExitCode();
        if (exitCode == 0) {
            _logger.info("Volume " + volumeName + " exists, deleting first");
            TestCluster.runCommand((String)("maprcli volume remove -name " + volumeName));
        }
        TestCluster.runCommand((String)("maprcli volume create -name " + volumeName + " -path " + volumePath + " -securitypolicy " + securityPolicy + " -enforcementmode " + enforcementMode + " -auditenabled true"));
        TestCluster.runCommand((String)("hadoop mfs -setaudit on " + volumePath));
    }

    private static void removeVolume(String volumeName) throws Exception {
        TestCluster.runCommand((String)("maprcli volume remove -name " + volumeName));
    }

    private void validateScanOk(Table tab, DocumentReader r) {
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        block10: for (int nCFs = 3; nCFs > 0; --nCFs) {
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            switch (r.getFieldName()) {
                case "a": {
                    Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
                    Assert.assertEquals((Object)true, (Object)r.getBoolean());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    continue block10;
                }
                case "b": {
                    Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
                    Assert.assertEquals((Object)"y", (Object)r.getFieldName());
                    Assert.assertEquals((Object)"hello", (Object)r.getString());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    continue block10;
                }
                case "c": {
                    Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
                    Assert.assertEquals((Object)"x1", (Object)r.getFieldName());
                    Assert.assertEquals((Object)"aaa", (Object)r.getString());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    private void validateScanCf3Denied(Table tab, DocumentReader r) {
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        block8: for (int nCFs = 2; nCFs > 0; --nCFs) {
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            switch (r.getFieldName()) {
                case "a": {
                    Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
                    Assert.assertEquals((Object)true, (Object)r.getBoolean());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    continue block8;
                }
                case "b": {
                    Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
                    Assert.assertEquals((Object)"y", (Object)r.getFieldName());
                    Assert.assertEquals((Object)"hello", (Object)r.getString());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    continue block8;
                }
                default: {
                    assert (false);
                    continue block8;
                }
            }
        }
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    private void validateScanTableDenied(String tablePath) {
        try {
            JsonTable jsonTable = MapRDBImpl.getTable((String)tablePath);
        }
        catch (DBException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    private JsonTable createTableForIndex(String tableName, String indexName) throws Exception {
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        String[] splitKeys = new String[]{"user001", "user002", "user003", "user004", "user005"};
        JsonTable table = DBTests.createOrReplaceTable(tableName, cfMap, splitKeys);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        TestCluster.runCommand((String)("maprcli table index add -path " + table.getPath() + " -index " + indexName + " -indexedfields name.last:1,name.first:ASC,salary:asc -includedfields age"));
        DBTests.waitForSchemaUpdate();
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\", \"age\":43, \"salary\":43000, \"name\": {\"first\":\"Sam\", \"last\":\"Harris\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user002\", \"age\":32, \"salary\":340000, \"name\": {\"first\":\"Leon\", \"last\":\"Russel\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user003\", \"age\":47, \"salary\":25000, \"name\": {\"first\":\"David\", \"last\":\"Bowie\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user004\", \"age\":56, \"salary\":7500, \"name\": {\"first\":\"Bob\", \"last\":\"Dylan\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user005\", \"age\":54, \"salary\":12300, \"name\": {\"first\":\"David\", \"last\":\"Ackert\"}}"));
        table.flush();
        try {
            DBTests.waitForIndexFlush(table.getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.verifyIndexTableReadOk(table.getPath());
        return table;
    }

    private void verifyIndexTableReadOk(Path tablePath) throws Exception {
        Document doc = null;
        Collection tableIndexList = DBTests.admin().getTableIndexes(tablePath, true);
        IndexDesc indexTableDesc = (IndexDesc)tableIndexList.iterator().next();
        try (JsonTable indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = indexTable.find();){
            Iterator itr = stream.iterator();
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
            Assert.assertFalse((boolean)itr.hasNext());
        }
    }

    private void verifyIndexTableReadDenied(Collection<IndexDesc> tableIndexList) throws Exception {
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (JsonTable indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = indexTable.find();){
            Iterator itr = stream.iterator();
            try {
                ((Document)itr.next()).getIdString();
                Assert.assertNotNull(null);
            }
            catch (AccessDeniedException e) {
                _logger.debug("SUCCESS: Index scan failed with an exception as expected: " + e.getMessage());
            }
        }
    }

    static {
        DEBUG_AUDIT_TIME = false;
    }

    static enum OpType {
        OP_INSERT,
        OP_REPLACE,
        OP_INSERTORREPLACE;

    }
}

