/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.utils;

import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.tests.condition.TestCondition;
import com.mapr.db.util.ConditionParser;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class TestConditionParserWithoutCluster
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCondition.class);

    private void serializeAndCompare(QueryCondition condition, String infix) {
        _logger.info("Serializing condition\n{}", (Object)((ConditionImpl)condition).asPrefix());
        ByteBuffer serialized = ((ConditionImpl)condition).getDescriptor().getSerialized();
        QueryCondition newCondition = ConditionImpl.parseFrom((ByteBuffer)serialized);
        Assert.assertEquals((Object)condition, (Object)newCondition);
        Assert.assertEquals((Object)infix, (Object)((ConditionImpl)condition).asInfix());
    }

    @Test
    public void testSimpleConditionParsing() {
        String jsonCondition = "{\"$gt\":{\"a.b\":\"yyyy\"}}";
        ConditionParser conditionParser = new ConditionParser();
        ConditionImpl condition = (ConditionImpl)conditionParser.parseCondition(jsonCondition);
        this.serializeAndCompare((QueryCondition)condition, "(a.b > \"yyyy\")");
    }

    @Test
    public void testConditionWithExists() {
        String jsonCondition = "{\"$and\":[{\"$exists\":\"a.b\"},{\"$typeOf\":{\"a.x\":\"INT\"}}]}";
        ConditionParser conditionParser = new ConditionParser();
        ConditionImpl condition = (ConditionImpl)conditionParser.parseCondition(jsonCondition);
        this.serializeAndCompare((QueryCondition)condition, "((a.b != null) and (TYPE_OF(a.x) = INT))");
    }

    @Test
    public void testConditionWithEqualsToMapAndArray() {
        String jsonCondition = "{\"$or\":[{\"$eq\":{\"a.b\":{\"c\":{\"$numberLong\":234567}}}},{\"$eq\":{\"p.q\":[{\"$dateDay\":\"1994-05-27\"},\"Santanu\"]}}]}";
        ConditionParser conditionParser = new ConditionParser();
        ConditionImpl condition = (ConditionImpl)conditionParser.parseCondition(jsonCondition);
        this.serializeAndCompare((QueryCondition)condition, "((a.b = {\"c\":{\"$numberLong\":234567}}) or (p.q = [{\"$dateDay\":\"1994-05-27\"},\"Santanu\"]))");
    }

    @Test
    public void testConditionWithInOperator() {
        String jsonCondition = "{\"$and\":[{\"$in\":{\"age\":[20,30]}},{\"$notmatches\":{\"a.x\":\".*SAN.*\"}}]}";
        ConditionParser conditionParser = new ConditionParser();
        ConditionImpl condition = (ConditionImpl)conditionParser.parseCondition(jsonCondition);
        this.serializeAndCompare((QueryCondition)condition, "(((age = 20) or (age = 30)) and (a.x NOT_MATCHES \".*SAN.*\"))");
    }

    @Test
    public void testConditionWithBetweenOp() {
        String jsonCondition = "{\"$between\":{\"a.b\":[{\"$numberLong\":10000},{\"$numberLong\":20000}]}}";
        ConditionParser conditionParser = new ConditionParser();
        ConditionImpl condition = (ConditionImpl)conditionParser.parseCondition(jsonCondition);
        this.serializeAndCompare((QueryCondition)condition, "((a.b >= {\"$numberLong\":10000}) and (a.b <= {\"$numberLong\":20000}))");
    }

    @Test
    public void testConditionWithLike() {
        String jsonConditionStrVal = "{\"$like\": {\"field\": \"abc%\"}}";
        ConditionParser conditionParser1 = new ConditionParser();
        ConditionImpl condition1 = (ConditionImpl)conditionParser1.parseCondition(jsonConditionStrVal);
        this.serializeAndCompare((QueryCondition)condition1, "(field MATCHES \"^\\\\Qabc\\\\E.*$\")");
        String jsonConditionArrayVal = "{\"$like\": {\"field\": [\"a\\\\%bc%\", \"\\\\\"]}}";
        ConditionParser conditionParser2 = new ConditionParser();
        ConditionImpl condition2 = (ConditionImpl)conditionParser2.parseCondition(jsonConditionArrayVal);
        this.serializeAndCompare((QueryCondition)condition2, "(field MATCHES \"^\\\\Qabc\\\\E.*$\")");
    }
}

