/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.impl;

import com.mapr.db.impl.IdCodec;
import com.mapr.db.util.ByteBufs;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.ojai.Value;

public class TestIdCodec {
    @Test
    public void testStringEncodeDecode() {
        String SIMPLE_ENGLISH_TEXT = "simple_english_text";
        String SIMPLE_HINDI_TEXT = "\u0938\u0930\u0932\u0903\u0939\u093f\u0902\u0926\u0940\u0903\u0935\u093e\u0915\u094d\u092f";
        ByteBuffer encoded = IdCodec.encode((String)"simple_english_text");
        Assert.assertEquals((long)("simple_english_text".length() + 1), (long)encoded.remaining());
        encoded.mark();
        Assert.assertEquals((long)Value.Type.STRING.getCode(), (long)encoded.get());
        encoded.reset().mark();
        String decoded = IdCodec.decodeString((ByteBuffer)encoded);
        Assert.assertEquals((Object)"simple_english_text", (Object)decoded);
        encoded = IdCodec.encode((String)"\u0938\u0930\u0932\u0903\u0939\u093f\u0902\u0926\u0940\u0903\u0935\u093e\u0915\u094d\u092f");
        Assert.assertEquals((long)(1 + "\u0938\u0930\u0932\u0903\u0939\u093f\u0902\u0926\u0940\u0903\u0935\u093e\u0915\u094d\u092f".length() * 3), (long)encoded.remaining());
        encoded.mark();
        Assert.assertEquals((long)Value.Type.STRING.getCode(), (long)encoded.get());
        encoded.reset().mark();
        decoded = IdCodec.decodeString((ByteBuffer)encoded);
        Assert.assertEquals((Object)"\u0938\u0930\u0932\u0903\u0939\u093f\u0902\u0926\u0940\u0903\u0935\u093e\u0915\u094d\u092f", (Object)decoded);
    }

    @Test
    public void testBinaryEncodeDecode() {
        ByteBuffer ORIGINAL_BUFFER = ByteBufs.wrap((byte[])new byte[]{97, 98, 121, 116, 101, 98, 117, 102, 102, 101, 114});
        int remaining = ORIGINAL_BUFFER.remaining();
        ByteBuffer encoded = IdCodec.encode((ByteBuffer)ORIGINAL_BUFFER);
        Assert.assertEquals((long)remaining, (long)ORIGINAL_BUFFER.remaining());
        Assert.assertEquals((long)(remaining + 1), (long)encoded.remaining());
        encoded.mark();
        Assert.assertEquals((long)Value.Type.BINARY.getCode(), (long)encoded.get());
        encoded.reset().mark();
        ByteBuffer decoded = IdCodec.decodeBinary((ByteBuffer)encoded);
        Assert.assertEquals((Object)ORIGINAL_BUFFER, (Object)decoded);
    }
}

