/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.impl.MapRDBImpl;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.exceptions.DecodingException;

public class SubDocumentParser {
    private DocumentBuilder w;

    private void addArrayValue(DocumentReader reader, DocumentReader.EventType et) {
        switch (et) {
            case NULL: {
                this.w.addNull();
                break;
            }
            case BOOLEAN: {
                this.w.add(reader.getBoolean());
                break;
            }
            case STRING: {
                this.w.add(reader.getString());
                break;
            }
            case BYTE: {
                this.w.add(reader.getByte());
                break;
            }
            case SHORT: {
                this.w.add(reader.getShort());
                break;
            }
            case INT: {
                this.w.add(reader.getInt());
                break;
            }
            case LONG: {
                this.w.add(reader.getLong());
                break;
            }
            case FLOAT: {
                this.w.add(reader.getFloat());
                break;
            }
            case DOUBLE: {
                this.w.add(reader.getDouble());
                break;
            }
            case DECIMAL: {
                this.w.add(reader.getDecimal());
                break;
            }
            case DATE: {
                this.w.add(reader.getDate());
                break;
            }
            case TIME: {
                this.w.add(reader.getTime());
                break;
            }
            case TIMESTAMP: {
                this.w.add(reader.getTimestamp());
                break;
            }
            case BINARY: {
                this.w.add(reader.getBinary());
                break;
            }
            case INTERVAL: {
                this.w.add(reader.getInterval());
                break;
            }
            case START_MAP: {
                this.w.addNewMap();
                this.parseDocumentAsValue(reader);
                break;
            }
            case END_MAP: {
                this.w.endMap();
                break;
            }
            case START_ARRAY: {
                this.w.addNewArray();
                this.addNewArray(reader);
                break;
            }
            case END_ARRAY: {
                this.w.endArray();
                break;
            }
            default: {
                throw new DecodingException("Error parsing JSON Mutation : " + et);
            }
        }
    }

    private void addNewArray(DocumentReader reader) {
        DocumentReader.EventType et;
        while ((et = reader.next()) != null) {
            if (et == DocumentReader.EventType.END_ARRAY) {
                this.w.endArray();
                return;
            }
            this.w.setArrayIndex(reader.getArrayIndex());
            this.addArrayValue(reader, et);
        }
    }

    private void parseDocumentAsValue(DocumentReader reader) {
        DocumentReader.EventType et;
        block21: while ((et = reader.next()) != null) {
            switch (et) {
                case NULL: {
                    this.w.putNull(reader.getFieldName());
                    continue block21;
                }
                case BOOLEAN: {
                    this.w.put(reader.getFieldName(), reader.getBoolean());
                    continue block21;
                }
                case STRING: {
                    this.w.put(reader.getFieldName(), reader.getString());
                    continue block21;
                }
                case BYTE: {
                    this.w.put(reader.getFieldName(), reader.getByte());
                    continue block21;
                }
                case SHORT: {
                    this.w.put(reader.getFieldName(), reader.getShort());
                    continue block21;
                }
                case INT: {
                    this.w.put(reader.getFieldName(), reader.getInt());
                    continue block21;
                }
                case LONG: {
                    this.w.put(reader.getFieldName(), reader.getLong());
                    continue block21;
                }
                case FLOAT: {
                    this.w.put(reader.getFieldName(), reader.getFloat());
                    continue block21;
                }
                case DOUBLE: {
                    this.w.put(reader.getFieldName(), reader.getDouble());
                    continue block21;
                }
                case DECIMAL: {
                    this.w.put(reader.getFieldName(), reader.getDecimal());
                    continue block21;
                }
                case DATE: {
                    this.w.put(reader.getFieldName(), reader.getDate());
                    continue block21;
                }
                case TIME: {
                    this.w.put(reader.getFieldName(), reader.getTime());
                    continue block21;
                }
                case TIMESTAMP: {
                    this.w.put(reader.getFieldName(), reader.getTimestamp());
                    continue block21;
                }
                case INTERVAL: {
                    this.w.put(reader.getFieldName(), reader.getInterval());
                    continue block21;
                }
                case BINARY: {
                    this.w.put(reader.getFieldName(), reader.getBinary());
                    continue block21;
                }
                case START_MAP: {
                    this.w.putNewMap(reader.getFieldName());
                    this.parseDocumentAsValue(reader);
                    continue block21;
                }
                case END_MAP: {
                    this.w.endMap();
                    return;
                }
                case START_ARRAY: {
                    this.w.putNewArray(reader.getFieldName());
                    this.addNewArray(reader);
                    continue block21;
                }
                case END_ARRAY: {
                    this.w.endArray();
                    continue block21;
                }
            }
            throw new DecodingException("Error parsing JSON Mutatuion : " + et);
        }
    }

    public Document parseSubDocument(DocumentReader reader) {
        this.w = MapRDBImpl.newDocumentBuilder();
        this.w.addNewMap();
        this.parseDocumentAsValue(reader);
        return this.w.getDocument();
    }
}

