/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.jackson;

import com.mapr.db.JsonTable;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClusterTest.class})
public class TestMapRDBObjectsSerialization
extends BaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexDescSerialization() throws Exception {
        String tableName = "testIndexDesc_table";
        try (JsonTable table = DBTests.createOrReplaceTable("testIndexDesc_table");){
            DBTests.createIndex("testIndexDesc_table", "testindex", new String[]{"name.last"}, new String[]{"age"});
            Collection tableIndexes = DBTests.admin().getTableIndexes(table.getPath(), true);
            IndexDesc originalIndexDesc = (IndexDesc)tableIndexes.iterator().next();
            String serializedString = DBTests.mapper().writeValueAsString((Object)originalIndexDesc);
            IndexDesc newIndexDesc = (IndexDesc)DBTests.mapper().readValue(serializedString, IndexDesc.class);
            Assert.assertEquals((Object)originalIndexDesc, (Object)newIndexDesc);
        }
        catch (Throwable throwable) {
            DBTests.deleteTables("testIndexDesc_table");
            throw throwable;
        }
        DBTests.deleteTables("testIndexDesc_table");
    }
}

