/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tools;

import com.mapr.db.Admin;
import com.mapr.db.JsonTable;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.json.Events;
import org.ojai.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportJson
extends Configured
implements Tool {
    private static final Logger logger = LoggerFactory.getLogger(ImportJson.class);
    private MapRFileSystem maprfs_;
    private Events.Delegate eventDelegate_;
    private Path jsonFilePath_;
    private Path tablePath_;
    private FieldPath idField_;

    public ImportJson() {
    }

    public ImportJson(Path tablePath, Path jsonFilePath, FieldPath idField, Events.Delegate eventDelegate) {
        this.tablePath_ = tablePath;
        this.jsonFilePath_ = jsonFilePath;
        this.idField_ = idField;
        this.eventDelegate_ = eventDelegate;
    }

    public int run(String[] args) throws Exception {
        String id;
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs == null || otherArgs.length != 2) {
            this.usage();
            throw new IllegalArgumentException("ImportJson requires table name and json file path as argument. All other parameters must be specified as properties.");
        }
        this.tablePath_ = new Path(otherArgs[0]);
        this.jsonFilePath_ = new Path(otherArgs[1]);
        Class delegateClass = this.getConf().getClass("import.record.reader.delegate", null);
        if (delegateClass != null) {
            this.eventDelegate_ = (Events.Delegate)delegateClass.newInstance();
        }
        if ((id = this.getConf().get("import.id.fieldpath")) != null) {
            this.idField_ = FieldPath.parseFrom((String)id);
        }
        return this.run0();
    }

    public int run0() throws Exception {
        int code = 0;
        this.maprfs_ = MapRDBTableImplHelper.getMapRFileSystem(this.getConf());
        FileSystem importFileFS_ = FileSystem.get((URI)this.jsonFilePath_.toUri(), (Configuration)this.getConf());
        int printStatusEveryXRecord = this.getConf().getInt("print.status.every.x.record", 10000);
        if (this.maprfs_.exists(this.tablePath_) && !this.maprfs_.getTableProperties(this.tablePath_).getAttr().getJson()) {
            logger.error("Table path should to point to JSON table");
            return 1;
        }
        try (JsonTable table = this.maprfs_.exists(this.tablePath_) ? MapRDBImpl.getTable(this.tablePath_) : MapRDBImpl.createTable(this.tablePath_.toUri().getPath());
             FSDataInputStream jsonInStream = importFileFS_.open(this.jsonFilePath_);
             DocumentStream stream = Json.newDocumentStream((InputStream)jsonInStream, (Events.Delegate)this.eventDelegate_);){
            int recordCount = 0;
            for (Document record : stream) {
                if (this.idField_ != null) {
                    table.insertOrReplace(record.getString(this.idField_), record);
                } else {
                    table.insertOrReplace(record);
                }
                if (++recordCount % printStatusEveryXRecord != 0) continue;
                logger.info("Imported {} records.", (Object)recordCount);
            }
            logger.info("{} records imported.", (Object)recordCount);
            this.Cleanup();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return code;
    }

    private void Cleanup() throws IOException {
        Admin maprAdmin = MapRDBImpl.newAdmin();
        TableDescriptor dstTableDesc = maprAdmin.getTableDescriptor(this.tablePath_);
        if (dstTableDesc.isBulkLoad()) {
            dstTableDesc.setBulkLoad(false);
            maprAdmin.alterTable(dstTableDesc);
        }
    }

    private void usage() {
        System.out.println("Usage: ImportJson [options...] <table_name> <json_file>");
    }

    Path getJsonFilePath() {
        return this.jsonFilePath_;
    }

    void setJsonFilePath(Path jsonFilePath) {
        this.jsonFilePath_ = jsonFilePath;
    }

    FieldPath getIdField() {
        return this.idField_;
    }

    void setIdField(FieldPath idField) {
        this.idField_ = idField;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new ImportJson(), (String[])args);
        System.exit(ret);
    }
}

