/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.TimeAndUniq;
import org.ojai.Value;

class ContainerContext {
    private final Value.Type type;
    private int index;
    private TimeAndUniq indexTimeUniq;
    private final String fieldName;
    private final KeyValue kv;
    static final ContainerContext NULL = new ContainerContext(null);

    ContainerContext(Value.Type t) {
        this(t, null, null);
    }

    ContainerContext(Value.Type t, String key) {
        this(t, key, null);
    }

    ContainerContext(Value.Type t, String key, KeyValue v) {
        this.kv = v;
        this.type = t;
        this.index = -1;
        this.fieldName = key;
        this.indexTimeUniq = new TimeAndUniq();
    }

    public Value.Type getType() {
        return this.type;
    }

    int getIndex() {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("getIndex() called on a map");
        }
        return this.index;
    }

    TimeAndUniq getIndexTime() {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("getIndex() called on a map");
        }
        return this.indexTimeUniq;
    }

    void incrementIndex() {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("incrementIndex() called on a map");
        }
        ++this.index;
    }

    void setIndex(int i) {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("incrementIndex() called on a map");
        }
        this.index = i;
    }

    void setIndexTimeUniq(TimeAndUniq timeuniq) {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("setIndexTimeUniq() called on a map");
        }
        if (timeuniq == null) {
            this.indexTimeUniq.setTime(0L);
            this.indexTimeUniq.setUniq(0);
        } else {
            this.indexTimeUniq.setTime(timeuniq.time());
            this.indexTimeUniq.setUniq(timeuniq.uniq());
        }
    }

    void clearIndexTimeUniq() {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("clearIndexTimeUniq() called on a map");
        }
        this.indexTimeUniq.setTime(0L);
        this.indexTimeUniq.setUniq(0);
    }

    public String toString() {
        return "[" + this.type + ", " + this.index + ", " + this.fieldName + "]@" + this.hashCode();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public KeyValue getKv() {
        return this.kv;
    }

    public boolean isMap() {
        return this.type == Value.Type.MAP;
    }
}

