/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueSizeDescriptor;
import com.mapr.db.rowcol.KeyValueSizeHelper;
import com.mapr.db.rowcol.RowcolType;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.TimeDescriptor;
import com.mapr.db.rowcol.Validators;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import org.ojai.Value;
import org.ojai.exceptions.TypeException;

public class KeyValueSerializeHelper {
    public static void serialize(String fieldName, KeyValue kv, KeyValue parentKv, int indexInParent, SerializationContext context, ByteWriter w) {
        int numBitsForValue;
        int keySize;
        Validators.validateFieldForRowColSerialization(fieldName, kv, context);
        int startOffset = w.position();
        byte[] keyNameBytes = null;
        byte type = RowcolType.rowColType(kv.getType());
        type = (byte)(type | kv.opType << 5);
        w.put(type);
        if (kv.isArrayElement()) {
            keySize = 0;
            numBitsForValue = 8;
        } else {
            keyNameBytes = Bytes.toBytes((String)fieldName);
            keySize = keyNameBytes.length;
            numBitsForValue = KeyValueSizeDescriptor.valueSizeBitsForType(kv.getType());
        }
        int valueSize = KeyValueSizeHelper.getValueSize(kv);
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize(numBitsForValue, keySize);
        int valueSizeOfSize = KeyValueSizeDescriptor.getValueSizeOfSize(numBitsForValue, valueSize);
        if (kv.getType() == Value.Type.BOOLEAN) {
            valueSize = kv.getBoolean() ? 1 : 0;
        }
        int valueOffset = KeyValueSizeDescriptor.encodeKeyValueSize(numBitsForValue, keySizeOfSize, valueSizeOfSize, keySize, valueSize, w);
        assert (!kv.isContainerType() || valueSize == Integer.MAX_VALUE);
        TimeDescriptor.serialize(kv, w);
        if (!kv.isArrayElement()) {
            KeyValueSerializeHelper.serializeOrderOfField(kv, w);
            w.put(keyNameBytes);
        } else {
            DBList l = (DBList)parentKv;
            if (l.IsAbsoluteIndexType()) {
                ArrayIndexDescriptor.serialize(ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ABSOLUTE, indexInParent, l.map.size(), w);
            } else {
                ArrayIndexDescriptor.serialize(ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ASSOCIATIVE, indexInParent, l.list.size(), w);
            }
        }
        KeyValueSerializeHelper.serializeValue(kv, valueSize, context, w);
        if (kv.isContainerType()) {
            valueSize = w.position() - startOffset;
            w.putAtOffset(valueOffset, valueSize);
        }
    }

    private static void serializeOrderOfField(KeyValue kv, ByteWriter w) {
        int keySize = kv.getOrderOfField();
        int keySizeOfSize = KeyValueSizeDescriptor.getKeySizeOfSize(0, keySize);
        KeyValueSizeDescriptor.encodeKeyValueSize(0, keySizeOfSize, 0, keySize, 0, w);
    }

    private static void serializeValue(KeyValue kv, int estimatedValueSize, SerializationContext context, ByteWriter w) {
        if (kv.opType != InsertContext.OpType.NONE.ordinal()) {
            context.setHasMutation(true);
        }
        switch (kv.getType()) {
            case ARRAY: {
                KeyValueSerializeHelper.serializeArrayValue(kv, context, w);
                return;
            }
            case BINARY: {
                ByteBuffer b = kv.getBinary();
                if (b.remaining() <= 0) {
                    return;
                }
                int pos = b.position();
                w.put(b);
                b.position(pos);
                return;
            }
            case NULL: {
                if (!TimeDescriptor.isCreateTimeValid(kv) && TimeDescriptor.isDeleteTimeValid(kv)) {
                    context.setHasDeletes(true);
                }
                return;
            }
            case BOOLEAN: {
                return;
            }
            case BYTE: {
                w.put(kv.getByte());
                return;
            }
            case DECIMAL: {
                BigDecimalSizeDescriptor.serialize(kv.getDecimal(), w);
                return;
            }
            case DOUBLE: 
            case LONG: {
                w.putLong(kv.getPrimValue());
                return;
            }
            case FLOAT: 
            case INT: {
                w.putInt((int)(kv.getPrimValue() & 0xFFFFFFFFL));
                return;
            }
            case MAP: {
                KeyValueSerializeHelper.serializeMap(kv, context, w);
                return;
            }
            case SHORT: {
                w.putShort(kv.getShort());
                return;
            }
            case STRING: {
                byte[] b = Bytes.toBytes((String)kv.getString());
                w.put(b);
                return;
            }
            case INTERVAL: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                KeyValueSerializeHelper.serializeVarLong(kv, estimatedValueSize, w);
                return;
            }
        }
        throw new TypeException("Unknown type " + kv.getType());
    }

    private static void serializeMap(KeyValue kv, SerializationContext context, ByteWriter w) {
        DBDocumentImpl rec = (DBDocumentImpl)kv;
        TreeMap<String, KeyValue> sortedMap = new TreeMap<String, KeyValue>();
        int i = 0;
        for (Map.Entry<String, KeyValue> entry : rec.map.entrySet()) {
            String k = entry.getKey();
            KeyValue child = entry.getValue();
            if (child.isRootOfColumnFamily() && context.isFamilyRoot(child)) {
                ++i;
                continue;
            }
            child.setOrderOfField(i);
            sortedMap.put(k, child);
            ++i;
        }
        for (Map.Entry<String, KeyValue> entry : sortedMap.entrySet()) {
            KeyValue child = entry.getValue();
            KeyValueSerializeHelper.serialize(entry.getKey(), child, rec, child.getOrderOfField(), context, w);
        }
        w.put((byte)0);
    }

    private static void serializeVarLong(KeyValue kv, int estimatedValueSize, ByteWriter w) {
        long v = kv.getPrimValue();
        switch (estimatedValueSize) {
            case 0: {
                return;
            }
            case 1: {
                w.put((byte)(v & 0xFFL));
                return;
            }
            case 2: {
                w.putShort((short)(v & 0xFFFFL));
                return;
            }
            case 4: {
                w.putInt((int)v & 0xFFFFFFFF);
                return;
            }
            case 8: {
                w.putLong(v);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid size in serialize " + estimatedValueSize);
    }

    private static void serializeArrayValue(KeyValue kv, SerializationContext context, ByteWriter w) {
        DBList list = (DBList)kv;
        if (list.IsAbsoluteIndexType()) {
            for (int index : list.map.keySet()) {
                KeyValueSerializeHelper.serialize(null, list.map.get(index), list, index, context, w);
            }
        } else {
            for (int index = 0; index < list.list.size(); ++index) {
                if (list.list.get(index) == null) continue;
                KeyValueSerializeHelper.serialize(null, list.list.get(index), list, index, context, w);
            }
        }
        w.put((byte)0);
    }
}

