/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import java.util.Stack;
import org.ojai.FieldPath;

public class FieldPathStack {
    private final StringBuilder sb = new StringBuilder();
    private final Stack<Integer> stackTop = new Stack();
    private static final char SEPARATOR = '.';
    private final String NOT_MAP_FIELD = "$";
    private final String EMPTY_STRING = "";

    public void pop() {
        if (this.stackTop.empty()) {
            throw new IllegalStateException("path stack is empty");
        }
        int lastTop = this.stackTop.pop();
        this.sb.setLength(lastTop);
    }

    public void push(String fieldPath) {
        Preconditions.checkNotNull((Object)fieldPath, (Object)"fieldPath cannot be null");
        int currentLength = this.sb.length();
        this.stackTop.push(currentLength);
        if (currentLength > 0) {
            this.sb.append('.');
        }
        this.sb.append(fieldPath);
    }

    public void push(FieldPath fieldPath) {
        Preconditions.checkNotNull((Object)fieldPath, (Object)"fieldPath cannot be null");
        this.push(fieldPath.toString());
    }

    public String getPath(String fieldPath) {
        boolean notMapField = fieldPath.equals("$");
        if (this.stackTop.empty()) {
            return notMapField ? "" : fieldPath;
        }
        return this.sb.toString() + (String)(notMapField ? "" : "." + fieldPath);
    }

    public FieldPath getPath(FieldPath fieldPath) {
        return FieldPath.parseFrom((String)this.getPath(fieldPath.toString()));
    }
}

