/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.proto.Dbfilters;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;

@API.Internal
public class ConditionDescriptor {
    public static final ConditionDescriptor EMPTY_DESC = new ConditionDescriptor(ByteBuffer.wrap(new byte[0]));
    private Dbfilters.FilterMsg filterMsg;
    private ByteBuffer serialized;
    private Map<Integer, ? extends Set<FieldPath>> familyFieldPathsMap;

    private ConditionDescriptor(ByteBuffer serializedCondition) {
        this.serialized = serializedCondition;
    }

    ConditionDescriptor(Dbfilters.FilterMsg filterMsg, Map<Integer, ? extends Set<FieldPath>> familyFieldPathsMap) {
        this.filterMsg = filterMsg;
        this.familyFieldPathsMap = familyFieldPathsMap;
    }

    public Dbfilters.FilterMsg getFilterMsg() {
        return this.filterMsg;
    }

    public ByteBuffer getSerialized() {
        if (this.serialized == null && this.filterMsg != null) {
            byte[] b = this.filterMsg.toByteArray();
            this.serialized = ByteBufs.wrap(b);
        }
        return this.serialized;
    }

    public Map<Integer, ? extends Set<FieldPath>> getFamilyFieldPathsMap() {
        return this.familyFieldPathsMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.familyFieldPathsMap == null ? 0 : this.familyFieldPathsMap.hashCode());
        result = 31 * result + (this.serialized == null ? 0 : this.serialized.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionDescriptor other = (ConditionDescriptor)obj;
        if (this.familyFieldPathsMap == null ? other.familyFieldPathsMap != null : !this.familyFieldPathsMap.equals(other.familyFieldPathsMap)) {
            return false;
        }
        return !(this.serialized == null ? other.serialized != null : !this.serialized.equals(other.serialized));
    }

    public String toString() {
        ByteBuffer serialized = this.getSerialized();
        int position = serialized.position();
        QueryCondition qc = ConditionImpl.parseFrom(serialized);
        serialized.position(position);
        return qc.toString();
    }
}

