/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponentArray;
import com.mapr.db.indexrowkeyfmt.Null;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.db.indexrowkeyfmt.OMap;
import com.mapr.utils.ByteReader;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public abstract class CompositeComponent
extends IndexRowKeyComponent {
    protected Object document_;
    private IndexRowKeyComponentArray componentArray_;
    private int encodingSize_;
    private int origTypeEncodingSize_;
    protected boolean root_;
    protected final int ENCODING_SIZE_SIZE = 2;
    protected final int ORIGINAL_TYPE_ENCODING_SIZE_SIZE = 2;
    private static Null n = new Null();
    private static String s = new String("");
    private static byte[] ba = new byte[1];
    private static ODate d = new ODate(0L);
    private static OTimestamp ts = new OTimestamp(0L);
    private static OTime t = new OTime(0L);
    private static Error e = new Error(0);
    private static OArray a = new OArray();
    private static OMap m = new OMap();

    public abstract byte getMarker();

    public abstract boolean canPotentiallyContributeToOriginalTypeEncoding(int var1);

    CompositeComponent(boolean missingAndNullFirst, boolean descendingOrder, byte type, boolean root) {
        super(type, descendingOrder);
        this.document_ = null;
        this.componentArray_ = new IndexRowKeyComponentArray();
        this.encodingSize_ = 0;
        this.origTypeEncodingSize_ = 0;
        this.root_ = root;
    }

    CompositeComponent(OArray doc, boolean missingAndNullFirst, boolean descendingOrder, byte type, boolean root) {
        super(type, descendingOrder);
        this.document_ = doc.array_;
        this.componentArray_ = new IndexRowKeyComponentArray();
        this.encodingSize_ = 0;
        this.origTypeEncodingSize_ = 0;
        this.root_ = root;
        int componentIdx = 0;
        int componentArraySize = doc.array_.size();
        this.componentArray_.init(componentArraySize, missingAndNullFirst);
        for (int i = 0; i < componentArraySize; ++i) {
            if (doc.array_.get(i) == null) {
                this.componentArray_.set(componentIdx++, new Null(), this.descendingOrder_);
                continue;
            }
            this.componentArraySet(componentIdx++, doc.array_.get(i));
        }
    }

    CompositeComponent(OMap doc, boolean missingAndNullFirst, boolean descendingOrder, byte type, boolean root) {
        super(type, descendingOrder);
        this.document_ = doc.map_;
        this.componentArray_ = new IndexRowKeyComponentArray();
        this.encodingSize_ = 0;
        this.origTypeEncodingSize_ = 0;
        this.root_ = root;
        int componentIdx = 0;
        int componentArraySize = doc.map_.size() * 2;
        this.componentArray_.init(componentArraySize, missingAndNullFirst);
        for (Map.Entry<String, Object> entry : doc.map_.entrySet()) {
            String key = entry.getKey();
            this.componentArray_.set(componentIdx++, key.getBytes(), key.length(), descendingOrder);
            Object value = entry.getValue();
            if (value == null) {
                this.componentArray_.set(componentIdx++, new Null(), this.descendingOrder_);
                continue;
            }
            this.componentArraySet(componentIdx++, value);
        }
    }

    protected void componentArrayReset() {
        this.componentArray_.init(0);
    }

    private void componentArraySet(int idx, Object fieldValue) {
        if (fieldValue instanceof Boolean) {
            this.componentArray_.set(idx, (Boolean)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof String) {
            this.componentArray_.set(idx, ((String)fieldValue).getBytes(), this.descendingOrder_);
        } else if (fieldValue instanceof Byte) {
            this.componentArray_.set(idx, (Byte)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof Short) {
            this.componentArray_.set(idx, (Short)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof Integer) {
            this.componentArray_.set(idx, (Integer)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof Long) {
            this.componentArray_.set(idx, (Long)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof Float) {
            this.componentArray_.set(idx, ((Float)fieldValue).floatValue(), this.descendingOrder_);
        } else if (fieldValue instanceof Double) {
            this.componentArray_.set(idx, (Double)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof ODate) {
            this.componentArray_.set(idx, (ODate)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof OTime) {
            this.componentArray_.set(idx, (OTime)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof OTimestamp) {
            this.componentArray_.set(idx, (OTimestamp)fieldValue, this.descendingOrder_);
        } else if (fieldValue instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)fieldValue;
            this.componentArray_.set(idx, bb.array(), bb.array().length, this.descendingOrder_);
        } else if (fieldValue instanceof Map) {
            this.componentArray_.set(idx, new OMap((Map)fieldValue), this.descendingOrder_);
        } else if (fieldValue instanceof List) {
            this.componentArray_.set(idx, new OArray((List)fieldValue), this.descendingOrder_);
        }
    }

    protected IndexRowKeyComponent componentArrayGet(int idx) {
        return this.componentArray_.get(idx);
    }

    @Override
    public byte getMarker(boolean biggest) {
        return this.getMarker();
    }

    @Override
    public int getOrigTypeEncodingSize() {
        return this.origTypeEncodingSize_;
    }

    @Override
    public int getEncodingSizeEstimate() {
        return 3 + (this.root_ ? 2 : 0) + this.componentArray_.getEncodingSizeEstimate() + this.componentArray_.getNumComponents();
    }

    @Override
    public int getEncodingSize() {
        return this.encodingSize_;
    }

    @Override
    public int encodeOrigType(ByteBuffer buf) {
        int numComponents = this.componentArray_.getNumComponents();
        int initPosition = buf.position();
        for (int i = 0; i < numComponents; ++i) {
            int encSize;
            if (!this.canPotentiallyContributeToOriginalTypeEncoding(i) || (encSize = this.componentArray_.get(i).encodeOrigType(buf)) >= 0) continue;
            return encSize;
        }
        return buf.position() - initPosition;
    }

    protected IndexRowKeyComponent getComponent(ByteReader buf, int offset) {
        byte firstByte = buf.getByte(offset);
        IndexRowKeyComponent component = null;
        switch (firstByte) {
            case -6: 
            case 5: {
                this.componentArray_.emplace_back(n, this.descendingOrder_);
                break;
            }
            case -8: 
            case -7: 
            case 6: 
            case 7: {
                this.componentArray_.emplace_back(false, this.descendingOrder_);
                break;
            }
            case -9: 
            case 8: {
                this.componentArray_.emplace_back(s.getBytes(), this.descendingOrder_);
                break;
            }
            case -10: 
            case 9: {
                this.componentArray_.emplace_back(ba, ba.length, this.descendingOrder_);
                break;
            }
            case -11: 
            case 10: {
                this.componentArray_.emplace_back(d, this.descendingOrder_);
                break;
            }
            case -13: 
            case 12: {
                this.componentArray_.emplace_back(ts, this.descendingOrder_);
                break;
            }
            case -12: 
            case 11: {
                this.componentArray_.emplace_back(t, this.descendingOrder_);
                break;
            }
            case -18: 
            case 17: {
                this.componentArray_.emplace_back(a, this.descendingOrder_);
                break;
            }
            case -17: 
            case 16: {
                this.componentArray_.emplace_back(m, this.descendingOrder_);
                break;
            }
            default: {
                if (90 <= firstByte || firstByte <= -91 || 90 <= firstByte || firstByte <= -91 || firstByte == -80 || firstByte == 79 || firstByte == -79 || firstByte == 78) {
                    this.componentArray_.emplace_back(0, this.descendingOrder_);
                    break;
                }
                return null;
            }
        }
        component = this.componentArray_.back();
        if (component.calculateEncodingSize(buf, offset) == 0) {
            return null;
        }
        assert (buf.length() >= this.componentArray_.getNumComponents());
        component.setOffset(offset);
        return component;
    }

    @Override
    public int encode(ByteBuffer dst) {
        short size = 0;
        int initPosition = dst.position();
        dst.put(this.getMarker());
        int wholeEncodingSizeOffset = dst.position();
        dst.putShort(size);
        int originalTypeEncodingSizeOffset = 0;
        if (this.root_) {
            originalTypeEncodingSizeOffset = dst.position();
            dst.putShort(size);
        }
        int numComponents = this.componentArray_.getNumComponents();
        this.origTypeEncodingSize_ = 0;
        for (int i = 0; i < numComponents; ++i) {
            Byte s;
            IndexRowKeyComponent irkc = this.componentArray_.get(i);
            int encSize = irkc.encode(dst);
            if (encSize < 0) {
                return encSize;
            }
            if (this.canPotentiallyContributeToOriginalTypeEncoding(i)) {
                this.origTypeEncodingSize_ += irkc.getOrigTypeEncodingSize();
            }
            if ((s = irkc.getSeparator()) == null) continue;
            dst.put(s);
        }
        this.encodingSize_ = dst.position() - initPosition;
        dst.putShort(wholeEncodingSizeOffset, (short)this.encodingSize_);
        if (this.root_) {
            dst.putShort(originalTypeEncodingSizeOffset, (short)this.origTypeEncodingSize_);
        }
        return this.encodingSize_;
    }

    private int unsigned(byte b) {
        return 0xFF & b;
    }

    @Override
    public int calculateEncodingSize(ByteReader bb, int offset) {
        int n = ++offset;
        byte msb = bb.getByte(n);
        int n2 = ++offset;
        ++offset;
        byte lsb = bb.getByte(n2);
        this.encodingSize_ = this.unsigned(msb) << 8 | this.unsigned(lsb);
        if (this.root_) {
            msb = bb.getByte(offset++);
            lsb = bb.getByte(offset++);
            this.origTypeEncodingSize_ = this.unsigned(msb) << 8 | this.unsigned(lsb);
        }
        return this.encodingSize_;
    }
}

