/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.ClonedCondition;
import com.mapr.db.impl.ConditionNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.ojai.FieldPath;

public class CorrelationTracker {
    final HashMap<String, Set<ClonedCondition>> fieldConditions = new HashMap();
    private static final Pattern OPEN_ARRAY = Pattern.compile("\\[\\]");
    private final Stack<ConditionNode> logicalStack = new Stack();

    public static boolean isOpenArrayPath(String fieldPath) {
        return fieldPath.indexOf("[]") > 0;
    }

    public static boolean isOpenArrayPath(FieldPath fieldPath) {
        return CorrelationTracker.isOpenArrayPath(fieldPath.toString());
    }

    public static boolean hasMultiLevelArray(String fieldPath) {
        return OPEN_ARRAY.matcher(fieldPath).results().count() > 1L;
    }

    public Set<ClonedCondition> getClonedConditions(String fieldPath) {
        Set<ClonedCondition> foundSet = this.fieldConditions.get(fieldPath);
        if (foundSet == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(foundSet);
    }

    public void addKeyCondition(String fieldPath, ClonedCondition clonedCondition) {
        Preconditions.checkArgument((boolean)CorrelationTracker.isOpenArrayPath(fieldPath), (Object)("fieldPath is not an array path " + fieldPath));
        Preconditions.checkNotNull((Object)clonedCondition, (Object)"clonedCondition cannot be null");
        Set<ClonedCondition> conditionSet = this.fieldConditions.get(fieldPath);
        if (conditionSet == null) {
            conditionSet = new HashSet<ClonedCondition>();
            this.fieldConditions.put(fieldPath, conditionSet);
        }
        conditionSet.add(clonedCondition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{fieldConditions = ");
        sb.append(this.fieldConditions.toString());
        sb.append(", logicalStack = ");
        sb.append(this.logicalStack);
        sb.append('}');
        return sb.toString();
    }

    public void push(ConditionNode conditionNode) {
        this.logicalStack.push(conditionNode);
    }

    public void pop(ConditionNode conditionNode) {
        ConditionNode poppedNode = this.logicalStack.pop();
        if (poppedNode != conditionNode) {
            throw new IllegalStateException();
        }
    }

    public boolean underCorrelation() {
        return !this.logicalStack.isEmpty() && this.logicalStack.peek() != null;
    }
}

