/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.indexrowkeyfmt.CompositeComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.utils.ByteReader;
import org.apache.commons.lang.mutable.MutableInt;
import org.ojai.Document;
import org.ojai.DocumentBuilder;

public class ArrayComponent
extends CompositeComponent {
    private OArray value_;
    private int encodingSize_;

    public ArrayComponent(boolean missingAndNullFirst, boolean descendingOrder, boolean root) {
        super(missingAndNullFirst, descendingOrder, (byte)17, root);
        this.value_ = null;
    }

    public ArrayComponent(boolean missingAndNullFirst, boolean descendingOrder) {
        super(missingAndNullFirst, descendingOrder, (byte)17, false);
        this.value_ = null;
    }

    public ArrayComponent(OArray value, boolean missingAndNullFirst, boolean descendingOrder, boolean root) {
        super(value, missingAndNullFirst, descendingOrder, (byte)17, root);
        this.value_ = value;
    }

    public ArrayComponent(OArray value, boolean missingAndNullFirst, boolean descendingOrder) {
        super(value, missingAndNullFirst, descendingOrder, (byte)17, false);
        this.value_ = value;
    }

    @Override
    public byte getMarker() {
        return this.descendingOrder_ ? (byte)-18 : 17;
    }

    @Override
    public OArray getArray() {
        return this.value_;
    }

    @Override
    public boolean canPotentiallyContributeToOriginalTypeEncoding(int i) {
        return true;
    }

    @Override
    public int decode(ByteReader buf, int offset, int bufSize, MutableInt origTypeOffset) {
        DocumentBuilder docBld = MapRDBImpl.newDocumentBuilder();
        docBld.addNewMap();
        docBld.putNewArray("top");
        int decodedSize = this.decodeChildren(buf, offset, bufSize, origTypeOffset, docBld);
        docBld.endArray();
        docBld.endMap();
        assert (this.root_);
        Document d = docBld.getDocument();
        this.document_ = d.getValue("top").getList();
        this.value_ = new OArray(d.getValue("top").getList());
        this.setIsDecoded();
        return decodedSize;
    }

    @Override
    public int decodeChildren(ByteReader buf, int offset, int bufSize, MutableInt origTypeOffset, DocumentBuilder docBld) {
        if (buf.getByte(offset) != this.getMarker()) {
            return -1;
        }
        int offsetLimit = offset + bufSize;
        int origTypeInit = origTypeOffset.intValue();
        ++offset;
        offset += 2;
        if (this.root_) {
            offset += 2;
        }
        while (offset < offsetLimit) {
            IndexRowKeyComponent irkcV = this.getComponent(buf, offset);
            if (irkcV == null) {
                this.componentArrayReset();
                return -1;
            }
            int decodedSize = irkcV.decode(buf, offset, irkcV.getEncodingSize(), origTypeOffset, docBld);
            if (decodedSize < 0) {
                this.componentArrayReset();
                return -1;
            }
            offset += irkcV.getFullEncodingSize();
        }
        if (this.root_ && origTypeOffset.intValue() - origTypeInit != this.getOrigTypeEncodingSize()) {
            this.componentArrayReset();
            return -1;
        }
        if (offset != offsetLimit) {
            this.componentArrayReset();
            return -1;
        }
        return bufSize;
    }
}

