/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.utils;

import com.mapr.utils.Crypto;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class DataUtil {
    private static final Random rand = new Random(System.currentTimeMillis());

    public static String buildKey(long keynum) {
        return DataUtil.buildKey(keynum, "user", false);
    }

    public static String buildKey(long keynum, String keyPrefix) {
        return DataUtil.buildKey(keynum, keyPrefix, false);
    }

    public static String buildKey(long keynum, String keyPrefix, boolean orderedinserts) {
        if (!orderedinserts) {
            keynum = Crypto.fnvHash64((long)keynum);
        }
        return keyPrefix + keynum;
    }

    public static Map<String, ByteBuffer> buildValues(int fieldcount, int fieldlength) {
        HashMap<String, ByteBuffer> values = new HashMap<String, ByteBuffer>();
        for (int i = 0; i < fieldcount; ++i) {
            String fieldkey = "field" + i;
            ByteBuffer data = ByteBuffer.allocate(fieldlength);
            rand.nextBytes(data.array());
            values.put(fieldkey, data);
        }
        return values;
    }
}

