/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.mapr.db.impl.AefTransformer;
import com.mapr.db.impl.ClonedCondition;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.CorrelationTracker;
import com.mapr.db.impl.ElementAndScreener;
import com.mapr.db.impl.FieldPathStack;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBIndexImplWrapper;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.db.util.SqlHelper;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.fs.proto.Dbserver;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.utils.IndentingStringBuilder;
import com.mapr.utils.JsonUtils;
import com.mapr.utils.Regexes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.json.JsonOptions;
import org.ojai.store.QueryCondition;
import org.ojai.util.Values;

@API.Internal
public class ConditionLeaf
extends ConditionNode {
    private final FieldPath field;
    private final String fieldStr;
    private String complexPathStr;
    private FieldPath complexPath;
    private final Dbfilters.CompareOpProto op;
    private final Dbfilters.ComparatorModeProto cmpMode;
    private KeyValue value;
    private MapRDBIndexImpl indexTable = null;
    private boolean nonindexed = false;
    private ClonedCondition clonedCondition;
    private static final String EMPTY_STR = "";
    private static final int INDEX_POS_INCLUDED = -1;
    private static final BiMap<Dbfilters.CompareOpProto, QueryCondition.Op> opProtoMapInverse = opProtoMap.inverse();
    private static final BaseEncoding base64UrlEncoder = BaseEncoding.base64Url();

    ConditionLeaf(FieldPath path, QueryCondition.Op op, KeyValue initFrom, ConditionImpl c) {
        this(path, (Dbfilters.CompareOpProto)opProtoMap.get((Object)op), initFrom, c);
    }

    ConditionLeaf(FieldPath field, Dbfilters.CompareOpProto op, KeyValue value, ConditionImpl c) {
        this(field, op, value, Dbfilters.ComparatorModeProto.CMP_VALUE, c);
    }

    ConditionLeaf(FieldPath field, QueryCondition.Op op, KeyValue value, Dbfilters.ComparatorModeProto cmpMode, ConditionImpl c) {
        this(field, (Dbfilters.CompareOpProto)opProtoMap.get((Object)op), value, cmpMode, c);
    }

    ConditionLeaf(FieldPath field, Dbfilters.CompareOpProto op, KeyValue value, Dbfilters.ComparatorModeProto cmpMode, ConditionLeaf oldLeaf, ConditionImpl c) {
        super(c);
        this.op = op;
        this.field = field;
        this.value = value;
        this.cmpMode = cmpMode;
        this.fieldStr = field.asPathString();
        this.checkArgs();
        if (oldLeaf != null) {
            this.complexPath = oldLeaf.complexPath;
            this.complexPathStr = oldLeaf.complexPathStr;
        }
    }

    ConditionLeaf(FieldPath field, Dbfilters.CompareOpProto op, KeyValue value, Dbfilters.ComparatorModeProto cmpMode, ConditionImpl c) {
        this(field, op, value, cmpMode, null, c);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionLeaf other = (ConditionLeaf)o;
        if (this.cmpMode != other.cmpMode || this.op != other.op || !this.fieldStr.equals(other.fieldStr)) {
            return false;
        }
        return this.value == null || this.value.equals(other.value);
    }

    ConditionLeaf(String filterId, ByteString serializedState, ConditionImpl c) {
        super(c);
        Dbfilters.FilterComparatorProto filterComparator = null;
        try {
            switch (filterId) {
                case "8cbdcd12": {
                    Dbfilters.ConditionFilterProto proto = Dbfilters.ConditionFilterProto.parseFrom((ByteString)serializedState);
                    this.field = FieldPath.parseFrom((String)proto.getFieldPath());
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                case "469dbd04": {
                    this.field = DocumentConstants.ID_FIELD;
                    Dbfilters.ConditionFilterProto proto = Dbfilters.RowFilterProto.parseFrom((ByteString)serializedState);
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                case "rk_filter": {
                    this.field = Constants.ROWKEY_FIELD_PATH;
                    Dbfilters.ConditionFilterProto proto = Dbfilters.RowFilterProto.parseFrom((ByteString)serializedState);
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid filter id: " + filterId);
                }
            }
            this.op = filterComparator.getCompareOp();
            if (filterComparator.hasComparator() && filterComparator.getComparator().hasSerializedComparator()) {
                String name = filterComparator.getComparator().getName();
                ByteString state = filterComparator.getComparator().getSerializedComparator();
                switch (name) {
                    case "45a94888": {
                        Dbfilters.BinaryComparatorProto binaryComparator = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)state);
                        ByteBuffer encoded = binaryComparator.getComparable().asReadOnlyByteBuffer();
                        encoded.order(ByteOrder.LITTLE_ENDIAN);
                        HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
                        bufferMap.put(0, encoded);
                        DBDocumentImpl doc = RowcolCodec.decode(bufferMap, Constants.DEFAULT_FAMILY_MAP, Constants.DEFAULT_NAME_MAP);
                        this.value = (KeyValue)doc.getValue(Dbfilters.ConditionLeafFieldsProto.getDefaultInstance().getXField());
                        break;
                    }
                    case "e2d7ba40": {
                        Dbfilters.RegexStringComparatorProto regexComparator = Dbfilters.RegexStringComparatorProto.parseFrom((ByteString)state);
                        this.value = DBValueBuilderImpl.KeyValueBuilder.initFrom(regexComparator.getPattern().toStringUtf8());
                        break;
                    }
                    case "05f39865": {
                        ByteString byteString = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)state).getComparable();
                        this.value = IdCodec.decode(byteString.asReadOnlyByteBuffer());
                        break;
                    }
                    case "2e7025c4": {
                        this.value = DBValueBuilderImpl.KeyValueBuilder.initFrom(Dbfilters.SizeComparatorProto.parseFrom((ByteString)state).getSize());
                        break;
                    }
                    case "8543f5eb": {
                        this.value = null;
                        break;
                    }
                    case "1e95fd6b": {
                        this.value = DBValueBuilderImpl.KeyValueBuilder.initFrom(Dbfilters.TypeComparatorProto.parseFrom((ByteString)state).getType());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid comparator id: " + name);
                    }
                }
            } else {
                this.value = null;
            }
            this.cmpMode = filterComparator.hasComparatorMode() ? filterComparator.getComparatorMode() : null;
            this.fieldStr = this.field.asPathString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode message", e);
        }
        this.checkArgs();
    }

    Dbfilters.CompareOpProto getOp() {
        return this.op;
    }

    FieldPath getField() {
        return this.field;
    }

    KeyValue getValue() {
        return this.value;
    }

    Dbfilters.ComparatorModeProto getComparatorMode() {
        return this.cmpMode;
    }

    @Override
    boolean checkAndPrune(ConditionNode.OptimizationMode optimizeMode) {
        switch (optimizeMode) {
            case OptimizeNone: {
                break;
            }
            case OptimizeRowKey: {
                if (this.isOnRowKey() && this.cmpMode == Dbfilters.ComparatorModeProto.CMP_VALUE && this.op != Dbfilters.CompareOpProto.NOT_EQUAL && opProtoMap.containsValue((Object)this.op) && this.value != null) {
                    return true;
                }
            }
            case OptimizeFull: {
                if (!this.isOnRowKey() && !this.isOnPartitionKeyPrefix() || this.cmpMode != Dbfilters.ComparatorModeProto.CMP_VALUE || this.op == Dbfilters.CompareOpProto.NOT_EQUAL || !opProtoMap.containsValue((Object)this.op) || this.value == null) break;
                return true;
            }
        }
        return false;
    }

    @Override
    void addProjections(Set<FieldPath> proj) {
        proj.add(this.complexPath);
    }

    @Override
    StringBuilder expressionBuilder(StringBuilder sb) {
        return this.treeBuilder(sb, 0);
    }

    public String toString() {
        return this.expressionBuilder(new StringBuilder()).toString();
    }

    @Override
    StringBuilder treeBuilder(StringBuilder sb, int level) {
        return sb.append('(').append(this.getFieldStr(sb)).append(' ').append(this.getOpStr(sb)).append(' ').append(this.getValueStr(sb)).append(')');
    }

    private String getFieldStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_PATTERN: 
            case CMP_VALUE: {
                sb.append(this.field.asPathString());
                break;
            }
            case CMP_TYPE: {
                sb.append("TYPE_OF(").append(this.fieldStr).append(')');
                break;
            }
            case CMP_SIZE: {
                sb.append("SIZE_OF(").append(this.fieldStr).append(')');
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return EMPTY_STR;
    }

    private String getValueStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_PATTERN: 
            case CMP_VALUE: 
            case CMP_SIZE: {
                if (this.value == null) {
                    sb.append("null");
                    break;
                }
                if (this.value.getType() == Value.Type.BINARY) {
                    sb.append("{\"").append("$binary").append("\":").append(JsonUtils.toJsonValue((ByteBuffer)this.value.getBinary())).append('}');
                    break;
                }
                sb.append(Values.asJsonString((Value)this.value));
                break;
            }
            case CMP_TYPE: {
                sb.append(Value.Type.valueOf((int)this.value.getInt()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return EMPTY_STR;
    }

    private String getOpStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_VALUE: 
            case CMP_TYPE: 
            case CMP_SIZE: {
                sb.append((String)opSymbolMap.get(this.op));
                break;
            }
            case CMP_PATTERN: {
                sb.append(this.op == Dbfilters.CompareOpProto.EQUAL ? "MATCHES" : "NOT_MATCHES");
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return EMPTY_STR;
    }

    private StringBuilder jsonBuilderUnaryOp(StringBuilder sb, String opStr) {
        return sb.append('{').append('\"').append(opStr).append('\"').append(':').append('\"').append(this.fieldStr).append('\"').append('}');
    }

    private static StringBuilder jsonBuilderFullBinaryOp(StringBuilder sb, String firstKey, String secondKey, String value) {
        return sb.append('{').append('\"').append(firstKey).append('\"').append(':').append('{').append('\"').append(secondKey).append('\"').append(':').append(value).append('}').append('}');
    }

    private StringBuilder jsonBuilderBinaryOp(StringBuilder sb, String opStr) {
        return ConditionLeaf.jsonBuilderFullBinaryOp(sb, opStr, this.fieldStr, this.value.asJsonString(JsonOptions.WITH_TAGS));
    }

    private StringBuilder jsonBuilderInfixBinaryOp(StringBuilder sb, String opStr) {
        return sb.append('{').append('\"').append(opStr).append('\"').append(':').append('{').append('\"').append(this.fieldStr).append('\"').append(':').append('{').append('\"').append((String)opJsonOpMap.get(this.op)).append('\"').append(':').append(this.value.asJsonString()).append('}').append('}').append('}');
    }

    @Override
    StringBuilder jsonBuilder(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_PATTERN: {
                String opStr = this.op == Dbfilters.CompareOpProto.EQUAL ? "$matches" : "$notmatches";
                return this.jsonBuilderBinaryOp(sb, opStr);
            }
            case CMP_VALUE: {
                if (this.value == null) {
                    String opStr = this.op == Dbfilters.CompareOpProto.EQUAL ? "$notexists" : "$exists";
                    return this.jsonBuilderUnaryOp(sb, opStr);
                }
                return this.jsonBuilderBinaryOp(sb, (String)opJsonOpMap.get(this.op));
            }
            case CMP_TYPE: {
                String opStr = this.op == Dbfilters.CompareOpProto.EQUAL ? "$typeof" : "$nottypeof";
                return ConditionLeaf.jsonBuilderFullBinaryOp(sb, opStr, this.fieldStr, "\"" + Value.Type.valueOf((int)this.value.getInt()).name() + "\"");
            }
            case CMP_SIZE: {
                return this.jsonBuilderInfixBinaryOp(sb, "$sizeof");
            }
        }
        throw new IllegalStateException("no case for " + this.cmpMode);
    }

    private void appendFieldStr(IndentingStringBuilder sb, String tableAlias, String fieldAlias) {
        boolean needDot = false;
        if (tableAlias != null) {
            sb.append(tableAlias);
            needDot = true;
        }
        if (fieldAlias != null) {
            if (needDot) {
                sb.append('.');
                needDot = false;
            }
            sb.append(fieldAlias);
            needDot = true;
        }
        if (!this.fieldStr.equals("$")) {
            if (needDot) {
                sb.append('.');
                needDot = false;
            }
            sb.append(this.fieldStr);
        }
    }

    private void appendSqlValue(IndentingStringBuilder sb) {
        if (this.value == null) {
            sb.append("null");
            return;
        }
        String toAppend = SqlHelper.toSqlString(this.value);
        sb.append(toAppend);
    }

    @Override
    public void appendSqlArrayCondition(IndentingStringBuilder sb, String tableAlias, String fieldAlias) {
        String opName = this.op == Dbfilters.CompareOpProto.NOT_EQUAL ? "<>" : (String)opSymbolMap.get(this.op);
        switch (this.cmpMode) {
            case CMP_VALUE: {
                sb.append('(');
                this.appendFieldStr(sb, tableAlias, fieldAlias);
                sb.append(' ');
                if (this.value == null && (this.op == Dbfilters.CompareOpProto.NOT_EQUAL || this.op == Dbfilters.CompareOpProto.EQUAL)) {
                    String opStr = this.op == Dbfilters.CompareOpProto.NOT_EQUAL ? "is not" : "is";
                    sb.append(opStr);
                } else {
                    sb.append(opName);
                }
                sb.append(' ');
                this.appendSqlValue(sb);
                sb.append(')');
                break;
            }
            case CMP_PATTERN: {
                if (this.op == Dbfilters.CompareOpProto.EQUAL) {
                    sb.append("ojai_matches(");
                } else {
                    sb.append("ojai_notmatches(");
                }
                this.appendFieldStr(sb, tableAlias, fieldAlias);
                sb.append(", ");
                this.appendSqlValue(sb);
                sb.append(')');
                break;
            }
            case CMP_SIZE: {
                sb.append('(');
                sb.append("ojai_sizeof(");
                this.appendFieldStr(sb, tableAlias, fieldAlias);
                sb.append(") ");
                sb.append(opName);
                sb.append(' ');
                this.appendSqlValue(sb);
                sb.append(')');
                break;
            }
            case CMP_TYPE: {
                sb.append('(');
                sb.append("ojai_typeof(");
                this.appendFieldStr(sb, tableAlias, fieldAlias);
                sb.append(") ");
                if (this.op == Dbfilters.CompareOpProto.EQUAL) {
                    sb.append("=");
                } else {
                    sb.append("<>");
                }
                sb.append(' ');
                this.appendSqlValue(sb);
                sb.append(')');
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is not currently supported.");
            }
        }
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap, MapRDBIndexImplWrapper idxWrapper) {
        if (this.isOnRowKey()) {
            return this.toRowKeyFilter(pathIdMap);
        }
        if (idxWrapper != null) {
            this.indexTable = idxWrapper.indexTable;
            this.setSiIndex(true);
            return this.toIndexFilter(pathIdMap, idxWrapper);
        }
        if (this.isOnId()) {
            return this.toIdFieldFilter(pathIdMap);
        }
        return this.toConditionFilter(pathIdMap);
    }

    boolean isOnId() {
        return this.complexPath.getRootSegment().isLastPath() && "_id".equals(this.complexPath.getRootSegment().getNameSegment().getName());
    }

    boolean isOnRowKey() {
        return this.complexPath.getRootSegment().isLastPath() && "$$row_key".equals(this.complexPath.getRootSegment().getNameSegment().getName());
    }

    private void checkArgs() {
        if (this.cmpMode == null) {
            throw new IllegalArgumentException("ComparatorModeProto can not be null.");
        }
        if (this.op == null) {
            throw new IllegalArgumentException("CompareOpProto can not be null.");
        }
        if (this.field == null) {
            throw new IllegalArgumentException("FieldPath can not be null.");
        }
        if (this.isOnPartitionKeyPrefix() && (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_VALUE || this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) && this.value != null && !IdCodec.isSupportedType(this.value.getType())) {
            throw new IllegalArgumentException(String.format("A %s value can not be used for '_id' field.", this.value.getType()));
        }
        if (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) {
            Pattern.compile(this.value.getString());
        }
    }

    private ConditionDescriptor toRowKeyFilter(BiMap<FieldPath, Integer> pathIdMap) {
        Dbfilters.RowFilterProto rowFilter = Dbfilters.RowFilterProto.newBuilder().setFilterComparator(this.getComparator(true)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("rk_filter").setSerializedState(rowFilter.toByteString()).build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry pathIdEntry : pathIdMap.inverse().entrySet()) {
            mapBuilder.put((Object)((Integer)pathIdEntry.getKey()), (Object)ImmutableSet.of((Object)((FieldPath)pathIdEntry.getValue())));
        }
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)mapBuilder.build());
    }

    private ConditionDescriptor toIdFieldFilter(BiMap<FieldPath, Integer> pathIdMap) {
        Dbfilters.RowFilterProto rowFilter = Dbfilters.RowFilterProto.newBuilder().setFilterComparator(this.getComparator(true)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("469dbd04").setSerializedState(rowFilter.toByteString()).build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry pathIdEntry : pathIdMap.inverse().entrySet()) {
            mapBuilder.put((Object)((Integer)pathIdEntry.getKey()), (Object)ImmutableSet.of((Object)((FieldPath)pathIdEntry.getValue())));
        }
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)mapBuilder.build());
    }

    private int getIndexPos(MapRDBIndexImplWrapper idxWrapper) {
        if (idxWrapper == null) {
            return -1;
        }
        MapRDBIndexImpl indexTable = idxWrapper.indexTable;
        int indexPos = this.isOnId() ? 0 : indexTable.getIndexRowkeyPos(this.complexPathStr, idxWrapper.useIdxFieldsTill);
        return indexPos;
    }

    private ConditionDescriptor toIndexFilter(BiMap<FieldPath, Integer> pathIdMap, MapRDBIndexImplWrapper idxWrapper) {
        Dbfilters.FilterMsg filterMsg;
        int indexPos = this.getIndexPos(idxWrapper);
        if (indexPos != -1) {
            Dbfilters.IndexRowKeyFilterProto indexFilter = Dbfilters.IndexRowKeyFilterProto.newBuilder().setOnIdField(this.isOnId()).setRowKeyPosition(indexPos).setFilterComparator(this.getComparator(this.isOnId())).build();
            filterMsg = Dbfilters.FilterMsg.newBuilder().setId("17544506").setSerializedState(indexFilter.toByteString()).build();
        } else {
            String nonindexedfp;
            this.nonindexed = true;
            try {
                nonindexedfp = this.complexPathStr.length() > 0 && this.complexPathStr.equals(this.fieldStr) ? (this.indexTable.isArrayIndex() ? this.indexTable.fieldPathToCFIdQual(this.complexPathStr) : this.indexTable.getNonIndexedComponentPath(this.complexPathStr)) : this.fieldStr;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("index field provided (" + this.complexPathStr + ") does not exist", e);
            }
            Dbfilters.ConditionFilterProto conditionFilter = Dbfilters.ConditionFilterProto.newBuilder().setFieldPath(nonindexedfp).setFamilyId(1).setFilterComparator(this.getComparator(false)).build();
            filterMsg = Dbfilters.FilterMsg.newBuilder().setId("8cbdcd12").setSerializedState(conditionFilter.toByteString()).build();
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry pathIdEntry : pathIdMap.inverse().entrySet()) {
            mapBuilder.put((Object)((Integer)pathIdEntry.getKey()), (Object)ImmutableSet.of((Object)((FieldPath)pathIdEntry.getValue())));
        }
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)mapBuilder.build());
    }

    private ConditionDescriptor toConditionFilter(BiMap<FieldPath, Integer> pathIdMap) {
        int useFamilyId;
        FieldPath fieldPath = this.field;
        Integer familyId = (Integer)pathIdMap.get((Object)FieldPath.EMPTY);
        if (familyId == null) {
            throw new IllegalStateException("Unable to find family id for the default column family.");
        }
        FieldPath lastParent = null;
        for (Map.Entry kv : pathIdMap.entrySet()) {
            FieldSegment progeny;
            FieldPath familyPath = (FieldPath)kv.getKey();
            if (familyPath.equals((Object)FieldPath.EMPTY) || (progeny = this.field.segmentAfterAncestor(familyPath)) == null || lastParent != null && !lastParent.isAtOrAbove(familyPath)) continue;
            lastParent = familyPath;
            fieldPath = progeny.equals((Object)FieldPath.EMPTY.getRootSegment()) ? Constants.DUMMY_FIELDPATH_V : Constants.DUMMY_FIELDPATH_V.cloneWithNewChild(progeny);
            familyId = (Integer)kv.getValue();
        }
        Dbfilters.ConditionFilterProto.Builder conditionFilterBuilder = Dbfilters.ConditionFilterProto.newBuilder().setFieldPath(fieldPath.asPathString(false)).setFilterComparator(this.getComparator(false));
        if (!this.complexPathStr.contains("[]")) {
            useFamilyId = familyId;
        } else {
            Map<Integer, FieldPath> idMap = MapRDBTableImplHelper.getOneCFQualifier(FieldPath.parseFrom((String)this.complexPathStr.substring(0, this.complexPathStr.indexOf("[]"))), pathIdMap, true);
            Map.Entry<Integer, FieldPath> cfCol = idMap.entrySet().iterator().next();
            useFamilyId = cfCol.getKey();
        }
        Dbfilters.ConditionFilterProto conditionFilter = conditionFilterBuilder.setFamilyId(useFamilyId).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("8cbdcd12").setSerializedState(conditionFilter.toByteString()).build();
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)ImmutableMap.of((Object)familyId, (Object)ImmutableSet.of((Object)fieldPath)));
    }

    private Dbfilters.FilterComparatorProto getComparator(boolean onId) {
        if (this.indexTable != null && !this.nonindexed && this.cmpMode == Dbfilters.ComparatorModeProto.CMP_VALUE) {
            boolean asc = false;
            Dbfilters.CompareOpProto op = this.op;
            try {
                asc = "_id".equals(this.complexPathStr) || IndexFieldDesc.Order.Asc == this.indexTable.getIndexComponentOrder(this.complexPathStr);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to find component order", e);
            }
            if (!asc) {
                if (this.op.equals((Object)Dbfilters.CompareOpProto.GREATER)) {
                    op = Dbfilters.CompareOpProto.LESS;
                }
                if (this.op.equals((Object)Dbfilters.CompareOpProto.LESS)) {
                    op = Dbfilters.CompareOpProto.GREATER;
                }
                if (this.op.equals((Object)Dbfilters.CompareOpProto.GREATER_OR_EQUAL)) {
                    op = Dbfilters.CompareOpProto.LESS_OR_EQUAL;
                }
                if (this.op.equals((Object)Dbfilters.CompareOpProto.LESS_OR_EQUAL)) {
                    op = Dbfilters.CompareOpProto.GREATER_OR_EQUAL;
                }
            }
            Dbfilters.FilterComparatorProto.Builder filterComparator = Dbfilters.FilterComparatorProto.newBuilder().setComparatorMode(this.cmpMode).setCompareOp(op);
            filterComparator.setComparator(this.toComparator(onId));
            return filterComparator.build();
        }
        Dbfilters.FilterComparatorProto.Builder filterComparator = Dbfilters.FilterComparatorProto.newBuilder().setComparatorMode(this.cmpMode).setCompareOp(this.op);
        filterComparator.setComparator(this.toComparator(onId));
        return filterComparator.build();
    }

    private Dbfilters.ComparatorProto toComparator(boolean onId) {
        Dbfilters.ComparatorProto.Builder builder = Dbfilters.ComparatorProto.newBuilder();
        switch (this.cmpMode) {
            case CMP_VALUE: {
                return this.buildValueComparator(builder, onId);
            }
            case CMP_TYPE: {
                return this.buildTypeComparator(builder, onId);
            }
            case CMP_PATTERN: {
                return this.buildPatternComparator(builder, onId);
            }
            case CMP_SIZE: {
                return this.buildSizeComparator(builder, onId);
            }
        }
        throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
    }

    private Dbfilters.ComparatorProto buildSizeComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString state = Dbfilters.SizeComparatorProto.newBuilder().setSize(this.value.getInt()).setOnIdField(onId).build().toByteString();
        return builder.setName("2e7025c4").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildPatternComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString pattern = ByteString.copyFrom((byte[])Bytes.toBytes((String)this.value.getString()));
        ByteString state = Dbfilters.RegexStringComparatorProto.newBuilder().setPattern(pattern).setIsUTF8(true).setOnIdField(onId).build().toByteString();
        return builder.setName("e2d7ba40").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildTypeComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString state = Dbfilters.TypeComparatorProto.newBuilder().setType(this.value.getInt()).setOnIdField(onId).build().toByteString();
        return builder.setName("1e95fd6b").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildValueComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        String name = null;
        ByteString state = null;
        if (this.value == null) {
            name = "8543f5eb";
            state = Dbfilters.NullComparatorProto.newBuilder().build().toByteString();
        } else {
            ByteString comparable = null;
            if (onId) {
                name = "05f39865";
                comparable = ByteString.copyFrom((ByteBuffer)IdCodec.encode(this.value));
            } else if (this.value != null) {
                if (this.isIndex && !this.nonindexed) {
                    int version;
                    name = "05f39865";
                    boolean isAsc = false;
                    try {
                        isAsc = IndexFieldDesc.Order.Asc == this.indexTable.getIndexComponentOrder(this.complexPathStr);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Failed to get index component order", e);
                    }
                    int n = version = this.indexTable.getVersion() == Dbserver.SIndexInfo.Version.v6dot0 ? 0 : 1;
                    if (this.value.getType() == Value.Type.MAP) {
                        TreeMap resMap = new TreeMap();
                        ConditionLeaf.recursiveMapSort(this.value, resMap);
                        this.value = DBValueBuilderImpl.KeyValueBuilder.initFromObject(resMap);
                    }
                    if (this.value.getType() == Value.Type.ARRAY) {
                        ArrayList resList = new ArrayList();
                        ConditionLeaf.recursiveMapSort(this.value, resList);
                        this.value = DBValueBuilderImpl.KeyValueBuilder.initFromObject(resList);
                    }
                    ByteBuffer bb = IndexRowKeyEncoder.encodeComponent(this.value, version, !isAsc, this.indexTable.getMissingAndNullFirst());
                    comparable = ByteString.copyFrom((byte[])bb.array(), (int)0, (int)bb.position());
                } else {
                    name = "45a94888";
                    Dbfilters.ConditionLeafFieldsProto defaultInstance = Dbfilters.ConditionLeafFieldsProto.getDefaultInstance();
                    DBDocumentImpl rec = new DBDocumentImpl();
                    rec.set(defaultInstance.getXField(), this.value);
                    SerializedFamilyInfo[] famInfo = RowcolCodec.encode(rec, Constants.DEFAULT_FAMILY_MAP);
                    assert (famInfo.length == 1);
                    assert (famInfo[0].getAction() == SerializationAction.SET);
                    comparable = ByteString.copyFrom((ByteBuffer)famInfo[0].getByteBuffer());
                }
            }
            state = Dbfilters.BinaryComparatorProto.newBuilder().setComparable(comparable).setOnIdField(onId).build().toByteString();
        }
        return builder.setName(name).setSerializedComparator(state).build();
    }

    private int getPartitionKeyIdx() {
        ConditionImpl cImpl = this.topLevelCondition;
        int nPartitionKeys = cImpl.getPartitionKeys().size();
        if (cImpl.getUseIdxFieldTill() < nPartitionKeys) {
            nPartitionKeys = cImpl.getUseIdxFieldTill();
        }
        String conditionFieldName = this.complexPathStr;
        for (int i = 0; i < nPartitionKeys; ++i) {
            IndexFieldDesc idesc = this.topLevelCondition.getPartitionKeys().get(i);
            Object partitionKeyComponentName = ((IndexFieldDescImpl)idesc).getFieldPathStr();
            if (idesc.isFunctional()) {
                partitionKeyComponentName = "$" + i;
            }
            if (!((String)partitionKeyComponentName).equals(conditionFieldName)) continue;
            return i;
        }
        return -1;
    }

    private boolean isOnPartitionKeyPrefix() {
        IndexFieldDesc idesc = this.topLevelCondition.getPartitionKeys().get(0);
        String firstPartitionKeyComponentName = ((IndexFieldDescImpl)idesc).getFieldPathStr();
        String conditionFieldName = this.field.toString();
        if (idesc.isFunctional()) {
            firstPartitionKeyComponentName = "$0";
        }
        return firstPartitionKeyComponentName.equals(conditionFieldName);
    }

    @Override
    List<List<ConditionNode.RowkeyRange>> getRowkeyRanges() {
        ConditionImpl topCond = this.topLevelCondition;
        if (topCond.hasRowKeyCondition() && !this.isOnRowKey()) {
            return FULL_TABLE_RANGE_LIST;
        }
        return this.calculateRowKeyRange();
    }

    private List<List<ConditionNode.RowkeyRange>> calculateRowKeyRange() {
        List<List<ConditionNode.RowkeyRange>> llrr = this.getLLRR();
        int idx = this.getPartitionKeyIdx();
        if (this.op == Dbfilters.CompareOpProto.NOT_EQUAL || this.value == null || this.cmpMode != Dbfilters.ComparatorModeProto.CMP_VALUE && this.cmpMode != Dbfilters.ComparatorModeProto.CMP_PATTERN || !this.isOnRowKey() && idx < 0) {
            return llrr;
        }
        ConditionImpl topCond = this.topLevelCondition;
        if (!this.isOnRowKey() && topCond.isSecondaryIndexQueryCondition()) {
            List<IndexFieldDesc> partitionKeys = topCond.getPartitionKeys();
            boolean[] descendingOrder = new boolean[partitionKeys.size()];
            for (int i = 0; i < partitionKeys.size(); ++i) {
                descendingOrder[i] = partitionKeys.get(i).getSortOrder() == IndexFieldDesc.Order.Desc;
            }
            boolean missingAndNullFirst = topCond.getMissingAndNullFirst();
            boolean isHashedIndex = topCond.isHashedIndexQueryCondition();
            int numHashPartitions = isHashedIndex ? topCond.getHashedIndexNumPartitions() : 0;
            IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
            encoder.init(topCond.getIndexVersion(), descendingOrder, missingAndNullFirst, isHashedIndex, numHashPartitions);
            if (this.op == Dbfilters.CompareOpProto.EQUAL && this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) {
                byte[] regexPrefix = Regexes.getRegexPrefix((String)this.value.getString()).getBytes();
                llrr.set(idx, regexPrefix.length == 0 ? FULL_TABLE_RANGE : encoder.getRowKeyRangeForPrefixMatch(regexPrefix, idx));
            } else {
                if (this.value.getType() == Value.Type.MAP) {
                    TreeMap resMap = new TreeMap();
                    ConditionLeaf.recursiveMapSort(this.value, resMap);
                    this.value = DBValueBuilderImpl.KeyValueBuilder.initFromObject(resMap);
                }
                if (this.value.getType() == Value.Type.ARRAY) {
                    ArrayList resList = new ArrayList();
                    ConditionLeaf.recursiveMapSort(this.value, resList);
                    this.value = DBValueBuilderImpl.KeyValueBuilder.initFromObject(resList);
                }
                llrr.set(idx, encoder.getRowKeyRange(this.op, this.value, idx));
            }
            return llrr;
        }
        llrr = new ArrayList<List<ConditionNode.RowkeyRange>>(1);
        llrr.add(FULL_TABLE_RANGE);
        byte[] startRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] fieldValue = null;
        if (this.complexPath.equals((Object)Constants.ROWKEY_FIELD_PATH)) {
            assert (this.value.getType() == Value.Type.BINARY);
            fieldValue = Bytes.getBytes((ByteBuffer)this.value.getBinary());
        } else {
            fieldValue = IdCodec.encodeAsBytes(this.value);
        }
        switch (this.op) {
            case GREATER_OR_EQUAL: {
                startRow = fieldValue;
                break;
            }
            case GREATER: {
                startRow = Bytes.appendZeroByte((byte[])fieldValue);
                break;
            }
            case LESS_OR_EQUAL: {
                stopRow = Bytes.appendZeroByte((byte[])fieldValue);
                break;
            }
            case LESS: {
                stopRow = fieldValue;
                break;
            }
            case EQUAL: {
                if (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) {
                    String prefix = Regexes.getRegexPrefix((String)this.value.getString());
                    if (prefix.length() <= 0 || (stopRow = Bytes.createStopKeyForPrefix((byte[])(startRow = Bytes.getBytes((ByteBuffer)IdCodec.encode(prefix))))).length <= startRow.length) break;
                    stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
                    break;
                }
                startRow = fieldValue;
                stopRow = Bytes.appendZeroByte((byte[])fieldValue);
            }
        }
        if (startRow != MapRConstants.EMPTY_BYTE_ARRAY || stopRow != MapRConstants.EMPTY_BYTE_ARRAY) {
            llrr.set(0, (List<ConditionNode.RowkeyRange>)ImmutableList.of((Object)new ConditionNode.RowkeyRange(startRow, stopRow)));
        }
        return llrr;
    }

    private static void recursiveMapSort(Object input, Object res) {
        if (((KeyValue)input).getType() != Value.Type.ARRAY && ((KeyValue)input).getType() != Value.Type.MAP) {
            return;
        }
        if (((KeyValue)input).getType() == Value.Type.MAP) {
            ((Map)res).putAll(((KeyValue)input).getMap());
            for (Map.Entry<String, Object> entry : ((KeyValue)input).getMap().entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                TreeMap child = new TreeMap();
                ((Map)res).put(entry.getKey(), child);
                ConditionLeaf.recursiveMapSort(entry.getValue(), child);
            }
        }
        if (((KeyValue)input).getType() == Value.Type.ARRAY) {
            ((List)res).addAll(((KeyValue)input).getList());
            for (int k = 0; k < ((KeyValue)input).getList().size(); ++k) {
                Cloneable sres = null;
                if (((KeyValue)input).getList().get(k) instanceof Map) {
                    sres = new TreeMap();
                } else if (((KeyValue)input).getList().get(k) instanceof List) {
                    sres = new ArrayList();
                }
                if (!(((KeyValue)input).getList().get(k) instanceof Map) && !(((KeyValue)input).getList().get(k) instanceof List)) continue;
                Object temp = ((KeyValue)input).getList().get(k);
                ((List)res).set(k, sres);
                ConditionLeaf.recursiveMapSort(temp, sres);
            }
        }
    }

    private String serializeBase64() {
        ConditionDescriptor condDesc = this.getDescriptor(Constants.DEFAULT_FAMILY_MAP, null);
        ByteBuffer condBuffer = condDesc.getSerialized();
        byte[] condBytes = new byte[condBuffer.limit() - condBuffer.position()];
        condBuffer.get(condBytes);
        String condString = base64UrlEncoder.encode(condBytes);
        return condString;
    }

    @Override
    void visit(ConditionVisitor visitor) {
        visitor.field(this.field, this.complexPath, false);
        block0 : switch (this.cmpMode) {
            case CMP_VALUE: {
                this.visitValue(visitor);
                Value.Type valueType = this.value == null ? Value.Type.NULL : this.value.getType();
                switch (valueType) {
                    case ARRAY: 
                    case MAP: {
                        if (this.op == Dbfilters.CompareOpProto.EQUAL) {
                            visitor.operator("equals", 2, (ConditionNode)this);
                            break block0;
                        }
                        visitor.operator("nequals", 2, (ConditionNode)this);
                        break block0;
                    }
                }
                visitor.operator((QueryCondition.Op)opProtoMapInverse.get((Object)this.op), 2, (ConditionNode)this);
                break;
            }
            case CMP_PATTERN: {
                visitor.stringLiteral(this.value.getString());
                visitor.operator(this.op == Dbfilters.CompareOpProto.EQUAL ? "matches" : "notMatches", 2, (ConditionNode)this);
                break;
            }
            case CMP_TYPE: {
                visitor.operator("typeOf", 1, (ConditionNode)this);
                this.visitValue(visitor);
                visitor.operator((QueryCondition.Op)opProtoMapInverse.get((Object)this.op), 2, (ConditionNode)this);
                break;
            }
            case CMP_SIZE: {
                visitor.operator("sizeOf", 1, (ConditionNode)this);
                this.visitValue(visitor);
                visitor.operator((QueryCondition.Op)opProtoMapInverse.get((Object)this.op), 2, (ConditionNode)this);
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized comparator mode for ConditionLeaf");
            }
        }
    }

    private void visitValue(ConditionVisitor visitor) {
        Value.Type valueType = this.value == null ? Value.Type.NULL : this.value.getType();
        switch (valueType) {
            case ARRAY: {
                visitor.arrayLiteral(this.value.getList());
                break;
            }
            case BINARY: {
                visitor.binaryLiteral(this.value.getBinary());
                break;
            }
            case BOOLEAN: {
                visitor.booleanLiteral(this.value.getBoolean());
                break;
            }
            case BYTE: {
                visitor.byteLiteral(this.value.getByte());
                break;
            }
            case DATE: {
                visitor.dateLiteral(this.value.getDate());
                break;
            }
            case DECIMAL: {
                visitor.decimalLiteral(this.value.getDecimal());
                break;
            }
            case DOUBLE: {
                visitor.doubleLiteral(this.value.getDouble());
                break;
            }
            case FLOAT: {
                visitor.floatLiteral(this.value.getFloat());
                break;
            }
            case INT: {
                visitor.intLiteral(this.value.getInt());
                break;
            }
            case INTERVAL: {
                visitor.intervalLiteral(this.value.getInterval());
                break;
            }
            case LONG: {
                visitor.longLiteral(this.value.getLong());
                break;
            }
            case MAP: {
                visitor.mapLiteral(this.value.getMap());
                break;
            }
            case NULL: {
                visitor.nullLiteral();
                break;
            }
            case SHORT: {
                visitor.shortLiteral(this.value.getShort());
                break;
            }
            case STRING: {
                visitor.stringLiteral(this.value.getString());
                break;
            }
            case TIME: {
                visitor.timeLiteral(this.value.getTime());
                break;
            }
            case TIMESTAMP: {
                visitor.timestampLiteral(this.value.getTimestamp());
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized value type " + this.value.getType());
            }
        }
    }

    @Override
    boolean hasRowKeyCondition() {
        return this.isOnRowKey();
    }

    private static int countDimensionsBack(String fieldStr, int postStart) {
        assert (postStart < fieldStr.length());
        int nDimension = 1;
        for (int strIdx = postStart - 2; strIdx >= 0 && fieldStr.charAt(strIdx) == '[' && fieldStr.charAt(strIdx + 1) == ']'; strIdx -= 2) {
            ++nDimension;
        }
        return nDimension;
    }

    private boolean isKeyField(MapRDBIndexImplWrapper idxWrapper) {
        if (idxWrapper == null) {
            return false;
        }
        MapRDBIndexImpl indexTable = idxWrapper.indexTable;
        List<IndexFieldDesc> keyList = indexTable.getIndexedFieldList();
        int pos = 0;
        for (IndexFieldDesc keyDesc : keyList) {
            String fieldPathStr = keyDesc.getFieldPath().toString();
            if (pos >= idxWrapper.useIdxFieldsTill) break;
            if (this.complexPathStr.startsWith(fieldPathStr)) {
                return true;
            }
            ++pos;
        }
        return false;
    }

    @Override
    public AefTransformer createAefTransformer(MapRDBIndexImplWrapper idxWrapper) {
        if (this.fieldStr.startsWith("$[]")) {
            throw new IllegalArgumentException("leaf path cannot start with $[]");
        }
        int nextBrackets = this.fieldStr.lastIndexOf("[]");
        for (String sub : this.fieldStr.split("\\.")) {
            int firstBrackets = sub.indexOf("[]");
            if (firstBrackets == -1 || !sub.substring(firstBrackets + 2).matches(".*\\[[0-9]+\\].*")) continue;
            throw new IllegalArgumentException("array path can only take specific array index as leading fields");
        }
        if (nextBrackets < 0 || this.getIndexPos(idxWrapper) != -1 || this.isKeyField(idxWrapper)) {
            return new AefTransformer(this);
        }
        int postStart = nextBrackets + 3;
        int postLength = this.fieldStr.length() - postStart;
        String leafField = postLength <= 0 ? "$" : this.fieldStr.substring(postStart);
        ConditionLeaf newLeaf = new ConditionLeaf(FieldPath.parseFrom((String)leafField), this.op, this.value, this.cmpMode, this, this.topLevelCondition);
        AefTransformer lastTransformer = new AefTransformer(newLeaf);
        while (true) {
            int nDimension = ConditionLeaf.countDimensionsBack(this.fieldStr, nextBrackets);
            for (int i = 1; i < nDimension; ++i) {
                lastTransformer = new AefTransformer(lastTransformer);
            }
            int arrayNameEnd = nextBrackets - (nDimension - 1) * 2;
            if ((nextBrackets = this.fieldStr.lastIndexOf("[]", arrayNameEnd - 1)) < 0) {
                String arrayName = this.fieldStr.substring(0, arrayNameEnd);
                lastTransformer = idxWrapper != null ? new AefTransformer(idxWrapper.indexTable.fieldPathToCFIdQual(arrayName), Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_ANY_ELEMENT, lastTransformer) : new AefTransformer(arrayName, Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_ANY_ELEMENT, lastTransformer);
                return lastTransformer;
            }
            postStart = nextBrackets + 3;
            String arrayPath = this.fieldStr.substring(postStart, arrayNameEnd);
            lastTransformer = new AefTransformer(arrayPath, Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_ANY_ELEMENT, lastTransformer);
            nextBrackets = this.fieldStr.lastIndexOf("[]", postStart);
        }
    }

    private void ensureClonedCondition() {
        if (this.clonedCondition == null) {
            this.clonedCondition = new ClonedCondition(this);
        }
    }

    @Override
    public boolean isCloneOf(ConditionNode conditionNode) {
        if (!(conditionNode instanceof ConditionLeaf)) {
            return false;
        }
        ConditionLeaf other = (ConditionLeaf)conditionNode;
        return other.clonedCondition == this.clonedCondition;
    }

    @Override
    void prepare(FieldPathStack fieldPathStack, CorrelationTracker correlationTracker) {
        this.complexPathStr = fieldPathStack.getPath(this.fieldStr);
        this.complexPath = FieldPath.parseFrom((String)this.complexPathStr);
        if (CorrelationTracker.isOpenArrayPath(this.complexPathStr)) {
            this.topLevelCondition.markArrayQuery();
            if (!correlationTracker.underCorrelation()) {
                this.ensureClonedCondition();
                correlationTracker.addKeyCondition(this.complexPathStr, this.clonedCondition);
            }
        }
    }

    public ClonedCondition getClonedCondition() {
        this.ensureClonedCondition();
        return this.clonedCondition;
    }

    @Override
    protected ConditionLeaf clone(ConditionImpl topLevelCondition, Boolean cloneLeafCondition) {
        ConditionLeaf newLeaf = (ConditionLeaf)super.clone();
        newLeaf.setTopLevelCondition(topLevelCondition);
        if (cloneLeafCondition.booleanValue()) {
            this.ensureClonedCondition();
            this.clonedCondition.add(newLeaf);
        }
        return newLeaf;
    }

    @Override
    public void elementAndScreen(ElementAndScreener elementAndScreener) {
        elementAndScreener.requireField(this.complexPathStr);
    }
}

