/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.ImmutableSet;
import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.AccessDeniedException;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.CommitContextHelper;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.FSTests;
import com.mapr.fs.jni.IndexSyncStateTracker;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.utils.ssh.RunCommand;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.json.Json;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestIndexTable
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestIndexTable.class);
    private static final String TABLE_NAME = "testtable-TestIndexTable";
    private static final String INDEX_NAME = "testindex-TestIndexTable";
    private static Table table;
    private static Collection<IndexDesc> tableIndexList;

    private IndexDesc createIndex(Table tab, String indexName, String indexedFields, String nonIndexedFields, boolean isHashed, int numHashPartitions) throws Exception {
        String indexCreateCommand = "maprcli table index add  -path " + tab.getPath() + " -index " + indexName + " -indexedfields " + indexedFields + (nonIndexedFields == null ? "" : " -includedfields " + nonIndexedFields) + (isHashed ? " -hashed true -numhashpartitions " + Integer.toString(numHashPartitions) : "");
        TestCluster.runCommand((String)indexCreateCommand);
        DBTests.waitForSchemaUpdate();
        tableIndexList = DBTests.admin().getTableIndexes(tab.getPath(), true);
        for (IndexDesc idx : tableIndexList) {
            if (!idx.getIndexName().equals(indexName)) continue;
            return idx;
        }
        return null;
    }

    private IndexDesc createIndex(Table tab, String indexName, String indexedFields, String nonIndexedFields) throws Exception {
        return this.createIndex(tab, indexName, indexedFields, nonIndexedFields, false, 0);
    }

    private IndexDesc getIndex(Table table, String indexName) throws DBException, IOException {
        Collection indexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        for (IndexDesc idx : indexList) {
            if (!idx.getIndexName().equals(indexName)) continue;
            return idx;
        }
        return null;
    }

    private void removeUnneededRow() {
        table.delete("user001");
        table.delete("user002");
        table.delete("user003");
        table.delete("user004");
        table.delete("user005");
        table.flush();
    }

    @Before
    public void startupBefore() throws Exception {
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        String[] splitKeys = new String[]{"user001", "user002", "user003", "user004", "user005"};
        table = DBTests.createOrReplaceTable(TABLE_NAME, cfMap, splitKeys);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        TestCluster.runCommand((String)("maprcli table index add -path " + table.getPath() + " -index " + INDEX_NAME + " -indexedfields name.last:1,name.first:ASC,salary:asc -includedfields age"));
        DBTests.waitForSchemaUpdate();
        tableIndexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\", \"age\":43, \"salary\":43000, \"name\": {\"first\":\"Sam\", \"last\":\"Harris\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user002\", \"age\":12, \"salary\":340000, \"name\": {\"first\":\"Leon\", \"last\":\"Russel\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user003\", \"age\":87, \"salary\":9999999, \"name\": {\"first\":\"David\", \"last\":\"Bowie\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user004\", \"age\":56, \"salary\":7, \"name\": {\"first\":\"Bob\", \"last\":\"Dylan\"}}"));
        table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user005\", \"age\":54, \"salary\":123, \"name\": {\"first\":\"David\", \"last\":\"Ackert\"}}"));
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
    }

    @After
    public void cleanupAfter() throws IOException, Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testOmniTypeNotEquals() throws IOException, Exception {
        String testTable = "testtable-testOmniTypeNotEquals";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1\",\"a\":1}"));
            t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"2\",\"a\":2.04}"));
            t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"3\",\"a\":\"three\"}"));
            t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"4\",\"a\":false}"));
            t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"5\",\"b\":true}"));
            t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"6\",\"c\":true}"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        ConditionImpl qc = MapRDBImpl.newCondition().is("a", QueryCondition.Op.NOT_EQUAL, 1).build();
        try (Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = i.find((QueryCondition)qc);){
            int count = 0;
            for (Document d : stream) {
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
    }

    @Test
    public void testOmniTypeArrayNotEquals() throws IOException, Exception {
        String testTable = "testtable-testOmniTypeNotEquals";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a.b[].c", "x");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1\",\"a\":1}"));
            t.insertOrReplace("2", MapRDB.newDocument().set("a", MapRDB.newDocument().set("b", 1)).set("x", "Eugene"));
            t.insertOrReplace("3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("b", MapRDB.newDocument().set("c", 1))).set("x", "Eugene"));
            t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"4\",\"c\":true}"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b[].c", QueryCondition.Op.NOT_EQUAL, 1).build();
        try (Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = i.find((QueryCondition)qc);){
            int count = 0;
            for (Document d : stream) {
                ++count;
            }
            Assert.assertEquals((long)3L, (long)count);
        }
    }

    @Test
    public void testSmokeComplexTypeWOBracket() throws IOException, Exception {
        String testTable = "testtable-testSmokeComplexTypeWOBracket";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a1", "Eugene")).set("b", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key2", MapRDB.newDocument().set("a", Arrays.asList("a2", "b2", "c2")).set("b", "Liu").set("c", "mapr2"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.insertOrReplace("key4", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a4", "Eugene4")).set("b", "Liu4"));
            t.insertOrReplace("key5", MapRDB.newDocument().set("a", "Eugene5").set("b", MapRDB.newDocument().set("a5", "Eugene5")).set("c", "mapr5"));
            t.insertOrReplace("key6", MapRDB.newDocument().set("a", "Eugene6").set("b", Arrays.asList("x6", "y6", "z6")).set("c", "mapr6"));
            t.insertOrReplace("key7", MapRDB.newDocument().set("b", MapRDB.newDocument().set("a7", "Eugene7")).set("c", "mapr7"));
            t.insertOrReplace("key8", MapRDB.newDocument().set("b", Arrays.asList("x8", "y8", "z8")).set("c", "mapr8"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        Document doc2 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = index.find();){
            HashSet<Document> docSet1 = new HashSet<Document>();
            HashSet<Document> docSet2 = new HashSet<Document>();
            HashSet<Document> docSet3 = new HashSet<Document>();
            HashSet<Document> docSet4 = new HashSet<Document>();
            HashSet<Document> docSet5 = new HashSet<Document>();
            HashSet<Document> docSet6 = new HashSet<Document>();
            HashSet<Document> docSet7 = new HashSet<Document>();
            HashSet<Document> docSet8 = new HashSet<Document>();
            for (Document doc2 : stream) {
                if (doc2.getIdString().equals("key1")) {
                    docSet1.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key2")) {
                    docSet2.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key3")) {
                    docSet3.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key4")) {
                    docSet4.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key5")) {
                    docSet5.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key6")) {
                    docSet6.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key7")) {
                    docSet7.add(doc2);
                    continue;
                }
                if (!doc2.getIdString().equals("key8")) continue;
                docSet8.add(doc2);
            }
            Assert.assertEquals((long)1L, (long)docSet1.size());
            Assert.assertEquals((long)1L, (long)docSet2.size());
            Assert.assertEquals((long)1L, (long)docSet3.size());
            Assert.assertEquals((long)1L, (long)docSet4.size());
            Assert.assertEquals((long)1L, (long)docSet5.size());
            Assert.assertEquals((long)1L, (long)docSet6.size());
            Assert.assertEquals((long)1L, (long)docSet7.size());
            Assert.assertEquals((long)1L, (long)docSet8.size());
            Assert.assertEquals(docSet1.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key1").set("a", MapRDB.newDocument().set("a1", "Eugene")).set("b", "Liu"));
            Assert.assertEquals(docSet2.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key2").set("a", Arrays.asList("a2", "b2", "c2")).set("b", "Liu"));
            Assert.assertEquals(docSet3.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key3").set("a", MapRDB.newDocument().set("a3", "Eugene3")));
            Assert.assertEquals(docSet4.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key4").set("a", MapRDB.newDocument().set("a4", "Eugene4")).set("b", "Liu4"));
            Assert.assertEquals(docSet5.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key5").set("a", "Eugene5").set("b", MapRDB.newDocument().set("a5", "Eugene5")));
            Assert.assertEquals(docSet6.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key6").set("a", "Eugene6").set("b", Arrays.asList("x6", "y6", "z6")));
            Assert.assertEquals(docSet7.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key7").set("b", MapRDB.newDocument().set("a7", "Eugene7")));
            Assert.assertEquals(docSet8.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key8").set("b", Arrays.asList("x8", "y8", "z8")));
        }
    }

    @Test
    public void testSmokeComplexTypeWBracket() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracket";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[]", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a1", "Eugene")).set("b", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key2", MapRDB.newDocument().set("a", Arrays.asList("a2", "b2", "c2")).set("b", "Liu").set("c", "mapr2"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.insertOrReplace("key4", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a4", "Eugene4")).set("b", "Liu4"));
            t.insertOrReplace("key5", MapRDB.newDocument().set("a", "Eugene5").set("b", MapRDB.newDocument().set("a5", "Eugene5")).set("c", "mapr5"));
            t.insertOrReplace("key6", MapRDB.newDocument().set("a", "Eugene6").set("b", Arrays.asList("x6", "y6", "z6")).set("c", "mapr6"));
            t.insertOrReplace("key7", MapRDB.newDocument().set("b", MapRDB.newDocument().set("a7", "Eugene7")).set("c", "mapr7"));
            t.insertOrReplace("key8", MapRDB.newDocument().set("b", Arrays.asList("x8", "y8", "z8")).set("c", "mapr8"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        Document doc2 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find();){
            HashSet<Document> docSet1 = new HashSet<Document>();
            HashSet<Document> docSet2 = new HashSet<Document>();
            HashSet<Document> docSet3 = new HashSet<Document>();
            HashSet<Document> docSet4 = new HashSet<Document>();
            HashSet<Document> docSet5 = new HashSet<Document>();
            HashSet<Document> docSet6 = new HashSet<Document>();
            HashSet<Document> docSet7 = new HashSet<Document>();
            HashSet<Document> docSet8 = new HashSet<Document>();
            for (Document doc2 : stream) {
                if (doc2.getIdString().equals("key1")) {
                    docSet1.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key2")) {
                    docSet2.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key3")) {
                    docSet3.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key4")) {
                    docSet4.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key5")) {
                    docSet5.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key6")) {
                    docSet6.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key7")) {
                    docSet7.add(doc2);
                    continue;
                }
                if (!doc2.getIdString().equals("key8")) continue;
                docSet8.add(doc2);
            }
            Assert.assertEquals((long)1L, (long)docSet1.size());
            Assert.assertEquals((long)3L, (long)docSet2.size());
            Assert.assertEquals((long)1L, (long)docSet3.size());
            Assert.assertEquals((long)1L, (long)docSet4.size());
            Assert.assertEquals((long)1L, (long)docSet5.size());
            Assert.assertEquals((long)1L, (long)docSet6.size());
            Assert.assertEquals((long)1L, (long)docSet7.size());
            Assert.assertEquals((long)1L, (long)docSet8.size());
            ArrayList<String> listOfMissing = new ArrayList<String>();
            listOfMissing.add("$JSONMISSINGVALUE");
            Assert.assertEquals(docSet1.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key1").set("$idx", Arrays.asList(MapRDB.newDocument().set("a1", "Eugene"))).set("b", "Liu"));
            Document docSet2Exp1 = MapRDB.newDocument().set("_id", "key2").set("$idx", Arrays.asList("a2")).set("b", "Liu");
            Document docSet2Exp2 = MapRDB.newDocument().set("_id", "key2").set("$idx", Arrays.asList("b2")).set("b", "Liu");
            Document docSet2Exp3 = MapRDB.newDocument().set("_id", "key2").set("$idx", Arrays.asList("c2")).set("b", "Liu");
            for (Document d : docSet2) {
                Assert.assertTrue((d.equals(docSet2Exp1) || d.equals(docSet2Exp2) || d.equals(docSet2Exp3) ? 1 : 0) != 0);
            }
            Assert.assertEquals(docSet3.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key3").set("$idx", Arrays.asList(MapRDB.newDocument().set("a3", "Eugene3"))));
            Assert.assertEquals(docSet4.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key4").set("$idx", Arrays.asList(MapRDB.newDocument().set("a4", "Eugene4"))).set("b", "Liu4"));
            Assert.assertEquals(docSet5.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key5").set("$idx", Arrays.asList("Eugene5")).set("b", MapRDB.newDocument().set("a5", "Eugene5")));
            Assert.assertEquals(docSet6.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key6").set("$idx", Arrays.asList("Eugene6")).set("b", Arrays.asList("x6", "y6", "z6")));
            Assert.assertEquals(docSet7.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key7").set("$idx", listOfMissing).set("b", MapRDB.newDocument().set("a7", "Eugene7")));
            Assert.assertEquals(docSet8.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key8").set("$idx", listOfMissing).set("b", Arrays.asList("x8", "y8", "z8")));
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketCond() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketCond";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[]", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a1", "Eugene")).set("b", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key2", MapRDB.newDocument().set("a", Arrays.asList("a2", "b2", "c2")).set("b", "Liu").set("c", "mapr2"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.insertOrReplace("key4", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a4", "Eugene4")).set("b", "Liu4"));
            t.insertOrReplace("key5", MapRDB.newDocument().set("a", "Eugene5").set("b", MapRDB.newDocument().set("a5", "Eugene5")).set("c", "mapr5"));
            t.insertOrReplace("key6", MapRDB.newDocument().set("a", "Eugene6").set("b", Arrays.asList("x6", "y6", "z6")).set("c", "mapr6"));
            t.insertOrReplace("key7", MapRDB.newDocument().set("b", MapRDB.newDocument().set("a7", "Eugene7")).set("c", "mapr7"));
            t.insertOrReplace("key8", MapRDB.newDocument().set("b", Arrays.asList("x8", "y8", "z8")).set("c", "mapr8"));
            t.insertOrReplace("key9", MapRDB.newDocument().set("a", "b2"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        Document doc2 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().is("a[]", QueryCondition.Op.EQUAL, "b2").build());){
            HashSet<Document> docSet1 = new HashSet<Document>();
            HashSet<Document> docSet2 = new HashSet<Document>();
            HashSet<Document> docSet3 = new HashSet<Document>();
            HashSet<Document> docSet4 = new HashSet<Document>();
            HashSet<Document> docSet5 = new HashSet<Document>();
            HashSet<Document> docSet6 = new HashSet<Document>();
            HashSet<Document> docSet7 = new HashSet<Document>();
            HashSet<Document> docSet8 = new HashSet<Document>();
            HashSet<Document> docSet9 = new HashSet<Document>();
            for (Document doc2 : stream) {
                if (doc2.getIdString().equals("key1")) {
                    docSet1.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key2")) {
                    docSet2.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key3")) {
                    docSet3.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key4")) {
                    docSet4.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key5")) {
                    docSet5.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key6")) {
                    docSet6.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key7")) {
                    docSet7.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key8")) {
                    docSet8.add(doc2);
                    continue;
                }
                if (!doc2.getIdString().equals("key9")) continue;
                docSet9.add(doc2);
            }
            Assert.assertEquals((long)0L, (long)docSet1.size());
            Assert.assertEquals((long)1L, (long)docSet2.size());
            Assert.assertEquals((long)0L, (long)docSet3.size());
            Assert.assertEquals((long)0L, (long)docSet4.size());
            Assert.assertEquals((long)0L, (long)docSet5.size());
            Assert.assertEquals((long)0L, (long)docSet6.size());
            Assert.assertEquals((long)0L, (long)docSet7.size());
            Assert.assertEquals((long)0L, (long)docSet8.size());
            Assert.assertEquals((long)1L, (long)docSet9.size());
            Assert.assertEquals(docSet2.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key2").set("$idx", Arrays.asList("b2")).set("b", "Liu"));
            Assert.assertEquals(docSet9.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key9").set("$idx", Arrays.asList("b2")));
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketDotCond() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketCond";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].qqq", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", "Eugene")).set("b", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().is("a[].qqq", QueryCondition.Op.EQUAL, "Eugene").build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeListEquals() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeListEquals";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].qqq", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", Arrays.asList("eugene"))).set("b", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().equals("a[].qqq", Arrays.asList("eugene")).build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeMapEquals() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeMapEquals";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].qqq", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", MapRDB.newDocument().set("liu", MapRDB.newDocument().set("blake", "ave").set("mapr", "eugene"))).set("b", "Liu").set("c", "mapr1")));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().equals("a[].qqq", (Map)MapRDB.newDocument().set("liu", MapRDB.newDocument().set("mapr", "eugene").set("blake", "ave"))).build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketDotCondElementAnd() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketCond";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].qqq", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", "Eugene")).set("xxx", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().and().is("a[].qqq", QueryCondition.Op.EQUAL, "Eugene").close().build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketNestElementAnd() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketNestElementAnd";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].qqq,a[].zzz[]", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", "Eugene").set("zzz", "gene")).set("xxx", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().and().is("a[].qqq", QueryCondition.Op.EQUAL, "Eugene").and().is("a[].zzz[]", QueryCondition.Op.EQUAL, "gene").close().close().build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketOrUnderElementAnd() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketOrUnderElementAnd";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].qqq,a[].zzz", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", "Eugene").set("zzz", "gene")).set("xxx", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().and().is("a[].qqq", QueryCondition.Op.EQUAL, "Eugene").or().is("a[].zzz", QueryCondition.Op.EQUAL, "gene").close().close().build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketAndUnderElementAnd() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketAndUnderElementAnd";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].qqq,a[].zzz", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", "Eugene").set("zzz", "gene")).set("xxx", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().and().is("a[].qqq", QueryCondition.Op.EQUAL, "Eugene1").and().or().is("a[].zzz", QueryCondition.Op.EQUAL, "gene").is("a[].zzz", QueryCondition.Op.EQUAL, "gene1").close().close().close().build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketMultiDimensionElementAnd() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketMultiDimensionElementAnd";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "xxx[][]", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", "Eugene")).set("xxx", Arrays.asList(Arrays.asList("eugene"))).set("c", "mapr1"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().and().is("xxx[][]", QueryCondition.Op.EQUAL, "eugene").close().build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Ignore(value="Enable after MAPRDB-845 is fixed")
    @Test
    public void testSmokeComplexTypeCompositeWBracketDotCondElementAnd() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketCond";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].b,a[].c", null);
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", Arrays.asList(MapRDB.newDocument().set("b", "ab1").set("c", "ac1"), MapRDB.newDocument().set("b", "ab2").set("c", "ac2"))).set("xxx", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key2", MapRDB.newDocument().set("a", MapRDB.newDocument().set("b", "ab2").set("c", "ac2")).set("c", "mapr3"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().and().is("a[].b", QueryCondition.Op.EQUAL, "ab2").is("a[].c", QueryCondition.Op.EQUAL, "ac2").close().build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertTrue((id.compareTo("key1") == 0 || id.compareTo("key2") == 0 ? 1 : 0) != 0);
                ++count;
            }
            Assert.assertEquals((long)2L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Ignore
    @Test
    public void testSmokeComplexTypeCompositeBracketAndScalar() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketCond";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].b,a.c", null);
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", Arrays.asList(MapRDB.newDocument().set("b", "ab1").set("c", "ac1"), MapRDB.newDocument().set("b", "ab2").set("c", "ac2"))).set("xxx", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key2", MapRDB.newDocument().set("a", MapRDB.newDocument().set("b", "ab2").set("c", "ac2")).set("c", "mapr3"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find();){
            int count = 0;
            for (Document doc : stream) {
                if (doc.getIdString().equals("key1")) {
                    Assert.assertTrue((doc.equals(MapRDB.newDocument().set("_id", "key1").set("$idx", Arrays.asList(new String("ab1"), "$JSONMISSINGVALUE"))) || doc.equals(MapRDB.newDocument().set("_id", "key1").set("$idx", Arrays.asList(new String("ab2"), "$JSONMISSINGVALUE"))) ? 1 : 0) != 0);
                } else if (doc.getIdString().equals("key2")) {
                    Assert.assertEquals((Object)doc, (Object)MapRDB.newDocument().set("_id", "key2").set("a", MapRDB.newDocument().set("c", "ac2")).set("$idx", Arrays.asList(new String("ab2"), new String("ac2"))));
                } else {
                    Assert.assertEquals((Object)doc, (Object)MapRDB.newDocument().set("_id", "key3").set("$idx", Arrays.asList("$JSONMISSINGVALUE", "$JSONMISSINGVALUE")));
                }
                ++count;
            }
            Assert.assertEquals((long)4L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketDotCondAnd() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketCond";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].qqq", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("qqq", "Eugene")).set("xxx", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().and().is("a[].qqq", QueryCondition.Op.EQUAL, "Eugene").close().build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSmokeComplexTypeWBracketComposite() throws Exception {
        String testTable = "testtable-testSmokeComplexTypeWBracketComposite";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[],b", "c");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a1", "Eugene")).set("b", "Liu").set("c", "mapr1"));
            t.insertOrReplace("key2", MapRDB.newDocument().set("a", Arrays.asList("a2", "b2", "c2")).set("b", "Liu").set("c", "mapr2"));
            t.insertOrReplace("key3", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.insertOrReplace("key4", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a4", "Eugene4")).set("b", "Liu4"));
            t.insertOrReplace("key5", MapRDB.newDocument().set("a", "Eugene5").set("b", MapRDB.newDocument().set("a5", "Eugene5")).set("c", "mapr5"));
            t.insertOrReplace("key6", MapRDB.newDocument().set("a", "Eugene6").set("b", Arrays.asList("x6", "y6", "z6")).set("c", "mapr6"));
            t.insertOrReplace("key7", MapRDB.newDocument().set("b", MapRDB.newDocument().set("a7", "Eugene7")).set("c", "mapr7"));
            t.insertOrReplace("key8", MapRDB.newDocument().set("b", Arrays.asList("x8", "y8", "z8")).set("c", "mapr8"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        Document doc2 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find();){
            HashSet<Document> docSet1 = new HashSet<Document>();
            HashSet<Document> docSet2 = new HashSet<Document>();
            HashSet<Document> docSet3 = new HashSet<Document>();
            HashSet<Document> docSet4 = new HashSet<Document>();
            HashSet<Document> docSet5 = new HashSet<Document>();
            HashSet<Document> docSet6 = new HashSet<Document>();
            HashSet<Document> docSet7 = new HashSet<Document>();
            HashSet<Document> docSet8 = new HashSet<Document>();
            for (Document doc2 : stream) {
                if (doc2.getIdString().equals("key1")) {
                    docSet1.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key2")) {
                    docSet2.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key3")) {
                    docSet3.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key4")) {
                    docSet4.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key5")) {
                    docSet5.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key6")) {
                    docSet6.add(doc2);
                    continue;
                }
                if (doc2.getIdString().equals("key7")) {
                    docSet7.add(doc2);
                    continue;
                }
                if (!doc2.getIdString().equals("key8")) continue;
                docSet8.add(doc2);
            }
            Assert.assertEquals((long)1L, (long)docSet1.size());
            Assert.assertEquals((long)3L, (long)docSet2.size());
            Assert.assertEquals((long)1L, (long)docSet3.size());
            Assert.assertEquals((long)1L, (long)docSet4.size());
            Assert.assertEquals((long)1L, (long)docSet5.size());
            Assert.assertEquals((long)1L, (long)docSet6.size());
            Assert.assertEquals((long)1L, (long)docSet7.size());
            Assert.assertEquals((long)1L, (long)docSet8.size());
            Assert.assertEquals(docSet1.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key1").set("$idx", Arrays.asList(MapRDB.newDocument().set("a1", "Eugene"), "Liu")).set("b", "Liu").set("c", "mapr1"));
            Document docSet2Exp1 = MapRDB.newDocument().set("_id", "key2").set("$idx", Arrays.asList("a2", "Liu")).set("b", "Liu").set("c", "mapr2");
            Document docSet2Exp2 = MapRDB.newDocument().set("_id", "key2").set("$idx", Arrays.asList("b2", "Liu")).set("b", "Liu").set("c", "mapr2");
            Document docSet2Exp3 = MapRDB.newDocument().set("_id", "key2").set("$idx", Arrays.asList("c2", "Liu")).set("b", "Liu").set("c", "mapr2");
            for (Document d : docSet2) {
                Assert.assertTrue((d.equals(docSet2Exp1) || d.equals(docSet2Exp2) || d.equals(docSet2Exp3) ? 1 : 0) != 0);
            }
            Assert.assertEquals(docSet3.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key3").set("$idx", Arrays.asList(MapRDB.newDocument().set("a3", "Eugene3"), "$JSONMISSINGVALUE")).set("c", "mapr3"));
            Assert.assertEquals(docSet4.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key4").set("$idx", Arrays.asList(MapRDB.newDocument().set("a4", "Eugene4"), "Liu4")).set("b", "Liu4"));
            Assert.assertEquals(docSet5.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key5").set("$idx", Arrays.asList("Eugene5", MapRDB.newDocument().set("a5", "Eugene5"))).set("b", MapRDB.newDocument().set("a5", "Eugene5")).set("c", "mapr5"));
            Assert.assertEquals(docSet6.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key6").set("$idx", Arrays.asList("Eugene6", Arrays.asList("x6", "y6", "z6"))).set("b", Arrays.asList("x6", "y6", "z6")).set("c", "mapr6"));
            Assert.assertEquals(docSet7.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key7").set("$idx", Arrays.asList("$JSONMISSINGVALUE", MapRDB.newDocument().set("a7", "Eugene7"))).set("b", MapRDB.newDocument().set("a7", "Eugene7")).set("c", "mapr7"));
            Assert.assertEquals(docSet8.iterator().next(), (Object)MapRDB.newDocument().set("_id", "key8").set("$idx", Arrays.asList("$JSONMISSINGVALUE", Arrays.asList("x8", "y8", "z8"))).set("b", Arrays.asList("x8", "y8", "z8")).set("c", "mapr8"));
        }
    }

    private void testBug28312_checkIndexDataConsitency_Float(Path tablePath, String field, float f) throws IOException, Exception {
        Iterator idxItr = DBTests.admin().getTableIndexes(tablePath, true).iterator();
        int indexes = 0;
        while (idxItr.hasNext()) {
            IndexDesc indexTableDesc = (IndexDesc)idxItr.next();
            ++indexes;
            Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
            Iterator dsItr = i.find().iterator();
            int docs = 0;
            while (dsItr.hasNext()) {
                ++docs;
                Document doc = (Document)dsItr.next();
                float flt = doc.getFloat(field);
                Assert.assertTrue((f == flt ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)1L, (long)docs);
        }
        Assert.assertEquals((long)1L, (long)indexes);
    }

    private void testBug28312_Float() throws IOException, Exception {
        String testTable = "testBug28312";
        String docId = "user0";
        String indexedField = "abc";
        Table t = DBTests.createOrReplaceTable(testTable);
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        Path tablePath = t.getPath();
        t.insertOrReplace(docId, MapRDBImpl.newDocument().set(indexedField, Float.MAX_VALUE));
        Document doc0 = t.findById(docId);
        float flt0 = doc0.getFloat(indexedField);
        this.createIndex(t, "i1", indexedField, null);
        DBTests.waitForIndexFlush(tablePath);
        this.testBug28312_checkIndexDataConsitency_Float(tablePath, indexedField, flt0);
        DocumentMutation mut = MapRDB.newMutation();
        mut.increment(indexedField, Float.valueOf(Float.MAX_VALUE).floatValue());
        t.update(docId, mut);
        DBTests.waitForIndexFlush(tablePath);
        Document doc1 = t.findById(docId);
        float flt1 = doc1.getFloat(indexedField);
        this.testBug28312_checkIndexDataConsitency_Float(tablePath, indexedField, flt1);
        t.close();
    }

    private void testBug28312_checkIndexDataConsitency_Double(Path tablePath, String field, double d) throws IOException, Exception {
        Iterator idxItr = DBTests.admin().getTableIndexes(tablePath, true).iterator();
        int indexes = 0;
        while (idxItr.hasNext()) {
            IndexDesc indexTableDesc = (IndexDesc)idxItr.next();
            ++indexes;
            Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
            Iterator dsItr = i.find().iterator();
            int docs = 0;
            while (dsItr.hasNext()) {
                ++docs;
                Document doc = (Document)dsItr.next();
                double dbl = doc.getDouble(field);
                Assert.assertTrue((d == dbl ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)1L, (long)docs);
        }
        Assert.assertEquals((long)1L, (long)indexes);
    }

    private void testBug28312_Double() throws IOException, Exception {
        String testTable = "testBug28312";
        String docId = "user0";
        String indexedField = "abc";
        Table t = DBTests.createOrReplaceTable(testTable);
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        Path tablePath = t.getPath();
        t.insertOrReplace(docId, MapRDBImpl.newDocument().set(indexedField, Double.MAX_VALUE));
        Document doc0 = t.findById(docId);
        double dbl0 = doc0.getDouble(indexedField);
        this.createIndex(t, "i1", indexedField, null);
        DBTests.waitForIndexFlush(tablePath);
        this.testBug28312_checkIndexDataConsitency_Double(tablePath, indexedField, dbl0);
        DocumentMutation mut = MapRDB.newMutation();
        mut.increment(indexedField, Double.valueOf(Double.MAX_VALUE).doubleValue());
        t.update(docId, mut);
        DBTests.waitForIndexFlush(tablePath);
        Document doc1 = t.findById(docId);
        double dbl1 = doc1.getDouble(indexedField);
        this.testBug28312_checkIndexDataConsitency_Double(tablePath, indexedField, dbl1);
        t.close();
    }

    @Test
    public void testBug28312() throws IOException, Exception {
        this.testBug28312_Float();
        this.testBug28312_Double();
    }

    @Test
    public void testBug29167() throws IOException, Exception {
        int i;
        String testTable = "testBug29167";
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a");
        cfMap.put("cf2", "b");
        cfMap.put("cf3", "c");
        Table t = DBTests.createOrReplaceTable(testTable, cfMap);
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        for (i = 0; i < 1; ++i) {
            t.insertOrReplace(MapRDBImpl.newDocument((String)("{\"_id\":\"user" + i + "\", \"a\":{\"inta\":11},\"b\":{\"intb\":12},\"c\":{\"intc\":13}}")));
        }
        t.close();
        this.createIndex(t, "i1", "a.inta,b.intb,c.intc", null);
        t = DBTests.getTable(testTable);
        for (i = 0; i < 1; ++i) {
            t.insertOrReplace(MapRDBImpl.newDocument((String)("{\"_id\":\"user" + i + "\", \"a\":{\"inta\":21}}")));
        }
        for (i = 0; i < 1; ++i) {
            t.insertOrReplace(MapRDBImpl.newDocument((String)("{\"_id\":\"user" + i + "\", \"c\":{\"intc\":23}}")));
        }
        DBTests.waitForIndexFlush(t.getPath());
        for (IndexDesc indexTableDesc : DBTests.admin().getTableIndexes(t.getPath(), true)) {
            Table i2 = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
            Iterator dsItr = i2.find().iterator();
            int docs = 0;
            while (dsItr.hasNext()) {
                ++docs;
                Document document = (Document)dsItr.next();
            }
            Assert.assertEquals((long)1L, (long)docs);
        }
    }

    @Test
    public void testRyowAPIs() throws IOException, Exception {
        String testTable = "testtable-testRyowAPIs";
        Table t = DBTests.createOrReplaceTable(testTable);
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        t.close();
        this.createIndex(t, "i1", "a", null);
        t = DBTests.getTable(testTable);
        MapRDBTableImpl tI = (MapRDBTableImpl)t;
        tI.beginTrackingWrites();
        try {
            tI.beginTrackingWrites();
            Assert.fail((String)"beginTrackingWrites() should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\", \"age\":43, \"salary\":43000, \"a\":1}"));
        String ctx1 = tI.endTrackingWrites();
        try {
            tI.endTrackingWrites();
            Assert.fail((String)"endTrackingWrites() should have thrown exception");
        }
        catch (DBException dBException) {
            // empty catch block
        }
        tI.beginTrackingWrites(ctx1);
        int numRows = 5000;
        for (int i = 2; i <= numRows; ++i) {
            t.insertOrReplace(MapRDBImpl.newDocument((String)("{\"_id\":\"user00" + i + "\", \"age\":43, \"salary\":43000, \"a\":" + i + "}")));
        }
        String ctx2 = tI.endTrackingWrites();
        Path path = t.getPath();
        IndexSyncStateTracker trkr = tI.createIndexSyncStateTracker(CommitContextHelper.DecodeCommitContext((String)ctx2));
        int totalWaitTime = 0;
        while (totalWaitTime < 60000 && !trkr.haveIndexesSynced()) {
            long waitMs = trkr.getEstimatedWaitMs() > 5000L ? 5000L : trkr.getEstimatedWaitMs();
            Thread.sleep(waitMs);
            totalWaitTime = (int)((long)totalWaitTime + waitMs);
        }
        if (!trkr.haveIndexesSynced()) {
            Assert.fail((String)("Indexes not synced after " + totalWaitTime / 1000 + " secs"));
        }
        t.close();
        IndexDesc indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(path, true).iterator().next();
        Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        Iterator dsItr = i.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            ++docs;
            dsItr.next();
        }
        Assert.assertEquals((long)numRows, (long)docs);
    }

    @Test
    public void testScanHang() throws IOException, Exception {
        Table t = DBTests.createOrReplaceTable("testtable-testScanHang");
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        TestCluster.runCommand((String)("maprcli table index add -path " + t.getPath() + " -index i1 -indexedfields a"));
        int numRows = 0;
        for (int i = 0; i < numRows; ++i) {
            t.insertOrReplace(MapRDBImpl.newDocument((String)("{\"_id\":\"user00" + i + "\", \"age\":43, \"salary\":43000, \"a\":" + i + "}")));
        }
        t.flush();
        DBTests.waitForIndexFlush(t.getPath());
        IndexDesc indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        Iterator dsItr = i.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            ++docs;
            dsItr.next();
        }
        Assert.assertEquals((long)numRows, (long)docs);
    }

    @Test
    public void testConditionSortOnMap() throws Exception {
        String testTable = "testtable-testConditionSortOnMap";
        try (Table t = DBTests.createOrReplaceTable(testTable);){
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            this.createIndex(t, "i1", "a[].cc", "b");
        }
        IndexDesc indexTableDesc = null;
        try (Table t = DBTests.getTable(testTable);){
            t.insertOrReplace("key1", MapRDB.newDocument().set("a", MapRDB.newDocument().set("cc", MapRDB.newDocument().set("liu", MapRDB.newDocument().set("blake", "ave").set("mapr", "eugene"))).set("b", "Liu").set("c", "mapr1")));
            t.insertOrReplace("key2", MapRDB.newDocument().set("a", MapRDB.newDocument().set("a3", "Eugene3")).set("c", "mapr3"));
            t.flush();
            DBTests.waitForIndexFlush(t.getPath());
            indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        }
        var4_6 = null;
        try (Table index = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = ((MapRDBIndexImpl)index).setDecodeIndexValues(true).find((QueryCondition)MapRDBImpl.newCondition().equals("a[].cc", (Map)MapRDB.newDocument().set("liu", MapRDB.newDocument().set("mapr", "eugene").set("blake", "ave"))).build());){
            int count = 0;
            for (Document doc : stream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)id, (Object)"key1");
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testMutation() throws IOException, Exception {
        Table t = DBTests.createOrReplaceTable("testtable-testMutation");
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        TestCluster.runCommand((String)("maprcli table index add -path " + t.getPath() + " -index i1 -indexedfields a -includedfields b"));
        int numRows = 4;
        t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\",\"a\":25,\"b\":20}"));
        t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user002\",\"a\":15}"));
        t.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user003\",\"b\":20}"));
        t.flush();
        t.update("user001", MapRDBImpl.newMutation().decrement("a", 20).decrement("b", 1));
        t.update("user002", MapRDBImpl.newMutation().decrement("a", 5));
        t.update("user003", MapRDBImpl.newMutation().decrement("b", 1));
        t.update("user004", MapRDBImpl.newMutation().increment("a", 20).decrement("b", 1));
        t.flush();
        DBTests.waitForIndexFlush(t.getPath(), 120000L);
        IndexDesc indexTableDesc = (IndexDesc)DBTests.admin().getTableIndexes(t.getPath(), true).iterator().next();
        Table i = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        Iterator dsItr = i.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            dsItr.next();
            ++docs;
        }
        Assert.assertEquals((long)numRows, (long)docs);
    }

    @Test
    public void testSimpleScan() throws IOException {
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = indexTable.find();){
            Iterator itr = stream.iterator();
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Ackert", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"David", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)123L, (long)doc.getInt("salary"));
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Bowie", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"David", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)9999999L, (long)doc.getInt("salary"));
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Dylan", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"Bob", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)7L, (long)doc.getInt("salary"));
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Harris", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"Sam", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)43000L, (long)doc.getInt("salary"));
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
            Assert.assertEquals((Object)"Russel", (Object)doc.getString("name.last"));
            Assert.assertEquals((Object)"Leon", (Object)doc.getString("name.first"));
            Assert.assertEquals((long)340000L, (long)doc.getInt("salary"));
            Assert.assertFalse((boolean)itr.hasNext());
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=26999")
    @Test
    public void testScanCFAces() throws IOException, InterruptedException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyTraverseData, "u:mapr");
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyReadData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyReadData, "u:root");
        Thread.sleep(200000L);
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27406")
    @Test
    public void testScanCFAcesNoTraverse() throws IOException, InterruptedException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyReadData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyReadData, "u:root");
        Thread.sleep(200000L);
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Test
    public void testScanCFAcesOnlyTraverse() throws IOException {
        DBTests.setCFAce(DBTests.getTablePath(TABLE_NAME), "default", Dbserver.DBAccessType.FamilyTraverseData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = indexTable.find();){
            Iterator itr = stream.iterator();
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
            Assert.assertFalse((boolean)itr.hasNext());
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27408")
    @Test
    public void testScanCFAcesParentTraverse() throws IOException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name", Dbserver.DBAccessType.ColumnReadData, "u:mapr");
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name", Dbserver.DBAccessType.ColumnTraverseData, "u:mapr");
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.last", Dbserver.DBAccessType.ColumnReadData, "u:root");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name", Dbserver.DBAccessType.ColumnTraverseData, "u:root");
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27409")
    @Test
    public void testScanCFAcesLeafRead() throws IOException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first", Dbserver.DBAccessType.ColumnReadData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first", Dbserver.DBAccessType.ColumnReadData, "u:root");
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Test
    public void testScanCFAcesColTraverse() throws IOException {
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "age", Dbserver.DBAccessType.ColumnTraverseData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
             DocumentStream stream = indexTable.find();){
            Iterator itr = stream.iterator();
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
            doc = (Document)itr.next();
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
            Assert.assertFalse((boolean)itr.hasNext());
        }
    }

    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27407")
    @Test
    public void testScanCFShortPath() throws IOException {
        Iterator itr2;
        Throwable throwable;
        DocumentStream stream;
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first.init.a", Dbserver.DBAccessType.ColumnReadData, "u:mapr");
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        try (Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);){
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                try {
                    ((Document)itr2.next()).getIdString();
                    Assert.assertNotNull(null);
                }
                catch (AccessDeniedException e) {
                    _logger.debug("index scan failed with an exception: " + e.getMessage());
                }
            }
            catch (Throwable itr2) {
                throwable = itr2;
                throw itr2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable itr2) {
                            throwable.addSuppressed(itr2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        DBTests.setFieldAce(DBTests.getTablePath(TABLE_NAME), "default", "name.first.init.a", Dbserver.DBAccessType.ColumnReadData, "u:root");
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        var4_4 = null;
        try {
            stream = indexTable.find();
            throwable = null;
            try {
                itr2 = stream.iterator();
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user005", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user003", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user004", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user001", (Object)doc.getIdString());
                doc = (Document)itr2.next();
                Assert.assertNotNull((Object)doc);
                Assert.assertEquals((Object)"user002", (Object)doc.getIdString());
                Assert.assertFalse((boolean)itr2.hasNext());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (indexTable != null) {
                if (var4_4 != null) {
                    try {
                        indexTable.close();
                    }
                    catch (Throwable throwable5) {
                        var4_4.addSuppressed(throwable5);
                    }
                } else {
                    indexTable.close();
                }
            }
        }
    }

    @Test
    public void testInitialIndexSync() throws Exception {
        this.removeUnneededRow();
        String i1 = "TestIndexTable-testInitialIndexSync-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = null;
        Document doc = MapRDBImpl.newDocument();
        doc.set("a.b.c", "abc").set("a.c.d", "acd");
        int count = 10;
        int maxkey = count << 1;
        while (count < maxkey) {
            String key = "key" + Integer.toString(count++);
            table.insert(key, doc);
        }
        table.flush();
        i1Desc = this.createIndex(table, i1, "a.b.c", "a.c.d");
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = indexTable.find();
        Iterator itr = ds.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        count = 10;
        while (itr.hasNext()) {
            Document d = (Document)itr.next();
            Assert.assertEquals((Object)("key" + Integer.toString(count++)), (Object)d.getIdString());
            Assert.assertEquals((Object)"abc", (Object)doc.getString("a.b.c"));
            Assert.assertEquals((Object)"acd", (Object)doc.getString("a.c.d"));
        }
    }

    @Test
    public void testInitialIndexSyncWithDates() throws Exception {
        this.removeUnneededRow();
        String i1 = "TestIndexTable-testInitialIndexSyncWithDates-" + Long.toString(System.currentTimeMillis());
        ODate date0 = ODate.parse((String)"2012-02-02");
        ODate date1 = ODate.parse((String)"2012-02-03");
        OTimestamp ts0 = OTimestamp.parse((String)"2012-02-03T10:00:00.000Z");
        OTimestamp ts1 = OTimestamp.parse((String)"2012-02-03T09:00:00.000Z");
        OTimestamp ts2 = OTimestamp.parse((String)"2012-02-01T19:00:00.000Z");
        int i = 0;
        int count = 5;
        Document[] doc = new Document[5];
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", date0).set("a.c.d", "acd");
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", date1).set("a.c.d", "acd");
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", ts0).set("a.c.d", "acd");
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", ts1).set("a.c.d", "acd");
        doc[i++] = MapRDBImpl.newDocument().set("a.b.c", ts2).set("a.c.d", "acd");
        for (i = 0; i < 5; ++i) {
            table.insert("key" + Integer.toString(i), doc[i]);
        }
        table.flush();
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c", "a.c.d");
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = indexTable.find();
        Iterator itr = ds.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        Document d = (Document)itr.next();
        Assert.assertEquals((long)date0.compareTo(d.getDate("a.b.c")), (long)0L);
        Assert.assertTrue((boolean)itr.hasNext());
        d = (Document)itr.next();
        Assert.assertEquals((long)date1.compareTo(d.getDate("a.b.c")), (long)0L);
        Assert.assertTrue((boolean)itr.hasNext());
        d = (Document)itr.next();
        Assert.assertEquals((long)ts2.compareTo(d.getTimestamp("a.b.c")), (long)0L);
        Assert.assertTrue((boolean)itr.hasNext());
        d = (Document)itr.next();
        Assert.assertEquals((long)ts1.compareTo(d.getTimestamp("a.b.c")), (long)0L);
        Assert.assertTrue((boolean)itr.hasNext());
        d = (Document)itr.next();
        Assert.assertEquals((long)ts0.compareTo(d.getTimestamp("a.b.c")), (long)0L);
    }

    @Test
    public void testUpdatesWithNoIndexImpact() throws Exception {
        String i1 = "TestIndexTable-testUpdatesWithNoIndexImpact-" + Long.toString(System.currentTimeMillis());
        this.removeUnneededRow();
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("b.c.d", "bcd").setOrReplace("a.d.e", "ace").setOrReplace("y.x.y", "yxy");
        int count = 10;
        int maxkey = count << 1;
        int rows = 0;
        while (count < maxkey) {
            String key = "key" + Integer.toString(count++);
            table.update(key, mut);
            ++rows;
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = indexTable.find();
        int rc = 0;
        for (Document d : ds) {
            ++rc;
            Assert.assertEquals((long)1L, (long)d.size());
        }
        Assert.assertEquals((long)rows, (long)rc);
    }

    @Test
    public void testConditionFilterString() throws Exception {
        Document doc = null;
        IndexDesc indexTableDesc = tableIndexList.iterator().next();
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("name.last", QueryCondition.Op.EQUAL, "Harris").build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("name.last", QueryCondition.Op.EQUAL, "Eugene").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add("Sam");
        blockList.add("Fisher");
        blockList.add("Harris");
        qc = MapRDBImpl.newCondition().in("name.last", blockList).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        blockList.remove(2);
        qc = MapRDBImpl.newCondition().in("name.last", blockList).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("name.last", QueryCondition.Op.EQUAL, "Harris").is("name.first", QueryCondition.Op.EQUAL, "Sam").close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("name.last", QueryCondition.Op.EQUAL, "Liu").is("name.first", QueryCondition.Op.EQUAL, "Eugene").close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterNoBinaryComparator() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        this.removeUnneededRow();
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c:desc,p.q", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("p.q", 35).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notExists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)100L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)35L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        mut.setOrReplace("a.b.c", "xyz").setOrReplace("p.q", 20).setOrReplace("a.c.d", 12).setOrReplace("e", 18);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().typeOf("a.b.c", Value.Type.INT).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notTypeOf("a.b.c", Value.Type.INT).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().typeOf("a.b.c", Value.Type.STRING).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().sizeOf("a.b.c", QueryCondition.Op.EQUAL, 5L).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().sizeOf("a.b.c", QueryCondition.Op.EQUAL, 3L).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().matches("a.b.c", ".*m.*").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notMatches("a.b.c", ".*m.*").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().matches("a.b.c", ".*y.*").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"xyz", (Object)doc.getString("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        table.delete("key1");
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notExists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)100L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)35L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        mut.setOrReplace("a.b.c", 5).setOrReplace("p.q", 20).setOrReplace("a.c.d", 12).setOrReplace("e", 18);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().typeOf("a.b.c", Value.Type.STRING).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().notTypeOf("a.b.c", Value.Type.STRING).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().typeOf("a.b.c", Value.Type.INT).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)12L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)20L, (long)doc.getInt("p.q"));
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterInteger() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c,p.q", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("p.q", 35).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.b.c", 11).setOrReplace("p.q", 20).setOrReplace("a.c.d", 12).setOrReplace("e", 18);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.c.d", QueryCondition.Op.GREATER_OR_EQUAL, 50).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        try {
            doc.getInt("a.c.d");
            Assert.fail((String)"Expect NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.LESS, 15).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        Assert.assertEquals((long)11L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        try {
            doc.getInt("a.c.d");
            Assert.fail((String)"Expect NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("p.q", QueryCondition.Op.GREATER_OR_EQUAL, 20).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        try {
            doc.getInt("p.q");
            Assert.fail((String)"Expect NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("a.b.c", QueryCondition.Op.LESS, 10).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("a.b.c", QueryCondition.Op.LESS, 10).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 3).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 3).is("p.q", QueryCondition.Op.GREATER_OR_EQUAL, 41).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("p.q", QueryCondition.Op.GREATER, 20).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 5).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("a.b.c", QueryCondition.Op.LESS_OR_EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("a.b.c", QueryCondition.Op.LESS_OR_EQUAL, 2).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("p.q", QueryCondition.Op.LESS, 20).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("p.q", QueryCondition.Op.LESS_OR_EQUAL, 20).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("a.c.d", QueryCondition.Op.GREATER_OR_EQUAL, 25).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testIndexProjection() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c,p.q", "a.c.d,m.n");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("p.q", 35).setOrReplace("a.c.d", 100).setOrReplace("m.n", 717).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.b.c", 11).setOrReplace("p.q", 20).setOrReplace("a.c.d", 12).setOrReplace("m.n", (Map)MapRDBImpl.newDocument().set("z", 818)).setOrReplace("e", 18);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)100L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)35L, (long)doc.getInt("p.q"));
        Assert.assertEquals((long)717L, (long)doc.getInt("m.n"));
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)doc.size(), (long)2L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.c.d"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)100L, (long)doc.getInt("a.c.d"));
        Assert.assertEquals((long)doc.size(), (long)2L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c", "p.q"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)35L, (long)doc.getInt("p.q"));
        Assert.assertEquals((long)doc.size(), (long)3L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.LESS, 10).is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c", "m.n"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key", (Object)doc.getIdString());
        Assert.assertEquals((long)5L, (long)doc.getInt("a.b.c"));
        Assert.assertEquals((long)717L, (long)doc.getInt("m.n"));
        Assert.assertEquals((long)doc.size(), (long)3L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 11).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"m.n.z"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertEquals((long)818L, (long)doc.getInt("m.n.z"));
        Assert.assertEquals((long)doc.size(), (long)2L);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 11).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"m.n.p"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 11).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"u.f.o"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 11).build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"_id"});
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertEquals((Object)"key1", (Object)doc.getIdString());
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testErrorEncoding() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c,p.q", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", (Map)MapRDBImpl.newDocument().set("eliu", 5)).setOrReplace("p.q", Arrays.asList("o", "p", "q")).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        Iterator itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        mut.setOrReplace("a.b.c", 11).setOrReplace("p.q", "Eugene").setOrReplace("a.c.d", 12).setOrReplace("e", 18);
        table.update("key", mut);
        DBTests.waitForIndexFlush(table.getPath());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER, 10).is("p.q", QueryCondition.Op.EQUAL, "Eugene").close().build();
        stream = indexTable.find((QueryCondition)qc, new String[]{"a.b.c"});
        itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testCastToNumeric() throws Exception {
        String i1 = "TestIndexTable-testCastToNumeric-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(i@INT),$CAST(l@LONG),$CAST(f@FLOAT),$CAST(d@DOUBLE)'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", "1357").setOrReplace("l", "1357").setOrReplace("f", "1357").setOrReplace("d", "1357");
        table.update("fromString", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Short.MAX_VALUE).setOrReplace("l", Short.MAX_VALUE).setOrReplace("f", Short.MAX_VALUE).setOrReplace("d", Short.MAX_VALUE);
        table.update("fromShort", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Integer.MAX_VALUE).setOrReplace("l", Integer.MAX_VALUE).setOrReplace("f", Integer.MAX_VALUE).setOrReplace("d", Integer.MAX_VALUE);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Long.MAX_VALUE).setOrReplace("l", Long.MAX_VALUE).setOrReplace("f", Long.MAX_VALUE).setOrReplace("d", Long.MAX_VALUE);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", 31400.0f).setOrReplace("l", 31400.0f).setOrReplace("f", 31400.0f).setOrReplace("d", 31400.0f);
        table.update("fromFloat", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", 3.142345678).setOrReplace("l", 3.142345678).setOrReplace("f", 3.142345678).setOrReplace("d", 3.142345678);
        table.update("fromDouble", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", true).setOrReplace("l", false);
        table.update("fromBool", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("i", Bytes.toByteBuffer((String)"1000000")).setOrReplace("l", Bytes.toByteBuffer((String)"1000000")).setOrReplace("d", Bytes.toByteBuffer((String)"1000000")).setOrReplace("f", Bytes.toByteBuffer((String)"1000000"));
        table.update("fromBinary", mut);
        mut = MapRDBImpl.newMutation();
        mut.setNull("i").setNull("l").setNull("d").setNull("f");
        table.update("fromNull", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1357).build();
        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        ConditionImpl userCond = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1357).build();
        ConditionImpl finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(((ScanRange)scanRanges.get(0)).getCondition()).close().build();
        Iterator dsItr = indexTable.find((QueryCondition)finalCond).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        Assert.assertEquals((long)1357L, (long)doc.getLong("$1"));
        Assert.assertEquals((double)1357.0, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)1357.0, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, Short.MAX_VALUE).build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        userCond = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, Short.MAX_VALUE).build();
        finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(((ScanRange)scanRanges.get(0)).getCondition()).close().build();
        dsItr = indexTable.find((QueryCondition)finalCond).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromShort", (Object)doc.getIdString());
        Assert.assertEquals((long)32767L, (long)doc.getLong("$1"));
        Assert.assertEquals((double)32767.0, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)32767.0, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$1", QueryCondition.Op.EQUAL, Integer.MAX_VALUE).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)doc.getLong("$1"));
        Assert.assertEquals((double)2.147483648E9, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)2.147483647E9, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$1", QueryCondition.Op.EQUAL, Long.MAX_VALUE).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
        Assert.assertEquals((long)-1L, (long)doc.getInt("$0"));
        Assert.assertEquals((double)9.223372036854776E18, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)9.223372036854776E18, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 31400.0f).build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        userCond = MapRDBImpl.newCondition().is("$2", QueryCondition.Op.EQUAL, 31400.0f).build();
        finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(((ScanRange)scanRanges.get(0)).getCondition()).close().build();
        dsItr = indexTable.find((QueryCondition)finalCond).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromFloat", (Object)doc.getIdString());
        Assert.assertEquals((long)31400L, (long)doc.getInt("$0"));
        Assert.assertEquals((double)31400.0, (double)doc.getLong("$1"), (double)0.0);
        Assert.assertEquals((double)31400.0, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 3).build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        userCond = MapRDBImpl.newCondition().is("$3", QueryCondition.Op.EQUAL, 3.142345678).build();
        finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(((ScanRange)scanRanges.get(0)).getCondition()).close().build();
        dsItr = indexTable.find((QueryCondition)finalCond).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDouble", (Object)doc.getIdString());
        Assert.assertEquals((long)3L, (long)doc.getInt("$0"));
        Assert.assertEquals((double)3.0, (double)doc.getLong("$1"), (double)0.0);
        Assert.assertEquals((double)3.142345666885376, (double)doc.getFloat("$2"), (double)0.0);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromBool", (Object)doc.getIdString());
        Assert.assertEquals((long)0L, (long)doc.getLong("$1"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 1000000).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromBinary", (Object)doc.getIdString());
        Assert.assertEquals((long)1000000L, (long)doc.getLong("$1"));
        Assert.assertEquals((double)1000000.0, (double)doc.getFloat("$2"), (double)0.0);
        Assert.assertEquals((double)1000000.0, (double)doc.getDouble("$3"), (double)0.0);
        qc = MapRDBImpl.newCondition().typeOf("$0", Value.Type.NULL).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromNull", (Object)doc.getIdString());
        Assert.assertEquals((Object)Value.Type.NULL, (Object)doc.getValue("$1").getType());
        Assert.assertEquals((Object)Value.Type.NULL, (Object)doc.getValue("$2").getType());
        Assert.assertEquals((Object)Value.Type.NULL, (Object)doc.getValue("$3").getType());
    }

    @Test
    public void testCastCompositeIndexesString() throws Exception {
        String i1 = "TestIndexTable-testCastCompIndexesString-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(a@STRING),$CAST(b@STRING),$CAST(c@STRING(8)'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 1234).setOrReplace("b", 56).setOrReplace("c", 111122223);
        table.update("k1", mut);
        mut.setOrReplace("a", 1).setOrReplace("b", 2345678).setOrReplace("c", 12345678);
        table.update("k2", mut);
        mut.setOrReplace("a", 123.54322f).setOrReplace("b", false).setOrReplace("c", true);
        table.update("k3", mut);
        mut.setOrReplace("a", true).setOrReplace("b", "bval").setOrReplace("c", "stringlengthmorethan8");
        table.update("k4", mut);
        mut.setOrReplace("a", Long.MAX_VALUE).setOrReplace("b", 1.2345672).setOrReplace("c", 456.7890145);
        table.update("k5", mut);
        mut.setOrReplace("a", Bytes.toByteBuffer((String)"testStringA")).setOrReplace("b", Bytes.toByteBuffer((String)"testStringB")).setOrReplace("c", Bytes.toByteBuffer((String)"testStringC"));
        table.update("k6", mut);
        ODate date1 = ODate.parse((String)"1977-05-20");
        ODate date2 = ODate.parse((String)"2006-02-07");
        mut.setOrReplace("a", date1).setOrReplace("b", date2).setOrReplace("c", date2);
        table.update("days", mut);
        OTime t1 = OTime.parse((String)"09:01:39.001");
        OTime t2 = OTime.parse((String)"23:59:25.234");
        mut.setOrReplace("a", t1).setOrReplace("b", t2).setOrReplace("c", t2);
        table.update("times", mut);
        OTimestamp ts1 = OTimestamp.parse((String)"2017-06-17T13:30:05.999Z");
        OTimestamp ts2 = OTimestamp.parse((String)"1947-08-15T00:05:59.156Z");
        mut.setOrReplace("a", ts1).setOrReplace("b", ts2).setOrReplace("c", ts2);
        table.update("timestamps", mut);
        mut.setNull("a").setNull("b");
        table.update("null", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "1234").build();
        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        ConditionImpl userCond = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "1234").build();
        ConditionImpl finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(((ScanRange)scanRanges.get(0)).getCondition()).close().build();
        Iterator dsItr = indexTable.find((QueryCondition)finalCond).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k1", (Object)doc.getIdString());
        Assert.assertEquals((Object)"56", (Object)doc.getString("$1"));
        Assert.assertEquals((Object)"11112222", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "1").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k2", (Object)doc.getIdString());
        Assert.assertEquals((Object)"2345678", (Object)doc.getString("$1"));
        Assert.assertEquals((Object)"12345678", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "123.543221").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k3", (Object)doc.getIdString());
        Assert.assertEquals((float)123.54322f, (float)Float.valueOf(doc.getString("$0")).floatValue(), (float)0.0f);
        Assert.assertEquals((Object)"false", (Object)doc.getString("$1"));
        Assert.assertEquals((Object)"true", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "true").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k4", (Object)doc.getIdString());
        Assert.assertEquals((Object)"bval", (Object)doc.getString("$1"));
        Assert.assertEquals((Object)"stringle", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "9223372036854775807").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k5", (Object)doc.getIdString());
        Assert.assertEquals((double)1.2345672, (double)Double.parseDouble(doc.getString("$1")), (double)0.0);
        Assert.assertEquals((Object)"456.7890", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "testStringA");
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"k6", (Object)doc.getIdString());
        Assert.assertEquals((Object)"testStringB", (Object)doc.getString("$1"));
        Assert.assertEquals((Object)"testStri", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "1977-05-20").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"days", (Object)doc.getIdString());
        Assert.assertEquals((Object)"2006-02-07", (Object)doc.getString("$1"));
        Assert.assertEquals((Object)"2006-02-", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "09:01:39.001").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"times", (Object)doc.getIdString());
        Assert.assertEquals((Object)"23:59:25.234", (Object)doc.getString("$1"));
        Assert.assertEquals((Object)"23:59:25", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "2017-06-17T13:30:05.999Z").build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"timestamps", (Object)doc.getIdString());
        Assert.assertEquals((Object)"1947-08-15T00:05:59.156Z", (Object)doc.getString("$1"));
        Assert.assertEquals((Object)"1947-08-", (Object)doc.getString("$2"));
        qc = MapRDBImpl.newCondition().typeOf("$0", Value.Type.NULL).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"null", (Object)doc.getIdString());
        Assert.assertEquals((Object)Value.Type.NULL, (Object)doc.getValue("$1").getType());
    }

    @Test
    public void testCastToTimestamp() throws Exception {
        String i1 = "TestIndexTable-testCastToTimestamp-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(a@TIMESTAMP)'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 732000);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 1497701532456L);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", "2006-02-07T12:36:02.750Z");
        table.update("fromString", mut);
        OTimestamp ts = OTimestamp.parse((String)"1977-01-02T04:59:59.267Z");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", ts);
        table.update("fromTimestamp", mut);
        ODate date = ODate.parse((String)"1977-05-20");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", date);
        table.update("fromDate", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", Bytes.toByteBuffer((String)"2020-12-31T20:20:20.020Z"));
        table.update("fromBinary", mut);
        mut = MapRDBImpl.newMutation();
        mut.setNull("a");
        table.update("fromNull", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        OTimestamp ts1 = OTimestamp.parse((String)"1970-01-01T00:12:12.000Z");
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        ConditionImpl userCond = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        ConditionImpl finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(((ScanRange)scanRanges.get(0)).getCondition()).close().build();
        Iterator dsItr = indexTable.find((QueryCondition)finalCond).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"2017-06-17T12:12:12.456Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"2006-02-07T12:36:02.750Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"1977-01-02T04:59:59.267Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTimestamp", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"1977-05-20T00:00:00.000Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDate", (Object)doc.getIdString());
        ts1 = OTimestamp.parse((String)"2020-12-31T20:20:20.020Z");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, ts1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromBinary", (Object)doc.getIdString());
        qc = MapRDBImpl.newCondition().typeOf("$0", Value.Type.NULL).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromNull", (Object)doc.getIdString());
    }

    @Test
    public void testCastToTime() throws Exception {
        String i1 = "TestIndexTable-testCastToTime-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(a@TIME)'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 100000);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 84640123L);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", "10:01:02.750");
        table.update("fromString", mut);
        OTimestamp ts = OTimestamp.parse((String)"1977-01-02T04:59:59.267Z");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", ts);
        table.update("fromTimestamp", mut);
        ODate date = ODate.parse((String)"1977-05-20");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", date);
        table.update("fromDate", mut);
        OTime t1 = OTime.parse((String)"12:00:00.000");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", t1);
        table.update("fromTime", mut);
        t1 = OTime.parse((String)"18:07");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", t1);
        table.update("fromShortTime", mut);
        mut = MapRDBImpl.newMutation();
        mut.setNull("a");
        table.update("fromNull", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        OTime time1 = OTime.parse((String)"00:01:40.000");
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        ConditionImpl userCond = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        ConditionImpl finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(((ScanRange)scanRanges.get(0)).getCondition()).close().build();
        Iterator dsItr = indexTable.find((QueryCondition)finalCond).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        time1 = OTime.parse((String)"23:30:40.123");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
        time1 = OTime.parse((String)"10:01:02.750");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        time1 = OTime.parse((String)"04:59:59.267");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTimestamp", (Object)doc.getIdString());
        time1 = OTime.parse((String)"00:00:00.000");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDate", (Object)doc.getIdString());
        time1 = OTime.parse((String)"12:00:00.000");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTime", (Object)doc.getIdString());
        time1 = OTime.parse((String)"18:07");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, time1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromShortTime", (Object)doc.getIdString());
        qc = MapRDBImpl.newCondition().typeOf("$0", Value.Type.NULL).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromNull", (Object)doc.getIdString());
    }

    @Test
    public void testCastToDate() throws Exception {
        String i1 = "TestIndexTable-testCastToDate-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(a@DATE)'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 100000);
        table.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 1497651277000L);
        table.update("fromLong", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", "2000-12-31");
        table.update("fromString", mut);
        OTimestamp ts = OTimestamp.parse((String)"1977-01-02T04:30:45.267Z");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", ts);
        table.update("fromTimestamp", mut);
        ODate date = ODate.parse((String)"1977-05-20");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", date);
        table.update("fromDate", mut);
        mut = MapRDBImpl.newMutation();
        mut.setNull("a");
        table.update("fromNull", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        ODate date1 = ODate.parse((String)"1970-01-01");
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        ConditionImpl userCond = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        ConditionImpl finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(((ScanRange)scanRanges.get(0)).getCondition()).close().build();
        Iterator dsItr = indexTable.find((QueryCondition)finalCond).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        date1 = ODate.parse((String)"2017-06-16");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromLong", (Object)doc.getIdString());
        date1 = ODate.parse((String)"2000-12-31");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        date1 = ODate.parse((String)"1977-01-02");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTimestamp", (Object)doc.getIdString());
        date1 = ODate.parse((String)"1977-05-20");
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, date1).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDate", (Object)doc.getIdString());
        qc = MapRDBImpl.newCondition().typeOf("$0", Value.Type.NULL).build();
        dsItr = indexTable.find((QueryCondition)qc).iterator();
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromNull", (Object)doc.getIdString());
    }

    @Test
    public void testCastToBool() throws Exception {
        Iterator dsItr;
        Document doc2;
        DocumentStream ds;
        ConditionImpl finalCond;
        String i1 = "TestIndexTable-testCastToBool-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(b@BOOLEAN)'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("b", (short)25);
        table.update("fromShort", mut);
        mut.setOrReplace("b", 0);
        table.update("fromInt", mut);
        mut.setOrReplace("b", 1L);
        table.update("fromLong", mut);
        mut.setOrReplace("b", 0.0f);
        table.update("fromFloat", mut);
        mut.setOrReplace("b", 9.0);
        table.update("fromDouble", mut);
        mut.setOrReplace("b", "true");
        table.update("fromTrue", mut);
        mut.setOrReplace("b", "YeS");
        table.update("fromYes", mut);
        mut.setOrReplace("b", "On");
        table.update("fromOn", mut);
        mut.setOrReplace("b", "Y");
        table.update("fromY", mut);
        mut.setOrReplace("b", "t");
        table.update("fromT", mut);
        mut.setOrReplace("b", "1");
        table.update("fromOne", mut);
        mut.setOrReplace("b", "faLse");
        table.update("fromFalse", mut);
        mut.setOrReplace("b", "no");
        table.update("fromNo", mut);
        mut.setOrReplace("b", "OFf");
        table.update("fromOff", mut);
        mut.setOrReplace("b", "n");
        table.update("fromN", mut);
        mut.setOrReplace("b", "F");
        table.update("fromF", mut);
        mut.setOrReplace("b", "0");
        table.update("fromZero", mut);
        mut.setNull("b");
        table.update("fromNull", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        QueryCondition qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, true).build();
        List scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        QueryCondition userCond = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, true).build();
        int docs = 0;
        for (ScanRange range : scanRanges) {
            System.out.println(range.getCondition());
            finalCond = MapRDBImpl.newCondition().and().condition(userCond).condition(range.getCondition()).close().build();
            ds = indexTable.find((QueryCondition)finalCond);
            block22: for (Document doc2 : ds) {
                switch (++docs) {
                    case 1: {
                        Assert.assertEquals((Object)"fromDouble", (Object)doc2.getIdString());
                        continue block22;
                    }
                    case 2: {
                        Assert.assertEquals((Object)"fromLong", (Object)doc2.getIdString());
                        continue block22;
                    }
                    case 3: {
                        Assert.assertEquals((Object)"fromOn", (Object)doc2.getIdString());
                        continue block22;
                    }
                    case 4: {
                        Assert.assertEquals((Object)"fromOne", (Object)doc2.getIdString());
                        continue block22;
                    }
                    case 5: {
                        Assert.assertEquals((Object)"fromShort", (Object)doc2.getIdString());
                        continue block22;
                    }
                    case 6: {
                        Assert.assertEquals((Object)"fromT", (Object)doc2.getIdString());
                        continue block22;
                    }
                    case 7: {
                        Assert.assertEquals((Object)"fromTrue", (Object)doc2.getIdString());
                        continue block22;
                    }
                    case 8: {
                        Assert.assertEquals((Object)"fromY", (Object)doc2.getIdString());
                        continue block22;
                    }
                    case 9: {
                        Assert.assertEquals((Object)"fromYes", (Object)doc2.getIdString());
                        continue block22;
                    }
                }
            }
            Assert.assertEquals((long)9L, (long)docs);
        }
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, false).build();
        scanRanges = indexMetaTable.getScanRanges(qc);
        Assert.assertNotNull((Object)scanRanges);
        userCond = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, false).build();
        for (ScanRange range : scanRanges) {
            finalCond = MapRDBImpl.newCondition().and().condition(userCond).condition(range.getCondition()).close().build();
            ds = indexTable.find((QueryCondition)finalCond);
            dsItr = ds.iterator();
            docs = 0;
            block24: while (dsItr.hasNext()) {
                doc2 = (Document)dsItr.next();
                switch (++docs) {
                    case 1: {
                        Assert.assertEquals((Object)"fromF", (Object)doc2.getIdString());
                        continue block24;
                    }
                    case 2: {
                        Assert.assertEquals((Object)"fromFalse", (Object)doc2.getIdString());
                        continue block24;
                    }
                    case 3: {
                        Assert.assertEquals((Object)"fromFloat", (Object)doc2.getIdString());
                        continue block24;
                    }
                    case 4: {
                        Assert.assertEquals((Object)"fromInt", (Object)doc2.getIdString());
                        continue block24;
                    }
                    case 5: {
                        Assert.assertEquals((Object)"fromN", (Object)doc2.getIdString());
                        continue block24;
                    }
                    case 6: {
                        Assert.assertEquals((Object)"fromNo", (Object)doc2.getIdString());
                        continue block24;
                    }
                    case 7: {
                        Assert.assertEquals((Object)"fromOff", (Object)doc2.getIdString());
                        continue block24;
                    }
                    case 8: {
                        Assert.assertEquals((Object)"fromZero", (Object)doc2.getIdString());
                        continue block24;
                    }
                }
            }
            Assert.assertEquals((long)8L, (long)docs);
        }
        qc = MapRDBImpl.newCondition().typeOf("$0", Value.Type.NULL).build();
        dsItr = indexTable.find(qc).iterator();
        doc2 = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromNull", (Object)doc2.getIdString());
    }

    @Test
    public void testCompositeCastFailure1() throws Exception {
        String i1 = "TestIndexTable-testCompositeCastFailure-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(a@STRING),$CAST(b@STRING)'", null);
        Document doc = MapRDBImpl.newDocument().set("a", "astring").set("b[0]", 1).set("b[1]", 2);
        table.insertOrReplace("k1", doc);
        doc.set("a", "astring").set("b", "bstring");
        table.insertOrReplace("k2", doc);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        Iterator dsItr = indexTable.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            Document Doc = (Document)dsItr.next();
            if (!Doc.getId().equals("k1") && !Doc.getId().equals("k2")) continue;
            ++docs;
        }
        Assert.assertEquals((long)1L, (long)docs);
    }

    @Test
    public void testCompositeCastFailure2() throws Exception {
        String i1 = "TestIndexTable-testCompositeCastFailure-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(a@STRING),$CAST(b@STRING)'", null);
        Document doc = MapRDBImpl.newDocument().set("a[0]", 1).set("a[1]", 2).set("b", "bstring");
        table.insertOrReplace("k1", doc);
        doc.set("a", "astring").set("b", "bstring");
        table.insertOrReplace("k2", doc);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        Iterator dsItr = indexTable.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            Document Doc = (Document)dsItr.next();
            if (!Doc.getId().equals("k1") && !Doc.getId().equals("k2")) continue;
            ++docs;
        }
        Assert.assertEquals((long)1L, (long)docs);
    }

    @Test
    public void testCastBoolString() throws Exception {
        String i1 = "TestIndexTable-testCastBoolToString-" + Long.toString(System.currentTimeMillis());
        String i2 = "TestIndexTable-testCastStringToBool-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(y@STRING)'", null);
        IndexDesc i2Desc = this.createIndex(table, i2, "'$CAST(z@BOOLEAN)'", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("y", false).setOrReplace("z", "false");
        table.update("falsekey", mut);
        mut.setOrReplace("y", true).setOrReplace("z", "true");
        table.update("truekey", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        Iterator dsItr = indexTable.find().iterator();
        int docs = 0;
        while (dsItr.hasNext()) {
            Document Doc = (Document)dsItr.next();
            if (!Doc.getId().equals("truekey") && !Doc.getId().equals("falsekey")) continue;
            ++docs;
        }
        Assert.assertEquals((long)2L, (long)docs);
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "false").build();
        dsItr = indexTable.find((QueryCondition)qc, new String[]{"$0"}).iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertEquals((Object)"falsekey", (Object)doc.getIdString());
        Assert.assertFalse((boolean)dsItr.hasNext());
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, "true").build();
        dsItr = indexTable.find((QueryCondition)qc, new String[]{"$0"}).iterator();
        doc = (Document)dsItr.next();
        Assert.assertEquals((Object)"truekey", (Object)doc.getIdString());
        Assert.assertFalse((boolean)dsItr.hasNext());
        indexTable = MapRDBImpl.getIndexTable((IndexDesc)i2Desc);
        dsItr = indexTable.find().iterator();
        docs = 0;
        while (dsItr.hasNext()) {
            Document Doc = (Document)dsItr.next();
            if (!Doc.getId().equals("truekey") && !Doc.getId().equals("falsekey")) continue;
            ++docs;
        }
        Assert.assertEquals((long)2L, (long)docs);
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, false).build();
        dsItr = indexTable.find((QueryCondition)qc, new String[]{"$0"}).iterator();
        doc = (Document)dsItr.next();
        Assert.assertEquals((Object)"falsekey", (Object)doc.getIdString());
        Assert.assertFalse((boolean)dsItr.hasNext());
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, true).build();
        dsItr = indexTable.find((QueryCondition)qc, new String[]{"$0"}).iterator();
        doc = (Document)dsItr.next();
        Assert.assertEquals((Object)"truekey", (Object)doc.getIdString());
        Assert.assertFalse((boolean)dsItr.hasNext());
    }

    @Test
    public void testConditionFilterCast() throws Exception {
        String i1 = "TestIndexTable-testConditionInteger-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "'$CAST(a.b.c@INT)'", "'a.c.d'");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", "5").setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.b.c", "11").setOrReplace("a.c.d", 12).setOrReplace("e", 13);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc, new String[]{"$0"});
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.LESS, 10).is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("$0", QueryCondition.Op.LESS, 10).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 1).is("$0", QueryCondition.Op.LESS, 10).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.LESS, 3).is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 1).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 5).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().or().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("$0", QueryCondition.Op.LESS_OR_EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        qc = MapRDBImpl.newCondition().or().is("$0", QueryCondition.Op.GREATER_OR_EQUAL, 12).is("$0", QueryCondition.Op.LESS_OR_EQUAL, 2).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testCastWithArrayFieldIndex() throws Exception {
        String tName = "testCastWithArrayFieldIndex-table";
        String i1Name = "testCastWithArrayFieldIndex-i1";
        String i2Name = "testCastWithArrayFieldIndex-i2";
        String[] indexedFields1 = new String[]{"$CAST(a[].b@STRING)"};
        String[] indexedFields2 = new String[]{"$CAST(a[].b@DOUBLE),$CAST(a[].c@BOOLEAN)"};
        Table t1 = DBTests.createOrGetTable(tName);
        DBTests.createIndex(tName, i1Name, indexedFields1);
        DBTests.createIndex(tName, i2Name, indexedFields2);
        IndexDesc iDesc1 = this.getIndex(t1, i1Name);
        IndexDesc iDesc2 = this.getIndex(t1, i2Name);
        Assert.assertNotNull((Object)iDesc1);
        Assert.assertNotNull((Object)iDesc2);
        Document d1 = MapRDBImpl.newDocument().set("a.b", 10).set("a.c", "true");
        Document d2 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", 100).set("c", 0), MapRDBImpl.newDocument().set("b", 20).set("c", "true"), MapRDBImpl.newDocument().set("b", 30).set("c", 0)});
        t1.insertOrReplace("key1", d1);
        t1.insertOrReplace("key2", d2);
        t1.flush();
        DBTests.waitForIndexFlush(t1.getPath());
        MapRDBIndexImpl idx1 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)iDesc1);
        MapRDBIndexImpl idx2 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)iDesc2);
        QueryCondition qc1 = MapRDB.newCondition().like("$0", "%10%");
        idx1.setDecodeIndexValues(true);
        idx2.setDecodeIndexValues(true);
        DocumentStream ds1 = idx1.find(qc1);
        Iterator itr1 = ds1.iterator();
        Assert.assertNotNull((Object)itr1);
        int count = 0;
        while (itr1.hasNext()) {
            ++count;
            Document readDoc = (Document)itr1.next();
            switch (readDoc.getIdString()) {
                case "key1": {
                    Assert.assertEquals((Object)"10", (Object)readDoc.getString("$idx[0]"));
                    break;
                }
                case "key2": {
                    Assert.assertEquals((Object)"100", (Object)readDoc.getString("$idx[0]"));
                }
            }
        }
        Assert.assertEquals((long)2L, (long)count);
        ds1.close();
        QueryCondition qc2 = MapRDBImpl.newCondition().and().is("$0", QueryCondition.Op.GREATER, 10.0).is("$1", QueryCondition.Op.EQUAL, false).close().build();
        DocumentStream ds2 = idx2.find(qc2);
        Iterator itr2 = ds2.iterator();
        Assert.assertNotNull((Object)itr2);
        count = 0;
        boolean fail = false;
        while (itr2.hasNext()) {
            Document readDoc = (Document)itr2.next();
            switch (readDoc.getIdString()) {
                case "key1": {
                    fail = true;
                }
                case "key2": {
                    if (readDoc.getDouble("$idx[0]") == 100.0) {
                        Assert.assertFalse((boolean)readDoc.getBoolean("$idx[1]"));
                        ++count;
                        break;
                    }
                    Assert.assertEquals((double)30.0, (double)readDoc.getDouble("$idx[0]"), (double)0.0);
                    Assert.assertFalse((boolean)readDoc.getBoolean("$idx[1]"));
                    ++count;
                }
            }
        }
        assert (!fail);
        Assert.assertEquals((long)2L, (long)count);
        ds2.close();
    }

    private void runQueryAndCheckResults(Table indexTable, QueryCondition qc, String[] expectedIds) throws Exception {
        this.runQueryAndCheckResults(indexTable, qc, expectedIds, null);
    }

    private void runQueryAndCheckResults(Table indexTable, QueryCondition qc, String[] expectedIds, List<IndexFieldDesc> fieldDescList) throws Exception {
        int i;
        if (fieldDescList != null) {
            ConditionImpl cond = (ConditionImpl)qc;
            int version = ((MapRDBIndexImpl)indexTable).getVersion() == Dbserver.SIndexInfo.Version.v6dot0 ? 0 : 1;
            cond.setPartitionKeys(version, fieldDescList);
        }
        DocumentStream stream = indexTable.find(qc);
        Iterator itr = stream.iterator();
        Assert.assertTrue((expectedIds.length == 0 && !itr.hasNext() || expectedIds.length != 0 && itr.hasNext() ? 1 : 0) != 0);
        if (expectedIds.length == 0) {
            return;
        }
        HashMap<String, Integer> ei = new HashMap<String, Integer>();
        for (i = 0; i < expectedIds.length; ++i) {
            ei.put(expectedIds[i], 0);
        }
        for (i = 0; i < expectedIds.length; ++i) {
            Document doc = (Document)itr.next();
            System.out.println("0. id = " + doc.getIdString());
            Assert.assertTrue((boolean)ei.containsKey(doc.getIdString()));
        }
        Assert.assertFalse((boolean)itr.hasNext());
    }

    private void runQueries(Table indexTable, QueryCondition qc, String[] expectedIds, List<IndexFieldDesc> fieldDescList) throws Exception {
        this.runQueryAndCheckResults(indexTable, qc, expectedIds);
        this.runQueryAndCheckResults(indexTable, qc, expectedIds, fieldDescList);
    }

    private String getIndexAddFieldSpecification(String indexedField, boolean descending) {
        return indexedField + (descending ? ":-1" : "");
    }

    private void testQueryConditionOnTime(String indexedField0, String indexedField1, boolean firstIndexedFieldIsDescending) throws Exception {
        String i1 = "TestIndexTable-testQueryConditionOnTime-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, this.getIndexAddFieldSpecification(indexedField0, firstIndexedFieldIsDescending), this.getIndexAddFieldSpecification(indexedField1, false));
        List fieldDescList = i1Desc.getIndexedFields();
        int numberOfDocs = 10;
        DocumentMutation mut = MapRDBImpl.newMutation();
        for (int i = 0; i < numberOfDocs; ++i) {
            mut.setOrReplace(indexedField0, OTime.parse((String)("20:12:0" + i))).setOrReplace(indexedField1, 100).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:05")).build(), new String[]{"id5"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:55")).build(), new String[0], fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS_OR_EQUAL, OTime.parse((String)"20:12:05")).build(), new String[]{"id0", "id1", "id2", "id3", "id4", "id5"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS, OTime.parse((String)"20:12:05")).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, OTime.parse((String)"20:12:05")).build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER, OTime.parse((String)"20:12:05")).build(), new String[]{"id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, OTime.parse((String)"20:12:55")).build(), new String[0], fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:05")).is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:05")).close().build(), new String[]{"id5"}, fieldDescList);
        this.runQueryAndCheckResults(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:05")).is(indexedField0, QueryCondition.Op.EQUAL, OTime.parse((String)"20:12:07")).close().build(), new String[0]);
    }

    @Test
    public void testConditionOnTime() throws Exception {
        boolean firstIndexedFieldIsDescending = true;
        this.testQueryConditionOnTime("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
        firstIndexedFieldIsDescending = false;
        this.testQueryConditionOnTime("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
    }

    private void testQueryConditionOnString(String indexedField0, String indexedField1, boolean firstIndexedFieldIsDescending) throws Exception {
        String i1 = "TestIndexTable-testQueryConditionOnString-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, this.getIndexAddFieldSpecification(indexedField0, firstIndexedFieldIsDescending), this.getIndexAddFieldSpecification(indexedField1, false));
        List fieldDescList = i1Desc.getIndexedFields();
        int numberOfDocs = 10;
        DocumentMutation mut = MapRDBImpl.newMutation();
        for (int i = 0; i < numberOfDocs; ++i) {
            mut.setOrReplace(indexedField0, "id" + i).setOrReplace(indexedField1, 100).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, "id5").build(), new String[]{"id5"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, "id99").build(), new String[0], fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS_OR_EQUAL, "id5").build(), new String[]{"id0", "id1", "id2", "id3", "id4", "id5"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS, "id5").build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, "id5").build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER, "id5").build(), new String[]{"id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, "id99").build(), new String[0], fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, "id5").is(indexedField0, QueryCondition.Op.EQUAL, "id5").close().build(), new String[]{"id5"}, fieldDescList);
        this.runQueryAndCheckResults(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, "id5").is(indexedField0, QueryCondition.Op.EQUAL, "id7").close().build(), new String[0]);
    }

    @Test
    public void testConditionOnString() throws Exception {
        boolean firstIndexedFieldIsDescending = true;
        this.testQueryConditionOnString("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
        firstIndexedFieldIsDescending = false;
        this.testQueryConditionOnString("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
    }

    private void testQueryConditionOnNoneBinaryComparator(String indexedField0, String indexedField1, boolean firstIndexedFieldIsDescending) throws Exception {
        int i;
        String i1 = "TestIndexTable-testQueryConditionOnInt-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, this.getIndexAddFieldSpecification(indexedField0, firstIndexedFieldIsDescending), this.getIndexAddFieldSpecification(indexedField1, false));
        List fieldDescList = i1Desc.getIndexedFields();
        int numberOfDocs = 5;
        DocumentMutation mut = MapRDBImpl.newMutation();
        for (i = 0; i < numberOfDocs; ++i) {
            mut.setOrReplace(indexedField0, "xyz").setOrReplace(indexedField1, 100).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        mut = MapRDBImpl.newMutation();
        for (i = 5; i < 5 + numberOfDocs; ++i) {
            mut.setOrReplace(indexedField1, i).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().exists(indexedField0).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().notExists(indexedField0).build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().typeOf(indexedField0, Value.Type.STRING).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().notTypeOf(indexedField0, Value.Type.STRING).build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().typeOf(indexedField0, Value.Type.INT).build(), new String[0], fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().notTypeOf(indexedField0, Value.Type.INT).build(), new String[]{"id0", "id1", "id2", "id3", "id4", "id5", "id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, MapRDBImpl.newCondition().sizeOf(indexedField0, QueryCondition.Op.EQUAL, 3L).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescList);
        this.runQueries(indexTable, MapRDBImpl.newCondition().sizeOf(indexedField0, QueryCondition.Op.EQUAL, 5L).build(), new String[0], fieldDescList);
        this.runQueries(indexTable, MapRDBImpl.newCondition().sizeOf(indexedField0, QueryCondition.Op.LESS, 5L).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().matches(indexedField0, ".*m.*").build(), new String[0], fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().notMatches(indexedField0, ".*m.*").build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescList);
    }

    private void testQueryConditionOnInt(String indexedField0, String indexedField1, boolean firstIndexedFieldIsDescending) throws Exception {
        String i1 = "TestIndexTable-testQueryConditionOnInt-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, this.getIndexAddFieldSpecification(indexedField0, firstIndexedFieldIsDescending), this.getIndexAddFieldSpecification(indexedField1, false));
        List fieldDescList = i1Desc.getIndexedFields();
        int numberOfDocs = 10;
        DocumentMutation mut = MapRDBImpl.newMutation();
        for (int i = 0; i < numberOfDocs; ++i) {
            mut.setOrReplace(indexedField0, i).setOrReplace(indexedField1, 100).setOrReplace("e", 1000);
            table.update("id" + i, mut);
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, 5).build(), new String[]{"id5"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.EQUAL, 99).build(), new String[0], fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS_OR_EQUAL, 5).build(), new String[]{"id0", "id1", "id2", "id3", "id4", "id5"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.LESS, 5).build(), new String[]{"id0", "id1", "id2", "id3", "id4"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, 5).build(), new String[]{"id5", "id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER, 5).build(), new String[]{"id6", "id7", "id8", "id9"}, fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().is(indexedField0, QueryCondition.Op.GREATER_OR_EQUAL, 99).build(), new String[0], fieldDescList);
        this.runQueries(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, 5).is(indexedField0, QueryCondition.Op.EQUAL, 5).close().build(), new String[]{"id5"}, fieldDescList);
        this.runQueryAndCheckResults(indexTable, (QueryCondition)MapRDBImpl.newCondition().and().is(indexedField0, QueryCondition.Op.EQUAL, 5).is(indexedField0, QueryCondition.Op.EQUAL, 7).close().build(), new String[0]);
    }

    @Test
    public void testConditionOnInt() throws Exception {
        boolean firstIndexedFieldIsDescending = true;
        this.testQueryConditionOnInt("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
        firstIndexedFieldIsDescending = false;
        this.testQueryConditionOnInt("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
    }

    @Test
    public void testConditionOnNoneBinaryComparator() throws Exception {
        this.removeUnneededRow();
        boolean firstIndexedFieldIsDescending = true;
        this.testQueryConditionOnNoneBinaryComparator("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
        firstIndexedFieldIsDescending = false;
        this.testQueryConditionOnNoneBinaryComparator("a.b.c", "a.c.d", firstIndexedFieldIsDescending);
    }

    @Test
    public void testConditionFilterIntegerDesc() throws Exception {
        String i1 = "TestIndexTable-testConditionFilterIntegerDesc-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c:-1", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 5).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.EQUAL, 5).is("a.b.c", QueryCondition.Op.EQUAL, 5).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.EQUAL, 5).is("a.b.c", QueryCondition.Op.EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterNonIndexed() throws Exception {
        String i1 = "TestIndexTable-testConditionNonindexed-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.EQUAL, 100).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.c.d", QueryCondition.Op.EQUAL, 100).is("a.b.c", QueryCondition.Op.EQUAL, 5).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.c.d", QueryCondition.Op.EQUAL, 100).is("a.b.c", QueryCondition.Op.EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterNonIndexedDesc() throws Exception {
        String i1 = "TestIndexTable-testConditionNonindexedDesc-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c:DESC", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.b.c", 5).setOrReplace("a.c.d", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.b.c", 11).setOrReplace("a.c.d", 12).setOrReplace("e", 13);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.EQUAL, 100).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.c.d", QueryCondition.Op.EQUAL, 100).is("a.b.c", QueryCondition.Op.EQUAL, 5).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().and().is("a.c.d", QueryCondition.Op.EQUAL, 100).is("a.b.c", QueryCondition.Op.EQUAL, 7).close().build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterMap() throws Exception {
        String i1 = "TestIndexTable-testConditionMap-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.c.d", (Map)MapRDBImpl.newDocument().set("z", 5)).setOrReplace("a.b.c", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.c.d", (Map)MapRDBImpl.newDocument().set("z", 4)).setOrReplace("a.b.c", 100).setOrReplace("e", 1000);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.c.d.z", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d.z", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConditionFilterList() throws Exception {
        String i1 = "TestIndexTable-testConditionList-" + Long.toString(System.currentTimeMillis());
        IndexDesc i1Desc = this.createIndex(table, i1, "a.b.c", "a.c.d");
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a.c.d", Arrays.asList(5, 9)).setOrReplace("a.b.c", 100).setOrReplace("e", 1000);
        table.update("key", mut);
        mut.setOrReplace("a.c.d", Arrays.asList(6, 4)).setOrReplace("a.b.c", 100).setOrReplace("e", 1000);
        table.update("key1", mut);
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc = MapRDBImpl.newCondition().is("a.c.d[0]", QueryCondition.Op.EQUAL, 5).build();
        DocumentStream stream = indexTable.find((QueryCondition)qc);
        Iterator itr = stream.iterator();
        Document doc = (Document)itr.next();
        System.out.println(doc);
        Assert.assertFalse((boolean)itr.hasNext());
        qc = MapRDBImpl.newCondition().is("a.c.d[0]", QueryCondition.Op.EQUAL, 7).build();
        stream = indexTable.find((QueryCondition)qc);
        itr = stream.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testArrayIndexProjectionWithCondition() throws Exception {
        int count;
        Assert.assertNotNull((Object)table);
        this.removeUnneededRow();
        String i1Name = "testArrayIndexProjectionWithCondition-i1";
        String[] indexedFields = new String[]{"a.b[].c", "a.b[].d"};
        String[] includedFields = new String[]{"a.b[].e", "x.y.z.w", "i"};
        Document doc1 = MapRDBImpl.newDocument().setArray("a.b", new Object[]{MapRDBImpl.newDocument().set("c", "abc1").set("e", "abe1").set("d", "abd1"), MapRDBImpl.newDocument().set("c", "abc2").set("e", "abe2").set("d", "abd2")}).set("x.y.z.w", "xyzw1").set("i", 10);
        Document doc2 = MapRDBImpl.newDocument().setArray("a.b", new Object[]{MapRDBImpl.newDocument().set("c", "abc1").set("e", "abe1").set("d", "abd1"), MapRDBImpl.newDocument().set("c", "abc2").set("e", "abe2").set("d", "abd2")}).set("x.y.z.w", "xyzw2").set("i", 20);
        table.insertOrReplace("key1", doc1);
        table.insertOrReplace("key2", doc2);
        table.flush();
        DBTests.createIndex(table, i1Name, false, 0, indexedFields, null, includedFields);
        IndexDesc i1Desc = this.getIndex(table, i1Name);
        Table i1Table = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc1 = MapRDBImpl.newCondition().and().is("a.b[].c", QueryCondition.Op.EQUAL, "abc1").is("i", QueryCondition.Op.GREATER, 15).close().build();
        String[] proj1 = new String[]{"x.y.z.w"};
        try (DocumentStream ds1 = i1Table.find((QueryCondition)qc1, proj1);){
            Iterator itr = ds1.iterator();
            Assert.assertTrue((boolean)itr.hasNext());
            count = 0;
            while (itr.hasNext()) {
                Document readDoc = (Document)itr.next();
                Assert.assertEquals((Object)"key2", (Object)readDoc.getIdString());
                Assert.assertEquals((Object)"xyzw2", (Object)readDoc.getString("x.y.z.w"));
                Assert.assertNull((Object)readDoc.getValue("a.b"));
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        ConditionImpl qc2 = MapRDBImpl.newCondition().and().and().is("a.b[].c", QueryCondition.Op.EQUAL, "abc1").is("a.b[].d", QueryCondition.Op.EQUAL, "abd1").close().is("i", QueryCondition.Op.GREATER, 15).close().build();
        try (DocumentStream ds2 = i1Table.find((QueryCondition)qc2, new String[]{"i"});){
            count = 0;
            for (Document doc : ds2) {
                String id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                Assert.assertEquals((Object)"key2", (Object)id);
                int i = doc.getInt("i");
                Assert.assertEquals((long)20L, (long)i);
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    @Test
    public void testHashedIndexPutsAndScanNoQueryCondition() throws Exception {
        int numRows;
        Assert.assertNotNull((Object)table);
        this.removeUnneededRow();
        String i1Name = "i1-testHashedIndexPutsAndScanNoQueryCondition";
        int startKey = numRows = 1000;
        int endKey1 = startKey + numRows / 2;
        int endKey2 = startKey * 2;
        int insCount = 0;
        for (int i = startKey; i < endKey1; ++i) {
            Document d = MapRDBImpl.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("w.x.y", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        IndexDesc i1Desc = this.createIndex(table, i1Name, "a.b.c", "w.x.y", true, 10);
        if (i1Desc == null) {
            DBTests.waitForIndexFlush(table.getPath());
            i1Desc = this.getIndex(table, i1Name);
        }
        Assert.assertTrue((boolean)i1Desc.isHashed());
        for (int i = endKey1 + 1; i < endKey2; ++i) {
            Document d = MapRDBImpl.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("w.x.y", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream stream = indexTable.find();
        Iterator itr = stream.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        int count = 0;
        while (itr.hasNext()) {
            Document d = (Document)itr.next();
            String key = d.getIdString();
            String ordinal = key.substring("key".length());
            Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
            Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
            ++count;
        }
        Assert.assertEquals((long)count, (long)insCount);
    }

    @Test
    public void testHashedIndexScanWithQueryConditionOnPartitionKey() throws Exception {
        String ordinal;
        String key;
        DocumentStream ds;
        String ordinal2;
        String key2;
        DocumentStream ds2;
        ConditionImpl finalCond;
        int numRows;
        Assert.assertNotNull((Object)table);
        this.removeUnneededRow();
        String i1Name = "i1-testHashedIndexPutsAndScanNoQueryCondition";
        int startKey = numRows = 10000;
        int endKey1 = startKey + numRows / 2;
        int endKey2 = startKey * 2;
        int insCount = 0;
        for (int i = startKey; i < endKey1; ++i) {
            Document d = MapRDBImpl.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("w.x.y", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        IndexDesc i1Desc = this.createIndex(table, i1Name, "a.b.c", "w.x.y", true, 3);
        if (i1Desc == null) {
            DBTests.waitForIndexFlush(table.getPath());
            i1Desc = this.getIndex(table, i1Name);
        }
        Assert.assertTrue((i1Desc.isHashed() && i1Desc.getNumHashPartitions() > 0 ? 1 : 0) != 0);
        DBTests.waitForIndexFlush(table.getPath());
        for (int i = endKey1; i < endKey2; ++i) {
            Document d = MapRDBImpl.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("w.x.y", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        _logger.info("Testing GREATER, LESS operators");
        int scanCount = 0;
        int scanStart = startKey + numRows / 20;
        int scanStop = endKey1 - numRows / 10;
        ConditionImpl qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.LESS, "abc" + Integer.toString(scanStop)).close().build();
        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)3L, (long)scanRanges.size());
        ArrayList<String> keys = new ArrayList<String>();
        ConditionImpl userCond = MapRDBImpl.newCondition().and().is("w.x.y", QueryCondition.Op.LESS, "xyz" + Integer.toString(scanStop - 10)).close().build();
        for (ScanRange range : scanRanges) {
            finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(range.getCondition()).close().build();
            ds2 = indexTable.find((QueryCondition)finalCond);
            for (Document d : ds2) {
                key2 = d.getIdString();
                ordinal2 = key2.substring("key".length());
                Assert.assertTrue((ordinal2.compareTo(Integer.toString(scanStart)) > 0 && ordinal2.compareTo(Integer.toString(scanStop - 10)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal2));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal2));
                keys.add(key2);
                ++scanCount;
            }
            keys.sort(null);
            ds2.close();
        }
        Assert.assertEquals((long)scanCount, (long)(scanStop - 10 - (scanStart + 1)));
        _logger.info("Testing GREATER_OR_EQUAL, LESS_OR_EQUAL operators");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.LESS_OR_EQUAL, "abc" + Integer.toString(scanStop)).close().build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)3L, (long)scanRanges.size());
        userCond = MapRDBImpl.newCondition().and().is("w.x.y", QueryCondition.Op.LESS, "xyz" + Integer.toString(scanStop - 10)).close().build();
        for (ScanRange range : scanRanges) {
            finalCond = MapRDBImpl.newCondition().and().condition((QueryCondition)userCond).condition(range.getCondition()).close().build();
            ds2 = indexTable.find((QueryCondition)finalCond);
            for (Document d : ds2) {
                key2 = d.getIdString();
                ordinal2 = key2.substring("key".length());
                Assert.assertTrue((ordinal2.compareTo(Integer.toString(scanStart)) >= 0 && ordinal2.compareTo(Integer.toString(scanStop - 10)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal2));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal2));
                keys.add(key2);
                ++scanCount;
            }
            keys.sort(null);
            ds2.close();
        }
        Assert.assertEquals((long)(scanStop - 10 - scanStart), (long)scanCount);
        _logger.info("Testing EQUAL operators");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.EQUAL, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.EQUAL, "abc" + Integer.toString(scanStop)).close().build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)6L, (long)scanRanges.size());
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) == 0 || ordinal.compareTo(Integer.toString(scanStop)) == 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)2L, (long)scanCount);
        _logger.info("Testing EXISTS api");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)1L, (long)scanRanges.size());
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(startKey)) >= 0 && ordinal.compareTo(Integer.toString(endKey2)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(endKey2 - startKey), (long)scanCount);
        _logger.info("Testing non-partition key condition.");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDBImpl.newCondition().and().and().is("a.b.c", QueryCondition.Op.GREATER, "abc" + Integer.toString(scanStart)).is("w.x.y", QueryCondition.Op.LESS, "xyz" + Integer.toString(scanStop)).close().and().is("a.b.c", QueryCondition.Op.LESS, "abc" + Integer.toString(scanStop - 10)).close().close().build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        Assert.assertEquals((long)3L, (long)scanRanges.size());
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) > 0 && ordinal.compareTo(Integer.toString(scanStop - 10)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(scanStop - 10 - (scanStart + 1)), (long)scanCount);
    }

    @Ignore(value="Enable manually, run and disable when done - long running test")
    @Test
    public void testHashedIndexScanWithQueryConditionOnPartitionKeyXL() throws Exception {
        String ordinal;
        String key;
        DocumentStream ds;
        int numRows;
        Assert.assertNotNull((Object)table);
        String i1Name = "i1-testHashedIndexPutsAndScanWithQueryConditionOnPartitionKeyXL";
        int startKey = numRows = 100000000;
        int endKey1 = startKey + numRows / 2;
        int endKey2 = startKey * 2;
        int insCount = 0;
        IndexDesc i1Desc = this.createIndex(table, i1Name, "'\"a.b.c\"'", "'\"w.x.y\"'", true, 3);
        if (i1Desc == null) {
            DBTests.waitForIndexFlush(table.getPath());
            i1Desc = this.getIndex(table, i1Name);
        }
        System.err.println(i1Desc.getIndexName());
        Assert.assertTrue((i1Desc.isHashed() && i1Desc.getNumHashPartitions() > 0 ? 1 : 0) != 0);
        DBTests.waitForIndexFlush(table.getPath());
        for (int i = startKey; i < endKey2; ++i) {
            Document d = MapRDBImpl.newDocument().set("a.b.c", "abc" + Integer.toString(i)).set("a.b.d", "abd" + Integer.toString(i)).set("w.x.y", "xyz" + Integer.toString(i));
            table.insert("key" + Integer.toString(i), d);
            ++insCount;
        }
        table.flush();
        DBTests.waitForIndexFlush(table.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        MetaTable indexMetaTable = indexTable.getMetaTable();
        _logger.info("Testing GREATER, LESS operators");
        int scanCount = 0;
        int scanStart = startKey + numRows / 20;
        int scanStop = endKey1 - numRows / 10;
        ConditionImpl qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.LESS, "abc" + Integer.toString(scanStop)).close().build();
        List scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        ArrayList<String> keys = new ArrayList<String>();
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) > 0 && ordinal.compareTo(Integer.toString(scanStop)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)scanCount, (long)(scanStop - (scanStart + 1)));
        _logger.info("Testing GREATER_OR_EQUAL, LESS_OR_EQUAL operators");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDBImpl.newCondition().and().is("a.b.c", QueryCondition.Op.GREATER_OR_EQUAL, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.LESS_OR_EQUAL, "abc" + Integer.toString(scanStop)).close().build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) >= 0 && ordinal.compareTo(Integer.toString(scanStop)) <= 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(scanStop - (scanStart - 1)), (long)scanCount);
        _logger.info("Testing EQUAL operators");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDBImpl.newCondition().or().is("a.b.c", QueryCondition.Op.EQUAL, "abc" + Integer.toString(scanStart)).is("a.b.c", QueryCondition.Op.EQUAL, "abc" + Integer.toString(scanStop)).close().build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) == 0 || ordinal.compareTo(Integer.toString(scanStop)) == 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)2L, (long)scanCount);
        _logger.info("Testing EXISTS api");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDBImpl.newCondition().exists("a.b.c").build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(startKey)) >= 0 && ordinal.compareTo(Integer.toString(endKey2)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(endKey2 - startKey), (long)scanCount);
        _logger.info("Testing non-partition key condition.");
        scanCount = 0;
        scanStart = startKey + numRows / 20;
        scanStop = endKey2 - numRows / 10;
        keys.clear();
        qc = MapRDBImpl.newCondition().and().and().is("a.b.c", QueryCondition.Op.GREATER, "abc" + Integer.toString(scanStart)).is("w.x.y", QueryCondition.Op.LESS, "xyz" + Integer.toString(scanStop)).close().and().is("a.b.c", QueryCondition.Op.LESS, "abc" + Integer.toString(scanStop - 10)).close().close().build();
        scanRanges = indexMetaTable.getScanRanges((QueryCondition)qc);
        Assert.assertNotNull((Object)scanRanges);
        for (ScanRange range : scanRanges) {
            ds = indexTable.find(range.getCondition());
            for (Document d : ds) {
                key = d.getIdString();
                ordinal = key.substring("key".length());
                Assert.assertTrue((ordinal.compareTo(Integer.toString(scanStart)) > 0 && ordinal.compareTo(Integer.toString(scanStop - 10)) < 0 ? 1 : 0) != 0);
                Assert.assertEquals((Object)d.getString("a.b.c"), (Object)("abc" + ordinal));
                Assert.assertEquals((Object)d.getString("w.x.y"), (Object)("xyz" + ordinal));
                keys.add(key);
                ++scanCount;
            }
            keys.sort(null);
            ds.close();
        }
        Assert.assertEquals((long)(scanStop - 10 - (scanStart + 1)), (long)scanCount);
    }

    @Ignore(value="Disabled due to bug 27001 - update TS indexing not supported in 6.0")
    @Test
    public void testUpdateTimeOnlyIndexScanWithCondition() throws Exception {
        if (MapRDBImpl.tableExists((String)table.getPath().toString())) {
            MapRDBImpl.deleteTable((String)table.getPath().toString());
        }
        String myTableName = "testUpdateTimeOnlyIndexScanWithCondition-table";
        table = DBTests.createOrReplaceTable(myTableName);
        String indexName = "testUpdateTimeOnlyIndexScanWithCondition-index";
        String indexedFields = "'$$timestamp'";
        String nonIndexedFields = "x.y,a.b";
        IndexDesc idxDesc = this.createIndex(table, indexName, indexedFields, nonIndexedFields);
        _logger.trace("Index " + indexName + " created for table " + table.getName() + " on  indexed fields " + indexedFields + " and non-indexed fields " + nonIndexedFields);
        int count = 10;
        this.testUpdateTimeIndexHelper(count, indexName, idxDesc);
        this.testUpdateTimeIndexHelper(count << 2, indexName, idxDesc);
    }

    @Ignore(value="Disabled due to bug 27001 - update TS indexing not supported in 6.0")
    @Test
    public void testUpdateTimeCompositeIndexScanWithCondition() throws Exception {
        if (MapRDBImpl.tableExists((String)table.getPath().toString())) {
            MapRDBImpl.deleteTable((String)table.getPath().toString());
        }
        String myTableName = "testUpdateTimeCompositeIndexScanWithCondition-table";
        table = DBTests.createOrReplaceTable(myTableName);
        String indexName = "testUpdateTimeIndexScanWithCondition-index";
        String indexedFields = "'$$timestamp,a.b'";
        String nonIndexedFields = "x.y";
        IndexDesc idxDesc = this.createIndex(table, indexName, indexedFields, nonIndexedFields);
        _logger.trace("Index " + indexName + " created for table " + table.getName() + " on  indexed fields " + indexedFields + " and non-indexed fields " + nonIndexedFields);
        int count = 10;
        this.testUpdateTimeIndexHelper(count, indexName, idxDesc);
        this.testUpdateTimeIndexHelper(count << 2, indexName, idxDesc);
    }

    private void testUpdateTimeIndexHelper(int count, String indexName, IndexDesc idxDesc) throws Exception {
        Document d;
        for (int i = 0; i < count; ++i) {
            Document d2 = MapRDBImpl.newDocument().set("a.b", i);
            String key = "key" + Integer.toString(i);
            table.insertOrReplace(key, d2);
            table.flush();
            Thread.sleep(1000L);
            _logger.trace("Inserted document: ( " + key + ", " + d2.toString() + " )");
        }
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)idxDesc);
        DocumentStream ds = indexTable.find();
        Iterator itr = ds.iterator();
        int resCount = 0;
        int lesser = 0;
        int greater = 0;
        OTimestamp refTime = null;
        while (itr.hasNext()) {
            Document d3 = (Document)itr.next();
            OTimestamp ts = d3.getTimestamp("$$timestamp");
            if (resCount < count / 2) {
                ++lesser;
            } else if (resCount == count / 2) {
                refTime = ts;
            } else {
                ++greater;
            }
            _logger.trace("Received Document " + Integer.toString(resCount) + ":" + d3.getIdString() + ", " + d3.asJsonString());
            ++resCount;
        }
        ds.close();
        ConditionImpl cond = MapRDBImpl.newCondition().is(Constants.LAST_MODIFIED_TIMESTAMP_FP, QueryCondition.Op.LESS, refTime).build();
        ds = indexTable.find((QueryCondition)cond);
        itr = ds.iterator();
        resCount = 0;
        while (itr.hasNext()) {
            d = (Document)itr.next();
            Assert.assertTrue((refTime.compareTo(d.getTimestamp("$$timestamp")) > 0 ? 1 : 0) != 0);
            ++resCount;
        }
        Assert.assertEquals((long)lesser, (long)resCount);
        ds.close();
        _logger.trace("LESS ok");
        cond = MapRDBImpl.newCondition().is("$$timestamp", QueryCondition.Op.EQUAL, refTime).build();
        ds = indexTable.find((QueryCondition)cond);
        itr = ds.iterator();
        resCount = 0;
        while (itr.hasNext()) {
            d = (Document)itr.next();
            Assert.assertTrue((refTime.compareTo(d.getTimestamp("$$timestamp")) == 0 ? 1 : 0) != 0);
            ++resCount;
        }
        Assert.assertEquals((long)1L, (long)resCount);
        ds.close();
        _logger.trace("EQUAL ok");
        cond = MapRDBImpl.newCondition().and().is("$$timestamp", QueryCondition.Op.GREATER_OR_EQUAL, refTime).is("a.b", QueryCondition.Op.LESS, 9).close().build();
        ds = indexTable.find((QueryCondition)cond);
        itr = ds.iterator();
        resCount = 0;
        while (itr.hasNext()) {
            d = (Document)itr.next();
            Assert.assertTrue((refTime.compareTo(d.getTimestamp("$$timestamp")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((d.getInt("a.b") < 9 ? 1 : 0) != 0);
            ++resCount;
        }
        Assert.assertTrue((resCount <= greater + 1 ? 1 : 0) != 0);
        ds.close();
        _logger.trace("GREATER_OR_EQUAL ok");
    }

    @Test
    @Ignore(value="Enable after Bugzilla Bug 27311 is fixed.")
    public void testIndexTabletInfos() throws Exception {
        Assert.assertNotNull((Object)table);
        String indexName = "testIndexTabletInfos-index";
        IndexDesc i1Desc = this.createIndex(table, indexName, "a.b.c", "a.c.d");
        MapRDBIndexImpl index = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        TabletInfo[] tablets = index.getTabletInfos();
        Assert.assertEquals((long)1L, (long)tablets.length);
    }

    @Test
    public void testWithNonJsonTable() throws Exception {
        Path tPath = DBTests.getTablePath("binarytable1");
        if (FSTests.maprfs().exists(tPath)) {
            _logger.info("Table {} exists, deleting.", (Object)tPath);
            FSTests.maprfs().delete(tPath);
        }
        String tableCreateCommand = "maprcli table create -path " + tPath.toString() + " -tabletype binary";
        TestCluster.runCommand((String)tableCreateCommand);
        try {
            Collection indexList = DBTests.admin().getTableIndexes(tPath, true);
            Assert.fail((String)"Expected DBException");
        }
        catch (DBException dBException) {
            // empty catch block
        }
        FSTests.maprfs().delete(tPath);
    }

    @Test
    public void testIndexSizeOf() throws Exception {
        String indexName = "testIndexSizeOf-index";
        IndexDesc i1desc = this.createIndex(table, indexName, "a", "w.x.y");
        Table index = MapRDBImpl.getIndexTable((IndexDesc)i1desc);
        String val = "aaaaa";
        byte[] byteVal = val.getBytes();
        Document d1 = MapRDBImpl.newDocument().set("a", ByteBufs.wrap((byte[])byteVal));
        Document d2 = MapRDBImpl.newDocument().set("a", "bbbbb");
        String val2 = "ccc";
        byte[] byteVal2 = val2.getBytes();
        Document d3 = MapRDBImpl.newDocument().set("a", ByteBufs.wrap((byte[])byteVal2));
        String val3 = "dddddd";
        byte[] byteVal3 = val3.getBytes();
        Document d4 = MapRDBImpl.newDocument().set("a", ByteBufs.wrap((byte[])byteVal3));
        try {
            table.insert("key1", d1);
            table.insert("key2", d2);
            table.insert("key3", d3);
            table.insert("key4", d4);
            table.flush();
        }
        catch (Exception e) {
            Assert.fail();
        }
        DBTests.waitForIndexFlush(table.getPath());
        QueryCondition cond = MapRDBImpl.newCondition().sizeOf("a", QueryCondition.Op.GREATER, 4L).build();
        DocumentStream ds = index.find(cond);
        Iterator itr = ds.iterator();
        int count = 0;
        while (itr.hasNext()) {
            Object value;
            Document doc = (Document)itr.next();
            if (doc.getIdString().equals("key1")) {
                value = doc.getBinary("a");
                Assert.assertTrue((boolean)Arrays.equals(((ByteBuffer)value).array(), byteVal));
            } else if (doc.getIdString().equals("key2")) {
                value = doc.getString("a");
                Assert.assertEquals((Object)"bbbbb", (Object)value);
            } else {
                Assert.assertEquals((Object)"key4", (Object)doc.getIdString());
                value = doc.getBinary("a");
                Assert.assertTrue((boolean)Arrays.equals(((ByteBuffer)value).array(), byteVal3));
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testBug29117() throws Exception {
        String tabName = "/testBug29117";
        Table tab = DBTests.createOrReplaceTable(tabName);
        Assert.assertNotNull((Object)tab);
        IndexDesc i1Desc = this.createIndex(tab, "i1", "a.b", "x.y");
        Document doc = MapRDB.newDocument().set("x.z", "xz");
        tab.insertOrReplace("key4", doc);
        DBTests.waitForIndexFlush(tab.getPath());
        tab.delete("key4");
        DBTests.waitForIndexFlush(tab.getPath());
        MapRDBIndexImpl index1 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = index1.find();
        Iterator itr = ds.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testRowReinsert() throws Exception {
        String tabName = "/testRowReinsert-test";
        Table tab = DBTests.createOrReplaceTable(tabName);
        Assert.assertNotNull((Object)tab);
        IndexDesc i1Desc = this.createIndex(tab, "i1", "a.a_int", null);
        DBTests.waitForIndexFlush(tab.getPath());
        Document doc1 = MapRDB.newDocument().set("a.a_int", 11);
        try {
            tab.insertOrReplace("key1", MapRDB.newDocument().set("a.a_int", 11));
            tab.insertOrReplace("key1", MapRDB.newDocument().set("a.b_int", 11));
            tab.insertOrReplace("key1", MapRDB.newDocument().set("a.a_int", 11));
        }
        catch (Exception e) {
            _logger.error("Insert failed: " + e.getMessage());
            throw e;
        }
        DBTests.waitForIndexFlush(tab.getPath());
        MapRDBIndexImpl index1 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = index1.find();
        Iterator itr = ds.iterator();
        int numDocs = 0;
        while (itr.hasNext()) {
            ++numDocs;
            itr.next();
        }
        Assert.assertEquals((long)1L, (long)numDocs);
    }

    @Test
    public void testMultiIndex() throws Exception {
        String tabName = "/testMultiIndex-test";
        Table tab = DBTests.createOrReplaceTable(tabName);
        Assert.assertNotNull((Object)tab);
        IndexDesc i1Desc = this.createIndex(tab, "i1", "a", null);
        IndexDesc i2Desc = this.createIndex(tab, "i2", "b", null);
        DBTests.waitForIndexFlush(tab.getPath());
        Document d1 = MapRDB.newDocument().set("a", 11).set("b", 22).set("c", 33);
        tab.insertOrReplace("1", d1);
        tab.flush();
        tab.update("1", MapRDBImpl.newMutation().setOrReplace("a", 111));
        tab.flush();
        tab.update("1", MapRDBImpl.newMutation().setOrReplace("b", 222));
        tab.flush();
        DBTests.waitForIndexFlush(tab.getPath());
        MapRDBIndexImpl index1 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = index1.find();
        int count = 0;
        for (Document d : ds) {
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        MapRDBIndexImpl index2 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i2Desc);
        ds = index2.find();
        count = 0;
        for (Document d : ds) {
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testIndexWithNestedFields() throws Exception {
        String tabName = "/testIndexWithNestedFields-test";
        Table tab = DBTests.createOrReplaceTable(tabName);
        Assert.assertNotNull((Object)tab);
        IndexDesc i1Desc = this.createIndex(tab, "i1", "a.b.c", "a.b,a.b.d");
        IndexDesc i2Desc = this.createIndex(tab, "i2", "a.b", "a.b.c,a.b.d");
        IndexDesc i3Desc = this.createIndex(tab, "i3", "a.b.c", "a.b.c.d,a.b,a.b.d");
        IndexDesc i4Desc = this.createIndex(tab, "i4", "a.b.c", "a.b.d,a.b,a.b.d.e,a.b.d.f");
        DBTests.waitForIndexFlush(tab.getPath());
        Document doc1 = MapRDB.newDocument().set("a.b.c", 1000).set("a.b.d", 2000);
        Document doc1cleanup = MapRDB.newDocument().set("a.b.c", 1001).set("a.b.d", 2001);
        Document doc2 = MapRDB.newDocument().set("a.b", 100);
        Document doc2cleanup = MapRDB.newDocument().set("a.b", 101);
        Document doc3 = MapRDB.newDocument().set("a.b.c.d", 3000).set("a.b.d", 4000);
        Document doc3cleanup = MapRDB.newDocument().set("a.b.c.d", 3001).set("a.b.d", 4001);
        Document doc4 = MapRDB.newDocument().set("a.b.c", 5000).set("a.b.d.e", 6000).set("a.b.d.f", 7000);
        Document doc4cleanup = MapRDB.newDocument().set("a.b.c", 5001).set("a.b.d.e", 6001).set("a.b.d.f", 7001);
        try {
            tab.insertOrReplace("key1", doc1);
            tab.insertOrReplace("key2", doc2);
            tab.insertOrReplace("key3", doc3);
            tab.insertOrReplace("key4", doc4);
            tab.flush();
        }
        catch (Exception e) {
            _logger.error("Insert failed: " + e.getMessage());
            throw e;
        }
        DBTests.waitForIndexFlush(tab.getPath());
        MapRDBIndexImpl index1 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        DocumentStream ds = index1.find();
        Iterator itr = ds.iterator();
        int numDocs = 0;
        block100: while (itr.hasNext()) {
            ++numDocs;
            Document readDoc = (Document)itr.next();
            switch (readDoc.getString("_id")) {
                case "key1": {
                    Assert.assertEquals((long)1000L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)2000L, (long)readDoc.getInt("a.b.d"));
                    continue block100;
                }
                case "key2": {
                    Assert.assertEquals((long)100L, (long)readDoc.getInt("a.b"));
                    continue block100;
                }
                case "key3": {
                    Assert.assertEquals((long)4000L, (long)readDoc.getInt("a.b.d"));
                    Assert.assertEquals((long)3000L, (long)readDoc.getInt("a.b.c.d"));
                    continue block100;
                }
                case "key4": {
                    Assert.assertEquals((long)5000L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)6000L, (long)readDoc.getInt("a.b.d.e"));
                    Assert.assertEquals((long)7000L, (long)readDoc.getInt("a.b.d.f"));
                    continue block100;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)numDocs);
        ds.close();
        MapRDBIndexImpl index2 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i2Desc);
        ds = index2.find();
        itr = ds.iterator();
        numDocs = 0;
        block101: while (itr.hasNext()) {
            ++numDocs;
            Document readDoc = (Document)itr.next();
            switch (readDoc.getString("_id")) {
                case "key1": {
                    Assert.assertEquals((long)1000L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)2000L, (long)readDoc.getInt("a.b.d"));
                    continue block101;
                }
                case "key2": {
                    Assert.assertEquals((long)100L, (long)readDoc.getInt("a.b"));
                    continue block101;
                }
                case "key3": {
                    Assert.assertEquals((long)4000L, (long)readDoc.getInt("a.b.d"));
                    Assert.assertEquals((long)3000L, (long)readDoc.getInt("a.b.c.d"));
                    continue block101;
                }
                case "key4": {
                    Assert.assertEquals((long)5000L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)6000L, (long)readDoc.getInt("a.b.d.e"));
                    Assert.assertEquals((long)7000L, (long)readDoc.getInt("a.b.d.f"));
                    continue block101;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)numDocs);
        ds.close();
        MapRDBIndexImpl index3 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i3Desc);
        ds = index3.find();
        itr = ds.iterator();
        numDocs = 0;
        block102: while (itr.hasNext()) {
            ++numDocs;
            Document readDoc = (Document)itr.next();
            switch (readDoc.getString("_id")) {
                case "key1": {
                    Assert.assertEquals((long)1000L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)2000L, (long)readDoc.getInt("a.b.d"));
                    continue block102;
                }
                case "key2": {
                    Assert.assertEquals((long)100L, (long)readDoc.getInt("a.b"));
                    continue block102;
                }
                case "key3": {
                    Assert.assertEquals((long)4000L, (long)readDoc.getInt("a.b.d"));
                    Assert.assertEquals((long)3000L, (long)readDoc.getInt("a.b.c.d"));
                    continue block102;
                }
                case "key4": {
                    Assert.assertEquals((long)5000L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)6000L, (long)readDoc.getInt("a.b.d.e"));
                    Assert.assertEquals((long)7000L, (long)readDoc.getInt("a.b.d.f"));
                    continue block102;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)numDocs);
        ds.close();
        MapRDBIndexImpl index4 = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)i4Desc);
        ds = index4.find();
        itr = ds.iterator();
        numDocs = 0;
        block103: while (itr.hasNext()) {
            ++numDocs;
            Document readDoc = (Document)itr.next();
            switch (readDoc.getString("_id")) {
                case "key1": {
                    Assert.assertEquals((long)1000L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)2000L, (long)readDoc.getInt("a.b.d"));
                    continue block103;
                }
                case "key2": {
                    Assert.assertEquals((long)100L, (long)readDoc.getInt("a.b"));
                    continue block103;
                }
                case "key3": {
                    Assert.assertEquals((long)4000L, (long)readDoc.getInt("a.b.d"));
                    Assert.assertEquals((long)3000L, (long)readDoc.getInt("a.b.c.d"));
                    continue block103;
                }
                case "key4": {
                    Assert.assertEquals((long)5000L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)6000L, (long)readDoc.getInt("a.b.d.e"));
                    Assert.assertEquals((long)7000L, (long)readDoc.getInt("a.b.d.f"));
                    continue block103;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)numDocs);
        ds.close();
        try {
            tab.insertOrReplace("key1", doc1cleanup);
            tab.insertOrReplace("key2", doc2cleanup);
            tab.insertOrReplace("key3", doc3cleanup);
            tab.insertOrReplace("key4", doc4cleanup);
            tab.flush();
        }
        catch (Exception e) {
            _logger.error("Insert failed: " + e.getMessage());
            throw e;
        }
        DBTests.waitForIndexFlush(tab.getPath());
        ds = index1.find();
        itr = ds.iterator();
        numDocs = 0;
        block104: while (itr.hasNext()) {
            ++numDocs;
            Document readDoc = (Document)itr.next();
            switch (readDoc.getString("_id")) {
                case "key1": {
                    Assert.assertEquals((long)1001L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)2001L, (long)readDoc.getInt("a.b.d"));
                    continue block104;
                }
                case "key2": {
                    Assert.assertEquals((long)101L, (long)readDoc.getInt("a.b"));
                    continue block104;
                }
                case "key3": {
                    Assert.assertEquals((long)4001L, (long)readDoc.getInt("a.b.d"));
                    Assert.assertEquals((long)3001L, (long)readDoc.getInt("a.b.c.d"));
                    continue block104;
                }
                case "key4": {
                    Assert.assertEquals((long)5001L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)6001L, (long)readDoc.getInt("a.b.d.e"));
                    Assert.assertEquals((long)7001L, (long)readDoc.getInt("a.b.d.f"));
                    continue block104;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)numDocs);
        ds.close();
        ds = index2.find();
        itr = ds.iterator();
        numDocs = 0;
        block105: while (itr.hasNext()) {
            ++numDocs;
            Document readDoc = (Document)itr.next();
            switch (readDoc.getString("_id")) {
                case "key1": {
                    Assert.assertEquals((long)1001L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)2001L, (long)readDoc.getInt("a.b.d"));
                    continue block105;
                }
                case "key2": {
                    Assert.assertEquals((long)101L, (long)readDoc.getInt("a.b"));
                    continue block105;
                }
                case "key3": {
                    Assert.assertEquals((long)4001L, (long)readDoc.getInt("a.b.d"));
                    Assert.assertEquals((long)3001L, (long)readDoc.getInt("a.b.c.d"));
                    continue block105;
                }
                case "key4": {
                    Assert.assertEquals((long)5001L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)6001L, (long)readDoc.getInt("a.b.d.e"));
                    Assert.assertEquals((long)7001L, (long)readDoc.getInt("a.b.d.f"));
                    continue block105;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)numDocs);
        ds.close();
        ds = index3.find();
        itr = ds.iterator();
        numDocs = 0;
        block106: while (itr.hasNext()) {
            ++numDocs;
            Document readDoc = (Document)itr.next();
            switch (readDoc.getString("_id")) {
                case "key1": {
                    Assert.assertEquals((long)1001L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)2001L, (long)readDoc.getInt("a.b.d"));
                    continue block106;
                }
                case "key2": {
                    Assert.assertEquals((long)101L, (long)readDoc.getInt("a.b"));
                    continue block106;
                }
                case "key3": {
                    Assert.assertEquals((long)4001L, (long)readDoc.getInt("a.b.d"));
                    Assert.assertEquals((long)3001L, (long)readDoc.getInt("a.b.c.d"));
                    continue block106;
                }
                case "key4": {
                    Assert.assertEquals((long)5001L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)6001L, (long)readDoc.getInt("a.b.d.e"));
                    Assert.assertEquals((long)7001L, (long)readDoc.getInt("a.b.d.f"));
                    continue block106;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)numDocs);
        ds.close();
        ds = index4.find();
        itr = ds.iterator();
        numDocs = 0;
        block107: while (itr.hasNext()) {
            ++numDocs;
            Document readDoc = (Document)itr.next();
            switch (readDoc.getString("_id")) {
                case "key1": {
                    Assert.assertEquals((long)1001L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)2001L, (long)readDoc.getInt("a.b.d"));
                    continue block107;
                }
                case "key2": {
                    Assert.assertEquals((long)101L, (long)readDoc.getInt("a.b"));
                    continue block107;
                }
                case "key3": {
                    Assert.assertEquals((long)4001L, (long)readDoc.getInt("a.b.d"));
                    Assert.assertEquals((long)3001L, (long)readDoc.getInt("a.b.c.d"));
                    continue block107;
                }
                case "key4": {
                    Assert.assertEquals((long)5001L, (long)readDoc.getInt("a.b.c"));
                    Assert.assertEquals((long)6001L, (long)readDoc.getInt("a.b.d.e"));
                    Assert.assertEquals((long)7001L, (long)readDoc.getInt("a.b.d.f"));
                    continue block107;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)numDocs);
        ds.close();
    }

    @Test
    public void testNullIsLast() throws Exception {
        String testTable = "testtable-testNullIsLast";
        Table t = DBTests.createOrReplaceTable(testTable);
        Assert.assertNotNull((Object)t);
        IndexDesc i1Desc = this.createIndex(t, "idx", "a,b", null);
        DocumentMutation mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", 100000);
        t.update("fromInt", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("b", "abcd");
        t.update("fromMissing", mut);
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", "10:01:02.750");
        t.update("fromString", mut);
        ODate date = ODate.parse((String)"1977-05-20");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", date);
        t.update("fromDate", mut);
        OTime t1 = OTime.parse((String)"12:00:00.000");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", t1);
        t.update("fromTime", mut);
        OTimestamp ts = OTimestamp.parse((String)"1977-01-02T04:59:59.267Z");
        mut = MapRDBImpl.newMutation();
        mut.setOrReplace("a", ts);
        t.update("fromTimestamp", mut);
        mut = MapRDBImpl.newMutation();
        mut.setNull("a");
        t.update("fromNull", mut);
        t.flush();
        DBTests.waitForIndexFlush(t.getPath());
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        Iterator dsItr = indexTable.find().iterator();
        Document doc = (Document)dsItr.next();
        Assert.assertTrue((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromString", (Object)doc.getIdString());
        doc = (Document)dsItr.next();
        Assert.assertTrue((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromDate", (Object)doc.getIdString());
        doc = (Document)dsItr.next();
        Assert.assertTrue((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTime", (Object)doc.getIdString());
        doc = (Document)dsItr.next();
        Assert.assertTrue((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromTimestamp", (Object)doc.getIdString());
        doc = (Document)dsItr.next();
        Assert.assertTrue((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromInt", (Object)doc.getIdString());
        doc = (Document)dsItr.next();
        Assert.assertTrue((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromNull", (Object)doc.getIdString());
        doc = (Document)dsItr.next();
        Assert.assertFalse((boolean)dsItr.hasNext());
        Assert.assertEquals((Object)"fromMissing", (Object)doc.getIdString());
        DBTests.deleteTables(testTable);
    }

    @Test
    public void testIndexesAndReplication() throws Exception {
        Document readDoc;
        String tName = "testIndexesAndReplication-table";
        String rName1 = "/testIndexesAndReplication-replica1";
        String rName2 = "/testIndexesAndReplication-replica2";
        String iName = "testIndexesAndReplication-index";
        String indexedFields = "a[].b,a[].c";
        Admin admin = MapRDBImpl.newAdmin();
        if (admin.tableExists(rName1)) {
            admin.deleteTable(rName1);
        }
        if (admin.tableExists(rName2)) {
            admin.deleteTable(rName2);
        }
        Table srcTable = DBTests.createOrGetTable(tName);
        MapRDBTableImpl replicaTable1 = DBTests.createReplica(srcTable.getPath().toString(), rName1, true, null, false, false);
        IndexDesc iDesc = this.createIndex(srcTable, iName, indexedFields, null);
        Table indexTable = MapRDB.getIndexTable((IndexDesc)iDesc);
        Document doc1 = MapRDBImpl.newDocument().set("a.b", "ab").set("a.c", "ac").set("x.y", "xy");
        Document doc2 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab1").set("c", "ac1"), MapRDBImpl.newDocument().set("b", "ab2").set("c", "ac2")}).set("x.y", "xy");
        srcTable.insert("key1", doc1);
        srcTable.insert("key2", doc2);
        srcTable.flush();
        Thread.sleep(3000L);
        DocumentStream ds = replicaTable1.find();
        Iterator itr = ds.iterator();
        int count = 0;
        while (itr.hasNext()) {
            readDoc = (Document)itr.next();
            ++count;
            switch (readDoc.getIdString()) {
                case "key1": {
                    Assert.assertEquals((Object)"ab", (Object)readDoc.getString("a.b"));
                    Assert.assertEquals((Object)"ac", (Object)readDoc.getString("a.c"));
                    Assert.assertEquals((Object)"xy", (Object)readDoc.getString("x.y"));
                    break;
                }
                case "key2": {
                    Assert.assertEquals((Object)"ab1", (Object)readDoc.getString("a[0].b"));
                    Assert.assertEquals((Object)"ab2", (Object)readDoc.getString("a[1].b"));
                    Assert.assertEquals((Object)"ac1", (Object)readDoc.getString("a[0].c"));
                    Assert.assertEquals((Object)"ac2", (Object)readDoc.getString("a[1].c"));
                    Assert.assertEquals((Object)"xy", (Object)readDoc.getString("x.y"));
                }
            }
        }
        Assert.assertEquals((long)2L, (long)count);
        ds.close();
        ds = ((MapRDBIndexImpl)indexTable).setDecodeIndexValues(true).find();
        itr = ds.iterator();
        count = 0;
        block17: while (itr.hasNext()) {
            readDoc = (Document)itr.next();
            ++count;
            switch (readDoc.getIdString()) {
                case "key1": {
                    Assert.assertEquals((Object)"ab", (Object)readDoc.getString("$idx[0]"));
                    Assert.assertEquals((Object)"ac", (Object)readDoc.getString("$idx[1]"));
                    Assert.assertNull((Object)readDoc.getValue("x.y"));
                    continue block17;
                }
                case "key2": {
                    if (readDoc.getString("$idx[0]").equals("ab1")) {
                        Assert.assertEquals((Object)"ac1", (Object)readDoc.getString("$idx[1]"));
                    } else {
                        Assert.assertEquals((Object)"ab2", (Object)readDoc.getString("$idx[0]"));
                        Assert.assertEquals((Object)"ac2", (Object)readDoc.getString("$idx[1]"));
                    }
                    Assert.assertNull((Object)readDoc.getValue("x.y"));
                    continue block17;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)3L, (long)count);
        ds.close();
    }

    private void unsupportedArrayIndexesShouldFail(Table t, String idxName, String indexedFields) throws Exception {
        String idxAddCmd = "maprcli table index add -path " + t.getPath().toString() + " -index " + idxName + " -indexedfields " + indexedFields;
        String errorString = "AddTableIndex failed, error (22)";
        RunCommand result = TestCluster.runCommand((String)idxAddCmd);
        IndexDesc idx = this.getIndex(t, idxName);
        Assert.assertTrue((result.getExitCode() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.getStdErr().contains(errorString));
        Assert.assertNull((Object)idx);
    }

    @Test
    public void testUnsupportedArrayIndexes() throws Exception {
        String tName = "/testUnsupportedArrayIndexes-table";
        String iName = "testUnsupportedArrayIndexes-index";
        Table t1 = DBTests.createOrGetTable(tName);
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[],x[]");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[][],x[]");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[].b,c[].d");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[].b,c.d[]");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[].b[],a[].c[]");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[].b[].c,a[].b.c[]");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[].b[].c[],a[].b[].d[]");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[].b,a[].d,c[].d");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[0].b");
        this.unsupportedArrayIndexesShouldFail(t1, iName, "a[][1].b");
    }

    private void supportedComplexArrayIndexesShouldSucceed(Table t, String idxName, String indexedFields) throws Exception {
        String idxAddCmd = "maprcli table index add -path " + t.getPath().toString() + " -index " + idxName + " -indexedfields " + indexedFields;
        RunCommand result = TestCluster.runCommand((String)idxAddCmd);
        Assert.assertTrue((result.getExitCode() == 0 ? 1 : 0) != 0);
        DBTests.waitForSchemaUpdate();
        IndexDesc idx = this.getIndex(t, idxName);
        Assert.assertNotNull((Object)idx);
    }

    @Test
    public void testSupportedComplexArrayIndexes() throws Exception {
        String tName = "/testSupportedComplexArrayIndexes-table";
        String iName = "testSupportedComplexArrayIndexes-index";
        Table t1 = DBTests.createOrGetTable(tName);
        int idxCount = 0;
        this.supportedComplexArrayIndexesShouldSucceed(t1, iName + Integer.toString(++idxCount), "m,n[]");
        this.supportedComplexArrayIndexesShouldSucceed(t1, iName + Integer.toString(++idxCount), "c,d[][]");
        this.supportedComplexArrayIndexesShouldSucceed(t1, iName + Integer.toString(++idxCount), "a[].d,a[].b[].d,a[].b[].c[].d");
    }

    @Test
    public void testIndexScanExcludeId_MAPRDB_1106() throws Exception {
        Document parsedDoc;
        Assert.assertNotNull((Object)table);
        IndexDesc idesc = this.getIndex(table, INDEX_NAME);
        assert (idesc.getIncludedFields().size() > 0);
        MapRDBIndexImpl index = ((MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)idesc)).setDecodeIndexValues(true);
        index.setOption(Table.TableOption.EXCLUDEID, false);
        DocumentStream ds = index.find();
        for (Document readDoc : ds) {
            Assert.assertNotNull((Object)readDoc.getId());
            parsedDoc = Json.newDocument((String)readDoc.asJsonString());
            Assert.assertNotNull((Object)parsedDoc.getId());
        }
        ds.close();
        index.setOption(Table.TableOption.EXCLUDEID, true);
        ds = index.find();
        for (Document readDoc : ds) {
            Assert.assertNotNull((Object)readDoc.getId());
            parsedDoc = Json.newDocument((String)readDoc.asJsonString());
            Assert.assertNull((Object)parsedDoc.getId());
        }
        ds.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIndexScan_illegalElementAnd() throws Exception {
        String tName = "testIndexScan_illegalElementAnd-table";
        String iName = "testIndexScan_illegalElementAnd-index";
        String[] indexedFields = new String[]{"a[].b", "a[].c"};
        try (Table t1 = DBTests.createOrGetTable("testIndexScan_illegalElementAnd-table");){
            DBTests.createIndex("testIndexScan_illegalElementAnd-table", "testIndexScan_illegalElementAnd-index", indexedFields);
            Document d1 = MapRDBImpl.newDocument().set("a.b", "ab").set("a.c", "ac1");
            Document d2 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab").set("c", "ac")});
            Document d3 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab1").set("c", "ac2")});
            Document d4 = MapRDBImpl.newDocument().set("a.b", "ab");
            Document d5 = MapRDBImpl.newDocument().set("x.y", "xy");
            t1.insertOrReplace("key1", d1);
            t1.insertOrReplace("key2", d2);
            t1.insertOrReplace("key3", d3);
            t1.insertOrReplace("key4", d4);
            t1.insertOrReplace("key5", d5);
            t1.flush();
            DBTests.waitForIndexFlush("testIndexScan_illegalElementAnd-table");
            IndexDesc idesc = this.getIndex(t1, "testIndexScan_illegalElementAnd-index");
            MapRDBIndexImpl index = ((MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)idesc)).setDecodeIndexValues(true);
            ConditionImpl qc = MapRDBImpl.newCondition().elementAnd("a[]").is("b", QueryCondition.Op.NOT_EQUAL, "ab").is("c", QueryCondition.Op.NOT_EQUAL, "ac").close().build();
            DocumentStream ds = index.find((QueryCondition)qc);
            Throwable throwable = null;
            if (ds != null) {
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ds.close();
                }
            }
        }
    }

    @Test
    public void testIndexScanNotEqualCondition() throws Exception {
        String tName = "testIndexScanNotEqualCondition-table";
        String iName = "testIndexScanNotEqualCondition-index";
        String[] indexedFields = new String[]{"a[].b", "a[].c"};
        try (Table t1 = DBTests.createOrGetTable("testIndexScanNotEqualCondition-table");){
            DBTests.createIndex("testIndexScanNotEqualCondition-table", "testIndexScanNotEqualCondition-index", indexedFields);
            Document d1 = MapRDBImpl.newDocument().set("a.b", "ab").set("a.c", "ac1");
            Document d2 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab").set("c", "ac")});
            Document d3 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab1").set("c", "ac2")});
            Document d4 = MapRDBImpl.newDocument().set("a.b", "ab");
            Document d5 = MapRDBImpl.newDocument().set("x.y", "xy");
            t1.insertOrReplace("key1", d1);
            t1.insertOrReplace("key2", d2);
            t1.insertOrReplace("key3", d3);
            t1.insertOrReplace("key4", d4);
            t1.insertOrReplace("key5", d5);
            t1.flush();
            DBTests.waitForIndexFlush("testIndexScanNotEqualCondition-table");
            IndexDesc idesc = this.getIndex(t1, "testIndexScanNotEqualCondition-index");
            try (MapRDBIndexImpl index = ((MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)idesc)).setDecodeIndexValues(true);){
                ConditionImpl qc = MapRDBImpl.newCondition().and().is("a[].b", QueryCondition.Op.NOT_EQUAL, "ab").is("a[].c", QueryCondition.Op.NOT_EQUAL, "ac").close().build();
                List rr = index.getRowkeyRanges((QueryCondition)qc);
                Assert.assertEquals((long)1L, (long)rr.size());
                Assert.assertEquals((Object)MapRConstants.EMPTY_BYTE_ARRAY, (Object)((ConditionNode.RowkeyRange)rr.get(0)).getStartRow());
                Assert.assertEquals((Object)MapRConstants.EMPTY_BYTE_ARRAY, (Object)((ConditionNode.RowkeyRange)rr.get(0)).getStopRow());
                try (DocumentStream ds = index.find((QueryCondition)qc);){
                    Iterator itr = ds.iterator();
                    ImmutableSet expectedKeys = new ImmutableSet.Builder().add((Object)"key3").add((Object)"key5").build();
                    HashSet<String> gotKeys = new HashSet<String>(expectedKeys.size());
                    HashSet<String> extraKeys = new HashSet<String>(expectedKeys.size());
                    int retCount = 0;
                    while (itr.hasNext()) {
                        Document readDoc = (Document)itr.next();
                        String id = readDoc.getIdString();
                        if (expectedKeys.contains((Object)id)) {
                            ++retCount;
                            gotKeys.add(id);
                            continue;
                        }
                        extraKeys.add(id);
                    }
                    Assert.assertEquals((String)("didn't receive all expected keys; missing " + new HashSet(expectedKeys).removeAll(gotKeys)), (long)expectedKeys.size(), (long)gotKeys.size());
                    Assert.assertEquals((String)("some keys were returned more than once, retCount = " + retCount), (long)retCount, (long)expectedKeys.size());
                    Assert.assertTrue((String)("received unexpected documents, _ids: " + extraKeys), (boolean)extraKeys.isEmpty());
                }
            }
        }
    }

    @Test
    public void testIndexScan_MAPRDB_1106() throws Exception {
        String tName = "testIndexScan_MAPRDB_1106-table";
        String iName = "testIndexScan_MAPRDB_1106-index";
        Table t = DBTests.createOrGetTable(tName);
        String[] indexedFields = new String[]{"a[].b"};
        String[] includedFields = new String[]{"a[].c"};
        DBTests.createIndex(tName, iName, indexedFields, includedFields);
        IndexDesc iDesc = this.getIndex(t, iName);
        Table iTable = MapRDBImpl.getIndexTable((IndexDesc)iDesc);
        iTable.setOption(Table.TableOption.BUFFERWRITE, false);
        iTable.setOption(Table.TableOption.EXCLUDEID, true);
        Document d = MapRDBImpl.newDocument().set("a.b", "ab").set("a.c", "ac");
        t.insertOrReplace("key1", d);
        t.flush();
        DBTests.waitForIndexFlush(t.getPath());
        try (DocumentStream docs = ((MapRDBIndexImpl)iTable).setDecodeIndexValues(true).find();){
            for (Document doc : docs) {
                Assert.assertNotNull((Object)doc.getId());
                Assert.assertEquals((Object)"ac", (Object)doc.getString("a.c"));
                Assert.assertEquals((Object)"ab", (Object)doc.getString("$idx[0]"));
                String docString = doc.asJsonString();
                Document parsedDoc = Json.newDocument((String)docString);
                Assert.assertNull((Object)parsedDoc.getString("_id"));
                Assert.assertEquals((Object)"ac", (Object)parsedDoc.getString("a.c"));
                Assert.assertEquals((Object)"ab", (Object)parsedDoc.getString("$idx[0]"));
            }
        }
    }

    @Test
    @Ignore(value="https://maprdrill.atlassian.net/browse/MAPRDB-1430")
    public void testHashedArrayIndexScanWithCondition_MAPRDB_1357() throws Exception {
        String tName = "testHashedArrayIndexScanWithCondition-table";
        String iName = "testHashedArrayIndexScanWithCondition-index";
        Table t = DBTests.createOrReplaceTable(tName);
        Document d1 = MapRDBImpl.newDocument().set("a.b", "ab1").set("a.c", "ac1");
        Document d2 = MapRDBImpl.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab1").set("c", "ac2"), MapRDBImpl.newDocument().set("b", "ab2").set("c", "ac1"), MapRDBImpl.newDocument().set("b", "ab1").set("c", "ac1")});
        Document d3 = MapRDBImpl.newDocument().set("a.b", "ab2").set("a.c", "ac1");
        t.insertOrReplace("key1", d1);
        t.insertOrReplace("key2", d2);
        t.insertOrReplace("key3", d1);
        t.insertOrReplace("key4", d2);
        t.insertOrReplace("key5", d3);
        String[] indexedFields = new String[]{"a[].b", "a[].c"};
        String[] includedFields = new String[]{"a[].c"};
        DBTests.createIndex(tName, iName, indexedFields, null);
        DBTests.waitForIndexFlush(t.getPath());
        IndexDesc iDesc = this.getIndex(t, iName);
        Table iTable = MapRDBImpl.getIndexTable((IndexDesc)iDesc);
        ((MapRDBIndexImpl)iTable).setDecodeIndexValues(true);
        ConditionImpl qc = MapRDBImpl.newCondition().and().is("a[].b", QueryCondition.Op.EQUAL, "ab1").or().is("a[].c", QueryCondition.Op.EQUAL, "ac1").is("_id", QueryCondition.Op.EQUAL, "key4").close().close().build();
        DocumentStream ds = iTable.find((QueryCondition)qc);
        Iterator itr = ds.iterator();
        int count = 0;
        block9: while (itr.hasNext()) {
            Document readDoc = (Document)itr.next();
            switch (readDoc.getIdString()) {
                case "key1": 
                case "key2": 
                case "key3": 
                case "key4": {
                    ++count;
                    continue block9;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)4L, (long)count);
        ds.close();
    }

    @Test
    public void testIndexScan_NonValueFilter() throws Exception {
        String tName = "testIndexScan_NonValueComparison-table";
        Table t1 = DBTests.createOrGetTable(tName);
        Document d1 = MapRDB.newDocument().set("a.b", 10.5);
        Document d2 = MapRDB.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab"), MapRDBImpl.newDocument().set("b", "ab1"), MapRDBImpl.newDocument().set("b", "AB2"), 10L});
        Document d3 = MapRDB.newDocument().setArray("a", new Object[]{MapRDBImpl.newDocument().set("b", "ab11"), MapRDBImpl.newDocument().set("b", "ab111"), 20.45});
        Document d4 = MapRDB.newDocument().set("a", "ab1");
        t1.insert("key1", d1);
        t1.insert("key2", d2);
        t1.insert("key3", d3);
        t1.insert("key4", d4);
        t1.flush();
        String[] indexedFields = new String[]{"a[].b"};
        String iName = "i1";
        DBTests.createIndex(tName, iName, indexedFields);
        DBTests.waitForIndexFlush(tName);
        IndexDesc i1Desc = this.getIndex(t1, iName);
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)i1Desc);
        ConditionImpl qc_typeOf = MapRDBImpl.newCondition().typeOf("a[].b", Value.Type.DOUBLE).build();
        DocumentStream ds = indexTable.find((QueryCondition)qc_typeOf);
        Iterator itr = ds.iterator();
        int count = 0;
        block36: while (itr.hasNext()) {
            Document d = (Document)itr.next();
            switch (d.getIdString()) {
                case "key1": {
                    ++count;
                    continue block36;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)1L, (long)count);
        ds.close();
        QueryCondition qc_sizeOf_1 = MapRDBImpl.newCondition().sizeOf("a[].b", QueryCondition.Op.LESS, 3L).build();
        ds = indexTable.find(qc_sizeOf_1);
        itr = ds.iterator();
        count = 0;
        block37: while (itr.hasNext()) {
            Document d = (Document)itr.next();
            switch (d.getIdString()) {
                case "key2": {
                    ++count;
                    continue block37;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)1L, (long)count);
        ds.close();
        QueryCondition qc_sizeOf_2 = MapRDBImpl.newCondition().sizeOf("a[].b", QueryCondition.Op.GREATER, 3L).build();
        ds = indexTable.find(qc_sizeOf_2);
        itr = ds.iterator();
        count = 0;
        block38: while (itr.hasNext()) {
            Document d = (Document)itr.next();
            switch (d.getIdString()) {
                case "key1": 
                case "key3": {
                    ++count;
                    continue block38;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)2L, (long)count);
        ds.close();
        QueryCondition qc_like = MapRDBImpl.newCondition().like("a[].b", "AB%").build();
        ds = indexTable.find(qc_like);
        itr = ds.iterator();
        count = 0;
        block39: while (itr.hasNext()) {
            Document d = (Document)itr.next();
            switch (d.getIdString()) {
                case "key2": {
                    ++count;
                    continue block39;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((long)1L, (long)count);
        ds.close();
    }

    @Test
    public void testIndexListWithPerms() throws Exception {
        String tName = "testIndexListWithPerms";
        String i1Name = "testIndexListWithPerms-i1";
        String i2Name = "testIndexListWithPerms-i2";
        String user = System.getProperty("user.name");
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "hits");
        Table t1 = DBTests.createOrReplaceTable(tName, cfMap);
        DBTests.setFieldAce(t1.getPath(), "default", "artists", Dbserver.DBAccessType.ColumnReadData, "!u:" + user);
        try {
            t1.insertOrReplace("key1", MapRDBImpl.newDocument().set("artists", 10));
        }
        catch (AccessDeniedException e) {
            _logger.info("insertOrReplace failed as expected");
        }
        String[] idxFields1 = new String[]{"hitsperpage", "hitsongs[]"};
        DBTests.createIndex(tName, i1Name, idxFields1);
        String[] idxFields2 = new String[]{"hits", "hitsperpage"};
        DBTests.createIndex(tName, i2Name, idxFields2);
        DBTests.waitForIndexFlush(tName);
        DocumentStream ds = t1.find();
        Iterator itr = ds.iterator();
        assert (itr.hasNext());
        IndexDesc i1Desc = this.getIndex(t1, i1Name);
        Assert.assertNotNull((Object)i1Desc);
        IndexDesc i2Desc = this.getIndex(t1, i2Name);
        Assert.assertNotNull((Object)i2Desc);
    }
}

