/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.fs.tables.TableBasicAttrs;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestTableOps
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestTableOps.class);
    private static final String TABLE_NAME = "testtable-TestTableOps";
    private static Table table;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        table.insertOrReplace(Datasets.SIMPLE_KEYS[0], Datasets.SIMPLE_RECORDS[0]);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testSimpleGet() throws IOException {
        Document d = MapRDBImpl.newDocument((String)"{ \"m\" : { \"a\" : 10, \"b\" : 20 } }");
        table.insertOrReplace("KEY", d);
        d = table.findById("KEY", new String[]{"m.c"});
        Assert.assertNotNull((Object)table.findById(Datasets.SIMPLE_KEYS[0]));
        Assert.assertNull((Object)table.findById(Datasets.SIMPLE_KEYS[1]));
    }

    @Test
    public void setWithUnicodeChar_Bug20501() throws Exception {
        FieldPath fp = FieldPath.parseFrom((String)"`\ud83c\udfda`");
        Document doc = MapRDBImpl.newDocument();
        doc.set(DocumentConstants.ID_FIELD, "r1");
        doc.set(fp, 1);
        table.insertOrReplace(doc);
        Assert.assertEquals((Object)doc.toString(), (Object)table.findById("r1").toString());
    }

    @Test
    public void testTableBasicAttrs() throws Exception {
        String myTableName = "testTableBasicAttrs-table";
        Table myTable = DBTests.createOrReplaceTable(myTableName);
        BaseJsonTable jsonTable = (BaseJsonTable)myTable;
        TableBasicAttrs basicattrs = jsonTable.maprTable().getMapRFS().getTableBasicAttrs(jsonTable.maprTable().getTablePath());
        Assert.assertEquals((Object)true, (Object)basicattrs.getIsJson());
        Assert.assertEquals((Object)false, (Object)basicattrs.getIsMarlinTable());
        Assert.assertEquals((Object)false, (Object)basicattrs.hasSecondaryIndex());
        DBTests.createIndex(myTableName, "i1", new String[]{"name.last"}, new String[]{"age"});
        Thread.sleep(10L);
        basicattrs = jsonTable.maprTable().getMapRFS().getTableBasicAttrs(jsonTable.maprTable().getTablePath());
        Assert.assertEquals((Object)true, (Object)basicattrs.getIsJson());
        Assert.assertEquals((Object)false, (Object)basicattrs.getIsMarlinTable());
        Assert.assertEquals((Object)true, (Object)basicattrs.hasSecondaryIndex());
        myTable.close();
        DBTests.deleteTables(myTableName);
    }

    @Test
    public void testRMWUpdateAfterSetOrReplace() throws Exception {
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        Document doc = MapRDBImpl.newDocument().set("a.b.c", 10).set("a.b.d", true);
        table.insertOrReplace("k6", doc);
        table.flush();
        DocumentMutation m = MapRDBImpl.newMutation().setOrReplace("a.b.c", 15);
        table.update("k6", m);
        Document md = MapRDBImpl.newDocument().set("b.c", 20);
        DocumentMutation m2 = MapRDBImpl.newMutation().merge("a", md);
        table.update("k6", m2);
        table.flush();
        Document result = table.findById("k6");
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document expected = MapRDBImpl.newDocument().set(DocumentConstants.ID_FIELD, "k6").set("a.b.d", true).set("a.b.c", 20);
        Assert.assertTrue((boolean)expected.equals(result));
    }

    @Test
    public void testCheckAndMutateAfterSetOrReplace() throws Exception {
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        Document doc = MapRDBImpl.newDocument().set("a.b.c", 10).set("a.b.d", true);
        table.insertOrReplace("k6", doc);
        table.flush();
        DocumentMutation m = MapRDBImpl.newMutation().setOrReplace("a.b.c", 15);
        table.update("k6", m);
        QueryCondition condition = MapRDBImpl.newCondition().is("a.b.d", QueryCondition.Op.EQUAL, true).build();
        Document md = MapRDBImpl.newDocument().set("b.c", 20);
        DocumentMutation m2 = MapRDBImpl.newMutation().merge("a", md);
        table.checkAndMutate("k6", condition, m2);
        table.flush();
        Document result = table.findById("k6");
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document expected = MapRDBImpl.newDocument().set(DocumentConstants.ID_FIELD, "k6").set("a.b.d", true).set("a.b.c", 20);
        Assert.assertTrue((boolean)expected.equals(result));
    }

    @Test
    public void testCheckAndReplaceAfterSetOrReplace() throws Exception {
        table.setOption(Table.TableOption.BUFFERWRITE, true);
        Document doc = MapRDBImpl.newDocument().set("a.b.c", 10).set("a.b.d", true);
        table.insertOrReplace("k6", doc);
        table.flush();
        DocumentMutation m = MapRDBImpl.newMutation().setOrReplace("a.b.c", 15);
        table.update("k6", m);
        QueryCondition condition = MapRDBImpl.newCondition().is("a.b.d", QueryCondition.Op.EQUAL, true).build();
        Document md = MapRDBImpl.newDocument().set("a.b.d", true).set("a.b.c", 20);
        table.checkAndReplace("k6", condition, md);
        table.flush();
        Document result = table.findById("k6");
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        Document expected = MapRDBImpl.newDocument().set(DocumentConstants.ID_FIELD, "k6").set("a.b.d", true).set("a.b.c", 20);
        Assert.assertTrue((boolean)expected.equals(result));
    }

    @Test
    public void testInNullFilter() throws Exception {
        String id;
        int ndocuments = 5;
        int nresults = 0;
        boolean result = false;
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        for (int i = 0; i < ndocuments; ++i) {
            Document rec = MapRDBImpl.newDocument().set("field1", i % 2);
            table.insertOrReplace("document" + i, rec);
        }
        table.flush();
        ArrayList target1 = new ArrayList();
        ConditionImpl condition = MapRDBImpl.newCondition().in("field1", target1).build();
        System.out.println("condition : " + condition.toString());
        DocumentStream results = table.find((QueryCondition)condition);
        for (Object document : results) {
            String id2 = document.getIdString();
            System.out.println(document.toString());
            ++nresults;
        }
        Assert.assertEquals((long)nresults, (long)0L);
        ArrayList<Integer> target2 = new ArrayList<Integer>();
        target2.add(0);
        condition = MapRDBImpl.newCondition().or().in("field1", target1).in("field1", target2).close().build();
        System.out.println("condition : " + condition.toString());
        nresults = 0;
        results = table.find((QueryCondition)condition);
        for (Document document : results) {
            id = document.getIdString();
            System.out.println(document.toString());
            ++nresults;
        }
        Assert.assertEquals((long)nresults, (long)3L);
        target2 = new ArrayList();
        target2.add(1);
        condition = MapRDBImpl.newCondition().and().in("field1", target1).in("field1", target2).close().build();
        System.out.println("condition : " + condition.toString());
        nresults = 0;
        results = table.find((QueryCondition)condition);
        for (Document document : results) {
            id = document.getIdString();
            System.out.println(document.toString());
            ++nresults;
        }
        Assert.assertEquals((long)nresults, (long)0L);
        condition = MapRDBImpl.newCondition().in("field1", target1).build();
        result = table.checkAndDelete("document0", (QueryCondition)condition);
        Assert.assertEquals((Object)result, (Object)false);
        target2 = new ArrayList();
        target2.add(0);
        condition = MapRDBImpl.newCondition().or().in("field1", target1).in("field1", target2).close().build();
        result = table.checkAndDelete("document0", (QueryCondition)condition);
        Assert.assertEquals((Object)result, (Object)true);
        Document newDoc = MapRDBImpl.newDocument().set("field1", 100);
        condition = MapRDBImpl.newCondition().in("field1", target1).build();
        result = table.checkAndReplace("document1", (QueryCondition)condition, newDoc);
        Assert.assertEquals((Object)result, (Object)false);
        target2 = new ArrayList();
        target2.add(1);
        condition = MapRDBImpl.newCondition().or().in("field1", target1).in("field1", target2).close().build();
        result = table.checkAndReplace("document1", (QueryCondition)condition, newDoc);
        Assert.assertEquals((Object)result, (Object)true);
        condition = MapRDBImpl.newCondition().in("field1", target1).build();
        DocumentMutation mut = MapRDBImpl.newMutation().decrement("field1", 99);
        result = table.checkAndMutate("document1", (QueryCondition)condition, mut);
        Assert.assertEquals((Object)result, (Object)false);
        target2 = new ArrayList();
        target2.add(100);
        condition = MapRDBImpl.newCondition().or().in("field1", target1).in("field1", target2).close().build();
        result = table.checkAndMutate("document1", (QueryCondition)condition, mut);
        Assert.assertEquals((Object)result, (Object)true);
        target2 = new ArrayList();
        target2.add(1);
        ArrayList<Integer> target3 = new ArrayList<Integer>();
        target3.add(0);
        target3.add(1);
        condition = MapRDBImpl.newCondition().or().and().in("field1", target1).in("field1", target2).close().in("field1", target3).close().build();
        System.out.println("condition : " + condition.toString());
        nresults = 0;
        results = table.find((QueryCondition)condition);
        for (Document document : results) {
            String id3 = document.getIdString();
            System.out.println(document.toString());
            ++nresults;
        }
        Assert.assertEquals((long)nresults, (long)4L);
    }

    @Test
    public void TestTableLotsOfCFs() throws Exception {
        int c;
        Document d;
        int i;
        String tablePath = "testTableLotsOfCFs";
        HashMap<String, String> cfMap = new HashMap<String, String>();
        for (int c2 = 1; c2 < 64; ++c2) {
            cfMap.put("cf" + c2, "cf" + c2);
        }
        DBTests.createOrReplaceTable(tablePath, cfMap);
        Table t = DBTests.getTable(tablePath);
        for (i = 0; i < 100; ++i) {
            d = MapRDBImpl.newDocument().set("_id", "" + i);
            for (c = 0; c < 64; ++c) {
                d.set("cf" + c, new byte[75000]);
            }
            t.insertOrReplace(d);
        }
        t.flush();
        for (i = 0; i < 100; ++i) {
            d = t.findById("" + i);
            Assert.assertNotNull((Object)d);
            for (c = 0; c < 64; ++c) {
                Assert.assertNotNull((Object)d.getBinary("cf" + c));
            }
        }
    }

    @Test
    public void testTabletCount() throws Exception {
        int nTablets = 300;
        String[] splitKeys = new String[nTablets];
        for (int i = 0; i < nTablets; ++i) {
            splitKeys[i] = "user" + i;
        }
        table = DBTests.createOrReplaceTable(TABLE_NAME, splitKeys);
        Assert.assertNotNull((Object)table);
        Table outTable = DBTests.getTable(TABLE_NAME);
        TabletInfo[] tablets = outTable.getTabletInfos();
        Assert.assertEquals((long)(nTablets + 1), (long)tablets.length);
    }
}

