/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.ojai.DBDocumentReader2;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.json.Json;

@Category(value={SimpleTest.class})
public class TestDBDocumentReader
extends BaseTest {
    private static final KeyValue _ID = DBValueBuilderImpl.KeyValueBuilder.initFrom("id1");

    private void validateSimple(Table tab, DocumentReader r) {
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        block10: for (int nCFs = 3; nCFs > 0; --nCFs) {
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            switch (r.getFieldName()) {
                case "a": {
                    Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
                    Assert.assertEquals((Object)false, (Object)r.getBoolean());
                    Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    continue block10;
                }
                case "k": {
                    Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
                    Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    continue block10;
                }
                case "n": {
                    Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
                    Assert.assertEquals((Object)"x1", (Object)r.getFieldName());
                    Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
                    Assert.assertEquals((Object)"y1", (Object)r.getFieldName());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
                    Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
                    Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
                    Assert.assertEquals((Object)"y2", (Object)r.getFieldName());
                    Assert.assertEquals((Object)"aaa", (Object)r.getString());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testSimple() throws IOException {
        HashMap cfPath = new HashMap();
        Table tab = DBTests.createOrReplaceTable("mytab");
        Document d = MapRDBImpl.newDocument().set("a.d", false).set("a.e", 111.222).set("k.x2", "abcd").set("n.x1.y1", 1.23).set("n.x2.y2", "aaa");
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader reader : tab.find().documentReaders()) {
            this.validateSimple(tab, reader);
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testSimple1() throws IOException {
        HashMap cfPath = new HashMap();
        Table tab = DBTests.createOrReplaceTable("mytab");
        Document d = MapRDBImpl.newDocument().set("a.d", false).set("a.e", 111.222);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find().documentReaders()) {
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)"a", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
            Assert.assertEquals((Object)false, (Object)r.getBoolean());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testSkipChildren() throws Exception {
        try (InputStream testJson = this.getResourceStream("com/mapr/db/tests/json/complex.json");
             DocumentStream stream = Json.newDocumentStream((InputStream)testJson);){
            DBDocumentImpl dbDoc = RowcolCodec.getDBDocument((Document)((Document)stream.iterator().next()));
            ByteBuffer encoded = RowcolCodec.encode((Document)dbDoc);
            DBDocumentReader2 r = new DBDocumentReader2((Map)ImmutableMap.of((Object)0, (Object)encoded), (Map)ImmutableMap.of((Object)FieldPath.EMPTY, (Object)0), _ID, false);
            DocumentReader.EventType et = null;
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"active", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"age", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            Assert.assertEquals((Object)"favorites", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"first", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((Object)"interests", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"last", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"salary", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"sex", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((Object)"skills", (Object)r.getFieldName());
            r.skipChildren();
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            r.skipChildren();
            et = r.next();
            Assert.assertNull((Object)et);
        }
    }
}

