/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.MetaTable;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.impl.TabletSegmentScanner;
import com.mapr.db.impl.scan.ScanStatsImpl;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.scan.ScanStats;
import com.mapr.fs.FidInfo;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.ojai.store.QueryCondition;

public abstract class BaseMetaTable
implements MetaTable {
    private static final int SCANRANGE_COUNT_THRESHOLD = Integer.parseInt(System.getProperty("com.mapr.db.metatable.scanrange-count-threshold", "500"));
    protected static final QueryCondition TOKEN_CONDITION = MapRDBImpl.newCondition();
    protected final BaseJsonTable baseJsonTable;
    protected boolean closed;

    public BaseMetaTable(BaseJsonTable baseJsonTable) {
        this.baseJsonTable = baseJsonTable;
        this.closed = false;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
        }
    }

    @Override
    public List<ScanRange> getScanRanges() throws DBException {
        return this.getScanRanges(TOKEN_CONDITION);
    }

    @Override
    public List<ScanRange> getScanRanges(int chunkSizeMBs) throws DBException {
        return this.getScanRanges(TOKEN_CONDITION, chunkSizeMBs);
    }

    @Override
    public List<ScanRange> getScanRanges(QueryCondition condition, int chunkSizeMBs) throws DBException {
        List<ScanRange> outerRanges = this.getScanRanges(condition);
        if (outerRanges.size() < SCANRANGE_COUNT_THRESHOLD) {
            TabletSegmentScanner segmentScanner = new TabletSegmentScanner(this.baseJsonTable, chunkSizeMBs);
            for (ScanRange scanRange : outerRanges) {
                segmentScanner.addTabletInfo((TabletInfoImpl)scanRange);
            }
            outerRanges = segmentScanner.getScanRanges();
        }
        return outerRanges;
    }

    @Override
    public ScanStats getScanStats() throws DBException {
        return this.getScanStats(TOKEN_CONDITION);
    }

    @Override
    public ScanStats getScanStats(QueryCondition condition) throws DBException {
        Preconditions.checkNotNull((Object)condition);
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long totalSize = 0L;
        long totalNumRows = 0L;
        int tabletCount = 0;
        int partitionCount = 0;
        List<ConditionNode.RowkeyRange> rowkeys = null;
        if (condition != TOKEN_CONDITION) {
            rowkeys = this.baseJsonTable.getRowkeyRanges(this.getCondition(condition));
        }
        if (rowkeys == null || rowkeys.size() == 1) {
            try {
                Dbserver.TableBasicStats scrStats = this.baseJsonTable.getScanRangeStats(this.getCondition(condition));
                totalSize = scrStats.getSize();
                totalNumRows = scrStats.getNumRows();
                partitionCount = tabletCount = (int)scrStats.getNumTablets();
            }
            catch (IOException e) {
                throw new DBException(e);
            }
        } else {
            TabletInfo[] ranges = this.baseJsonTable.getTabletInfos(this.getCondition(condition), true, true);
            partitionCount = ranges.length;
            HashSet<FidInfo> fidSet = new HashSet<FidInfo>();
            for (TabletInfo scanRange : ranges) {
                TabletInfoImpl tabletInfoImpl = (TabletInfoImpl)scanRange;
                if (fidSet.contains(tabletInfoImpl.getFid())) continue;
                fidSet.add(tabletInfoImpl.getFid());
                ++tabletCount;
                totalSize += tabletInfoImpl.getInternalEstimatedSize();
                totalNumRows += tabletInfoImpl.getInternalEstimatedNumRows();
            }
        }
        return new ScanStatsImpl(tabletCount, partitionCount, totalNumRows, totalSize);
    }

    @Override
    public long getAverageRowSize() throws DBException {
        try {
            return this.baseJsonTable.getAverageRowSize();
        }
        catch (IOException e) {
            throw new DBException(e);
        }
    }

    protected QueryCondition getCondition(QueryCondition condition) {
        return condition == TOKEN_CONDITION ? null : condition;
    }
}

