/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;

@Category(value={ClusterTest.class})
public class TestBaseJsonTable
extends BaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushOnClose() throws Exception {
        String tableName = "testFlushOnClose_table";
        try {
            Table table = DBTests.createOrReplaceTable("testFlushOnClose_table");
            Table table2 = DBTests.getTable("testFlushOnClose_table").setOption(Table.TableOption.BUFFERWRITE, true);
            Document originalDocument = MapRDBImpl.newDocument((String)String.format("{\"_id\": \"row1\", \"field1\": %d}", System.currentTimeMillis()));
            table.insertOrReplace(originalDocument);
            table.close();
            DocumentStream stream = table2.find();
            Iterator itr = stream.iterator();
            Assert.assertTrue((boolean)itr.hasNext());
            Document fetchedDocument = (Document)itr.next();
            Assert.assertNotNull((Object)fetchedDocument);
            Assert.assertEquals((Object)originalDocument, (Object)fetchedDocument);
            table2.close();
        }
        catch (Throwable throwable) {
            DBTests.deleteTables("testFlushOnClose_table");
            throw throwable;
        }
        DBTests.deleteTables("testFlushOnClose_table");
    }
}

