/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import com.mapr.tests.annotations.IsolatedTest;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;

@Category(value={ClusterTest.class, IsolatedTest.class})
public class ImpersonationTestOnDBOperations
extends BaseTest {
    private static String impersonationTableName;

    @Test
    public void impersonationTest() throws Exception {
        String user = "m7user1";
        UserGroupInformation ugi = ImpersonationTestOnDBOperations.createUser("m7user1");
        System.out.println("Running impersonation test as user: m7user1");
        impersonationTableName = "impersonation-table";
        Table impersonationTable = DBTests.createOrReplaceTable(impersonationTableName);
        impersonationTable.insertOrReplace("r1", MapRDBImpl.newDocument().set("name", "Joe"));
        Document d = impersonationTable.findById("r1");
        Assert.assertEquals((Object)d.getString("name"), (Object)"Joe");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Table table = DBTests.getTable(impersonationTableName);
                Document d = table.findById("r1");
                Assert.assertNull((Object)d.getString("name"));
                return null;
            }
        });
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
    }
}

