/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValuePair;
import com.mapr.db.rowcol.KeyValueSizeDescriptor;
import com.mapr.db.rowcol.RootTimeDescriptor;
import com.mapr.db.rowcol.RowcolType;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import com.mapr.db.util.ByteBufferToStringHashMap;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.nio.ByteBuffer;
import java.util.Map;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.exceptions.TypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueDeserializeHelper {
    private static final Logger logger = LoggerFactory.getLogger(KeyValueDeserializeHelper.class);
    private static final ThreadLocal<ByteBufferToStringHashMap> fieldCacheThreadLocal = new ThreadLocal();
    private static ThreadLocal<KeyValuePair> threadLocalKVPair = new ThreadLocal<KeyValuePair>(){

        @Override
        protected KeyValuePair initialValue() {
            return new KeyValuePair();
        }
    };

    public static Value.Type getType(ByteBuffer input) {
        byte rowColType = input.get();
        if (rowColType == 0) {
            return null;
        }
        Value.Type type = RowcolType.valueType(rowColType & 0x1F);
        return type;
    }

    public static void deserializeWithoutKeyValue(SerializationContext context, ByteBuffer input) {
        if (context.isRoot()) {
            context.setNewRecord(false);
            RootTimeDescriptor.deserialize(input, context);
            TimeDescriptor.deserialize(null, input, context, true);
        }
        Value.Type type = KeyValueDeserializeHelper.getType(input);
        context.setType(type);
        if (type == null) {
            return;
        }
        int numBitsForValue = context.isArrayElement() ? 8 : KeyValueSizeDescriptor.valueSizeBitsForType(type);
        context.setNumBitsForValue(numBitsForValue);
        context.setKeyValueSize(input);
        TimeDescriptor.deserialize(null, input, context);
        if (context.isArrayElement()) {
            ArrayIndexDescriptor.deserialize(null, input, context);
        } else {
            int[] kvOrder = KeyValueSizeDescriptor.decodeKeyValueSize(0, input);
            context.setOrderInMap(kvOrder[0]);
        }
    }

    public static boolean deserialize(boolean isArrayElement, int[] assocArrIdx, KeyValue parentKv, SerializationContext context, ByteBuffer input, Map<String, FieldPath> fieldPathMap, KeyValuePair kvPair) {
        KeyValue kv;
        SerializationContext.ProjectionState parentProjState;
        String key = null;
        FieldPath parentPath = context.currentPath();
        SerializationContext.ProjectionState projState = parentProjState = context.currentProjectionState();
        ByteBufferToStringHashMap fieldCache_ = fieldCacheThreadLocal.get();
        if (fieldCache_ == null) {
            fieldCache_ = new ByteBufferToStringHashMap();
            fieldCacheThreadLocal.set(fieldCache_);
            logger.debug("create a new fieldcache");
        } else {
            logger.debug("fetch a fieldcache threadlocal");
        }
        do {
            byte rowColType;
            if ((rowColType = input.get()) == 0) {
                return false;
            }
            Value.Type type = RowcolType.valueType(rowColType & 0x1F);
            if (type == Value.Type.MAP) {
                kv = new DBDocumentImpl();
            } else if (type == Value.Type.ARRAY) {
                kv = new DBList(InsertContext.OpType.NONE);
            } else {
                kv = context.newKeyValue();
                kv.type_ = type.getCode();
            }
            kv.setIsArrayElement(isArrayElement);
            rowColType = (byte)(rowColType >> 5 & 7);
            kv.opType = (byte)(InsertContext.OpType.valueOf(rowColType).ordinal() & 0xFF);
            int numBitsForValue = isArrayElement ? 8 : KeyValueSizeDescriptor.valueSizeBitsForType(type);
            int[] keyValueSize = KeyValueSizeDescriptor.decodeKeyValueSize(numBitsForValue, input);
            TimeDescriptor.deserialize(kv, input, context);
            if (isArrayElement) {
                ArrayIndexDescriptor.deserialize(kv, input, context);
                if (context.getIndexType() == ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ASSOCIATIVE) {
                    int n = assocArrIdx[0];
                    assocArrIdx[0] = n + 1;
                    kv.setOrderOfField(n);
                }
            } else {
                KeyValueDeserializeHelper.deserializeOrderOfField(kv, input);
                key = fieldCache_.get(input, keyValueSize[0]);
            }
            if (context.shouldPrunePaths()) {
                FieldPath p = parentPath;
                projState = parentProjState;
                if (!context.isRoot() || parentPath == FieldPath.EMPTY) {
                    if (key != null) {
                        if (fieldPathMap != null) {
                            if (parentPath == FieldPath.EMPTY) {
                                p = fieldPathMap.get(key);
                                if (p == null) {
                                    p = FieldPath.parseFrom((String)key);
                                    fieldPathMap.put(key, p);
                                }
                            } else {
                                p = parentPath.cloneWithNewChild(key);
                            }
                        } else {
                            p = parentPath == FieldPath.EMPTY ? FieldPath.parseFrom((String)key) : parentPath.cloneWithNewChild(key);
                        }
                    } else if (isArrayElement) {
                        if (fieldPathMap != null) {
                            if (parentPath == FieldPath.EMPTY) {
                                p = fieldPathMap.get(key);
                                if (p == null) {
                                    p = FieldPath.parseFrom((String)key);
                                    fieldPathMap.put(key, p);
                                }
                            } else {
                                p = parentPath.cloneWithNewChild(kv.orderInMap);
                            }
                        } else {
                            FieldPath fieldPath = p = parentPath == FieldPath.EMPTY ? FieldPath.parseFrom((String)key) : parentPath.cloneWithNewChild(kv.orderInMap);
                        }
                    }
                    if (parentProjState.isAncestor()) {
                        projState = context.getProjectionState(parentProjState, p);
                    }
                }
                context.setCurrentPath(p);
                context.setCurrentProjectionState(projState);
            }
            context.setNewRecord(false);
            KeyValueDeserializeHelper.deserializeValue(kv, input, context, keyValueSize[1], fieldPathMap);
        } while (projState != null && projState.isUnrelated());
        kvPair.setKey(key);
        kvPair.setValue(kv);
        return true;
    }

    private static void deserializeOrderOfField(KeyValue kv, ByteBuffer input) {
        int[] keyValueSize = KeyValueSizeDescriptor.decodeKeyValueSize(0, input);
        kv.setOrderOfField(keyValueSize[0]);
    }

    private static void deserializeValue(KeyValue kv, ByteBuffer input, SerializationContext context, int valueSize, Map<String, FieldPath> fieldPathMap) {
        switch (kv.getType()) {
            case ARRAY: {
                KeyValueDeserializeHelper.deserializeArrayValue(kv, context, input, fieldPathMap);
                return;
            }
            case BINARY: {
                byte[] bytes = new byte[valueSize];
                input.get(bytes);
                ByteBuffer b = ByteBuffer.wrap(bytes);
                kv.objValue = b;
                return;
            }
            case NULL: {
                return;
            }
            case BOOLEAN: {
                kv.primValue = valueSize;
                return;
            }
            case BYTE: {
                kv.primValue = input.get();
                return;
            }
            case DECIMAL: {
                kv.objValue = BigDecimalSizeDescriptor.deSerialize(input);
                return;
            }
            case DOUBLE: 
            case LONG: {
                kv.primValue = input.getLong();
                return;
            }
            case FLOAT: 
            case INT: {
                kv.primValue = input.getInt();
                return;
            }
            case MAP: {
                KeyValueDeserializeHelper.deserializeMap(kv, context, input, fieldPathMap);
                return;
            }
            case SHORT: {
                kv.primValue = input.getShort();
                return;
            }
            case STRING: {
                String v = Bytes.toString((ByteBuffer)input, (int)valueSize);
                kv.objValue = v;
                return;
            }
            case INTERVAL: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                kv.primValue = KeyValueDeserializeHelper.deserializeVarLong(valueSize, input);
                return;
            }
        }
        throw new TypeException("Unknown type " + kv.getType());
    }

    public static long deserializeVarLong(int valueSize, ByteBuffer input) {
        switch (valueSize) {
            case 0: {
                return 0L;
            }
            case 1: {
                return (long)input.get() & 0xFFL;
            }
            case 2: {
                return (long)input.getShort() & 0xFFFFL;
            }
            case 4: {
                return (long)input.getInt() & 0xFFFFFFFFL;
            }
            case 8: {
                return input.getLong();
            }
        }
        throw new IllegalArgumentException("Invalid size in serialize " + valueSize);
    }

    private static void deserializeMap(KeyValue kv, SerializationContext context, ByteBuffer input, Map<String, FieldPath> fieldPathMap) {
        DBDocumentImpl rec = (DBDocumentImpl)kv;
        KeyValuePair value = threadLocalKVPair.get();
        TimeAndUniq savedBaseTs = context.getBaseTime();
        FieldPath savedCurrentPath = null;
        SerializationContext.ProjectionState savedProjState = null;
        if (context.shouldPrunePaths()) {
            savedCurrentPath = context.currentPath();
            savedProjState = context.currentProjectionState();
        }
        while (KeyValueDeserializeHelper.deserialize(false, null, kv, context, input, fieldPathMap, value)) {
            rec.map.put(value.getKey(), value.getValue());
            if (savedCurrentPath == null) continue;
            context.setCurrentPath(savedCurrentPath);
            context.setCurrentProjectionState(savedProjState);
        }
        context.setBaseTime(savedBaseTs);
    }

    private static void deserializeArrayValue(KeyValue kv, SerializationContext context, ByteBuffer input, Map<String, FieldPath> fieldPathMap) {
        DBList rec = (DBList)kv;
        KeyValuePair kvPair = threadLocalKVPair.get();
        TimeAndUniq savedBaseTs = context.getBaseTime();
        FieldPath savedCurrentPath = null;
        SerializationContext.ProjectionState savedProjState = null;
        int[] assocArrIdx = new int[]{0};
        if (context.shouldPrunePaths()) {
            savedCurrentPath = context.currentPath();
            savedProjState = context.currentProjectionState();
        }
        while (KeyValueDeserializeHelper.deserialize(true, assocArrIdx, kv, context, input, fieldPathMap, kvPair)) {
            KeyValue value = kvPair.getValue();
            if (savedProjState != null && savedProjState.isUnrelated()) {
                context.setCurrentPath(savedCurrentPath);
                context.setCurrentProjectionState(savedProjState);
                continue;
            }
            if (value.getArrayIndexType() == ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ABSOLUTE) {
                FieldPath p;
                if (savedProjState != null && context.getProjectionState(savedProjState, p = savedCurrentPath.cloneWithNewChild(value.getOrderOfField())).isUnrelated()) {
                    context.setCurrentPath(savedCurrentPath);
                    context.setCurrentProjectionState(savedProjState);
                    continue;
                }
                int index = value.getOrderOfField();
                while (rec.list.size() < index) {
                    rec.list.add(null);
                }
                context.setHasArrayProjection();
                value.setArrayIndexType(ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ASSOCIATIVE);
            }
            rec.list.add(value);
            if (savedProjState == null) continue;
            context.setCurrentPath(savedCurrentPath);
            context.setCurrentProjectionState(savedProjState);
        }
        context.setBaseTime(savedBaseTs);
    }
}

