/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.ArrayComponent;
import com.mapr.db.indexrowkeyfmt.BooleanComponent;
import com.mapr.db.indexrowkeyfmt.ByteArrayComponent;
import com.mapr.db.indexrowkeyfmt.DateComponent;
import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.ErrorComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.MapComponent;
import com.mapr.db.indexrowkeyfmt.MissingComponent;
import com.mapr.db.indexrowkeyfmt.Null;
import com.mapr.db.indexrowkeyfmt.NullComponent;
import com.mapr.db.indexrowkeyfmt.NumericComponent;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.db.indexrowkeyfmt.OMap;
import com.mapr.db.indexrowkeyfmt.StringComponent;
import com.mapr.db.indexrowkeyfmt.TimeComponent;
import com.mapr.db.indexrowkeyfmt.TimestampComponent;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class IndexRowKeyComponentArray {
    private boolean missingAndNullFirst_;
    private int numComponents_;
    private IndexRowKeyComponent[] components_;

    public IndexRowKeyComponentArray(int numComponents, boolean missingAndNullFirst) {
        this.missingAndNullFirst_ = missingAndNullFirst;
        this.init(numComponents);
    }

    public void init(int numComponents) {
        this.numComponents_ = numComponents;
        this.components_ = new IndexRowKeyComponent[this.numComponents_];
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.numComponents_; ++i) {
            this.components_[i] = null;
        }
    }

    public void set(int idx, Error componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new ErrorComponent(componentValue);
    }

    public void set(int idx, Null componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new NullComponent(this.missingAndNullFirst_, descendingOrder);
    }

    public void set(int idx, boolean componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new BooleanComponent(componentValue, descendingOrder);
    }

    public void set(int idx, byte[] componentValue, int componentSize, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new ByteArrayComponent(componentValue, componentSize, descendingOrder);
    }

    public void set(int idx, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new MissingComponent(this.missingAndNullFirst_, descendingOrder);
    }

    public void set(int idx, byte componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new NumericComponent(componentValue, descendingOrder);
    }

    public void set(int idx, short componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new NumericComponent(componentValue, descendingOrder);
    }

    public void set(int idx, int componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new NumericComponent(componentValue, descendingOrder);
    }

    public void set(int idx, long componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new NumericComponent(componentValue, descendingOrder);
    }

    public void set(int idx, float componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new NumericComponent(componentValue, descendingOrder);
    }

    public void set(int idx, double componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new NumericComponent(componentValue, descendingOrder);
    }

    public void set(int idx, byte[] componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new StringComponent(componentValue, descendingOrder);
    }

    public void set(int idx, OTime componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new TimeComponent(componentValue, descendingOrder);
    }

    public void set(int idx, OTimestamp componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new TimestampComponent(componentValue, descendingOrder);
    }

    public void set(int idx, ODate componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new DateComponent(componentValue, descendingOrder);
    }

    public void set(int idx, OArray componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new ArrayComponent(componentValue, descendingOrder);
    }

    public void set(int idx, OMap componentValue, boolean descendingOrder) {
        assert (idx < this.numComponents_);
        this.components_[idx] = new MapComponent(componentValue, descendingOrder);
    }

    public IndexRowKeyComponent get(int idx) {
        return this.components_[idx];
    }

    public int getInitializedLeftSibling(int idx) {
        int i;
        for (i = idx - 1; i >= 0; --i) {
            if (this.components_[i] == null) continue;
            return i;
        }
        return i;
    }

    public int getNumComponents() {
        return this.numComponents_;
    }
}

