/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.db.indexrowkeyfmt.OMap;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public abstract class IndexRowKeyComponent {
    public static final byte NONE = 0;
    public static final byte STRING = 1;
    public static final byte MISSING = 2;
    public static final byte BOOLEAN = 3;
    public static final byte BYTE_ARRAY = 4;
    public static final byte BYTE = 5;
    public static final byte SHORT = 6;
    public static final byte INT = 7;
    public static final byte LONG = 8;
    public static final byte FLOAT = 9;
    public static final byte DOUBLE = 10;
    public static final byte NUMERIC = 11;
    public static final byte TIME = 12;
    public static final byte TIMESTAMP = 13;
    public static final byte DATE = 14;
    public static final byte _NULL = 15;
    public static final byte ERROR = 16;
    public static final byte ARRAY = 17;
    public static final byte MAP = 18;
    private static final int BYTE_SIZE = 8;
    private static final byte CONTINUATION_MARKER = -128;
    private static final byte[] leftoverMask = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};
    protected static final double BYTE_ARRAY_ENCODING_SIZE_RATIO = 1.1428571428571428;
    protected static final double BYTE_ARRAY_DECODING_SIZE_RATIO = 0.875;
    protected static final byte MARKER_SIZE = 1;
    protected byte type_;
    protected boolean descendingOrder_;
    protected int offset_;
    protected Byte separator_;
    protected boolean isDecoded_;

    public IndexRowKeyComponent(byte type, boolean descendingOrder) {
        this.type_ = type;
        this.descendingOrder_ = descendingOrder;
        this.offset_ = 0;
        this.separator_ = null;
        this.isDecoded_ = false;
    }

    public byte getType() {
        return this.type_;
    }

    public void setOrigType(byte type) {
    }

    public byte getOrigType() {
        return this.type_;
    }

    public void setOffset(int offset) {
        this.offset_ = offset;
    }

    public int getOffset() {
        return this.offset_;
    }

    public void setIsDecoded() {
        this.isDecoded_ = true;
    }

    public boolean isDecoded() {
        return this.isDecoded_;
    }

    public Byte getSeparator() {
        return this.separator_;
    }

    public int getEncodingSize() {
        return 1;
    }

    public int getFullEncodingSize() {
        return this.getEncodingSize() + (this.getSeparator() != null ? 1 : 0);
    }

    public int getNextComponentOffset() {
        return this.getOffset() + this.getFullEncodingSize();
    }

    public abstract byte getMarker(boolean var1);

    public abstract int encode(ByteBuffer var1);

    public abstract int decode(byte[] var1, int var2, int var3);

    public int calculateEncodingSize(byte[] buf, int offset) {
        return 1;
    }

    public int getEncodingSizeEstimate() {
        return 1;
    }

    public String getString() throws UnsupportedEncodingException {
        throw new IllegalArgumentException("getString() called for type " + this.getType());
    }

    public boolean getBoolean() {
        throw new IllegalArgumentException("getBoolean() called for type " + this.getType());
    }

    public byte[] getByteArray() {
        throw new IllegalArgumentException("getByteArray() called for type " + this.getType());
    }

    public byte getByte() {
        throw new IllegalArgumentException("getByte() called for type " + this.getType());
    }

    public short getShort() {
        throw new IllegalArgumentException("getShort() called for type " + this.getType());
    }

    public void setInt(int value) {
        throw new IllegalArgumentException("setInt() called for type " + this.getType());
    }

    public int getInt() {
        throw new IllegalArgumentException("getInt() called for type " + this.getType());
    }

    public void setLong(long value) {
        throw new IllegalArgumentException("setLong() called for type " + this.getType());
    }

    public long getLong() {
        throw new IllegalArgumentException("getLong() called for type " + this.getType());
    }

    public float getFloat() {
        throw new IllegalArgumentException("getFloat() called for type " + this.getType());
    }

    public double getDouble() {
        throw new IllegalArgumentException("getDouble() called for type " + this.getType());
    }

    public OTime getTime() {
        throw new IllegalArgumentException("getTime() called for type " + this.getType());
    }

    public OTimestamp getTimestamp() {
        throw new IllegalArgumentException("getTimestamp() called for type " + this.getType());
    }

    public ODate getDate() {
        throw new IllegalArgumentException("getDate() called for type " + this.getType());
    }

    public Error getError() {
        throw new IllegalArgumentException("getError() called for type " + this.getType());
    }

    public String getErrorMessage() {
        throw new IllegalArgumentException("getErrorMessage() called for type " + this.getType());
    }

    public OArray getArray() {
        throw new IllegalArgumentException("getArray() called for type " + this.getType());
    }

    public OMap getMap() {
        throw new IllegalArgumentException("getMap() called for type " + this.getType());
    }

    protected int findIdx(byte[] buf, int offset, byte b) {
        for (int i = offset; i < buf.length; ++i) {
            if (buf[i] != b) continue;
            return i - offset;
        }
        return -1;
    }

    int encodeByteArray(byte[] inBuf, int inBufSize, ByteBuffer outBuf) {
        int startingPosition = outBuf.position();
        int leftoverSize = 8;
        boolean encodingHasPaddingBits = inBufSize % 7 != 0;
        int i = 0;
        while (i < inBufSize) {
            byte b;
            assert (leftoverSize <= 8);
            switch (leftoverSize) {
                case 8: {
                    b = (byte)(0xFFFFFF80 | (inBuf[i] & leftoverMask[leftoverSize] & 0xFF) >> 1);
                    leftoverSize = 1;
                    break;
                }
                case 7: {
                    b = (byte)(0xFFFFFF80 | inBuf[i++] & leftoverMask[leftoverSize]);
                    leftoverSize = (byte)(leftoverSize + 1);
                    break;
                }
                default: {
                    b = (byte)(0xFFFFFF80 | (inBuf[i++] & leftoverMask[leftoverSize]) << 7 - leftoverSize);
                    if (i >= inBufSize) break;
                    leftoverSize = (byte)(leftoverSize + 1);
                    b = (byte)(b | (inBuf[i] & 0xFF) >> leftoverSize);
                }
            }
            outBuf.put(b);
        }
        return outBuf.position() - startingPosition;
    }

    int decodeByteArray(byte[] inBuf, int offset, Integer inBufSize, ByteBuffer outBuf) {
        int DATA_MASK = 127;
        int i = 0;
        int startingOffset = offset;
        int leftoverSize = 7;
        inBufSize = inBufSize + offset;
        while (offset < inBufSize && (inBuf[offset] & 0xFFFFFF80) != 0) {
            assert (leftoverSize < 8);
            byte b = (byte)(inBuf[offset++] << 8 - leftoverSize);
            if (offset >= inBufSize || (inBuf[offset] & 0xFFFFFF80) == 0) break;
            leftoverSize = (byte)(leftoverSize - 1);
            b = (byte)(b | (inBuf[offset] & 0x7F & 0xFF) >> leftoverSize);
            if (leftoverSize == 0) {
                ++offset;
                leftoverSize = 7;
            }
            outBuf.put(b);
            ++i;
        }
        assert ((inBuf[offset] & 0xFFFFFF80) == 0);
        inBufSize = offset - startingOffset;
        return 0;
    }

    int encodeByteArrayOnesComplement(byte[] inBuf, int inBufSize, ByteBuffer outBuf) {
        int startingPosition = outBuf.position();
        int leftoverSize = 8;
        int i = 0;
        while (i < inBufSize) {
            byte b;
            assert (leftoverSize <= 8);
            switch (leftoverSize) {
                case 8: {
                    b = (byte)(0xFFFFFF80 | (inBuf[i] & leftoverMask[leftoverSize] & 0xFF) >> 1);
                    leftoverSize = 1;
                    break;
                }
                case 7: {
                    b = (byte)(0xFFFFFF80 | inBuf[i++] & leftoverMask[leftoverSize]);
                    leftoverSize = (byte)(leftoverSize + 1);
                    break;
                }
                default: {
                    b = (byte)(0xFFFFFF80 | (inBuf[i++] & leftoverMask[leftoverSize]) << 7 - leftoverSize);
                    if (i >= inBufSize) break;
                    leftoverSize = (byte)(leftoverSize + 1);
                    b = (byte)(b | (inBuf[i] & 0xFF) >> leftoverSize);
                }
            }
            outBuf.put(~b);
        }
        return outBuf.position() - startingPosition;
    }

    int decodeByteArrayOnesComplement(byte[] inBuf, int offset, Integer inBufSize, ByteBuffer outBuf) {
        int DATA_MASK = 127;
        int i = 0;
        int startingOffset = offset;
        int leftoverSize = 7;
        inBufSize = inBufSize + offset;
        while (offset < inBufSize && ((byte)(~inBuf[offset]) & 0xFFFFFF80) != 0) {
            assert (leftoverSize < 8);
            byte b = (byte)(~inBuf[offset++] << 8 - leftoverSize);
            if (offset >= inBufSize || ((byte)(~inBuf[offset]) & 0xFFFFFF80) == 0) break;
            leftoverSize = (byte)(leftoverSize - 1);
            b = (byte)(b | ((byte)(~inBuf[offset]) & 0x7F & 0xFF) >> leftoverSize);
            if (leftoverSize == 0) {
                ++offset;
                leftoverSize = 7;
            }
            outBuf.put(b);
            ++i;
        }
        assert (((byte)(~inBuf[offset]) & 0xFFFFFF80) == 0);
        inBufSize = offset - startingOffset;
        return 0;
    }
}

