/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl.index;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.fs.proto.Dbserver;
import com.mapr.utils.JsonUtils;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.ojai.json.JsonOptions;

public final class IndexDescImpl
implements IndexDesc {
    private final List<IndexFieldDesc> indexedFields;
    private final Collection<IndexFieldDesc> includedFields;
    private final boolean hashed;
    private final boolean fullIndex;
    private final int numHashPartitions;
    private final boolean unique;
    private final boolean external;
    private final boolean disabled;
    private final Path primaryTablePath;
    private final String indexFid;
    private final String indexName;
    private final String system;
    private final String cluster;
    private final String connectionString;
    private final IndexDesc.MissingAndNullOrdering missingAndNullOrdering;
    private final Dbserver.SIndexInfo siInfo;

    private IndexDescImpl(List<IndexFieldDesc> indexedFields, Collection<IndexFieldDesc> includedFields, boolean isHashed, boolean isFullIndex, int numHashPartitions, boolean isUnique, boolean isExternal, boolean isDisabled, Path primaryTablePath, String indexFid, String indexName, String systemName, String clusterName, String connectionString, Dbserver.SIndexInfo siInfo) {
        this.indexedFields = indexedFields;
        this.includedFields = includedFields;
        this.hashed = isHashed;
        this.fullIndex = isFullIndex;
        this.numHashPartitions = numHashPartitions;
        this.unique = isUnique;
        this.external = isExternal;
        this.disabled = isDisabled;
        this.primaryTablePath = primaryTablePath;
        this.indexFid = indexFid;
        this.indexName = indexName;
        this.system = systemName;
        this.cluster = clusterName;
        this.connectionString = connectionString;
        this.siInfo = siInfo;
        this.missingAndNullOrdering = siInfo == null ? null : this.missingAndNullOrderingFromProto(siInfo);
    }

    private IndexDesc.MissingAndNullOrdering missingAndNullOrderingFromProto(Dbserver.SIndexInfo siInfo) {
        switch (siInfo.getMissingAndNullOrdering()) {
            case MissingAndNullFirst: {
                return IndexDesc.MissingAndNullOrdering.MissingAndNullFirst;
            }
            case MissingAndNullLast: {
                return IndexDesc.MissingAndNullOrdering.MissingAndNullLast;
            }
        }
        throw new AssertionError((Object)("Invalid null-ordering: " + siInfo.getMissingAndNullOrdering()));
    }

    @Override
    public List<IndexFieldDesc> getIndexedFields() {
        return this.indexedFields;
    }

    @Override
    public Collection<IndexFieldDesc> getIncludedFields() {
        return this.includedFields;
    }

    @Override
    public boolean isHashed() {
        return this.hashed;
    }

    @Override
    public int getNumHashPartitions() {
        return this.numHashPartitions;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isExternal() {
        return this.external;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public String getPrimaryTablePath() {
        return this.primaryTablePath.toString();
    }

    @Override
    public String getIndexFid() {
        return this.indexFid;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    @JsonIgnore
    public Dbserver.SIndexInfo getIndexInfo() {
        return this.siInfo;
    }

    @Override
    public boolean isFullIndex() {
        return this.fullIndex;
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public String getCluster() {
        return this.cluster;
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    public IndexDesc.MissingAndNullOrdering getMissingAndNullOrdering() {
        return this.missingAndNullOrdering;
    }

    public String toString() {
        return "{\"indexedFields\":" + this.indexedFields + ", \"includedFields\":" + this.includedFields + ", \"isUnique\":" + this.unique + ", \"isExternal\":" + this.external + ", \"isDisabled\":" + this.disabled + ", \"missingAndNullOrdering\":" + JsonUtils.toJsonValue((Object)((Object)this.missingAndNullOrdering)) + ", \"primaryTablePath\":" + this.primaryTablePath + ", \"indexName\":" + JsonUtils.toJsonValue((String)this.indexName) + ", \"systemName\":" + JsonUtils.toJsonValue((String)this.system) + ", \"clusterName\":" + JsonUtils.toJsonValue((String)this.cluster) + ", \"connectionString\":" + JsonUtils.toJsonValue((String)this.connectionString) + "}";
    }

    public String asJsonString() {
        return MapRDBImpl.newDocument(this).asJsonString();
    }

    public String asJsonString(JsonOptions options) {
        return MapRDBImpl.newDocument(this).asJsonString(options);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexDescImpl other = (IndexDescImpl)obj;
        if (this.cluster == null ? other.cluster != null : !this.cluster.equals(other.cluster)) {
            return false;
        }
        if (this.connectionString == null ? other.connectionString != null : !this.connectionString.equals(other.connectionString)) {
            return false;
        }
        if (this.includedFields == null ? other.includedFields != null : !this.includedFields.equals(other.includedFields)) {
            return false;
        }
        if (this.disabled != other.disabled) {
            return false;
        }
        if (this.external != other.external) {
            return false;
        }
        if (this.hashed != other.hashed) {
            return false;
        }
        if (this.indexFid == null ? other.indexFid != null : !this.indexFid.equals(other.indexFid)) {
            return false;
        }
        if (this.indexName == null ? other.indexName != null : !this.indexName.equals(other.indexName)) {
            return false;
        }
        if (this.indexedFields == null ? other.indexedFields != null : !this.indexedFields.equals(other.indexedFields)) {
            return false;
        }
        if (this.numHashPartitions != other.numHashPartitions) {
            return false;
        }
        if (this.primaryTablePath == null ? other.primaryTablePath != null : !this.primaryTablePath.equals((Object)other.primaryTablePath)) {
            return false;
        }
        if (this.system == null ? other.system != null : !this.system.equals(other.system)) {
            return false;
        }
        return this.unique == other.unique;
    }

    public IndexDescImpl() {
        this(null, null, true, true, 0, true, true, true, null, null, null, null, null, null, null);
    }

    public static final class Builder {
        private ImmutableList.Builder<IndexFieldDesc> indexedFieldsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<IndexFieldDesc> includedFieldsBuilder = ImmutableList.builder();
        private boolean isHashed;
        private boolean isFullIndex;
        private int numHashPartitions;
        private boolean isUnique;
        private boolean isExternal;
        private boolean isDisabled;
        private Path primaryTablePath;
        private String indexFid;
        private String indexName;
        private String systemName;
        private String clusterName;
        private String connectionString;
        private Dbserver.SIndexInfo siInfo;

        public IndexDescImpl build() {
            return new IndexDescImpl((List)this.indexedFieldsBuilder.build(), (Collection)this.includedFieldsBuilder.build(), this.isHashed, this.isFullIndex, this.numHashPartitions, this.isUnique, this.isExternal, this.isDisabled, this.primaryTablePath, this.indexFid, this.indexName, this.systemName, this.clusterName, this.connectionString, this.siInfo);
        }

        public Builder addIndexedField(IndexFieldDesc desc) {
            this.indexedFieldsBuilder.add((Object)desc);
            return this;
        }

        public Builder addIncludedFields(IndexFieldDesc desc) {
            this.includedFieldsBuilder.add((Object)desc);
            return this;
        }

        public Builder setUnique(boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public Builder setExternal(boolean isExternal) {
            this.isExternal = isExternal;
            return this;
        }

        public Builder setDisabled(boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public Builder setPrimaryTablePath(Path primaryTablePath) {
            this.primaryTablePath = primaryTablePath;
            return this;
        }

        public Builder setIndexFid(String indexFid) {
            this.indexFid = indexFid;
            return this;
        }

        public Builder setIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder setSystemName(String systemName) {
            this.systemName = systemName;
            return this;
        }

        public Builder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder setConnectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public Builder setHashed(boolean isHashed, int numHashPartitions) {
            this.isHashed = isHashed;
            this.numHashPartitions = isHashed ? numHashPartitions : 0;
            return this;
        }

        public Builder setSIndexInfo(Dbserver.SIndexInfo siInfo) {
            this.siInfo = siInfo;
            return this;
        }

        public Builder setFullIndex(boolean fullIndex) {
            this.isFullIndex = fullIndex;
            return this;
        }
    }
}

