/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.jni.MapRResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;

public class RowKeyDocumentStream
implements DocumentStream {
    final MapRResultScanner scanner_;
    private volatile boolean closed_;

    public RowKeyDocumentStream(MapRResultScanner scanner) {
        this.scanner_ = scanner;
    }

    protected Document next() {
        try {
            DBDocumentImpl doc = null;
            MapRResult res = this.scanner_.nextRow();
            ByteBuffer keyBuf = res.getKey();
            if (keyBuf != null) {
                KeyValue idValue = keyBuf.hasRemaining() ? IdCodec.decode(keyBuf) : DBValueBuilderImpl.KeyValueBuilder.initFrom("");
                doc = new DBDocumentImpl();
                doc.setId(idValue);
            }
            return doc;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "findAll.next()");
        }
    }

    public Iterator<Document> iterator() {
        return new Iterator<Document>(){
            Document next = null;
            boolean done = false;

            @Override
            public boolean hasNext() {
                if (this.done) {
                    return false;
                }
                if (this.next == null) {
                    this.next = RowKeyDocumentStream.this.next();
                    if (this.next == null) {
                        this.done = true;
                    }
                }
                return this.next != null;
            }

            @Override
            public Document next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Document temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    public void close() throws OjaiException {
        if (!this.closed_) {
            this.scanner_.close();
            this.closed_ = true;
        }
    }

    public void streamTo(DocumentListener listener) {
        throw new UnsupportedOperationException();
    }

    public Iterable<DocumentReader> documentReaders() {
        throw new UnsupportedOperationException();
    }

    public Document getQueryPlan() {
        return new DBDocumentImpl();
    }
}

