/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;

@API.Internal
public abstract class ConditionNode
implements Cloneable {
    static final String HASH_OF_CONDITION_FILTER = "8cbdcd12";
    static final String HASH_OF_INDEX_FILTER = "17544506";
    static final String HASH_OF_ROW_KEY_FILTER = "rk_filter";
    static final String HASH_OF_ID_FILTER = "469dbd04";
    static final String HASH_OF_ALWAYSFALSE_FILTER = "d71875e1";
    static final String HASH_OF_ALWAYSTRUE_FILTER = "7846fa80";
    static final String HASH_OF_KEYSAMPLING_FILTER = "3427db73";
    static final String HASH_OF_FILTER_LIST = "a42ebf64";
    static final String HASH_OF_NULL_COMPARATOR = "8543f5eb";
    static final String HASH_OF_BINARY_COMPARATOR = "05f39865";
    static final String HASH_OF_JSON_COMPARATOR = "45a94888";
    static final String HASH_OF_REGEX_COMPARATOR = "e2d7ba40";
    static final String HASH_OF_TYPE_COMPARATOR = "1e95fd6b";
    static final String HASH_OF_SIZE_COMPARATOR = "2e7025c4";
    static final String EMPTY_STR = "";
    static final Set<Integer> EMPTY_FIELD_IDS = ImmutableSet.of();
    static final Set<FieldPath> EMPTY_FIELD_PATHS = ImmutableSet.of();
    QueryCondition topLevelCondition;
    boolean isIndex = false;
    static final char DOLLAR_CHAR = '$';
    static final char COLON_CHAR = ':';
    static final char QUOTE_CHAR = '\"';
    static final char COMMA_CHAR = ',';
    static final char SPACE_CHAR = ' ';
    static final char NEWLINE_CHAR = '\n';
    static final char OPEN_BRACKET = '[';
    static final char CLOSE_BRACKET = ']';
    static final char OPEN_PARAN = '(';
    static final char CLOSE_PARAN = ')';
    static final char OPEN_MAP = '{';
    static final char CLOSE_MAP = '}';
    static final BiMap<QueryCondition.Op, Dbfilters.CompareOpProto> opProtoMap = EnumBiMap.create(QueryCondition.Op.class, Dbfilters.CompareOpProto.class);
    static final Map<Dbfilters.CompareOpProto, String> opSymbolMap;
    static final Map<Dbfilters.CompareOpProto, String> opJsonOpMap;
    static final List<RowkeyRange> FULL_TABLE_RANGE;
    static final byte[] emptyStart;
    static final byte[] emptyStop;
    public static final List<RowkeyRange> EMPTY_TABLE_RANGE;

    ConditionNode(QueryCondition cond) {
        this.topLevelCondition = cond;
    }

    boolean isLeaf() {
        return true;
    }

    StringBuilder treeBuilder(StringBuilder sb) {
        return this.treeBuilder(ConditionNode.indent(sb, 2), 2);
    }

    abstract ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> var1, MapRDBIndexImpl var2);

    abstract ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> var1);

    abstract StringBuilder expressionBuilder(StringBuilder var1);

    abstract StringBuilder treeBuilder(StringBuilder var1, int var2);

    abstract StringBuilder jsonBuilder(StringBuilder var1);

    abstract List<List<RowkeyRange>> getRowkeyRanges();

    abstract void addProjections(Set<FieldPath> var1);

    abstract void visit(ConditionVisitor var1);

    protected ConditionNode clone() {
        try {
            return (ConditionNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false) : "Clone failed!!!";
            return null;
        }
    }

    protected ConditionNode clone(ConditionImpl topLevelCondition) {
        return this.clone().setTopLevelCondition(topLevelCondition);
    }

    protected ConditionNode setTopLevelCondition(ConditionImpl topLevelCondition) {
        this.topLevelCondition = topLevelCondition;
        return this;
    }

    void setSiIndex(boolean isSi) {
        this.isIndex = isSi;
    }

    boolean isIndex() {
        return this.isIndex;
    }

    abstract boolean checkAndPrune();

    boolean isEmpty() {
        return false;
    }

    static StringBuilder indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    public List<List<RowkeyRange>> getLLRR() {
        int nPartitionKeys = ((ConditionImpl)this.topLevelCondition).getPartitionKeys().size();
        int rowkeyRangeArraySize = Math.max(nPartitionKeys, 1);
        ArrayList<List<RowkeyRange>> llrr = new ArrayList<List<RowkeyRange>>(rowkeyRangeArraySize);
        for (int i = 0; i < rowkeyRangeArraySize; ++i) {
            llrr.add(FULL_TABLE_RANGE);
        }
        return llrr;
    }

    public List<RowkeyRange> calculateConditionRowkeyRange(List<List<RowkeyRange>> llrr) {
        byte[] stop;
        byte[] start;
        int lastIdx;
        int j;
        int i;
        int startSuffixLength = 0;
        int stopSuffixLength = 0;
        RowkeyRange rr = null;
        List<RowkeyRange> first = llrr.get(0);
        if (first.size() == 0 || first == FULL_TABLE_RANGE) {
            return first;
        }
        for (i = 1; i < llrr.size() && llrr.get(i).size() == 1 && llrr.get(i).get(0).isEqualOpRange(); ++i) {
            rr = llrr.get(i).get(0);
            int startRowLength = rr.getStartRow().length;
            startSuffixLength += startRowLength;
            stopSuffixLength += startRowLength;
        }
        List<RowkeyRange> lastIndexedFieldRanges = null;
        int lastIndexedFieldNumerOfRanges = 1;
        if (i < llrr.size()) {
            lastIndexedFieldRanges = llrr.get(i);
            lastIndexedFieldNumerOfRanges = lastIndexedFieldRanges.size();
        }
        int[] startSuffixLen = new int[lastIndexedFieldNumerOfRanges];
        int[] stopSuffixLen = new int[lastIndexedFieldNumerOfRanges];
        if (lastIndexedFieldRanges != null && (lastIndexedFieldNumerOfRanges > 1 || lastIndexedFieldRanges != FULL_TABLE_RANGE)) {
            for (j = 0; j < lastIndexedFieldNumerOfRanges; ++j) {
                rr = llrr.get(i).get(j);
                startSuffixLen[j] = startSuffixLength + rr.getStartRow().length;
                stopSuffixLen[j] = stopSuffixLength + rr.getStopRow().length;
            }
            lastIdx = i;
        } else {
            if (rr != null) {
                stopSuffixLength -= rr.getStartRow().length;
                stopSuffixLength += rr.getStopRow().length;
            }
            startSuffixLen[0] = startSuffixLength;
            stopSuffixLen[0] = stopSuffixLength;
            lastIdx = i - 1;
        }
        if (startSuffixLen[0] == 0) {
            return first;
        }
        ByteBuffer[] bbStartSuffix = new ByteBuffer[lastIndexedFieldNumerOfRanges];
        ByteBuffer[] bbStopSuffix = new ByteBuffer[lastIndexedFieldNumerOfRanges];
        for (j = 0; j < lastIndexedFieldNumerOfRanges; ++j) {
            bbStartSuffix[j] = ByteBuffer.allocate(startSuffixLen[j]);
            bbStopSuffix[j] = ByteBuffer.allocate(stopSuffixLen[j]);
            for (i = 1; i < lastIdx; ++i) {
                rr = llrr.get(i).get(0);
                start = rr.getStartRow();
                bbStartSuffix[j].put(start);
                bbStopSuffix[j].put(start);
            }
            rr = llrr.get(i).get(j);
            start = rr.getStartRow();
            stop = rr.getStopRow();
            bbStartSuffix[j].put(start);
            bbStopSuffix[j].put(stop);
        }
        byte[][] startSuffix = new byte[lastIndexedFieldNumerOfRanges][];
        byte[][] stopSuffix = new byte[lastIndexedFieldNumerOfRanges][];
        for (j = 0; j < lastIndexedFieldNumerOfRanges; ++j) {
            startSuffix[j] = bbStartSuffix[j].array();
            stopSuffix[j] = bbStopSuffix[j].array();
        }
        ArrayList<RowkeyRange> conditionRowkeyRange = new ArrayList<RowkeyRange>();
        for (i = 0; i < first.size(); ++i) {
            rr = first.get(i);
            if (rr.isEqualOpRange()) {
                for (j = 0; j < lastIndexedFieldNumerOfRanges; ++j) {
                    start = Bytes.concatenate((byte[])rr.getStartRow(), (byte[])startSuffix[j]);
                    stop = Bytes.concatenate((byte[])rr.getStartRow(), (byte[])stopSuffix[j]);
                    conditionRowkeyRange.add(new RowkeyRange(start, stop));
                }
                continue;
            }
            conditionRowkeyRange.add(rr);
        }
        return conditionRowkeyRange;
    }

    static {
        opProtoMap.put((Object)QueryCondition.Op.LESS, (Object)Dbfilters.CompareOpProto.LESS);
        opProtoMap.put((Object)QueryCondition.Op.LESS_OR_EQUAL, (Object)Dbfilters.CompareOpProto.LESS_OR_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.EQUAL, (Object)Dbfilters.CompareOpProto.EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.NOT_EQUAL, (Object)Dbfilters.CompareOpProto.NOT_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.GREATER_OR_EQUAL, (Object)Dbfilters.CompareOpProto.GREATER_OR_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.GREATER, (Object)Dbfilters.CompareOpProto.GREATER);
        assert (opProtoMap.size() == QueryCondition.Op.values().length) : "Map is missing some of the QueryCondition.Op elements";
        opSymbolMap = Maps.newEnumMap(Dbfilters.CompareOpProto.class);
        opSymbolMap.put(Dbfilters.CompareOpProto.NO_OP, "!ERR!");
        opSymbolMap.put(Dbfilters.CompareOpProto.LESS, "<");
        opSymbolMap.put(Dbfilters.CompareOpProto.LESS_OR_EQUAL, "<=");
        opSymbolMap.put(Dbfilters.CompareOpProto.EQUAL, "=");
        opSymbolMap.put(Dbfilters.CompareOpProto.NOT_EQUAL, "!=");
        opSymbolMap.put(Dbfilters.CompareOpProto.GREATER_OR_EQUAL, ">=");
        opSymbolMap.put(Dbfilters.CompareOpProto.GREATER, ">");
        assert (opSymbolMap.size() == Dbfilters.CompareOpProto.values().length) : "Map is missing some of the CompareOpProto elements";
        opJsonOpMap = Maps.newEnumMap(Dbfilters.CompareOpProto.class);
        FULL_TABLE_RANGE = ImmutableList.of((Object)new RowkeyRange(MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY));
        emptyStart = new byte[]{5};
        emptyStop = new byte[]{4};
        EMPTY_TABLE_RANGE = ImmutableList.of((Object)new RowkeyRange(emptyStart, emptyStop));
    }

    public static class RowkeyRange {
        protected final byte[] startRow;
        protected final byte[] stopRow;

        public RowkeyRange(byte[] startRow, byte[] stopRow) {
            this.startRow = startRow;
            this.stopRow = stopRow;
        }

        public byte[] getStartRow() {
            return this.startRow == null ? MapRConstants.EMPTY_BYTE_ARRAY : this.startRow;
        }

        public byte[] getStopRow() {
            return this.stopRow == null ? MapRConstants.EMPTY_BYTE_ARRAY : this.stopRow;
        }

        public String toString() {
            return "RowkeyRange [startRow=" + Bytes.toStringBinary((byte[])this.startRow) + ", stopRow=" + Bytes.toStringBinary((byte[])this.stopRow) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.startRow);
            result = 31 * result + Arrays.hashCode(this.stopRow);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RowkeyRange other = (RowkeyRange)obj;
            if (!Arrays.equals(this.startRow, other.startRow)) {
                return false;
            }
            return Arrays.equals(this.stopRow, other.stopRow);
        }

        public boolean isCoversEntireRange() {
            return !(this.startRow != null && this.startRow.length != 0 || this.stopRow != null && this.stopRow.length != 0);
        }

        public static boolean isCoversEntireRange(List<RowkeyRange> rowkeys) {
            return rowkeys == null || rowkeys.size() == 1 && rowkeys.get(0).isCoversEntireRange();
        }

        public boolean isEqualOpRange() {
            int i;
            for (i = this.startRow.length - 1; i >= 0; --i) {
                if (this.startRow[i] == -1) continue;
                if (i == this.stopRow.length - 1 && this.stopRow[i] == (byte)(this.startRow[i] + 1)) break;
                return false;
            }
            if (i == -1) {
                return false;
            }
            --i;
            while (i >= 0) {
                if (this.startRow[i] != this.stopRow[i]) {
                    return false;
                }
                --i;
            }
            return true;
        }
    }
}

